/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.repackaged.direct_java.runners.core.KeyedWorkItem;
import org.apache.beam.repackaged.direct_java.runners.core.KeyedWorkItems;
import org.apache.beam.repackaged.direct_java.runners.local.StructuralKey;
import org.apache.beam.runners.direct.CommittedBundle;
import org.apache.beam.runners.direct.DirectGroupByKey;
import org.apache.beam.runners.direct.EvaluationContext;
import org.apache.beam.runners.direct.StepTransformResult;
import org.apache.beam.runners.direct.TransformEvaluator;
import org.apache.beam.runners.direct.TransformEvaluatorFactory;
import org.apache.beam.runners.direct.TransformResult;
import org.apache.beam.runners.direct.UncommittedBundle;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;

class GroupByKeyOnlyEvaluatorFactory
implements TransformEvaluatorFactory {
    private final EvaluationContext evaluationContext;

    GroupByKeyOnlyEvaluatorFactory(EvaluationContext evaluationContext) {
        this.evaluationContext = evaluationContext;
    }

    @Override
    public <InputT> TransformEvaluator<InputT> forApplication(AppliedPTransform<?, ?, ?> application, CommittedBundle<?> inputBundle) {
        TransformEvaluator evaluator = this.createEvaluator(application);
        return evaluator;
    }

    @Override
    public void cleanup() {
    }

    private <K, V> TransformEvaluator<KV<K, V>> createEvaluator(AppliedPTransform<PCollection<KV<K, V>>, PCollection<KeyedWorkItem<K, V>>, DirectGroupByKey.DirectGroupByKeyOnly<K, V>> application) {
        return new GroupByKeyOnlyEvaluator<K, V>(this.evaluationContext, application);
    }

    private static class GroupByKeyOnlyEvaluator<K, V>
    implements TransformEvaluator<KV<K, V>> {
        private final EvaluationContext evaluationContext;
        private final AppliedPTransform<PCollection<KV<K, V>>, PCollection<KeyedWorkItem<K, V>>, DirectGroupByKey.DirectGroupByKeyOnly<K, V>> application;
        private final Coder<K> keyCoder;
        private Map<StructuralKey<K>, List<WindowedValue<V>>> groupingMap;

        public GroupByKeyOnlyEvaluator(EvaluationContext evaluationContext, AppliedPTransform<PCollection<KV<K, V>>, PCollection<KeyedWorkItem<K, V>>, DirectGroupByKey.DirectGroupByKeyOnly<K, V>> application) {
            this.evaluationContext = evaluationContext;
            this.application = application;
            this.keyCoder = this.getKeyCoder(((PCollection)Iterables.getOnlyElement(application.getInputs().values())).getCoder());
            this.groupingMap = new HashMap<StructuralKey<K>, List<WindowedValue<V>>>();
        }

        private Coder<K> getKeyCoder(Coder<KV<K, V>> coder) {
            Preconditions.checkState((boolean)(coder instanceof KvCoder), (String)"%s requires a coder of class %s. This is an internal error; this is checked during pipeline construction but became corrupted.", (Object)this.getClass().getSimpleName(), (Object)KvCoder.class.getSimpleName());
            Coder keyCoder = ((KvCoder)coder).getKeyCoder();
            return keyCoder;
        }

        @Override
        public void processElement(WindowedValue<KV<K, V>> element) {
            KV kv = (KV)element.getValue();
            Object key = kv.getKey();
            StructuralKey<Object> groupingKey = StructuralKey.of(key, this.keyCoder);
            List values = this.groupingMap.computeIfAbsent(groupingKey, k -> new ArrayList());
            values.add(element.withValue(kv.getValue()));
        }

        @Override
        public TransformResult<KV<K, V>> finishBundle() {
            StepTransformResult.Builder resultBuilder = StepTransformResult.withoutHold(this.application);
            for (Map.Entry<StructuralKey<K>, List<WindowedValue<V>>> groupedEntry : this.groupingMap.entrySet()) {
                K key = groupedEntry.getKey().getKey();
                KeyedWorkItem groupedKv = KeyedWorkItems.elementsWorkItem(key, (Iterable)groupedEntry.getValue());
                UncommittedBundle bundle = this.evaluationContext.createKeyedBundle(StructuralKey.of(key, this.keyCoder), (PCollection)Iterables.getOnlyElement(this.application.getOutputs().values()));
                bundle.add(WindowedValue.valueInGlobalWindow(groupedKv));
                resultBuilder.addOutput(bundle, new UncommittedBundle[0]);
            }
            return resultBuilder.build();
        }
    }
}

