/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.metrics;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.ExecutionStateSampler;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;

@SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="Intentional for performance.")
public class ExecutionStateTracker
implements Comparable<ExecutionStateTracker> {
    private static final Map<Long, ExecutionStateTracker> CURRENT_TRACKERS = new ConcurrentHashMap<Long, ExecutionStateTracker>();
    private static final long LULL_REPORT_MS = TimeUnit.MINUTES.toMillis(5L);
    private static final AtomicIntegerFieldUpdater<ExecutionStateTracker> SAMPLING_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ExecutionStateTracker.class, "sampling");
    public static final String START_STATE_NAME = "start";
    public static final String PROCESS_STATE_NAME = "process";
    public static final String PROCESS_TIMERS_STATE_NAME = "process-timers";
    public static final String FINISH_STATE_NAME = "finish";
    public static final String ABORT_STATE_NAME = "abort";
    private final ExecutionStateSampler sampler;
    private @Nullable Thread trackedThread = null;
    private volatile @Nullable ExecutionState currentState;
    private volatile int sampling = 0;
    private volatile long numTransitions = 0L;
    private volatile long millisSinceLastTransition = 0L;
    private long transitionsAtLastSample = 0L;
    private long nextLullReportMs = LULL_REPORT_MS;

    public ExecutionStateTracker(ExecutionStateSampler sampler) {
        this.sampler = sampler;
    }

    public synchronized void reset() {
        if (this.trackedThread != null) {
            CURRENT_TRACKERS.remove(this.trackedThread.getId());
            this.trackedThread = null;
        }
        this.currentState = null;
        this.numTransitions = 0L;
        this.millisSinceLastTransition = 0L;
        this.transitionsAtLastSample = 0L;
        this.nextLullReportMs = LULL_REPORT_MS;
    }

    @VisibleForTesting
    public static ExecutionStateTracker newForTest() {
        return new ExecutionStateTracker(ExecutionStateSampler.newForTest());
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    @SuppressFBWarnings(value={"EQ_COMPARETO_USE_OBJECT_EQUALS"})
    public int compareTo(ExecutionStateTracker o) {
        if (this.equals(o)) {
            return 0;
        }
        return System.identityHashCode(this) - System.identityHashCode(o);
    }

    public static @Nullable ExecutionState getCurrentExecutionState() {
        ExecutionStateTracker tracker = CURRENT_TRACKERS.get(Thread.currentThread().getId());
        return tracker == null ? null : tracker.currentState;
    }

    public static @Nullable ExecutionState getCurrentExecutionState(long threadId) {
        ExecutionStateTracker tracker = CURRENT_TRACKERS.get(threadId);
        return tracker == null ? null : tracker.currentState;
    }

    public Closeable activate() {
        return this.activate(Thread.currentThread());
    }

    @VisibleForTesting
    public synchronized Closeable activate(Thread thread) {
        Preconditions.checkState((this.trackedThread == null ? 1 : 0) != 0, (Object)"Cannot activate an ExecutionStateTracker that is already in use.");
        ExecutionStateTracker other = CURRENT_TRACKERS.put(thread.getId(), this);
        Preconditions.checkState((other == null ? 1 : 0) != 0, (String)"Execution state of thread {} was already being tracked by {}", (long)thread.getId(), (Object)other);
        this.trackedThread = thread;
        this.sampler.addTracker(this);
        return this::deactivate;
    }

    public Thread getTrackedThread() {
        return this.trackedThread;
    }

    private synchronized void deactivate() {
        this.sampler.removeTracker(this);
        Thread thread = this.trackedThread;
        if (thread != null) {
            CURRENT_TRACKERS.remove(thread.getId());
        }
        this.trackedThread = null;
    }

    public ExecutionState getCurrentState() {
        return this.currentState;
    }

    public Closeable enterState(ExecutionState newState) {
        ExecutionState previous = this.currentState;
        this.currentState = newState;
        newState.onActivate(true);
        this.incTransitions();
        return () -> {
            this.currentState = previous;
            this.incTransitions();
            if (previous != null) {
                previous.onActivate(false);
            }
        };
    }

    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="Intentional for performance.")
    private void incTransitions() {
        ++this.numTransitions;
    }

    public long getNumTransitions() {
        return this.numTransitions;
    }

    public long getMillisSinceLastTransition() {
        return this.millisSinceLastTransition;
    }

    public long getTransitionsAtLastSample() {
        return this.transitionsAtLastSample;
    }

    public long getNextLullReportMs() {
        return this.nextLullReportMs;
    }

    void takeSample(long millisSinceLastSample) {
        if (SAMPLING_UPDATER.compareAndSet(this, 0, 1)) {
            try {
                this.takeSampleOnce(millisSinceLastSample);
            }
            finally {
                SAMPLING_UPDATER.set(this, 0);
            }
        }
    }

    protected void takeSampleOnce(long millisSinceLastSample) {
        ExecutionState state = this.currentState;
        long transitionsAtThisSample = this.numTransitions;
        if (transitionsAtThisSample != this.transitionsAtLastSample) {
            this.millisSinceLastTransition = 0L;
            this.nextLullReportMs = LULL_REPORT_MS;
            this.transitionsAtLastSample = transitionsAtThisSample;
        }
        this.updateMillisSinceLastTransition(millisSinceLastSample, state);
    }

    private void updateMillisSinceLastTransition(long millisSinceLastSample, ExecutionState state) {
        this.millisSinceLastTransition += millisSinceLastSample;
        if (state != null) {
            if (this.millisSinceLastTransition > this.nextLullReportMs) {
                state.reportLull(this.trackedThread, this.millisSinceLastTransition);
                this.nextLullReportMs += LULL_REPORT_MS;
            }
            state.takeSample(millisSinceLastSample);
        }
    }

    public static abstract class ExecutionState {
        private final String stateName;
        public final boolean isProcessElementState;

        public ExecutionState(String stateName) {
            this.stateName = stateName;
            this.isProcessElementState = Objects.equals(stateName, ExecutionStateTracker.PROCESS_STATE_NAME);
        }

        public abstract void takeSample(long var1);

        public String getStateName() {
            return this.stateName;
        }

        public void onActivate(boolean pushing) {
        }

        public abstract void reportLull(Thread var1, long var2);

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("stateName", (Object)this.stateName).toString();
        }

        public String getDescription() {
            return this.stateName;
        }
    }
}

