/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.construction;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.direct_java.runners.core.construction.SdkComponents;
import org.apache.beam.repackaged.direct_java.runners.core.construction.graph.PipelineValidator;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ArrayListMultimap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ListMultimap;

public class PipelineTranslation {
    public static RunnerApi.Pipeline toProto(Pipeline pipeline) {
        return PipelineTranslation.toProto(pipeline, SdkComponents.create(pipeline.getOptions()));
    }

    public static RunnerApi.Pipeline toProto(Pipeline pipeline, boolean useDeprecatedViewTransforms) {
        return PipelineTranslation.toProto(pipeline, SdkComponents.create(pipeline.getOptions()), useDeprecatedViewTransforms);
    }

    public static RunnerApi.Pipeline toProto(Pipeline pipeline, SdkComponents components) {
        return PipelineTranslation.toProto(pipeline, components, false);
    }

    public static RunnerApi.Pipeline toProto(final Pipeline pipeline, final SdkComponents components, boolean useDeprecatedViewTransforms) {
        final ArrayList rootIds = new ArrayList();
        pipeline.traverseTopologically((Pipeline.PipelineVisitor)new Pipeline.PipelineVisitor.Defaults(){
            private final ListMultimap<TransformHierarchy.Node, AppliedPTransform<?, ?, ?>> children = ArrayListMultimap.create();

            public void leaveCompositeTransform(TransformHierarchy.Node node) {
                if (node.isRootNode()) {
                    for (AppliedPTransform pipelineRoot : this.children.get((Object)node)) {
                        rootIds.add(components.getExistingPTransformId(pipelineRoot));
                    }
                } else {
                    this.children.put((Object)node.getEnclosingNode(), (Object)node.toAppliedPTransform(pipeline));
                    try {
                        components.registerPTransform(node.toAppliedPTransform(pipeline), this.children.get((Object)node));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }

            public void visitPrimitiveTransform(TransformHierarchy.Node node) {
                this.children.put((Object)node.getEnclosingNode(), (Object)node.toAppliedPTransform(pipeline));
                try {
                    components.registerPTransform(node.toAppliedPTransform(pipeline), Collections.emptyList());
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
        RunnerApi.Pipeline res = RunnerApi.Pipeline.newBuilder().setComponents(components.toComponents()).addAllRequirements(components.requirements()).addAllRootTransformIds(rootIds).build();
        if (!useDeprecatedViewTransforms) {
            res = PipelineTranslation.elideDeprecatedViews(res);
        }
        PipelineValidator.validate(res);
        return res;
    }

    private static RunnerApi.Pipeline elideDeprecatedViews(RunnerApi.Pipeline pipeline) {
        HashSet viewTransforms = new HashSet();
        HashMap viewOutputsToInputs = new HashMap();
        pipeline.getComponents().getTransformsMap().forEach((transformId, transform) -> {
            if (transform.getSpec().getUrn().equals("beam:transform:create_view:v1")) {
                viewTransforms.add(transformId);
                viewOutputsToInputs.put((String)Iterables.getOnlyElement(transform.getOutputsMap().values()), (String)Iterables.getOnlyElement(transform.getInputsMap().values()));
            }
        });
        HashMap newTransforms = new HashMap();
        pipeline.getComponents().getTransformsMap().forEach((transformId, transform) -> {
            RunnerApi.PTransform.Builder transformBuilder = transform.toBuilder();
            transform.getInputsMap().forEach((key, value) -> {
                if (viewOutputsToInputs.containsKey(value)) {
                    transformBuilder.putInputs(key, (String)viewOutputsToInputs.get(value));
                }
            });
            transform.getOutputsMap().forEach((key, value) -> {
                if (viewOutputsToInputs.containsKey(value)) {
                    transformBuilder.putOutputs(key, (String)viewOutputsToInputs.get(value));
                }
            });
            transformBuilder.clearSubtransforms();
            transformBuilder.addAllSubtransforms((Iterable)transform.getSubtransformsList().stream().filter(id -> !viewTransforms.contains(id)).collect(Collectors.toList()));
            newTransforms.put(transformId, transformBuilder.build());
        });
        RunnerApi.Pipeline.Builder newPipeline = pipeline.toBuilder();
        newPipeline.getComponentsBuilder().putAllTransforms(newTransforms);
        viewTransforms.forEach(arg_0 -> ((RunnerApi.Components.Builder)newPipeline.getComponentsBuilder()).removeTransforms(arg_0));
        viewOutputsToInputs.keySet().forEach(arg_0 -> ((RunnerApi.Components.Builder)newPipeline.getComponentsBuilder()).removePcollections(arg_0));
        newPipeline.clearRootTransformIds();
        newPipeline.addAllRootTransformIds((Iterable)pipeline.getRootTransformIdsList().stream().filter(id -> !viewTransforms.contains(id)).collect(Collectors.toList()));
        return newPipeline.build();
    }
}

