/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.construction;

import java.util.HashMap;
import java.util.Map;
import org.apache.beam.repackaged.direct_java.runners.core.construction.ReplacementOutputs;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.PTransformOverrideFactory;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;

public class DeduplicatedFlattenFactory<T>
implements PTransformOverrideFactory<PCollectionList<T>, PCollection<T>, Flatten.PCollections<T>> {
    public static <T> DeduplicatedFlattenFactory<T> create() {
        return new DeduplicatedFlattenFactory<T>();
    }

    private DeduplicatedFlattenFactory() {
    }

    public PTransformOverrideFactory.PTransformReplacement<PCollectionList<T>, PCollection<T>> getReplacementTransform(AppliedPTransform<PCollectionList<T>, PCollection<T>, Flatten.PCollections<T>> transform) {
        return PTransformOverrideFactory.PTransformReplacement.of(this.getInput(transform.getInputs(), transform.getPipeline()), new FlattenWithoutDuplicateInputs());
    }

    private PCollectionList<T> getInput(Map<TupleTag<?>, PCollection<?>> inputs, Pipeline p) {
        PCollectionList pCollections = PCollectionList.empty((Pipeline)p);
        for (PValue pValue : inputs.values()) {
            PCollection pcollection = (PCollection)pValue;
            pCollections = pCollections.and(pcollection);
        }
        return pCollections;
    }

    public Map<PCollection<?>, PTransformOverrideFactory.ReplacementOutput> mapOutputs(Map<TupleTag<?>, PCollection<?>> outputs, PCollection<T> newOutput) {
        return ReplacementOutputs.singleton(outputs, newOutput);
    }

    private static class DuplicateFn<T>
    extends DoFn<T, T> {
        private final int numTimes;

        private DuplicateFn(int numTimes) {
            this.numTimes = numTimes;
        }

        @DoFn.ProcessElement
        public void emitCopies(DoFn.ProcessContext context) {
            for (int i = 0; i < this.numTimes; ++i) {
                context.output(context.element());
            }
        }
    }

    @VisibleForTesting
    static class FlattenWithoutDuplicateInputs<T>
    extends PTransform<PCollectionList<T>, PCollection<T>> {
        FlattenWithoutDuplicateInputs() {
        }

        public PCollection<T> expand(PCollectionList<T> input) {
            HashMap<PCollection, Integer> instances = new HashMap<PCollection, Integer>();
            for (PCollection pCollection : input.getAll()) {
                int existing = instances.get(pCollection) == null ? 0 : (Integer)instances.get(pCollection);
                instances.put(pCollection, existing + 1);
            }
            PCollectionList output = PCollectionList.empty((Pipeline)input.getPipeline());
            for (Map.Entry instanceEntry : instances.entrySet()) {
                if (((Integer)instanceEntry.getValue()).equals(1)) {
                    output = output.and((PCollection)instanceEntry.getKey());
                    continue;
                }
                String duplicationName = String.format("Multiply %s", ((PCollection)instanceEntry.getKey()).getName());
                PCollection duplicated = (PCollection)((PCollection)instanceEntry.getKey()).apply(duplicationName, (PTransform)ParDo.of(new DuplicateFn((Integer)instanceEntry.getValue())));
                output = output.and(duplicated);
            }
            return (PCollection)output.apply((PTransform)Flatten.pCollections());
        }
    }
}

