/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core;

import org.apache.beam.repackaged.direct_java.runners.core.MergingStateAccessor;
import org.apache.beam.repackaged.direct_java.runners.core.ReduceFn;
import org.apache.beam.repackaged.direct_java.runners.core.StateAccessor;
import org.apache.beam.repackaged.direct_java.runners.core.StateMerging;
import org.apache.beam.repackaged.direct_java.runners.core.StateTag;
import org.apache.beam.repackaged.direct_java.runners.core.StateTags;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.state.CombiningState;
import org.apache.beam.sdk.state.ReadableState;
import org.apache.beam.sdk.transforms.Sum;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.WindowingStrategy;

public abstract class NonEmptyPanes<K, W extends BoundedWindow> {
    static <K, W extends BoundedWindow> NonEmptyPanes<K, W> create(WindowingStrategy<?, W> strategy, ReduceFn<K, ?, ?, W> reduceFn) {
        if (strategy.getMode() == WindowingStrategy.AccumulationMode.DISCARDING_FIRED_PANES) {
            return new DiscardingModeNonEmptyPanes(reduceFn);
        }
        return new GeneralNonEmptyPanes();
    }

    public abstract void recordContent(StateAccessor<K> var1);

    public abstract void clearPane(StateAccessor<K> var1);

    public abstract ReadableState<Boolean> isEmpty(StateAccessor<K> var1);

    public abstract void prefetchOnMerge(MergingStateAccessor<K, W> var1);

    public abstract void onMerge(MergingStateAccessor<K, W> var1);

    private static class GeneralNonEmptyPanes<K, W extends BoundedWindow>
    extends NonEmptyPanes<K, W> {
        private static final StateTag<CombiningState<Long, long[], Long>> PANE_ADDITIONS_TAG = StateTags.makeSystemTagInternal(StateTags.combiningValueFromInputInternal("count", VarLongCoder.of(), Sum.ofLongs()));

        private GeneralNonEmptyPanes() {
        }

        @Override
        public void recordContent(StateAccessor<K> state) {
            state.access(PANE_ADDITIONS_TAG).add((Object)1L);
        }

        @Override
        public void clearPane(StateAccessor<K> state) {
            state.access(PANE_ADDITIONS_TAG).clear();
        }

        @Override
        public ReadableState<Boolean> isEmpty(StateAccessor<K> state) {
            return state.access(PANE_ADDITIONS_TAG).isEmpty();
        }

        @Override
        public void prefetchOnMerge(MergingStateAccessor<K, W> state) {
            StateMerging.prefetchCombiningValues(state, PANE_ADDITIONS_TAG);
        }

        @Override
        public void onMerge(MergingStateAccessor<K, W> context) {
            StateMerging.mergeCombiningValues(context, PANE_ADDITIONS_TAG);
        }
    }

    private static class DiscardingModeNonEmptyPanes<K, W extends BoundedWindow>
    extends NonEmptyPanes<K, W> {
        private ReduceFn<K, ?, ?, W> reduceFn;

        private DiscardingModeNonEmptyPanes(ReduceFn<K, ?, ?, W> reduceFn) {
            this.reduceFn = reduceFn;
        }

        @Override
        public ReadableState<Boolean> isEmpty(StateAccessor<K> state) {
            return this.reduceFn.isEmpty(state);
        }

        @Override
        public void recordContent(StateAccessor<K> state) {
        }

        @Override
        public void clearPane(StateAccessor<K> state) {
        }

        @Override
        public void prefetchOnMerge(MergingStateAccessor<K, W> state) {
        }

        @Override
        public void onMerge(MergingStateAccessor<K, W> context) {
        }
    }
}

