/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.databases.cassandra.datastax;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.ProgrammaticDriverConfigLoaderBuilder;
import com.datastax.oss.driver.api.core.config.TypedDriverOption;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.api.core.session.Session;
import com.datastax.oss.driver.api.core.type.codec.MappingCodec;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.codec.registry.MutableCodecRegistry;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.api.querybuilder.SchemaBuilder;
import com.datastax.oss.driver.api.querybuilder.schema.CreateKeyspace;
import com.datastax.oss.driver.api.querybuilder.schema.CreateKeyspaceStart;
import com.datastax.oss.driver.internal.core.type.codec.registry.DefaultCodecRegistry;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.net.InetSocketAddress;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.databases.cassandra.datastax.DriverKeyspace;
import org.apache.hop.databases.cassandra.spi.Keyspace;

public class DriverConnection
implements AutoCloseable {
    private String hosts;
    private int port = 9042;
    private String localDataCenter;
    private String username;
    private String password;
    private Map<String, String> opts = new HashMap<String, String>();
    private boolean useCompression;
    private CqlSession session;
    private final Map<String, CqlSession> sessions = new HashMap<String, CqlSession>();
    private final boolean expandCollection = true;

    public DriverConnection() {
    }

    public DriverConnection(String hosts, int port, String localDataCenter) {
        this.hosts = hosts;
        this.port = port;
        this.localDataCenter = localDataCenter;
    }

    public void setHosts(String hosts) {
        this.hosts = hosts;
    }

    public void setDefaultPort(int port) {
        this.port = port;
    }

    public void setAdditionalOptions(Map<String, String> opts) {
        this.opts = opts;
        if (opts.containsKey("compression")) {
            this.setUseCompression(true);
        }
    }

    public Map<String, String> getAdditionalOptions() {
        return this.opts;
    }

    public CqlSession open() {
        this.session = (CqlSession)this.getSessionBuilder().build();
        return this.session;
    }

    @Override
    public void close() throws Exception {
        if (this.session != null) {
            this.session.close();
        }
        this.sessions.forEach((name, session) -> session.close());
        this.sessions.clear();
    }

    public Session getUnderlyingSession() {
        return this.session;
    }

    public void setUseCompression(boolean useCompression) {
        this.useCompression = useCompression;
    }

    public CqlSessionBuilder getSessionBuilder() {
        CqlSessionBuilder builder = (CqlSessionBuilder)CqlSession.builder().withApplicationName("Apache Hop");
        for (InetSocketAddress inetSocketAddress : this.getAddresses()) {
            builder = (CqlSessionBuilder)builder.addContactPoint(inetSocketAddress);
        }
        if (StringUtils.isNotEmpty((String)this.localDataCenter)) {
            builder = (CqlSessionBuilder)builder.withLocalDatacenter(this.localDataCenter);
        }
        ProgrammaticDriverConfigLoaderBuilder configLoaderBuilder = DriverConfigLoader.programmaticBuilder();
        if (!StringUtils.isEmpty((String)this.username)) {
            builder = (CqlSessionBuilder)builder.withAuthCredentials(this.username, this.password);
        }
        if (this.opts.containsKey("socketTimeout")) {
            int timeoutMs = Integer.parseUnsignedInt(this.opts.get("socketTimeout").trim());
            configLoaderBuilder = (ProgrammaticDriverConfigLoaderBuilder)configLoaderBuilder.withDuration(TypedDriverOption.CONNECTION_CONNECT_TIMEOUT.getRawOption(), Duration.ofMillis(timeoutMs));
        }
        if (this.useCompression) {
            configLoaderBuilder = (ProgrammaticDriverConfigLoaderBuilder)configLoaderBuilder.withString(TypedDriverOption.PROTOCOL_COMPRESSION.getRawOption(), "lz4");
        }
        DefaultCodecRegistry codecRegistry = new DefaultCodecRegistry("Apache Hop");
        this.registerCodecs((MutableCodecRegistry)codecRegistry);
        builder = (CqlSessionBuilder)builder.withCodecRegistry((MutableCodecRegistry)codecRegistry);
        builder = (CqlSessionBuilder)builder.withConfigLoader(configLoaderBuilder.build());
        return builder;
    }

    public CqlSession getSession(String keyspace) {
        return this.sessions.computeIfAbsent(keyspace, ks -> (CqlSession)((CqlSessionBuilder)this.getSessionBuilder().withKeyspace(keyspace)).build());
    }

    public Keyspace getKeyspace(String keyspaceName) throws Exception {
        Optional optionalKeyspace = this.getSession(keyspaceName).getMetadata().getKeyspace(keyspaceName);
        if (optionalKeyspace.isEmpty()) {
            throw new Exception("Unable to find keyspace '" + keyspaceName + "'");
        }
        return new DriverKeyspace(this, (KeyspaceMetadata)optionalKeyspace.get());
    }

    public String[] getKeyspaceNames() throws Exception {
        try (CqlSession session = (CqlSession)this.getSessionBuilder().build();){
            Collection keyspaceList = session.getMetadata().getKeyspaces().values();
            String[] names = new String[keyspaceList.size()];
            int i = 0;
            for (KeyspaceMetadata keyspace : keyspaceList) {
                names[i++] = keyspace.getName().asCql(false);
            }
            String[] stringArray = names;
            return stringArray;
        }
    }

    public void createKeyspace(String keyspaceName, boolean ifNotExists, Map<String, Object> createOptions) throws Exception {
        CreateKeyspaceStart keyspaceStart = SchemaBuilder.createKeyspace((String)keyspaceName);
        if (ifNotExists) {
            keyspaceStart = keyspaceStart.ifNotExists();
        }
        CreateKeyspace createKeyspace = (CreateKeyspace)keyspaceStart.withReplicationOptions(createOptions);
        try (CqlSession session = (CqlSession)this.getSessionBuilder().build();){
            session.execute((Statement)createKeyspace.build());
        }
    }

    public ResultSet executeCql(String query, Map<String, Object> values) throws Exception {
        try (CqlSession session = (CqlSession)this.getSessionBuilder().build();){
            ResultSet resultSet = session.execute(query, values);
            return resultSet;
        }
    }

    public boolean isExpandCollection() {
        return true;
    }

    public InetSocketAddress[] getAddresses() {
        if (!this.hosts.contains(",") && !this.hosts.contains(":")) {
            if (StringUtils.isEmpty((String)this.hosts)) {
                return new InetSocketAddress[0];
            }
            return new InetSocketAddress[]{new InetSocketAddress(this.hosts, this.port)};
        }
        String[] hostsStrings = StringUtils.split((String)this.hosts, (String)",");
        InetSocketAddress[] hosts = new InetSocketAddress[hostsStrings.length];
        for (int i = 0; i < hosts.length; ++i) {
            String[] hostPair = StringUtils.split((String)hostsStrings[i], (String)":");
            String hostName = hostPair[0].trim();
            int port = this.port;
            if (hostPair.length > 1) {
                try {
                    port = Integer.parseInt(hostPair[1].trim());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            hosts[i] = new InetSocketAddress(hostName, port);
        }
        return hosts;
    }

    private void registerCodecs(MutableCodecRegistry registry) {
        registry.register((TypeCodec)new MappingCodec<Integer, Long>((TypeCodec)TypeCodecs.INT, GenericType.LONG.unwrap()){

            @Nullable
            protected Long innerToOuter(@Nullable Integer value) {
                return value == null ? null : Long.valueOf(value.longValue());
            }

            @Nullable
            protected Integer outerToInner(@Nullable Long value) {
                return value == null ? null : Integer.valueOf(value.intValue());
            }
        });
        registry.register((TypeCodec)new MappingCodec<Float, Double>((TypeCodec)TypeCodecs.FLOAT, GenericType.DOUBLE.unwrap()){

            protected Float outerToInner(Double value) {
                return value == null ? null : Float.valueOf(value.floatValue());
            }

            protected Double innerToOuter(Float value) {
                return value == null ? null : Double.valueOf(value.doubleValue());
            }
        });
        registry.register((TypeCodec)new MappingCodec<Instant, Date>(TypeCodecs.TIMESTAMP, GenericType.of(Date.class)){

            @Nullable
            protected Date innerToOuter(@Nullable Instant instant) {
                if (instant == null) {
                    return null;
                }
                return new Date(instant.toEpochMilli());
            }

            @Nullable
            protected Instant outerToInner(@Nullable Date date) {
                if (date == null) {
                    return null;
                }
                return Instant.ofEpochMilli(date.getTime());
            }
        });
        registry.register((TypeCodec)new MappingCodec<Instant, Timestamp>(TypeCodecs.TIMESTAMP, GenericType.of(Timestamp.class)){

            @Nullable
            protected Timestamp innerToOuter(@Nullable Instant value) {
                if (value == null) {
                    return null;
                }
                Timestamp timestamp = new Timestamp(value.toEpochMilli());
                timestamp.setNanos(value.getNano());
                return timestamp;
            }

            @Nullable
            protected Instant outerToInner(@Nullable Timestamp timestamp) {
                if (timestamp == null) {
                    return null;
                }
                return Instant.ofEpochMilli(timestamp.getTime()).plusNanos(timestamp.getNanos());
            }
        });
    }

    public String getHosts() {
        return this.hosts;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getLocalDataCenter() {
        return this.localDataCenter;
    }

    public void setLocalDataCenter(String localDataCenter) {
        this.localDataCenter = localDataCenter;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Map<String, String> getOpts() {
        return this.opts;
    }

    public void setOpts(Map<String, String> opts) {
        this.opts = opts;
    }

    public boolean isUseCompression() {
        return this.useCompression;
    }

    public CqlSession getSession() {
        return this.session;
    }

    public void setSession(CqlSession session) {
        this.session = session;
    }

    public Map<String, CqlSession> getSessions() {
        return this.sessions;
    }
}

