/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.welcome;

import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiCompositeWidgets;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.util.EnvironmentUtils;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;

@GuiPlugin
public class WelcomeWelcome {
    private static final Class<?> PKG = WelcomeWelcome.class;
    private static final String WELCOME_WELCOME_PARENT_ID = "WelcomeWelcome.Parent.ID";
    public static final String WEB_NAME_HOP_APACHE_ORG = "hop.apache.org";
    public static final String WEB_LINK_HOP_APACHE_ORG = "https://hop.apache.org/";
    public static final String WEB_NAME_GETTING_STARTED = "The getting started guide";
    public static final String WEB_LINK_GETTING_STARTED = "https://hop.apache.org/manual/latest/getting-started/";
    public static final String WEB_NAME_USER_MANUAL = "The Hop user manual";
    public static final String WEB_LINK_USER_MANUAL = "https://hop.apache.org/manual/latest/";

    @GuiWidgetElement(type=GuiElementType.COMPOSITE, id="10000-welcome", label="Welcome!", parentId="WelcomeDialog.Parent.ID")
    public void welcome(Composite parent) {
        PropsUi props = PropsUi.getInstance();
        Composite parentComposite = new Composite(parent, 0);
        parentComposite.setLayout(props.createFormLayout());
        FormData fdParentComposite = new FormData();
        fdParentComposite.left = new FormAttachment(0, 0);
        fdParentComposite.right = new FormAttachment(100, 0);
        fdParentComposite.top = new FormAttachment(0, 0);
        fdParentComposite.bottom = new FormAttachment(100, 0);
        parentComposite.setLayoutData((Object)fdParentComposite);
        PropsUi.setLook((Widget)parentComposite);
        GuiCompositeWidgets compositeWidgets = new GuiCompositeWidgets(HopGui.getInstance().getVariables());
        compositeWidgets.createCompositeWidgets(this, null, parentComposite, WELCOME_WELCOME_PARENT_ID, null);
    }

    @GuiWidgetElement(id="WelcomeWelcome.1000-homepage", parentId="WelcomeWelcome.Parent.ID", type=GuiElementType.LINK, label="Welcome to the Apache Hop project!\n\nThe Hop Orchestration Platform, or Apache Hop, aims to facilitate all aspects of data and metadata orchestration.\n\nThe Apache Hop website can be found at <a>hop.apache.org</a>.\n\nBelow are a few documentation links to get started:\n")
    public void homepageLink(Event event) {
        this.handleWebLinkEvent(event, WEB_NAME_HOP_APACHE_ORG, WEB_LINK_HOP_APACHE_ORG);
    }

    @GuiWidgetElement(id="WelcomeWelcome.1010-getting-started", parentId="WelcomeWelcome.Parent.ID", type=GuiElementType.LINK, label="  * <a>The getting started guide</a>")
    public void gettingStarted(Event event) {
        this.handleWebLinkEvent(event, WEB_NAME_GETTING_STARTED, WEB_LINK_GETTING_STARTED);
    }

    @GuiWidgetElement(id="WelcomeWelcome.1020-user-manual", parentId="WelcomeWelcome.Parent.ID", type=GuiElementType.LINK, label="  * <a>The Hop user manual</a>\n\n\n\n")
    public void userManual(Event event) {
        this.handleWebLinkEvent(event, WEB_NAME_USER_MANUAL, WEB_LINK_USER_MANUAL);
    }

    private void handleWebLinkEvent(Event event, String text, String url) {
        try {
            if (text.equals(event.text)) {
                EnvironmentUtils.getInstance().openUrl(url);
            }
        }
        catch (Exception e) {
            new ErrorDialog(HopGui.getInstance().getShell(), "Error", "Error opening link to " + url, e);
        }
    }
}

