/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.widget;

import java.util.function.Supplier;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.ui.core.widget.IComboValuesSelectionListener;
import org.apache.hop.ui.core.widget.IFieldDisabledListener;
import org.apache.hop.ui.core.widget.ITextVarButtonRenderCallback;
import org.eclipse.swt.events.SelectionListener;

public class ColumnInfo {
    public static final int COLUMN_TYPE_NONE = 0;
    public static final int COLUMN_TYPE_TEXT = 1;
    public static final int COLUMN_TYPE_CCOMBO = 2;
    public static final int COLUMN_TYPE_BUTTON = 3;
    public static final int COLUMN_TYPE_ICON = 4;
    public static final int COLUMN_TYPE_FORMAT = 5;
    public static final int COLUMN_TYPE_TEXT_BUTTON = 6;
    private int type;
    private String name;
    private String[] comboValues;
    private Supplier<String[]> comboValueSupplier = () -> this.comboValues;
    private boolean numeric;
    private String tooltip;
    private int alignment;
    private boolean readonly;
    private String buttonText;
    private boolean hidingNegativeValues;
    private int width = -1;
    private boolean autoResize = true;
    private IValueMeta valueMeta;
    private SelectionListener selButton;
    private SelectionListener textVarButtonSelectionListener;
    private ITextVarButtonRenderCallback renderTextVarButtonCallback;
    private IFieldDisabledListener disabledListener;
    private boolean usingVariables;
    private boolean passwordField;
    private IComboValuesSelectionListener comboValuesSelectionListener;
    private int fieldTypeColumn;

    public ColumnInfo(String columnName, int columnType) {
        this.name = columnName;
        this.type = columnType;
        this.comboValues = null;
        this.numeric = false;
        this.tooltip = null;
        this.alignment = 16384;
        this.readonly = false;
        this.hidingNegativeValues = false;
        this.valueMeta = new ValueMetaString(columnName);
    }

    public ColumnInfo(String columnName, int columnType, String ... comboValues) {
        this(columnName, columnType);
        this.comboValues = comboValues;
        this.numeric = false;
        this.tooltip = null;
        this.alignment = 16384;
        this.readonly = false;
        this.hidingNegativeValues = false;
        this.valueMeta = new ValueMetaString(columnName);
    }

    public ColumnInfo(String columnName, int columnType, boolean numeric) {
        this(columnName, columnType);
        this.comboValues = null;
        this.numeric = numeric;
        this.tooltip = null;
        this.alignment = 16384;
        this.readonly = false;
        this.hidingNegativeValues = false;
        this.valueMeta = numeric ? new ValueMetaInteger(columnName) : new ValueMetaString(columnName);
    }

    public ColumnInfo(String colname, int coltype, String[] combo, boolean ro) {
        this(colname, coltype, combo);
        this.readonly = ro;
    }

    public ColumnInfo(String colname, int coltype, boolean num, boolean ro) {
        this(colname, coltype, num);
        this.readonly = ro;
    }

    public ColumnInfo(String colname, int coltype, boolean num, boolean ro, int width) {
        this(colname, coltype, num);
        this.readonly = ro;
        this.width = width;
    }

    public ColumnInfo(String colname, int coltype, int fieldTypeColumn) {
        this(colname, coltype);
        this.fieldTypeColumn = fieldTypeColumn;
    }

    public String toString() {
        return this.name;
    }

    public void setToolTip(String tip) {
        this.tooltip = tip;
    }

    public void setReadOnly(boolean ro) {
        this.readonly = ro;
    }

    public void setAlignment(int allign) {
        this.alignment = allign;
    }

    public void setComboValues(String[] cv) {
        this.comboValues = cv;
    }

    public void setComboValueSupplier(Supplier<String[]> comboValueSupplier) {
        this.comboValueSupplier = comboValueSupplier;
    }

    public void setButtonText(String bt) {
        this.buttonText = bt;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public String[] getComboValues() {
        String[] retval = this.comboValueSupplier.get();
        return retval;
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public void setNumeric(boolean numeric) {
        this.numeric = numeric;
    }

    public String getToolTip() {
        return this.tooltip;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public boolean isReadOnly() {
        return this.readonly;
    }

    public String getButtonText() {
        return this.buttonText;
    }

    public void setSelectionAdapter(SelectionListener sb) {
        this.selButton = sb;
    }

    public SelectionListener getSelectionAdapter() {
        return this.selButton;
    }

    public void hideNegative() {
        this.hidingNegativeValues = true;
    }

    public void showNegative() {
        this.hidingNegativeValues = false;
    }

    public boolean isNegativeHidden() {
        return this.hidingNegativeValues;
    }

    public IValueMeta getValueMeta() {
        return this.valueMeta;
    }

    public void setValueMeta(IValueMeta valueMeta) {
        this.valueMeta = valueMeta;
    }

    public boolean isUsingVariables() {
        return this.usingVariables;
    }

    public void setUsingVariables(boolean usingVariables) {
        this.usingVariables = usingVariables;
    }

    public boolean isPasswordField() {
        return this.passwordField;
    }

    public void setPasswordField(boolean password) {
        this.passwordField = password;
    }

    public int getFieldTypeColumn() {
        return this.fieldTypeColumn;
    }

    public void setFieldTypeColumn(int fieldTypeColumn) {
        this.fieldTypeColumn = fieldTypeColumn;
    }

    public IComboValuesSelectionListener getComboValuesSelectionListener() {
        return this.comboValuesSelectionListener;
    }

    public void setComboValuesSelectionListener(IComboValuesSelectionListener comboValuesSelectionListener) {
        this.comboValuesSelectionListener = comboValuesSelectionListener;
    }

    public IFieldDisabledListener getDisabledListener() {
        return this.disabledListener;
    }

    public void setDisabledListener(IFieldDisabledListener disabledListener) {
        this.disabledListener = disabledListener;
    }

    public SelectionListener getTextVarButtonSelectionListener() {
        return this.textVarButtonSelectionListener;
    }

    public void setTextVarButtonSelectionListener(SelectionListener textVarButtonSelectionListener) {
        this.textVarButtonSelectionListener = textVarButtonSelectionListener;
    }

    public void setRenderTextVarButtonCallback(ITextVarButtonRenderCallback callback) {
        this.renderTextVarButtonCallback = callback;
    }

    public boolean shouldRenderTextVarButton() {
        return this.renderTextVarButtonCallback == null || this.renderTextVarButtonCallback.shouldRenderButton();
    }

    public int getWidth() {
        return this.width;
    }

    public boolean isAutoResize() {
        return this.autoResize;
    }

    public void setAutoResize(boolean resize) {
        this.autoResize = resize;
    }
}

