/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.dialog;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hop.core.Const;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class DialogBoxWithButtons {
    private PropsUi props;
    private Shell shell;
    private final Shell parent;
    private final String title;
    private final String message;
    private final String[] buttonLabels;
    private final AtomicInteger choice;

    public DialogBoxWithButtons(Shell parent, String title, String message, String[] buttonLabels) {
        this.parent = parent;
        this.title = title;
        this.message = message;
        this.buttonLabels = buttonLabels;
        this.choice = new AtomicInteger();
    }

    public int open() {
        int formMargin;
        this.props = PropsUi.getInstance();
        this.shell = new Shell(this.parent, 2160);
        this.shell.setText(Const.NVL((String)this.title, (String)""));
        this.shell.setImage(GuiResource.getInstance().getImageHopUi());
        FormLayout formLayout = new FormLayout();
        formLayout.marginTop = formMargin = (int)((double)PropsUi.getFormMargin() * this.props.getZoomFactor());
        formLayout.marginLeft = formMargin;
        formLayout.marginBottom = formMargin;
        formLayout.marginRight = formMargin;
        this.shell.setLayout((Layout)formLayout);
        Label wLabel = new Label((Composite)this.shell, 0x1000040);
        PropsUi.setLook((Widget)wLabel);
        wLabel.setText(Const.NVL((String)this.message, (String)""));
        FormData fdLabel = new FormData();
        fdLabel.left = new FormAttachment(0, 0);
        fdLabel.top = new FormAttachment(0, 0);
        fdLabel.right = new FormAttachment(100, 0);
        wLabel.setLayoutData((Object)fdLabel);
        ArrayList<Button> buttons = new ArrayList<Button>();
        int i = 0;
        while (i < this.buttonLabels.length) {
            String buttonLabel = this.buttonLabels[i];
            Button button = new Button((Composite)this.shell, 8);
            PropsUi.setLook((Widget)button);
            button.setText(Const.NVL((String)buttonLabel, (String)""));
            buttons.add(button);
            int index = i++;
            button.addListener(13, e -> {
                this.choice.set(index);
                this.dispose();
            });
        }
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, buttons.toArray(new Button[0]), formMargin, (Control)wLabel);
        BaseTransformDialog.setSize(this.shell);
        this.shell.addListener(21, e -> this.dispose());
        BaseTransformDialog.setSize(this.shell);
        this.shell.open();
        Display display = this.shell.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.choice.get();
    }

    private void close() {
        this.choice.set(255);
    }

    private void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }
}

