/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.database.dialog;

import java.lang.reflect.InvocationTargetException;
import org.apache.hop.core.IProgressMonitor;
import org.apache.hop.core.IRunnableWithProgress;
import org.apache.hop.core.ProgressMonitorAdapter;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.database.DatabaseMetaInformation;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.ProgressMonitorDialog;
import org.apache.hop.ui.hopgui.HopGui;
import org.eclipse.swt.widgets.Shell;

public class GetDatabaseInfoProgressDialog {
    private static final Class<?> PKG = GetDatabaseInfoProgressDialog.class;
    private Shell shell;
    private final IVariables variables;
    private DatabaseMeta databaseMeta;

    public GetDatabaseInfoProgressDialog(Shell shell, IVariables variables, DatabaseMeta databaseMeta) {
        this.shell = shell;
        this.variables = variables;
        this.databaseMeta = databaseMeta;
    }

    public DatabaseMetaInformation open() {
        DatabaseMetaInformation dmi = new DatabaseMetaInformation(this.variables, this.databaseMeta);
        IRunnableWithProgress op = monitor -> {
            try {
                dmi.getData(HopGui.getInstance().getLoggingObject(), (IProgressMonitor)new ProgressMonitorAdapter(monitor));
            }
            catch (Exception e) {
                throw new InvocationTargetException(e, BaseMessages.getString(PKG, (String)"GetDatabaseInfoProgressDialog.Error.GettingInfoTable", (String[])new String[]{e.toString()}));
            }
        };
        try {
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.shell);
            pmd.run(true, op);
            if (pmd.getProgressMonitor().isCanceled()) {
                return null;
            }
        }
        catch (InvocationTargetException e) {
            this.showErrorDialog(e);
            return null;
        }
        catch (InterruptedException e) {
            this.showErrorDialog(e);
            return null;
        }
        return dmi;
    }

    private void showErrorDialog(Exception e) {
        new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"GetDatabaseInfoProgressDialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetDatabaseInfoProgressDialog.Error.Message", (String[])new String[0]), e);
    }
}

