/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.CursorBuilder;
import com.healthmarketscience.jackcess.DataType;
import com.healthmarketscience.jackcess.IndexCursor;
import com.healthmarketscience.jackcess.Row;
import com.healthmarketscience.jackcess.Table;
import com.healthmarketscience.jackcess.complex.ComplexColumnInfo;
import com.healthmarketscience.jackcess.complex.ComplexValue;
import com.healthmarketscience.jackcess.impl.ColumnImpl;
import com.healthmarketscience.jackcess.impl.DatabaseImpl;
import com.healthmarketscience.jackcess.impl.TableImpl;
import com.healthmarketscience.jackcess.impl.complex.AttachmentColumnInfoImpl;
import com.healthmarketscience.jackcess.impl.complex.MultiValueColumnInfoImpl;
import com.healthmarketscience.jackcess.impl.complex.UnsupportedColumnInfoImpl;
import com.healthmarketscience.jackcess.impl.complex.VersionHistoryColumnInfoImpl;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ComplexColumnSupport {
    private static final Log LOG = LogFactory.getLog(ComplexColumnSupport.class);
    private static final String COL_COMPLEX_TYPE_OBJECT_ID = "ComplexTypeObjectID";
    private static final String COL_TABLE_ID = "ConceptualTableID";
    private static final String COL_FLAT_TABLE_ID = "FlatTableID";
    private static final Set<DataType> MULTI_VALUE_TYPES = EnumSet.of(DataType.BYTE, new DataType[]{DataType.INT, DataType.LONG, DataType.FLOAT, DataType.DOUBLE, DataType.GUID, DataType.NUMERIC, DataType.TEXT, DataType.BIG_INT});

    public static ComplexColumnInfo<? extends ComplexValue> create(ColumnImpl column, ByteBuffer buffer, int offset) throws IOException {
        int complexTypeId = buffer.getInt(offset + column.getFormat().OFFSET_COLUMN_COMPLEX_ID);
        DatabaseImpl db = column.getDatabase();
        TableImpl complexColumns = db.getSystemComplexColumns();
        IndexCursor cursor = CursorBuilder.createCursor(complexColumns.getPrimaryKeyIndex());
        if (!cursor.findFirstRowByEntry(complexTypeId)) {
            throw new IOException(column.withErrorContext("Could not find complex column info for complex column with id " + complexTypeId));
        }
        Row cColRow = cursor.getCurrentRow();
        int tableId = cColRow.getInt(COL_TABLE_ID);
        if (tableId != column.getTable().getTableDefPageNumber()) {
            throw new IOException(column.withErrorContext("Found complex column for table " + tableId + " but expected table " + column.getTable().getTableDefPageNumber()));
        }
        int flatTableId = cColRow.getInt(COL_FLAT_TABLE_ID);
        int typeObjId = cColRow.getInt(COL_COMPLEX_TYPE_OBJECT_ID);
        TableImpl typeObjTable = db.getTable(typeObjId);
        TableImpl flatTable = db.getTable(flatTableId);
        if (typeObjTable == null || flatTable == null) {
            throw new IOException(column.withErrorContext("Could not find supporting tables (" + typeObjId + ", " + flatTableId + ") for complex column with id " + complexTypeId));
        }
        if (ComplexColumnSupport.isMultiValueColumn(typeObjTable)) {
            return new MultiValueColumnInfoImpl(column, complexTypeId, typeObjTable, flatTable);
        }
        if (ComplexColumnSupport.isAttachmentColumn(typeObjTable)) {
            return new AttachmentColumnInfoImpl(column, complexTypeId, typeObjTable, flatTable);
        }
        if (ComplexColumnSupport.isVersionHistoryColumn(typeObjTable)) {
            return new VersionHistoryColumnInfoImpl(column, complexTypeId, typeObjTable, flatTable);
        }
        LOG.warn((Object)column.withErrorContext("Unsupported complex column type " + typeObjTable.getName()));
        return new UnsupportedColumnInfoImpl(column, complexTypeId, typeObjTable, flatTable);
    }

    public static boolean isMultiValueColumn(Table typeObjTable) {
        List<? extends Column> typeCols = typeObjTable.getColumns();
        return typeCols.size() == 1 && MULTI_VALUE_TYPES.contains((Object)typeCols.get(0).getType());
    }

    public static boolean isAttachmentColumn(Table typeObjTable) {
        List<? extends Column> typeCols = typeObjTable.getColumns();
        if (typeCols.size() < 6) {
            return false;
        }
        int numMemo = 0;
        int numText = 0;
        int numDate = 0;
        int numOle = 0;
        int numLong = 0;
        for (Column column : typeCols) {
            switch (column.getType()) {
                case TEXT: {
                    ++numText;
                    break;
                }
                case LONG: {
                    ++numLong;
                    break;
                }
                case SHORT_DATE_TIME: {
                    ++numDate;
                    break;
                }
                case OLE: {
                    ++numOle;
                    break;
                }
                case MEMO: {
                    ++numMemo;
                    break;
                }
            }
        }
        return numMemo >= 1 && numText >= 2 && numOle >= 1 && numDate >= 1 && numLong >= 1;
    }

    public static boolean isVersionHistoryColumn(Table typeObjTable) {
        List<? extends Column> typeCols = typeObjTable.getColumns();
        if (typeCols.size() < 2) {
            return false;
        }
        int numMemo = 0;
        int numDate = 0;
        for (Column column : typeCols) {
            switch (column.getType()) {
                case SHORT_DATE_TIME: {
                    ++numDate;
                    break;
                }
                case MEMO: {
                    ++numMemo;
                    break;
                }
            }
        }
        return numMemo >= 1 && numDate >= 1;
    }
}

