/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction;

import com.google.cloud.Timestamp;
import java.io.Serializable;
import java.util.Objects;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionMode;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionRestrictionMetadata;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PartitionRestriction
implements Serializable {
    private static final long serialVersionUID = -7009236776208644264L;
    private final Timestamp startTimestamp;
    private final Timestamp endTimestamp;
    private final PartitionMode mode;
    private final @Nullable PartitionMode stoppedMode;
    private PartitionRestrictionMetadata metadata;

    public static PartitionRestriction updateState(Timestamp startTimestamp, Timestamp endTimestamp) {
        return new PartitionRestriction(startTimestamp, endTimestamp, PartitionMode.UPDATE_STATE, null);
    }

    public static PartitionRestriction queryChangeStream(Timestamp startTimestamp, Timestamp endTimestamp) {
        return new PartitionRestriction(startTimestamp, endTimestamp, PartitionMode.QUERY_CHANGE_STREAM, null);
    }

    public static PartitionRestriction waitForChildPartitions(Timestamp startTimestamp, Timestamp endTimestamp) {
        return new PartitionRestriction(startTimestamp, endTimestamp, PartitionMode.WAIT_FOR_CHILD_PARTITIONS, null);
    }

    public static PartitionRestriction done(Timestamp startTimestamp, Timestamp endTimestamp) {
        return new PartitionRestriction(startTimestamp, endTimestamp, PartitionMode.DONE, null);
    }

    public static PartitionRestriction stop(PartitionRestriction restriction) {
        return new PartitionRestriction(restriction.getStartTimestamp(), restriction.getEndTimestamp(), PartitionMode.STOP, restriction.getMode()).withMetadata(restriction.getMetadata());
    }

    public PartitionRestriction(Timestamp startTimestamp, Timestamp endTimestamp, PartitionMode mode, @Nullable PartitionMode stoppedMode) {
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
        this.mode = mode;
        this.stoppedMode = stoppedMode;
    }

    public PartitionRestriction withMetadata(PartitionRestrictionMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    public Timestamp getStartTimestamp() {
        return this.startTimestamp;
    }

    public Timestamp getEndTimestamp() {
        return this.endTimestamp;
    }

    public PartitionMode getMode() {
        return this.mode;
    }

    public @Nullable PartitionMode getStoppedMode() {
        return this.stoppedMode;
    }

    public PartitionRestrictionMetadata getMetadata() {
        return this.metadata;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PartitionRestriction)) {
            return false;
        }
        PartitionRestriction that = (PartitionRestriction)o;
        return Objects.equals(this.startTimestamp, that.startTimestamp) && Objects.equals(this.endTimestamp, that.endTimestamp) && this.mode == that.mode && this.stoppedMode == that.stoppedMode;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.startTimestamp, this.endTimestamp, this.mode, this.stoppedMode});
    }

    public String toString() {
        return "PartitionRestriction{startTimestamp=" + this.startTimestamp + ", endTimestamp=" + this.endTimestamp + ", mode=" + (Object)((Object)this.mode) + ", stoppedMode=" + (Object)((Object)this.stoppedMode) + ", metadata=" + this.metadata + '}';
    }
}

