/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.MapCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.sdk.values.TypeDescriptor;

public class PubsubMessageWithAttributesAndMessageIdCoder
extends CustomCoder<PubsubMessage> {
    private static final Coder<byte[]> PAYLOAD_CODER = ByteArrayCoder.of();
    private static final Coder<Map<String, String>> ATTRIBUTES_CODER = NullableCoder.of((Coder)MapCoder.of((Coder)StringUtf8Coder.of(), (Coder)StringUtf8Coder.of()));
    private static final Coder<String> MESSAGE_ID_CODER = StringUtf8Coder.of();

    public static Coder<PubsubMessage> of(TypeDescriptor<PubsubMessage> ignored) {
        return PubsubMessageWithAttributesAndMessageIdCoder.of();
    }

    public static PubsubMessageWithAttributesAndMessageIdCoder of() {
        return new PubsubMessageWithAttributesAndMessageIdCoder();
    }

    public void encode(PubsubMessage value, OutputStream outStream) throws IOException {
        PAYLOAD_CODER.encode((Object)value.getPayload(), outStream);
        ATTRIBUTES_CODER.encode(value.getAttributeMap(), outStream);
        MESSAGE_ID_CODER.encode((Object)value.getMessageId(), outStream);
    }

    public PubsubMessage decode(InputStream inStream) throws IOException {
        byte[] payload = (byte[])PAYLOAD_CODER.decode(inStream);
        Map attributes = (Map)ATTRIBUTES_CODER.decode(inStream);
        String messageId = (String)MESSAGE_ID_CODER.decode(inStream);
        return new PubsubMessage(payload, attributes, messageId);
    }
}

