/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import com.google.api.client.util.DateTime;
import com.google.auto.value.AutoValue;
import com.google.protobuf.ByteString;
import com.google.pubsub.v1.PubsubMessage;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.beam.sdk.io.gcp.pubsub.AutoValue_PubsubClient_IncomingMessage;
import org.apache.beam.sdk.io.gcp.pubsub.AutoValue_PubsubClient_OutgoingMessage;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubOptions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Objects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Splitter;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class PubsubClient
implements Closeable {
    protected static Long parseTimestampAsMsSinceEpoch(String timestamp) {
        if (timestamp.isEmpty()) {
            throw new IllegalArgumentException("Empty timestamp.");
        }
        try {
            return Long.parseLong(timestamp);
        }
        catch (IllegalArgumentException e1) {
            return DateTime.parseRfc3339((String)timestamp).getValue();
        }
    }

    protected static long extractTimestampAttribute(String timestampAttribute, @Nullable Map<String, String> attributes) {
        Preconditions.checkState((!timestampAttribute.isEmpty() ? 1 : 0) != 0);
        String value = attributes == null ? null : attributes.get(timestampAttribute);
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"PubSub message is missing a value for timestamp attribute %s", (Object)timestampAttribute);
        Long timestampMsSinceEpoch = PubsubClient.parseTimestampAsMsSinceEpoch(value);
        Preconditions.checkArgument((timestampMsSinceEpoch != null ? 1 : 0) != 0, (String)"Cannot interpret value of attribute %s as timestamp: %s", (Object)timestampAttribute, (Object)value);
        return timestampMsSinceEpoch;
    }

    public static ProjectPath projectPathFromPath(String path) {
        return new ProjectPath(path);
    }

    public static ProjectPath projectPathFromId(String projectId) {
        return new ProjectPath(String.format("projects/%s", projectId));
    }

    public static SubscriptionPath subscriptionPathFromPath(String path) {
        return new SubscriptionPath(path);
    }

    public static SubscriptionPath subscriptionPathFromName(String projectId, String subscriptionName) {
        return new SubscriptionPath(String.format("projects/%s/subscriptions/%s", projectId, subscriptionName));
    }

    public static TopicPath topicPathFromPath(String path) {
        return new TopicPath(path);
    }

    public static TopicPath topicPathFromName(String projectId, String topicName) {
        return new TopicPath(String.format("projects/%s/topics/%s", projectId, topicName));
    }

    public abstract int publish(TopicPath var1, List<OutgoingMessage> var2) throws IOException;

    public abstract List<IncomingMessage> pull(long var1, SubscriptionPath var3, int var4, boolean var5) throws IOException;

    public abstract void acknowledge(SubscriptionPath var1, List<String> var2) throws IOException;

    public abstract void modifyAckDeadline(SubscriptionPath var1, List<String> var2, int var3) throws IOException;

    public abstract void createTopic(TopicPath var1) throws IOException;

    public abstract void deleteTopic(TopicPath var1) throws IOException;

    public abstract List<TopicPath> listTopics(ProjectPath var1) throws IOException;

    public abstract void createSubscription(TopicPath var1, SubscriptionPath var2, int var3) throws IOException;

    public SubscriptionPath createRandomSubscription(ProjectPath project, TopicPath topic, int ackDeadlineSeconds) throws IOException {
        String subscriptionName = topic.getName() + "_beam_" + ThreadLocalRandom.current().nextLong();
        SubscriptionPath subscription = PubsubClient.subscriptionPathFromName(project.getId(), subscriptionName);
        this.createSubscription(topic, subscription, ackDeadlineSeconds);
        return subscription;
    }

    public abstract void deleteSubscription(SubscriptionPath var1) throws IOException;

    public abstract List<SubscriptionPath> listSubscriptions(ProjectPath var1, TopicPath var2) throws IOException;

    public abstract int ackDeadlineSeconds(SubscriptionPath var1) throws IOException;

    public abstract boolean isEOF();

    @AutoValue
    static abstract class IncomingMessage
    implements Serializable {
        IncomingMessage() {
        }

        public abstract com.google.pubsub.v1.PubsubMessage message();

        public abstract long timestampMsSinceEpoch();

        public abstract long requestTimeMsSinceEpoch();

        public abstract String ackId();

        public abstract String recordId();

        public static IncomingMessage of(com.google.pubsub.v1.PubsubMessage message, long timestampMsSinceEpoch, long requestTimeMsSinceEpoch, String ackId, String recordId) {
            return new AutoValue_PubsubClient_IncomingMessage(message, timestampMsSinceEpoch, requestTimeMsSinceEpoch, ackId, recordId);
        }
    }

    @AutoValue
    public static abstract class OutgoingMessage
    implements Serializable {
        public abstract com.google.pubsub.v1.PubsubMessage message();

        public abstract long timestampMsSinceEpoch();

        public abstract @Nullable String recordId();

        public static OutgoingMessage of(com.google.pubsub.v1.PubsubMessage message, long timestampMsSinceEpoch, @Nullable String recordId) {
            return new AutoValue_PubsubClient_OutgoingMessage(message, timestampMsSinceEpoch, recordId);
        }

        public static OutgoingMessage of(PubsubMessage message, long timestampMsSinceEpoch, @Nullable String recordId) {
            PubsubMessage.Builder builder = com.google.pubsub.v1.PubsubMessage.newBuilder().setData(ByteString.copyFrom((byte[])message.getPayload()));
            if (message.getAttributeMap() != null) {
                builder.putAllAttributes(message.getAttributeMap());
            }
            if (message.getOrderingKey() != null) {
                builder.setOrderingKey(message.getOrderingKey());
            }
            return OutgoingMessage.of(builder.build(), timestampMsSinceEpoch, recordId);
        }
    }

    public static class TopicPath
    implements Serializable {
        private final String path;

        TopicPath(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        public String getName() {
            List splits = Splitter.on((char)'/').splitToList((CharSequence)this.path);
            Preconditions.checkState((splits.size() == 4 ? 1 : 0) != 0, (String)"Malformed topic path %s", (Object)this.path);
            return (String)splits.get(3);
        }

        public String getFullPath() {
            List splits = Splitter.on((char)'/').splitToList((CharSequence)this.path);
            Preconditions.checkState((splits.size() == 4 ? 1 : 0) != 0, (String)"Malformed topic path %s", (Object)this.path);
            return String.format("/topics/%s/%s", splits.get(1), splits.get(3));
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TopicPath topicPath = (TopicPath)o;
            return this.path.equals(topicPath.path);
        }

        public int hashCode() {
            return this.path.hashCode();
        }

        public String toString() {
            return this.path;
        }
    }

    public static class SubscriptionPath
    implements Serializable {
        private final String projectId;
        private final String subscriptionName;

        SubscriptionPath(String path) {
            List splits = Splitter.on((char)'/').splitToList((CharSequence)path);
            Preconditions.checkState((splits.size() == 4 && "projects".equals(splits.get(0)) && "subscriptions".equals(splits.get(2)) ? 1 : 0) != 0, (String)"Malformed subscription path %s: must be of the form \"projects/\" + <project id> + \"subscriptions\"", (Object)path);
            this.projectId = (String)splits.get(1);
            this.subscriptionName = (String)splits.get(3);
        }

        public String getPath() {
            return String.format("projects/%s/subscriptions/%s", this.projectId, this.subscriptionName);
        }

        public String getName() {
            return this.subscriptionName;
        }

        public String getFullPath() {
            return String.format("/subscriptions/%s/%s", this.projectId, this.subscriptionName);
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SubscriptionPath that = (SubscriptionPath)o;
            return this.subscriptionName.equals(that.subscriptionName) && this.projectId.equals(that.projectId);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.projectId, this.subscriptionName});
        }

        public String toString() {
            return this.getPath();
        }
    }

    public static class ProjectPath
    implements Serializable {
        private final String projectId;

        ProjectPath(String path) {
            List splits = Splitter.on((char)'/').splitToList((CharSequence)path);
            Preconditions.checkArgument((splits.size() == 2 && "projects".equals(splits.get(0)) ? 1 : 0) != 0, (String)"Malformed project path \"%s\": must be of the form \"projects/\" + <project id>", (Object)path);
            this.projectId = (String)splits.get(1);
        }

        public String getPath() {
            return String.format("projects/%s", this.projectId);
        }

        public String getId() {
            return this.projectId;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProjectPath that = (ProjectPath)o;
            return this.projectId.equals(that.projectId);
        }

        public int hashCode() {
            return this.projectId.hashCode();
        }

        public String toString() {
            return this.getPath();
        }
    }

    public static interface PubsubClientFactory
    extends Serializable {
        public PubsubClient newClient(@Nullable String var1, @Nullable String var2, PubsubOptions var3, @Nullable String var4) throws IOException;

        public PubsubClient newClient(@Nullable String var1, @Nullable String var2, PubsubOptions var3) throws IOException;

        public String getKind();
    }
}

