/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.firestore;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ClientSettings;
import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.firestore.v1.FirestoreSettings;
import com.google.cloud.firestore.v1.stub.FirestoreStub;
import com.google.cloud.firestore.v1.stub.GrpcFirestoreStub;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.io.gcp.firestore.CounterFactory;
import org.apache.beam.sdk.io.gcp.firestore.DistributionFactory;
import org.apache.beam.sdk.io.gcp.firestore.FirestoreOptions;
import org.apache.beam.sdk.io.gcp.firestore.RpcQos;
import org.apache.beam.sdk.io.gcp.firestore.RpcQosImpl;
import org.apache.beam.sdk.io.gcp.firestore.RpcQosOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.util.Sleeper;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.nullness.qual.NonNull;

@Immutable
class FirestoreStatefulComponentFactory
implements Serializable {
    static final FirestoreStatefulComponentFactory INSTANCE = new FirestoreStatefulComponentFactory();

    private FirestoreStatefulComponentFactory() {
    }

    FirestoreStub getFirestoreStub(final PipelineOptions options) {
        try {
            FirestoreSettings.Builder builder = (FirestoreSettings.Builder)FirestoreSettings.newBuilder().setHeaderProvider((HeaderProvider)new FixedHeaderProvider(){

                public Map<@NonNull String, @NonNull String> getHeaders() {
                    return ImmutableMap.of((Object)"User-Agent", (Object)options.getUserAgent());
                }
            });
            RetrySettings retrySettings = RetrySettings.newBuilder().setMaxAttempts(1).build();
            builder.applyToAllUnaryMethods(b -> {
                b.setRetrySettings(retrySettings);
                return null;
            });
            FirestoreOptions firestoreOptions = (FirestoreOptions)options.as(FirestoreOptions.class);
            String emulatorHostPort = firestoreOptions.getEmulatorHost();
            if (emulatorHostPort != null) {
                ((FirestoreSettings.Builder)((FirestoreSettings.Builder)builder.setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)new FirestoreOptions.EmulatorCredentials()))).setEndpoint(emulatorHostPort)).setTransportChannelProvider((TransportChannelProvider)InstantiatingGrpcChannelProvider.newBuilder().setEndpoint(emulatorHostPort).setChannelConfigurator(c -> c.usePlaintext()).build());
            } else {
                GcpOptions gcpOptions = (GcpOptions)options.as(GcpOptions.class);
                ((FirestoreSettings.Builder)builder.setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)gcpOptions.getGcpCredential()))).setEndpoint("batch-firestore.googleapis.com:443");
            }
            ClientContext clientContext = ClientContext.create((ClientSettings)builder.build());
            return GrpcFirestoreStub.create((ClientContext)clientContext);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    RpcQos getRpcQos(RpcQosOptions options) {
        return new RpcQosImpl(options, new SecureRandom(), Sleeper.DEFAULT, CounterFactory.DEFAULT, DistributionFactory.DEFAULT);
    }
}

