/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableSchema;
import java.util.ArrayList;
import java.util.Map;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServicesImpl;
import org.apache.beam.sdk.io.gcp.bigquery.CreateTableHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Supplier;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CreateTables<DestinationT, ElementT>
extends PTransform<PCollection<KV<DestinationT, ElementT>>, PCollection<KV<TableDestination, ElementT>>> {
    private final BigQueryIO.Write.CreateDisposition createDisposition;
    private final BigQueryServices bqServices;
    private final DynamicDestinations<?, DestinationT> dynamicDestinations;
    private final @Nullable String kmsKey;

    public CreateTables(BigQueryIO.Write.CreateDisposition createDisposition, DynamicDestinations<?, DestinationT> dynamicDestinations) {
        this(createDisposition, new BigQueryServicesImpl(), dynamicDestinations, null);
    }

    private CreateTables(BigQueryIO.Write.CreateDisposition createDisposition, BigQueryServices bqServices, DynamicDestinations<?, DestinationT> dynamicDestinations, @Nullable String kmsKey) {
        this.createDisposition = createDisposition;
        this.bqServices = bqServices;
        this.dynamicDestinations = dynamicDestinations;
        this.kmsKey = kmsKey;
    }

    CreateTables<DestinationT, ElementT> withKmsKey(@Nullable String kmsKey) {
        return new CreateTables<DestinationT, ElementT>(this.createDisposition, this.bqServices, this.dynamicDestinations, kmsKey);
    }

    CreateTables<DestinationT, ElementT> withTestServices(BigQueryServices bqServices) {
        return new CreateTables<DestinationT, ElementT>(this.createDisposition, bqServices, this.dynamicDestinations, this.kmsKey);
    }

    public PCollection<KV<TableDestination, ElementT>> expand(PCollection<KV<DestinationT, ElementT>> input) {
        ArrayList sideInputs = Lists.newArrayList();
        sideInputs.addAll(this.dynamicDestinations.getSideInputs());
        return (PCollection)input.apply((PTransform)ParDo.of((DoFn)new CreateTablesFn()).withSideInputs((Iterable)sideInputs));
    }

    @VisibleForTesting
    static void clearCreatedTables() {
        CreateTableHelpers.clearCreatedTables();
    }

    private class CreateTablesFn
    extends DoFn<KV<DestinationT, ElementT>, KV<TableDestination, ElementT>> {
        private @Nullable Map<DestinationT, TableDestination> destinations = null;

        private CreateTablesFn() {
        }

        @DoFn.StartBundle
        public void startBundle() {
            this.destinations = Maps.newHashMap();
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext context) {
            CreateTables.this.dynamicDestinations.setSideInputAccessorFromProcessContext(context);
            org.apache.beam.sdk.util.Preconditions.checkStateNotNull(this.destinations);
            TableDestination tableDestination = this.destinations.computeIfAbsent(((KV)context.element()).getKey(), dest -> {
                TableDestination tableDestination1 = CreateTables.this.dynamicDestinations.getTable(dest);
                Preconditions.checkArgument((tableDestination1 != null ? 1 : 0) != 0, (String)"DynamicDestinations.getTable() may not return null, but %s returned null for destination %s", (Object)CreateTables.this.dynamicDestinations, (Object)dest);
                @Nullable Supplier schemaSupplier = () -> CreateTables.this.dynamicDestinations.getSchema(dest);
                return CreateTableHelpers.possiblyCreateTable(context, tableDestination1, (Supplier<TableSchema>)schemaSupplier, CreateTables.this.createDisposition, CreateTables.this.dynamicDestinations.getDestinationCoder(), CreateTables.this.kmsKey, CreateTables.this.bqServices);
            });
            context.output((Object)KV.of((Object)tableDestination, (Object)((KV)context.element()).getValue()));
        }
    }
}

