/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.concurrent;

import java.util.Arrays;
import org.apache.cassandra.utils.Throwables;
import org.apache.cassandra.utils.concurrent.RefCounted;
import org.apache.cassandra.utils.concurrent.SharedCloseableImpl;

public abstract class WrappedSharedCloseable
extends SharedCloseableImpl {
    final AutoCloseable[] wrapped;

    public WrappedSharedCloseable(AutoCloseable closeable) {
        this(new AutoCloseable[]{closeable});
    }

    public WrappedSharedCloseable(AutoCloseable[] closeable) {
        super(new Tidy(closeable));
        this.wrapped = closeable;
    }

    protected WrappedSharedCloseable(WrappedSharedCloseable copy) {
        super(copy);
        this.wrapped = copy.wrapped;
    }

    static final class Tidy
    implements RefCounted.Tidy {
        final AutoCloseable[] closeable;

        Tidy(AutoCloseable[] closeable) {
            this.closeable = closeable;
        }

        @Override
        public void tidy() throws Exception {
            Throwable fail = null;
            for (AutoCloseable c : this.closeable) {
                try {
                    c.close();
                }
                catch (Throwable t) {
                    fail = Throwables.merge(fail, t);
                }
            }
            Throwables.maybeFail(fail);
        }

        @Override
        public String name() {
            return Arrays.toString(this.closeable);
        }
    }
}

