/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.transforms.pubsub;

import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.beam.core.transform.BeamPublishTransform;
import org.apache.hop.beam.engines.IBeamPipelineEngineRunConfiguration;
import org.apache.hop.beam.pipeline.IBeamPipelineTransformHandler;
import org.apache.hop.beam.transforms.pubsub.BeamPublish;
import org.apache.hop.beam.transforms.pubsub.BeamPublishData;
import org.apache.hop.beam.transforms.pubsub.BeamPublishDialog;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.JsonRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;

@Transform(id="BeamPublish", name="Beam GCP Pub/Sub : Publish", description="Publish to a Pub/Sub topic", image="beam-gcp-pubsub-publish.svg", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.BigData", keywords={"i18n::BeamPublishMeta.keyword"}, documentationUrl="/pipeline/transforms/beamgcppublisher.html")
public class BeamPublishMeta
extends BaseTransformMeta<BeamPublish, BeamPublishData>
implements IBeamPipelineTransformHandler {
    public static final String TOPIC = "topic";
    public static final String MESSAGE_TYPE = "message_type";
    public static final String MESSAGE_FIELD = "message_field";
    @HopMetadataProperty
    private String topic = "Topic";
    @HopMetadataProperty(key="message_type")
    private String messageType = "String";
    @HopMetadataProperty(key="message_field")
    private String messageField = "message";

    public String getDialogClassName() {
        return BeamPublishDialog.class.getName();
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        inputRowMeta.clear();
    }

    public boolean isInput() {
        return false;
    }

    public boolean isOutput() {
        return true;
    }

    public void handleTransform(ILogChannel log, IVariables variables, String runConfigurationName, IBeamPipelineEngineRunConfiguration runConfiguration, String dataSamplersJson, IHopMetadataProvider metadataProvider, PipelineMeta pipelineMeta, TransformMeta transformMeta, Map<String, PCollection<HopRow>> transformCollectionMap, Pipeline pipeline, IRowMeta rowMeta, List<TransformMeta> previousTransforms, PCollection<HopRow> input, String parentLogChannelId) throws HopException {
        if (StringUtils.isEmpty((String)this.topic)) {
            throw new HopException("Please specify a topic to publish to in Beam Pub/Sub Publish transform '" + transformMeta.getName() + "'");
        }
        BeamPublishTransform beamOutputTransform = new BeamPublishTransform(transformMeta.getName(), variables.resolve(this.topic), this.messageType, this.messageField, JsonRowMeta.toJson((IRowMeta)rowMeta));
        if (previousTransforms.size() > 1) {
            throw new HopException("Combining data from multiple transforms is not supported yet!");
        }
        TransformMeta previousTransform = previousTransforms.get(0);
        input.apply((PTransform)beamOutputTransform);
        log.logBasic("Handled transform (PUBLISH) : " + transformMeta.getName() + ", gets data from " + previousTransform.getName());
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    public String getMessageField() {
        return this.messageField;
    }

    public void setMessageField(String messageField) {
        this.messageField = messageField;
    }
}

