/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.logging;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.util.IntParam$;
import org.apache.spark.util.logging.FileAppender;
import org.apache.spark.util.logging.RollingFileAppender;
import org.apache.spark.util.logging.RollingFileAppender$;
import org.apache.spark.util.logging.SizeBasedRollingPolicy;
import org.apache.spark.util.logging.SizeBasedRollingPolicy$;
import org.apache.spark.util.logging.TimeBasedRollingPolicy;
import org.apache.spark.util.logging.TimeBasedRollingPolicy$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.runtime.BoxesRunTime;

public final class FileAppender$
implements Logging {
    public static FileAppender$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new FileAppender$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int $lessinit$greater$default$3() {
        return 8192;
    }

    public boolean $lessinit$greater$default$4() {
        return false;
    }

    public FileAppender apply(InputStream inputStream, File file, SparkConf conf, boolean closeStreams) {
        FileAppender fileAppender;
        String rollingStrategy = conf.get(package$.MODULE$.EXECUTOR_LOGS_ROLLING_STRATEGY());
        String rollingSizeBytes = conf.get(package$.MODULE$.EXECUTOR_LOGS_ROLLING_MAX_SIZE());
        String rollingInterval = conf.get(package$.MODULE$.EXECUTOR_LOGS_ROLLING_TIME_INTERVAL());
        String string = rollingStrategy;
        if ("".equals(string)) {
            InputStream x$1 = inputStream;
            File x$2 = file;
            boolean x$3 = closeStreams;
            int x$4 = this.$lessinit$greater$default$3();
            fileAppender = new FileAppender(x$1, x$2, x$4, x$3);
        } else if ("time".equals(string)) {
            fileAppender = this.createTimeBasedAppender$1(rollingInterval, file, inputStream, conf, closeStreams);
        } else if ("size".equals(string)) {
            fileAppender = this.createSizeBasedAppender$1(rollingSizeBytes, file, inputStream, conf, closeStreams);
        } else {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append("Illegal strategy [").append(rollingStrategy).append("] for rolling executor logs, ").append("rolling logs not enabled").toString());
            InputStream x$5 = inputStream;
            File x$6 = file;
            boolean x$7 = closeStreams;
            int x$8 = this.$lessinit$greater$default$3();
            fileAppender = new FileAppender(x$5, x$6, x$8, x$7);
        }
        return fileAppender;
    }

    public boolean apply$default$4() {
        return false;
    }

    private final FileAppender createTimeBasedAppender$1(String rollingInterval$1, File file$1, InputStream inputStream$1, SparkConf conf$1, boolean closeStreams$1) {
        Some some;
        String string = rollingInterval$1;
        if ("daily".equals(string)) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Rolling executor logs enabled for ").append(file$1).append(" with daily rolling").toString());
            some = new Some((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)86400000L), (Object)"--yyyy-MM-dd"));
        } else if ("hourly".equals(string)) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Rolling executor logs enabled for ").append(file$1).append(" with hourly rolling").toString());
            some = new Some((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)3600000L), (Object)"--yyyy-MM-dd--HH"));
        } else if ("minutely".equals(string)) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Rolling executor logs enabled for ").append(file$1).append(" with rolling every minute").toString());
            some = new Some((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)60000L), (Object)"--yyyy-MM-dd--HH-mm"));
        } else {
            Option<Object> option = IntParam$.MODULE$.unapply(string);
            if (!option.isEmpty()) {
                int seconds = BoxesRunTime.unboxToInt((Object)option.get());
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Rolling executor logs enabled for ").append(file$1).append(" with rolling ").append(seconds).append(" seconds").toString());
                some = new Some((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)((long)seconds * 1000L)), (Object)"--yyyy-MM-dd--HH-mm-ss"));
            } else {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append("Illegal interval for rolling executor logs [").append(rollingInterval$1).append("], ").append("rolling logs not enabled").toString());
                some = None$.MODULE$;
            }
        }
        Some validatedParams = some;
        return (FileAppender)validatedParams.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long interval = tuple2._1$mcJ$sp();
            String pattern = (String)tuple2._2();
            InputStream x$1 = inputStream$1;
            File x$2 = file$1;
            TimeBasedRollingPolicy x$3 = new TimeBasedRollingPolicy(interval, pattern, TimeBasedRollingPolicy$.MODULE$.$lessinit$greater$default$3());
            SparkConf x$4 = conf$1;
            boolean x$5 = closeStreams$1;
            int x$6 = RollingFileAppender$.MODULE$.$lessinit$greater$default$5();
            RollingFileAppender rollingFileAppender = new RollingFileAppender(x$1, x$2, x$3, x$4, x$6, x$5);
            return rollingFileAppender;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            InputStream x$7 = inputStream$1;
            File x$8 = file$1;
            boolean x$9 = closeStreams$1;
            int x$10 = MODULE$.$lessinit$greater$default$3();
            return new FileAppender(x$7, x$8, x$10, x$9);
        });
    }

    private final FileAppender createSizeBasedAppender$1(String rollingSizeBytes$1, File file$1, InputStream inputStream$1, SparkConf conf$1, boolean closeStreams$1) {
        FileAppender fileAppender;
        String string = rollingSizeBytes$1;
        Option<Object> option = IntParam$.MODULE$.unapply(string);
        if (!option.isEmpty()) {
            int bytes = BoxesRunTime.unboxToInt((Object)option.get());
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Rolling executor logs enabled for ").append(file$1).append(" with rolling every ").append(bytes).append(" bytes").toString());
            InputStream x$1 = inputStream$1;
            File x$2 = file$1;
            SizeBasedRollingPolicy x$3 = new SizeBasedRollingPolicy(bytes, SizeBasedRollingPolicy$.MODULE$.$lessinit$greater$default$2());
            SparkConf x$4 = conf$1;
            boolean x$5 = closeStreams$1;
            int x$6 = RollingFileAppender$.MODULE$.$lessinit$greater$default$5();
            fileAppender = new RollingFileAppender(x$1, x$2, x$3, x$4, x$6, x$5);
        } else {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Illegal size [").append(rollingSizeBytes$1).append("] for rolling executor logs, rolling logs not enabled").toString());
            InputStream x$7 = inputStream$1;
            File x$8 = file$1;
            boolean x$9 = closeStreams$1;
            int x$10 = this.$lessinit$greater$default$3();
            fileAppender = new FileAppender(x$7, x$8, x$10, x$9);
        }
        return fileAppender;
    }

    private FileAppender$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

