/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.IdentityHashMap;
import java.util.Random;
import java.util.concurrent.ConcurrentMap;
import javax.management.MBeanServer;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.Tests$;
import org.apache.spark.util.KnownSizeEstimation;
import org.apache.spark.util.SizeEstimator;
import org.apache.spark.util.collection.OpenHashSet;
import org.apache.spark.util.collection.OpenHashSet$mcI$sp;
import org.slf4j.Logger;
import org.sparkproject.guava.collect.MapMaker;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@DeveloperApi
public final class SizeEstimator$
implements Logging {
    public static SizeEstimator$ MODULE$;
    private final int BYTE_SIZE;
    private final int BOOLEAN_SIZE;
    private final int CHAR_SIZE;
    private final int SHORT_SIZE;
    private final int INT_SIZE;
    private final int LONG_SIZE;
    private final int FLOAT_SIZE;
    private final int DOUBLE_SIZE;
    private final List<Object> fieldSizes;
    private final int ALIGN_SIZE;
    private final ConcurrentMap<Class<?>, SizeEstimator.ClassInfo> classInfos;
    private boolean is64bit;
    private boolean isCompressedOops;
    private int pointerSize;
    private int objectSize;
    private final int ARRAY_SIZE_FOR_SAMPLING;
    private final int ARRAY_SAMPLE_SIZE;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new SizeEstimator$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public long estimate(Object obj) {
        return this.estimate(obj, new IdentityHashMap<Object, Object>());
    }

    private int BYTE_SIZE() {
        return this.BYTE_SIZE;
    }

    private int BOOLEAN_SIZE() {
        return this.BOOLEAN_SIZE;
    }

    private int CHAR_SIZE() {
        return this.CHAR_SIZE;
    }

    private int SHORT_SIZE() {
        return this.SHORT_SIZE;
    }

    private int INT_SIZE() {
        return this.INT_SIZE;
    }

    private int LONG_SIZE() {
        return this.LONG_SIZE;
    }

    private int FLOAT_SIZE() {
        return this.FLOAT_SIZE;
    }

    private int DOUBLE_SIZE() {
        return this.DOUBLE_SIZE;
    }

    private List<Object> fieldSizes() {
        return this.fieldSizes;
    }

    private int ALIGN_SIZE() {
        return this.ALIGN_SIZE;
    }

    private ConcurrentMap<Class<?>, SizeEstimator.ClassInfo> classInfos() {
        return this.classInfos;
    }

    private boolean is64bit() {
        return this.is64bit;
    }

    private void is64bit_$eq(boolean x$1) {
        this.is64bit = x$1;
    }

    private boolean isCompressedOops() {
        return this.isCompressedOops;
    }

    private void isCompressedOops_$eq(boolean x$1) {
        this.isCompressedOops = x$1;
    }

    private int pointerSize() {
        return this.pointerSize;
    }

    private void pointerSize_$eq(int x$1) {
        this.pointerSize = x$1;
    }

    private int objectSize() {
        return this.objectSize;
    }

    private void objectSize_$eq(int x$1) {
        this.objectSize = x$1;
    }

    private void initialize() {
        String arch = System.getProperty("os.arch");
        this.is64bit_$eq(arch.contains("64") || arch.contains("s390x"));
        this.isCompressedOops_$eq(this.getIsCompressedOops());
        this.objectSize_$eq(!this.is64bit() ? 8 : (!this.isCompressedOops() ? 16 : 12));
        this.pointerSize_$eq(this.is64bit() && !this.isCompressedOops() ? 8 : 4);
        this.classInfos().clear();
        this.classInfos().put(Object.class, new SizeEstimator.ClassInfo(this.objectSize(), (List<Field>)Nil$.MODULE$));
    }

    private boolean getIsCompressedOops() {
        boolean bl;
        if (System.getProperty(Tests$.MODULE$.TEST_USE_COMPRESSED_OOPS_KEY()) != null) {
            return new StringOps(Predef$.MODULE$.augmentString(System.getProperty(Tests$.MODULE$.TEST_USE_COMPRESSED_OOPS_KEY()))).toBoolean();
        }
        String javaVendor = System.getProperty("java.vendor");
        if (javaVendor.contains("IBM") || javaVendor.contains("OpenJ9")) {
            return System.getProperty("java.vm.info").contains("Compressed Ref");
        }
        try {
            String hotSpotMBeanName = "com.sun.management:type=HotSpotDiagnostic";
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            Class<?> hotSpotMBeanClass = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
            Method getVMMethod = hotSpotMBeanClass.getDeclaredMethod("getVMOption", Class.forName("java.lang.String"));
            Object bean = ManagementFactory.newPlatformMXBeanProxy(server, hotSpotMBeanName, hotSpotMBeanClass);
            bl = getVMMethod.invoke(bean, "UseCompressedOops").toString().contains("true");
        }
        catch (Exception e) {
            boolean guess = Runtime.getRuntime().maxMemory() < 0x800000000L;
            String guessInWords = guess ? "yes" : "not";
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Failed to check whether UseCompressedOops is set; assuming ").append(guessInWords).toString());
            return guess;
        }
        return bl;
    }

    private long estimate(Object obj, IdentityHashMap<Object, Object> visited) {
        SizeEstimator.SearchState state = new SizeEstimator.SearchState(visited);
        state.enqueue(obj);
        while (!state.isFinished()) {
            this.visitSingleObject(state.dequeue(), state);
        }
        return state.size();
    }

    private void visitSingleObject(Object obj, SizeEstimator.SearchState state) {
        block3: {
            Class<?> cls;
            block2: {
                cls = obj.getClass();
                if (!cls.isArray()) break block2;
                this.visitArray(obj, cls, state);
                break block3;
            }
            if (cls.getName().startsWith("scala.reflect") || obj instanceof ClassLoader || obj instanceof Class) break block3;
            Object object = obj;
            if (object instanceof KnownSizeEstimation) {
                KnownSizeEstimation knownSizeEstimation = (KnownSizeEstimation)object;
                state.size_$eq(state.size() + knownSizeEstimation.estimatedSize());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                SizeEstimator.ClassInfo classInfo = this.getClassInfo(cls);
                state.size_$eq(state.size() + this.alignSize(classInfo.shellSize()));
                classInfo.pointerFields().foreach((Function1 & Serializable & scala.Serializable)field -> {
                    state.enqueue(field.get(obj));
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    private int ARRAY_SIZE_FOR_SAMPLING() {
        return this.ARRAY_SIZE_FOR_SAMPLING;
    }

    private int ARRAY_SAMPLE_SIZE() {
        return this.ARRAY_SAMPLE_SIZE;
    }

    private void visitArray(Object array, Class<?> arrayClass, SizeEstimator.SearchState state) {
        int length = ScalaRunTime$.MODULE$.array_length(array);
        Class<?> elementClass = arrayClass.getComponentType();
        long arrSize = this.alignSize(this.objectSize() + this.INT_SIZE());
        if (elementClass.isPrimitive()) {
            state.size_$eq(state.size() + (arrSize += this.alignSize((long)length * (long)this.primitiveSize(elementClass))));
        } else {
            state.size_$eq(state.size() + (arrSize += this.alignSize((long)length * (long)this.pointerSize())));
            if (length <= this.ARRAY_SIZE_FOR_SAMPLING()) {
                for (int arrayIndex = 0; arrayIndex < length; ++arrayIndex) {
                    state.enqueue(ScalaRunTime$.MODULE$.array_apply(array, arrayIndex));
                }
            } else {
                Random rand = new Random(42L);
                OpenHashSet$mcI$sp drawn = new OpenHashSet$mcI$sp(2 * this.ARRAY_SAMPLE_SIZE(), (ClassTag<Object>)ClassTag$.MODULE$.Int());
                long s1 = this.sampleArray(array, state, rand, drawn, length);
                long s2 = this.sampleArray(array, state, rand, drawn, length);
                long size = package$.MODULE$.min(s1, s2);
                state.size_$eq(state.size() + (package$.MODULE$.max(s1, s2) + size * (long)((length - this.ARRAY_SAMPLE_SIZE()) / this.ARRAY_SAMPLE_SIZE())));
            }
        }
    }

    private long sampleArray(Object array, SizeEstimator.SearchState state, Random rand, OpenHashSet<Object> drawn, int length) {
        LongRef size = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.ARRAY_SAMPLE_SIZE()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            block1: {
                int index = 0;
                while (drawn.contains$mcI$sp(index = rand.nextInt(length))) {
                }
                drawn.add$mcI$sp(index);
                Object obj = ScalaRunTime$.MODULE$.array_apply(array, index);
                if (obj == null) break block1;
                size$1.elem += MODULE$.estimate(obj, state.visited());
            }
        });
        return size.elem;
    }

    private int primitiveSize(Class<?> cls) {
        int n;
        Class<?> clazz = cls;
        Class<Byte> clazz2 = Byte.TYPE;
        if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
            n = this.BYTE_SIZE();
        } else {
            Class<?> clazz3 = cls;
            Class<Boolean> clazz4 = Boolean.TYPE;
            if (!(clazz3 != null ? !clazz3.equals(clazz4) : clazz4 != null)) {
                n = this.BOOLEAN_SIZE();
            } else {
                Class<?> clazz5 = cls;
                Class<Character> clazz6 = Character.TYPE;
                if (!(clazz5 != null ? !clazz5.equals(clazz6) : clazz6 != null)) {
                    n = this.CHAR_SIZE();
                } else {
                    Class<?> clazz7 = cls;
                    Class<Short> clazz8 = Short.TYPE;
                    if (!(clazz7 != null ? !clazz7.equals(clazz8) : clazz8 != null)) {
                        n = this.SHORT_SIZE();
                    } else {
                        Class<?> clazz9 = cls;
                        Class<Integer> clazz10 = Integer.TYPE;
                        if (!(clazz9 != null ? !clazz9.equals(clazz10) : clazz10 != null)) {
                            n = this.INT_SIZE();
                        } else {
                            Class<?> clazz11 = cls;
                            Class<Long> clazz12 = Long.TYPE;
                            if (!(clazz11 != null ? !clazz11.equals(clazz12) : clazz12 != null)) {
                                n = this.LONG_SIZE();
                            } else {
                                Class<?> clazz13 = cls;
                                Class<Float> clazz14 = Float.TYPE;
                                if (!(clazz13 != null ? !clazz13.equals(clazz14) : clazz14 != null)) {
                                    n = this.FLOAT_SIZE();
                                } else {
                                    Class<?> clazz15 = cls;
                                    Class<Double> clazz16 = Double.TYPE;
                                    if (!(clazz15 != null ? !clazz15.equals(clazz16) : clazz16 != null)) {
                                        n = this.DOUBLE_SIZE();
                                    } else {
                                        throw new IllegalArgumentException(new StringBuilder(46).append("Non-primitive class ").append(cls).append(" passed to primitiveSize()").toString());
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return n;
    }

    private SizeEstimator.ClassInfo getClassInfo(Class<?> cls) {
        SizeEstimator.ClassInfo info = (SizeEstimator.ClassInfo)this.classInfos().get(cls);
        if (info != null) {
            return info;
        }
        SizeEstimator.ClassInfo parent = this.getClassInfo(cls.getSuperclass());
        LongRef shellSize = LongRef.create((long)parent.shellSize());
        ObjectRef pointerFields = ObjectRef.create(parent.pointerFields());
        int[] sizeCount = (int[])Array$.MODULE$.ofDim(BoxesRunTime.unboxToInt((Object)this.fieldSizes().max((Ordering)Ordering.Int$.MODULE$)) + 1, ClassTag$.MODULE$.Int());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cls.getDeclaredFields())).foreach((Function1 & Serializable & scala.Serializable)field -> {
            SizeEstimator$.$anonfun$getClassInfo$1(sizeCount, pointerFields, field);
            return BoxedUnit.UNIT;
        });
        LongRef alignedSize = LongRef.create((long)shellSize.elem);
        this.fieldSizes().withFilter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)size -> sizeCount[size] > 0).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)size -> {
            long count = sizeCount[size];
            alignedSize$1.elem = package$.MODULE$.max(alignedSize$1.elem, MODULE$.alignSizeUp(shellSize$1.elem, size) + (long)size * count);
            shellSize$1.elem += (long)size * count;
        });
        shellSize.elem = this.alignSizeUp(alignedSize.elem, this.pointerSize());
        SizeEstimator.ClassInfo newInfo = new SizeEstimator.ClassInfo(shellSize.elem, (List<Field>)((List)pointerFields.elem));
        this.classInfos().put(cls, newInfo);
        return newInfo;
    }

    private long alignSize(long size) {
        return this.alignSizeUp(size, this.ALIGN_SIZE());
    }

    private long alignSizeUp(long size, int alignSize) {
        return size + (long)alignSize - 1L & (long)(~(alignSize - 1));
    }

    public static final /* synthetic */ void $anonfun$getClassInfo$1(int[] sizeCount$1, ObjectRef pointerFields$1, Field field) {
        block7: {
            if (Modifier.isStatic(field.getModifiers())) break block7;
            Class<?> fieldClass = field.getType();
            if (fieldClass.isPrimitive()) {
                int n = MODULE$.primitiveSize(fieldClass);
                sizeCount$1[n] = sizeCount$1[n] + 1;
            } else {
                try {
                    field.setAccessible(true);
                    Field field2 = field;
                    pointerFields$1.elem = ((List)pointerFields$1.elem).$colon$colon((Object)field2);
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof SecurityException) {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    if (throwable2 instanceof RuntimeException) {
                        RuntimeException runtimeException = (RuntimeException)throwable2;
                        String string = runtimeException.getClass().getSimpleName();
                        String string2 = "InaccessibleObjectException";
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                    }
                    throw throwable;
                }
                int n = MODULE$.pointerSize();
                sizeCount$1[n] = sizeCount$1[n] + 1;
            }
        }
    }

    private SizeEstimator$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.BYTE_SIZE = 1;
        this.BOOLEAN_SIZE = 1;
        this.CHAR_SIZE = 2;
        this.SHORT_SIZE = 2;
        this.INT_SIZE = 4;
        this.LONG_SIZE = 8;
        this.FLOAT_SIZE = 4;
        this.DOUBLE_SIZE = 8;
        this.fieldSizes = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{8, 4, 2, 1}));
        this.ALIGN_SIZE = 8;
        this.classInfos = new MapMaker().weakKeys().makeMap();
        this.is64bit = false;
        this.isCompressedOops = false;
        this.pointerSize = 4;
        this.objectSize = 8;
        this.initialize();
        this.ARRAY_SIZE_FOR_SAMPLING = 400;
        this.ARRAY_SAMPLE_SIZE = 100;
    }
}

