/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.gcp.auth;

import com.google.auth.Credentials;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.extensions.gcp.auth.CredentialFactory;
import org.apache.beam.sdk.options.PipelineOptions;

public class NoopCredentialFactory
implements CredentialFactory {
    private static final NoopCredentialFactory INSTANCE = new NoopCredentialFactory();
    private static final NoopCredentials NOOP_CREDENTIALS = new NoopCredentials();

    public static NoopCredentialFactory fromOptions(PipelineOptions options) {
        return INSTANCE;
    }

    @Override
    public Credentials getCredential() throws IOException {
        return NOOP_CREDENTIALS;
    }

    private static class NoopCredentials
    extends Credentials {
        private NoopCredentials() {
        }

        public String getAuthenticationType() {
            return null;
        }

        public Map<String, List<String>> getRequestMetadata(URI uri) throws IOException {
            return null;
        }

        public boolean hasRequestMetadata() {
            return false;
        }

        public boolean hasRequestMetadataOnly() {
            return false;
        }

        public void refresh() throws IOException {
        }
    }
}

