/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation.streaming;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.runners.core.DoFnRunner;
import org.apache.beam.runners.core.DoFnRunners;
import org.apache.beam.runners.core.SideInputReader;
import org.apache.beam.runners.core.StateInternals;
import org.apache.beam.runners.core.StatefulDoFnRunner;
import org.apache.beam.runners.core.StepContext;
import org.apache.beam.runners.core.TimerInternals;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.spark.coders.CoderHelpers;
import org.apache.beam.runners.spark.metrics.MetricsContainerStepMapAccumulator;
import org.apache.beam.runners.spark.stateful.SparkStateInternals;
import org.apache.beam.runners.spark.stateful.SparkTimerInternals;
import org.apache.beam.runners.spark.stateful.StateAndTimers;
import org.apache.beam.runners.spark.translation.DoFnRunnerWithMetrics;
import org.apache.beam.runners.spark.translation.SparkInputDataProcessor;
import org.apache.beam.runners.spark.translation.SparkProcessContext;
import org.apache.beam.runners.spark.util.ByteArray;
import org.apache.beam.runners.spark.util.CachedSideInputReader;
import org.apache.beam.runners.spark.util.GlobalWatermarkHolder;
import org.apache.beam.runners.spark.util.SideInputBroadcast;
import org.apache.beam.runners.spark.util.SparkSideInputReader;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.reflect.DoFnInvokers;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.apache.spark.streaming.State;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.Tuple2;
import scala.runtime.AbstractFunction3;

public class ParDoStateUpdateFn<@UnknownKeyFor KeyT, @UnknownKeyFor ValueT, @UnknownKeyFor InputT extends @UnknownKeyFor @NonNull @Initialized KV<KeyT, ValueT>, @UnknownKeyFor OutputT>
extends AbstractFunction3<ByteArray, Option<byte[]>, State<StateAndTimers>, List<Tuple2<TupleTag<?>, byte[]>>>
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(ParDoStateUpdateFn.class);
    private final @UnknownKeyFor @NonNull @Initialized MetricsContainerStepMapAccumulator metricsAccum;
    private final @UnknownKeyFor @NonNull @Initialized String stepName;
    private final @UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn;
    private final @UnknownKeyFor @NonNull @Initialized Coder<KeyT> keyCoder;
    private final // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized WindowedValue.FullWindowedValueCoder<ValueT> wvCoder;
    private transient @UnknownKeyFor @NonNull @Initialized boolean wasSetupCalled;
    private final @UnknownKeyFor @NonNull @Initialized SerializablePipelineOptions options;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> mainOutputTag;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> additionalOutputTags;
    private final @UnknownKeyFor @NonNull @Initialized Coder<InputT> inputCoder;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputCoders;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized SideInputBroadcast<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> sideInputs;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy;
    private final @UnknownKeyFor @NonNull @Initialized DoFnSchemaInformation doFnSchemaInformation;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputMapping;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized GlobalWatermarkHolder.SparkWatermarks> watermarks;
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Integer> sourceIds;
    private final // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerDataCoderV2 timerDataCoder;

    public ParDoStateUpdateFn(@UnknownKeyFor @NonNull @Initialized MetricsContainerStepMapAccumulator metricsAccum, @UnknownKeyFor @NonNull @Initialized String stepName, @UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn, @UnknownKeyFor @NonNull @Initialized Coder<KeyT> keyCoder, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized WindowedValue.FullWindowedValueCoder<ValueT> wvCoder, @UnknownKeyFor @NonNull @Initialized SerializablePipelineOptions options, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> mainOutputTag, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> additionalOutputTags, @UnknownKeyFor @NonNull @Initialized Coder<InputT> inputCoder, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputCoders, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized SideInputBroadcast<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> sideInputs, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy, @UnknownKeyFor @NonNull @Initialized DoFnSchemaInformation doFnSchemaInformation, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputMapping, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized GlobalWatermarkHolder.SparkWatermarks> watermarks, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Integer> sourceIds) {
        this.metricsAccum = metricsAccum;
        this.stepName = stepName;
        this.doFn = (DoFn)SerializableUtils.clone(doFn);
        this.options = options;
        this.mainOutputTag = mainOutputTag;
        this.additionalOutputTags = additionalOutputTags;
        this.keyCoder = keyCoder;
        this.inputCoder = inputCoder;
        this.outputCoders = outputCoders;
        this.wvCoder = wvCoder;
        this.sideInputs = sideInputs;
        this.windowingStrategy = windowingStrategy;
        this.doFnSchemaInformation = doFnSchemaInformation;
        this.sideInputMapping = sideInputMapping;
        this.watermarks = watermarks;
        this.sourceIds = sourceIds;
        this.timerDataCoder = TimerInternals.TimerDataCoderV2.of((Coder)windowingStrategy.getWindowFn().windowCoder());
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>> apply(@UnknownKeyFor @NonNull @Initialized ByteArray serializedKey, @UnknownKeyFor @NonNull @Initialized Option<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> serializedValue, @UnknownKeyFor @NonNull @Initialized State<@UnknownKeyFor @NonNull @Initialized StateAndTimers> state) {
        SparkStateInternals<KeyT> stateInternals;
        if (serializedValue.isEmpty()) {
            return Lists.newArrayList();
        }
        final SparkTimerInternals timerInternals = SparkTimerInternals.forStreamFromSources(this.sourceIds, this.watermarks);
        KeyT key = CoderHelpers.fromByteArray(serializedKey.getValue(), this.keyCoder);
        if (state.exists()) {
            StateAndTimers stateAndTimers = (StateAndTimers)state.get();
            stateInternals = SparkStateInternals.forKeyAndState(key, stateAndTimers.getState());
            timerInternals.addTimers(SparkTimerInternals.deserializeTimers(stateAndTimers.getTimers(), this.timerDataCoder));
        } else {
            stateInternals = SparkStateInternals.forKey(key);
        }
        byte[] byteValue = (byte[])serializedValue.get();
        WindowedValue windowedValue = (WindowedValue)CoderHelpers.fromByteArray(byteValue, this.wvCoder);
        WindowedValue keyedWindowedValue = windowedValue.withValue((Object)KV.of(key, (Object)windowedValue.getValue()));
        if (!this.wasSetupCalled) {
            DoFnInvokers.tryInvokeSetupFor(this.doFn, (PipelineOptions)this.options.get());
            this.wasSetupCalled = true;
        }
        SparkInputDataProcessor processor = SparkInputDataProcessor.createUnbounded();
        StepContext context = new StepContext(){

            public @UnknownKeyFor @NonNull @Initialized StateInternals stateInternals() {
                return stateInternals;
            }

            public @UnknownKeyFor @NonNull @Initialized TimerInternals timerInternals() {
                return timerInternals;
            }
        };
        DoFnRunner doFnRunner = DoFnRunners.simpleRunner((PipelineOptions)this.options.get(), this.doFn, (SideInputReader)CachedSideInputReader.of(new SparkSideInputReader(this.sideInputs)), (DoFnRunners.OutputManager)processor.getOutputManager(), this.mainOutputTag, this.additionalOutputTags, (StepContext)context, this.inputCoder, this.outputCoders, this.windowingStrategy, (DoFnSchemaInformation)this.doFnSchemaInformation, this.sideInputMapping);
        Coder windowCoder = this.windowingStrategy.getWindowFn().windowCoder();
        StatefulDoFnRunner.TimeInternalsCleanupTimer cleanUpTimer = new StatefulDoFnRunner.TimeInternalsCleanupTimer((TimerInternals)timerInternals, this.windowingStrategy);
        StatefulDoFnRunner.StateInternalsStateCleaner stateCleaner = new StatefulDoFnRunner.StateInternalsStateCleaner(this.doFn, stateInternals, windowCoder);
        doFnRunner = DoFnRunners.defaultStatefulDoFnRunner(this.doFn, this.inputCoder, (DoFnRunner)doFnRunner, (StepContext)context, this.windowingStrategy, (StatefulDoFnRunner.CleanupTimer)cleanUpTimer, (StatefulDoFnRunner.StateCleaner)stateCleaner);
        DoFnRunnerWithMetrics doFnRunnerWithMetrics = new DoFnRunnerWithMetrics(this.stepName, doFnRunner, this.metricsAccum);
        SparkProcessContext<KeyT, InputT, OutputT> ctx = new SparkProcessContext<KeyT, InputT, OutputT>(this.stepName, this.doFn, doFnRunnerWithMetrics, key, timerInternals.getTimers().iterator());
        Iterator iterator = Lists.newArrayList((Object[])new WindowedValue[]{keyedWindowedValue}).iterator();
        Iterator<Tuple2<TupleTag<?>, WindowedValue<?>>> outputIterator = processor.createOutputIterator(iterator, ctx);
        state.update((Object)StateAndTimers.of(stateInternals.getState(), SparkTimerInternals.serializeTimers(timerInternals.getTimers(), this.timerDataCoder)));
        ArrayList resultList = Lists.newArrayList(outputIterator);
        return resultList.stream().map(e -> {
            TupleTag tupleTag = (TupleTag)e._1();
            Coder<?> outputCoder = this.outputCoders.get(tupleTag);
            WindowedValue.FullWindowedValueCoder outputWindowCoder = WindowedValue.FullWindowedValueCoder.of(outputCoder, (Coder)windowCoder);
            return Tuple2.apply((Object)tupleTag, (Object)CoderHelpers.toByteArray((WindowedValue)e._2(), outputWindowCoder));
        }).collect(Collectors.toList());
    }
}

