/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.file;

import java.util.Properties;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.ui.hopgui.file.IHopFileType;

public abstract class HopFileTypeBase
implements IHopFileType {
    @Override
    public abstract String getName();

    @Override
    public abstract Properties getCapabilities();

    @Override
    public abstract String[] getFilterExtensions();

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj.getClass().equals(this.getClass());
    }

    @Override
    public boolean isHandledBy(String filename, boolean checkContent) throws HopException {
        try {
            if (checkContent) {
                throw new HopException("Generic file content validation is not possible at this time for file '" + filename + "'");
            }
            FileObject fileObject = HopVfs.getFileObject((String)filename);
            FileName fileName = fileObject.getName();
            String fileExtension = fileName.getExtension().toLowerCase();
            if (Utils.isEmpty((CharSequence)fileExtension)) {
                return false;
            }
            for (String typeExtension : this.getFilterExtensions()) {
                if (!typeExtension.toLowerCase().endsWith(fileExtension)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new HopException("Unable to verify file handling of file '" + filename + "' by extension", (Throwable)e);
        }
    }

    @Override
    public boolean hasCapability(String capability) {
        if (this.getCapabilities() == null) {
            return false;
        }
        Object available = this.getCapabilities().get(capability);
        if (available == null) {
            return false;
        }
        return "true".equalsIgnoreCase(available.toString());
    }
}

