/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.commtrace;

import com.ibm.as400.access.Trace;
import com.ibm.as400.util.commtrace.BitBuf;
import com.ibm.as400.util.commtrace.Data;
import com.ibm.as400.util.commtrace.Dec;
import com.ibm.as400.util.commtrace.Field;
import com.ibm.as400.util.commtrace.FormatProperties;
import com.ibm.as400.util.commtrace.Formatter;
import com.ibm.as400.util.commtrace.Header;
import com.ibm.as400.util.commtrace.Hex;
import com.ibm.as400.util.commtrace.Port;

public class UDPHeader
extends Header {
    private Field sourceport;
    private Field destport;
    private Field length;
    private Field checksum;
    private static final String CLASS = "UDPHeader";
    private static final String UNASSIGNED = "Unassigned";
    private static final String UDPSTR = "UDP";
    private static final String SRC = "SrcPort";
    private static final String DST = "DstPort";
    private static final String LEN = "Length";
    private static final String CHKSUM = "Checksum";

    UDPHeader(BitBuf data) {
        super(data);
        this.sourceport = new Dec(this.rawheader.slice(0, 16));
        this.destport = new Dec(this.rawheader.slice(16, 16));
        this.length = new Dec(this.rawheader.slice(32, 16));
        this.checksum = new Hex(this.rawheader.slice(48, 16));
        this.type = 17;
    }

    @Override
    public int getHeaderLen() {
        return 64;
    }

    @Override
    public String toString(FormatProperties filter) {
        if (filter != null) {
            boolean print = false;
            String port = filter.getPort();
            if (port == null) {
                print = true;
            } else if (port.equals(this.sourceport.toString()) || port.equals(this.destport.toString())) {
                print = true;
            }
            if (!print) {
                if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                    Trace.log(3, "UDPHeader.toString() Not printing record");
                }
                return "";
            }
        }
        String portname = (String)Port.get(this.sourceport.toString());
        String portname2 = (String)Port.get(this.destport.toString());
        if (this.rawheader.getBitSize() < this.getHeaderLen()) {
            return new Data(this.rawheader).toString();
        }
        if (portname == null) {
            portname = UNASSIGNED;
        }
        if (portname2 == null) {
            portname2 = UNASSIGNED;
        }
        String sourceport = this.sourceport.toString() + ", " + portname;
        String destport = this.destport.toString() + ", " + portname2;
        Object[] args = new Object[]{sourceport, destport, this.length, this.checksum};
        return Formatter.jsprintf("\t    UDP  . . . . :  SrcPort:  {0,18,L} DstPort:  {1,18,L}\n\t\t\t    Length:  {2,5,L} Checksum:  {3}\n", args) + this.printHexHeader() + this.printnext(filter) + new Data(this.rawpayload).toString();
    }

    public String getSrcPort() {
        return this.sourceport.toString();
    }

    public String getDstPort() {
        return this.destport.toString();
    }

    public String getLength() {
        return this.length.toString();
    }

    public String getData() {
        return this.rawpayload.toHexString();
    }

    public byte[] getByteData() {
        return this.rawpayload.getBytes();
    }
}

