/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.JDSQLToken;
import com.ibm.as400.access.JDSQLTokenList;
import java.util.Enumeration;
import java.util.NoSuchElementException;

class JDSQLTokenizer
implements Enumeration {
    static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    public static final String DEFAULT_DELIMITERS = " \t\n\r\f";
    private static final char[] INTERNAL_DELIMITERS = " \t\n\r\f".toCharArray();
    private static final int TOKEN_TYPE_DELIMITER = 1;
    private static final int TOKEN_TYPE_COMMENT = 2;
    private static final int TOKEN_TYPE_LITERAL = 4;
    private static final int TOKEN_TYPE_SQL = 8;
    private JDSQLToken[] tokens_;
    private int numberOfParameters_;
    private int currentTokenIndex_;

    public JDSQLTokenizer(String statement) {
        this(statement, DEFAULT_DELIMITERS, true, true);
    }

    public JDSQLTokenizer(String statement, String delimiters) {
        this(statement, delimiters, true, true);
    }

    public JDSQLTokenizer(String statement, String delimiters, boolean returnDelimiters, boolean returnComments) {
        char[] delims = DEFAULT_DELIMITERS.equals(delimiters) ? INTERNAL_DELIMITERS : delimiters.toCharArray();
        this.tokens_ = JDSQLTokenizer.scanForTokens(statement, delims, returnComments, returnDelimiters);
        this.numberOfParameters_ = 0;
        for (int i = 0; i < this.tokens_.length; ++i) {
            this.numberOfParameters_ += this.tokens_[i].parms_;
        }
        this.currentTokenIndex_ = 0;
    }

    public int countTokens() {
        return this.tokens_.length;
    }

    public int getNumberOfParameters() {
        return this.numberOfParameters_;
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public boolean hasMoreTokens() {
        return this.currentTokenIndex_ < this.tokens_.length;
    }

    private static final boolean isDelimiter(char c, char[] delimiters) {
        for (int i = 0; i < delimiters.length; ++i) {
            if (delimiters[i] != c) continue;
            return true;
        }
        return false;
    }

    public Object nextElement() {
        return this.nextToken();
    }

    public String nextToken() {
        if (!this.hasMoreTokens()) {
            throw new NoSuchElementException();
        }
        return this.tokens_[this.currentTokenIndex_++].getToken();
    }

    public String peekToken() {
        if (!this.hasMoreTokens()) {
            throw new NoSuchElementException();
        }
        return this.tokens_[this.currentTokenIndex_].getToken();
    }

    private static final JDSQLToken[] scanForTokens(String sql, char[] delimiters, boolean returnComments, boolean returnDelimiters) {
        JDSQLTokenList tokens = new JDSQLTokenList();
        char[] buffer = sql.toCharArray();
        int offset = 0;
        int bufferLen = buffer.length;
        while (offset < bufferLen) {
            int p2;
            int start;
            int p = offset + 1;
            JDSQLToken token = null;
            if (p < bufferLen && buffer[offset] == '/' && buffer[p] == '*') {
                start = offset;
                int commentDepth = 1;
                for (offset = p + 1; offset < bufferLen && commentDepth > 0; ++offset) {
                    p2 = offset + 1;
                    if (p2 >= bufferLen) continue;
                    if (buffer[offset] == '/' && buffer[p2] == '*') {
                        ++commentDepth;
                        ++offset;
                        continue;
                    }
                    if (buffer[offset] != '*' || buffer[p2] != '/') continue;
                    --commentDepth;
                    ++offset;
                }
                if (returnComments) {
                    token = new JDSQLToken(buffer, start, offset - start, 2);
                }
            } else if (p < bufferLen && buffer[offset] == '-' && buffer[p] == '-') {
                start = offset;
                offset = p + 1;
                while (offset < bufferLen && buffer[offset++] != '\n') {
                }
                if (returnComments) {
                    token = new JDSQLToken(buffer, start, offset - start, 2);
                }
            } else if (buffer[offset] == '\'') {
                start = offset++;
                while (offset < bufferLen && buffer[offset++] != '\'') {
                }
                token = new JDSQLToken(buffer, start, offset - start, 4);
            } else if (buffer[offset] == '\"') {
                start = offset++;
                while (offset < bufferLen && buffer[offset++] != '\"') {
                }
                token = new JDSQLToken(buffer, start, offset - start, 4);
            } else if (buffer[offset] == '(') {
                start = offset++;
                token = new JDSQLToken(buffer, start, offset - start, 8);
            } else if (JDSQLTokenizer.isDelimiter(buffer[offset], delimiters)) {
                if (returnDelimiters) {
                    token = new JDSQLToken(buffer, offset, 1, 1);
                }
                ++offset;
            } else {
                int numberOfParms = 0;
                int start2 = offset;
                while (!(offset >= bufferLen || JDSQLTokenizer.isDelimiter(buffer[offset], delimiters) || buffer[offset] == '\'' || buffer[offset] == '\"' || (p2 = offset + 1) < bufferLen && (buffer[offset] == '/' && buffer[p2] == '*' || buffer[offset] == '-' && buffer[p2] == '-'))) {
                    if (buffer[offset] == '?') {
                        ++numberOfParms;
                    }
                    ++offset;
                }
                token = new JDSQLToken(buffer, start2, offset - start2, 8, numberOfParms);
            }
            if (token == null) continue;
            tokens.addToken(token);
        }
        JDSQLToken[] jdTokens = new JDSQLToken[tokens.count_];
        System.arraycopy(tokens.tokens_, 0, jdTokens, 0, tokens.count_);
        return jdTokens;
    }

    public String toString() {
        StringBuffer contents = new StringBuffer();
        for (int i = 0; i < this.tokens_.length; ++i) {
            contents.append(this.tokens_[i].getToken());
        }
        return contents.toString();
    }
}

