/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.selection;

import com.google.common.base.Objects;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.selection.SelectionColumns;
import org.apache.cassandra.schema.ColumnMetadata;

public class SelectionColumnMapping
implements SelectionColumns {
    private final List<ColumnSpecification> columnSpecifications = new ArrayList<ColumnSpecification>();
    private final Multimap<ColumnSpecification, ColumnMetadata> columnMappings = HashMultimap.create();

    private SelectionColumnMapping() {
    }

    protected static SelectionColumnMapping newMapping() {
        return new SelectionColumnMapping();
    }

    protected static SelectionColumnMapping simpleMapping(Iterable<ColumnMetadata> columnDefinitions) {
        SelectionColumnMapping mapping = new SelectionColumnMapping();
        for (ColumnMetadata def : columnDefinitions) {
            mapping.addMapping((ColumnSpecification)def, def);
        }
        return mapping;
    }

    protected SelectionColumnMapping addMapping(ColumnSpecification colSpec, ColumnMetadata column) {
        this.columnSpecifications.add(colSpec);
        if (column != null) {
            this.columnMappings.put((Object)colSpec, (Object)column);
        }
        return this;
    }

    protected SelectionColumnMapping addMapping(ColumnSpecification colSpec, Iterable<ColumnMetadata> columns) {
        this.columnSpecifications.add(colSpec);
        this.columnMappings.putAll((Object)colSpec, columns);
        return this;
    }

    @Override
    public List<ColumnSpecification> getColumnSpecifications() {
        return Lists.newArrayList(this.columnSpecifications);
    }

    @Override
    public Multimap<ColumnSpecification, ColumnMetadata> getMappings() {
        return Multimaps.unmodifiableMultimap(this.columnMappings);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SelectionColumnMapping)) {
            return false;
        }
        SelectionColumns other = (SelectionColumns)obj;
        return Objects.equal(this.columnMappings, other.getMappings()) && Objects.equal(this.columnSpecifications, other.getColumnSpecifications());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.columnMappings});
    }

    public String toString() {
        return this.columnMappings.asMap().entrySet().stream().map(entry -> ((Collection)entry.getValue()).stream().map(colDef -> colDef.name.toString()).collect(Collectors.joining(", ", ((ColumnSpecification)entry.getKey()).name.toString() + ":[", "]"))).collect(Collectors.joining(", ", this.columnSpecifications.stream().map(colSpec -> colSpec.name.toString()).collect(Collectors.joining(", ", "{ Columns:[", "], Mappings:{")), "} }"));
    }
}

