/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.resources;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.Preconditions;

@Internal
public abstract class Resource<T extends Resource<T>>
implements Serializable,
Comparable<Resource> {
    private static final long serialVersionUID = 1L;
    private static final int MAX_VALUE_SCALE = 8;
    private final String name;
    private final BigDecimal value;

    protected Resource(String name, double value) {
        this(name, BigDecimal.valueOf(value));
    }

    protected Resource(String name, BigDecimal value) {
        Preconditions.checkNotNull(value);
        BigDecimal valueRoundDown = value.setScale(8, RoundingMode.DOWN).stripTrailingZeros();
        Preconditions.checkArgument(valueRoundDown.compareTo(BigDecimal.ZERO) >= 0, "Resource value must be no less than 0");
        this.name = Preconditions.checkNotNull(name);
        this.value = valueRoundDown;
    }

    public T merge(T other) {
        Preconditions.checkNotNull(other, "Cannot merge with null resources");
        Preconditions.checkArgument(this.getClass() == other.getClass(), "Merge with different resource type");
        Preconditions.checkArgument(this.name.equals(((Resource)other).getName()), "Merge with different resource name");
        return this.create(this.value.add(((Resource)other).getValue()));
    }

    public T subtract(T other) {
        Preconditions.checkNotNull(other, "Cannot subtract null resources");
        Preconditions.checkArgument(this.getClass() == other.getClass(), "Minus with different resource type");
        Preconditions.checkArgument(this.name.equals(((Resource)other).getName()), "Minus with different resource name");
        Preconditions.checkArgument(this.value.compareTo(((Resource)other).getValue()) >= 0, "Try to subtract a larger resource from this one.");
        return this.create(this.value.subtract(((Resource)other).getValue()));
    }

    public T multiply(BigDecimal multiplier) {
        return this.create(this.value.multiply(multiplier));
    }

    public T multiply(int multiplier) {
        return this.multiply(BigDecimal.valueOf(multiplier));
    }

    public T divide(BigDecimal by) {
        return this.create(this.value.divide(by, 8, RoundingMode.DOWN));
    }

    public T divide(int by) {
        return this.divide(BigDecimal.valueOf(by));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            Resource other = (Resource)o;
            return this.name.equals(other.getName()) && this.value.compareTo(other.getValue()) == 0;
        }
        return false;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + Objects.hashCode(this.value.doubleValue());
        return result;
    }

    public String toString() {
        return String.format("Resource(%s: %s)", this.name, this.value);
    }

    @Override
    public int compareTo(Resource other) {
        Preconditions.checkArgument(other != null && this.getClass() == other.getClass() && this.name.equals(other.name));
        return this.value.compareTo(other.value);
    }

    public String getName() {
        return this.name;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public boolean isZero() {
        return this.value.compareTo(BigDecimal.ZERO) == 0;
    }

    protected abstract T create(BigDecimal var1);
}

