/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.auth;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.auth.TokenScopeError;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class AuthError {
    public static final AuthError INVALID_ACCESS_TOKEN = new AuthError().withTag(Tag.INVALID_ACCESS_TOKEN);
    public static final AuthError INVALID_SELECT_USER = new AuthError().withTag(Tag.INVALID_SELECT_USER);
    public static final AuthError INVALID_SELECT_ADMIN = new AuthError().withTag(Tag.INVALID_SELECT_ADMIN);
    public static final AuthError USER_SUSPENDED = new AuthError().withTag(Tag.USER_SUSPENDED);
    public static final AuthError EXPIRED_ACCESS_TOKEN = new AuthError().withTag(Tag.EXPIRED_ACCESS_TOKEN);
    public static final AuthError ROUTE_ACCESS_DENIED = new AuthError().withTag(Tag.ROUTE_ACCESS_DENIED);
    public static final AuthError OTHER = new AuthError().withTag(Tag.OTHER);
    private Tag _tag;
    private TokenScopeError missingScopeValue;

    private AuthError() {
    }

    private AuthError withTag(Tag _tag) {
        AuthError result = new AuthError();
        result._tag = _tag;
        return result;
    }

    private AuthError withTagAndMissingScope(Tag _tag, TokenScopeError missingScopeValue) {
        AuthError result = new AuthError();
        result._tag = _tag;
        result.missingScopeValue = missingScopeValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isInvalidAccessToken() {
        return this._tag == Tag.INVALID_ACCESS_TOKEN;
    }

    public boolean isInvalidSelectUser() {
        return this._tag == Tag.INVALID_SELECT_USER;
    }

    public boolean isInvalidSelectAdmin() {
        return this._tag == Tag.INVALID_SELECT_ADMIN;
    }

    public boolean isUserSuspended() {
        return this._tag == Tag.USER_SUSPENDED;
    }

    public boolean isExpiredAccessToken() {
        return this._tag == Tag.EXPIRED_ACCESS_TOKEN;
    }

    public boolean isMissingScope() {
        return this._tag == Tag.MISSING_SCOPE;
    }

    public static AuthError missingScope(TokenScopeError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new AuthError().withTagAndMissingScope(Tag.MISSING_SCOPE, value);
    }

    public TokenScopeError getMissingScopeValue() {
        if (this._tag != Tag.MISSING_SCOPE) {
            throw new IllegalStateException("Invalid tag: required Tag.MISSING_SCOPE, but was Tag." + this._tag.name());
        }
        return this.missingScopeValue;
    }

    public boolean isRouteAccessDenied() {
        return this._tag == Tag.ROUTE_ACCESS_DENIED;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.missingScopeValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof AuthError) {
            AuthError other = (AuthError)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case INVALID_ACCESS_TOKEN: {
                    return true;
                }
                case INVALID_SELECT_USER: {
                    return true;
                }
                case INVALID_SELECT_ADMIN: {
                    return true;
                }
                case USER_SUSPENDED: {
                    return true;
                }
                case EXPIRED_ACCESS_TOKEN: {
                    return true;
                }
                case MISSING_SCOPE: {
                    return this.missingScopeValue == other.missingScopeValue || this.missingScopeValue.equals(other.missingScopeValue);
                }
                case ROUTE_ACCESS_DENIED: {
                    return true;
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    public static class Serializer
    extends UnionSerializer<AuthError> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void serialize(AuthError value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case INVALID_ACCESS_TOKEN: {
                    g.writeString("invalid_access_token");
                    break;
                }
                case INVALID_SELECT_USER: {
                    g.writeString("invalid_select_user");
                    break;
                }
                case INVALID_SELECT_ADMIN: {
                    g.writeString("invalid_select_admin");
                    break;
                }
                case USER_SUSPENDED: {
                    g.writeString("user_suspended");
                    break;
                }
                case EXPIRED_ACCESS_TOKEN: {
                    g.writeString("expired_access_token");
                    break;
                }
                case MISSING_SCOPE: {
                    g.writeStartObject();
                    this.writeTag("missing_scope", g);
                    TokenScopeError.Serializer.INSTANCE.serialize(value.missingScopeValue, g, true);
                    g.writeEndObject();
                    break;
                }
                case ROUTE_ACCESS_DENIED: {
                    g.writeString("route_access_denied");
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public AuthError deserialize(JsonParser p) throws IOException, JsonParseException {
            AuthError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("invalid_access_token".equals(tag)) {
                value = INVALID_ACCESS_TOKEN;
            } else if ("invalid_select_user".equals(tag)) {
                value = INVALID_SELECT_USER;
            } else if ("invalid_select_admin".equals(tag)) {
                value = INVALID_SELECT_ADMIN;
            } else if ("user_suspended".equals(tag)) {
                value = USER_SUSPENDED;
            } else if ("expired_access_token".equals(tag)) {
                value = EXPIRED_ACCESS_TOKEN;
            } else if ("missing_scope".equals(tag)) {
                TokenScopeError fieldValue = null;
                fieldValue = TokenScopeError.Serializer.INSTANCE.deserialize(p, true);
                value = AuthError.missingScope(fieldValue);
            } else {
                value = "route_access_denied".equals(tag) ? ROUTE_ACCESS_DENIED : OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        INVALID_ACCESS_TOKEN,
        INVALID_SELECT_USER,
        INVALID_SELECT_ADMIN,
        USER_SUSPENDED,
        EXPIRED_ACCESS_TOKEN,
        MISSING_SCOPE,
        ROUTE_ACCESS_DENIED,
        OTHER;

    }
}

