/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.fileinput;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.file.IInputFileMeta;
import org.apache.hop.core.file.TextFileInputField;
import org.apache.hop.core.fileinput.FileInputList;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.row.value.ValueMetaBoolean;
import org.apache.hop.core.row.value.ValueMetaDate;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.EnvUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.fileinput.TextFileFilter;
import org.apache.hop.pipeline.transforms.fileinput.TextFileInput;
import org.apache.hop.pipeline.transforms.fileinput.TextFileInputData;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.IResourceNaming;
import org.apache.hop.resource.ResourceDefinition;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.w3c.dom.Node;

@Deprecated(since="2.0")
@Transform(id="TextFileInput", image="textfileinput.svg", name="i18n::TextFileInput.Name", description="i18n::TextFileInput.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Input", keywords={"i18n::TextFileInputMeta.keyword"}, documentationUrl="/pipeline/transforms/textfileinput.html")
public class TextFileInputMeta
extends BaseTransformMeta<TextFileInput, TextFileInputData>
implements IInputFileMeta {
    private static final Class<?> PKG = TextFileInputMeta.class;
    public static final String[] RequiredFilesDesc = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    public static final String[] RequiredFilesCode = new String[]{"N", "Y"};
    private static final String NO = "N";
    private static final String YES = "Y";
    private static final String STRING_BASE64_PREFIX = "Base64: ";
    public static final int FILE_FORMAT_DOS = 0;
    public static final int FILE_FORMAT_UNIX = 1;
    public static final int FILE_FORMAT_MIXED = 2;
    public static final int FILE_TYPE_CSV = 0;
    public static final int FILE_TYPE_FIXED = 1;
    public static final String CONST_FILTER_POSITION = "filter_position";
    public static final String CONST_FILTER_IS_LAST_LINE = "filter_is_last_line";
    public static final String CONST_FILTER_IS_POSITIVE = "filter_is_positive";
    public static final String CONST_FORMAT = "format";
    public static final String CONST_FIELD = "field";
    public static final String CONST_FILTER = "filter";
    public static final String CONST_FILTER_STRING = "filter_string";
    public static final String CONST_SPACES_LONG = "        ";
    public static final String CONST_SPACES = "      ";
    private String[] fileName;
    private String[] fileMask;
    private String[] excludeFileMask;
    private String[] fileRequired;
    private String fileType;
    private String separator;
    private String enclosure;
    private String escapeCharacter;
    private boolean breakInEnclosureAllowed;
    private boolean header;
    private int nrHeaderLines;
    private boolean footer;
    private int nrFooterLines;
    private boolean lineWrapped;
    private int nrWraps;
    private boolean layoutPaged;
    private int nrLinesDocHeader;
    private int nrLinesPerPage;
    private String fileCompression;
    private boolean noEmptyLines;
    private boolean includeFilename;
    private String filenameField;
    private boolean includeRowNumber;
    private boolean rowNumberByFile;
    private String rowNumberField;
    private String fileFormat;
    private long rowLimit;
    private TextFileInputField[] inputFields;
    private String[] includeSubFolders;
    private TextFileFilter[] filter;
    private String encoding;
    private boolean errorIgnored;
    private String errorCountField;
    private String errorFieldsField;
    private String errorTextField;
    private String warningFilesDestinationDirectory;
    private String warningFilesExtension;
    private String errorFilesDestinationDirectory;
    private String errorFilesExtension;
    private String lineNumberFilesDestinationDirectory;
    private String lineNumberFilesExtension;
    private boolean dateFormatLenient;
    private Locale dateFormatLocale;
    private boolean errorLineSkipped;
    private boolean acceptingFilenames;
    private boolean passingThruFields;
    private String acceptingField;
    private String acceptingTransformName;
    private TransformMeta acceptingTransform;
    private boolean isaddresult;
    private String shortFileFieldName;
    private String pathFieldName;
    private String hiddenFieldName;
    private String lastModificationTimeFieldName;
    private String uriNameFieldName;
    private String rootUriNameFieldName;
    private String extensionFieldName;
    private String sizeFieldName;
    private boolean skipBadFiles;
    private String fileErrorField;
    private String fileErrorMessageField;

    public String getShortFileNameField() {
        return this.shortFileFieldName;
    }

    public void setShortFileNameField(String field) {
        this.shortFileFieldName = field;
    }

    public String getPathField() {
        return this.pathFieldName;
    }

    public void setPathField(String field) {
        this.pathFieldName = field;
    }

    public String isHiddenField() {
        return this.hiddenFieldName;
    }

    public void setIsHiddenField(String field) {
        this.hiddenFieldName = field;
    }

    public String getLastModificationDateField() {
        return this.lastModificationTimeFieldName;
    }

    public void setLastModificationDateField(String field) {
        this.lastModificationTimeFieldName = field;
    }

    public String getUriField() {
        return this.uriNameFieldName;
    }

    public void setUriField(String field) {
        this.uriNameFieldName = field;
    }

    public String getRootUriField() {
        return this.rootUriNameFieldName;
    }

    public void setRootUriField(String field) {
        this.rootUriNameFieldName = field;
    }

    public String getExtensionField() {
        return this.extensionFieldName;
    }

    public void setExtensionField(String field) {
        this.extensionFieldName = field;
    }

    public String getSizeField() {
        return this.sizeFieldName;
    }

    public void setSizeField(String field) {
        this.sizeFieldName = field;
    }

    public boolean isSkipBadFiles() {
        return this.skipBadFiles;
    }

    public void setSkipBadFiles(boolean value) {
        this.skipBadFiles = value;
    }

    public String getFileErrorField() {
        return this.fileErrorField;
    }

    public void setFileErrorField(String field) {
        this.fileErrorField = field;
    }

    public String getFileErrorMessageField() {
        return this.fileErrorMessageField;
    }

    public void setFileErrorMessageField(String field) {
        this.fileErrorMessageField = field;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public TextFileInputField[] getInputFields() {
        return this.inputFields;
    }

    public void setInputFields(TextFileInputField[] inputFields) {
        this.inputFields = inputFields;
    }

    public String getEnclosure() {
        return this.enclosure;
    }

    public void setEnclosure(String enclosure) {
        this.enclosure = enclosure;
    }

    public boolean isBreakInEnclosureAllowed() {
        return this.breakInEnclosureAllowed;
    }

    public void setBreakInEnclosureAllowed(boolean breakInEnclosureAllowed) {
        this.breakInEnclosureAllowed = breakInEnclosureAllowed;
    }

    public String[] getExludeFileMask() {
        return this.excludeFileMask;
    }

    public void setExcludeFileMask(String[] excludeFileMask) {
        this.excludeFileMask = excludeFileMask;
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    public void setFileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
    }

    public String[] getFileMask() {
        return this.fileMask;
    }

    public String[] getFileRequired() {
        return this.fileRequired;
    }

    public void setFileMask(String[] fileMask) {
        this.fileMask = fileMask;
    }

    public void setFileRequired(String[] fileRequired) {
        for (int i = 0; i < fileRequired.length; ++i) {
            this.fileRequired[i] = this.getRequiredFilesCode(fileRequired[i]);
        }
    }

    public String[] getIncludeSubFolders() {
        return this.includeSubFolders;
    }

    public void setIncludeSubFolders(String[] includeSubFoldersin) {
        for (int i = 0; i < includeSubFoldersin.length; ++i) {
            this.includeSubFolders[i] = this.getRequiredFilesCode(includeSubFoldersin[i]);
        }
    }

    public String getRequiredFilesCode(String tt) {
        if (tt == null) {
            return RequiredFilesCode[0];
        }
        if (tt.equals(RequiredFilesDesc[1])) {
            return RequiredFilesCode[1];
        }
        return RequiredFilesCode[0];
    }

    public String[] getFileName() {
        return this.fileName;
    }

    public void setFileName(String[] fileName) {
        this.fileName = fileName;
    }

    public String getFilenameField() {
        return this.filenameField;
    }

    public void setFilenameField(String filenameField) {
        this.filenameField = filenameField;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public TextFileFilter[] getFilter() {
        return this.filter;
    }

    public void setFilter(TextFileFilter[] filter) {
        this.filter = filter;
    }

    public boolean hasFooter() {
        return this.footer;
    }

    public void setFooter(boolean footer) {
        this.footer = footer;
    }

    public boolean hasHeader() {
        return this.header;
    }

    public void setHeader(boolean header) {
        this.header = header;
    }

    public boolean includeFilename() {
        return this.includeFilename;
    }

    public void setIncludeFilename(boolean includeFilename) {
        this.includeFilename = includeFilename;
    }

    public boolean includeRowNumber() {
        return this.includeRowNumber;
    }

    public void setIncludeRowNumber(boolean includeRowNumber) {
        this.includeRowNumber = includeRowNumber;
    }

    public boolean isRowNumberByFile() {
        return this.rowNumberByFile;
    }

    public void setRowNumberByFile(boolean rowNumberByFile) {
        this.rowNumberByFile = rowNumberByFile;
    }

    public boolean noEmptyLines() {
        return this.noEmptyLines;
    }

    public void setNoEmptyLines(boolean noEmptyLines) {
        this.noEmptyLines = noEmptyLines;
    }

    public long getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(long rowLimit) {
        this.rowLimit = rowLimit;
    }

    public String getRowNumberField() {
        return this.rowNumberField;
    }

    public void setRowNumberField(String rowNumberField) {
        this.rowNumberField = rowNumberField;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String getFileCompression() {
        return this.fileCompression;
    }

    public void setFileCompression(String fileCompression) {
        this.fileCompression = fileCompression;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        try {
            Node fnode;
            int i;
            this.acceptingFilenames = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"accept_filenames"));
            this.passingThruFields = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"passing_through_fields"));
            this.acceptingField = XmlHandler.getTagValue((Node)transformNode, (String)"accept_field");
            this.acceptingTransformName = XmlHandler.getTagValue((Node)transformNode, (String)"accept_transform_name");
            this.separator = XmlHandler.getTagValue((Node)transformNode, (String)"separator");
            this.enclosure = XmlHandler.getTagValue((Node)transformNode, (String)"enclosure");
            this.breakInEnclosureAllowed = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"enclosure_breaks"));
            this.escapeCharacter = XmlHandler.getTagValue((Node)transformNode, (String)"escapechar");
            this.header = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"header"));
            this.nrHeaderLines = Const.toInt((String)XmlHandler.getTagValue((Node)transformNode, (String)"nr_headerlines"), (int)1);
            this.footer = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"footer"));
            this.nrFooterLines = Const.toInt((String)XmlHandler.getTagValue((Node)transformNode, (String)"nr_footerlines"), (int)1);
            this.lineWrapped = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"line_wrapped"));
            this.nrWraps = Const.toInt((String)XmlHandler.getTagValue((Node)transformNode, (String)"nr_wraps"), (int)1);
            this.layoutPaged = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"layout_paged"));
            this.nrLinesPerPage = Const.toInt((String)XmlHandler.getTagValue((Node)transformNode, (String)"nr_lines_per_page"), (int)1);
            this.nrLinesDocHeader = Const.toInt((String)XmlHandler.getTagValue((Node)transformNode, (String)"nr_lines_doc_header"), (int)1);
            String addToResult = XmlHandler.getTagValue((Node)transformNode, (String)"add_to_result_filenames");
            this.isaddresult = Utils.isEmpty((CharSequence)addToResult) ? true : YES.equalsIgnoreCase(addToResult);
            String nempty = XmlHandler.getTagValue((Node)transformNode, (String)"noempty");
            this.noEmptyLines = YES.equalsIgnoreCase(nempty) || nempty == null;
            this.includeFilename = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"include"));
            this.filenameField = XmlHandler.getTagValue((Node)transformNode, (String)"include_field");
            this.includeRowNumber = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"rownum"));
            this.rowNumberByFile = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"rownumByFile"));
            this.rowNumberField = XmlHandler.getTagValue((Node)transformNode, (String)"rownum_field");
            this.fileFormat = XmlHandler.getTagValue((Node)transformNode, (String)CONST_FORMAT);
            this.encoding = XmlHandler.getTagValue((Node)transformNode, (String)"encoding");
            Node filenode = XmlHandler.getSubNode((Node)transformNode, (String)"file");
            Node fields = XmlHandler.getSubNode((Node)transformNode, (String)"fields");
            Node filtersNode = XmlHandler.getSubNode((Node)transformNode, (String)"filters");
            int nrfiles = XmlHandler.countNodes((Node)filenode, (String)"name");
            int nrFields = XmlHandler.countNodes((Node)fields, (String)CONST_FIELD);
            int nrfilters = XmlHandler.countNodes((Node)filtersNode, (String)CONST_FILTER);
            this.allocate(nrfiles, nrFields, nrfilters);
            for (i = 0; i < nrfiles; ++i) {
                Node filenamenode = XmlHandler.getSubNodeByNr((Node)filenode, (String)"name", (int)i);
                Node filemasknode = XmlHandler.getSubNodeByNr((Node)filenode, (String)"filemask", (int)i);
                Node excludefilemasknode = XmlHandler.getSubNodeByNr((Node)filenode, (String)"exclude_filemask", (int)i);
                Node fileRequirednode = XmlHandler.getSubNodeByNr((Node)filenode, (String)"file_required", (int)i);
                Node includeSubFoldersnode = XmlHandler.getSubNodeByNr((Node)filenode, (String)"include_subfolders", (int)i);
                this.fileName[i] = this.loadSource(filenode, filenamenode, i, metadataProvider);
                this.fileMask[i] = XmlHandler.getNodeValue((Node)filemasknode);
                this.excludeFileMask[i] = XmlHandler.getNodeValue((Node)excludefilemasknode);
                this.fileRequired[i] = XmlHandler.getNodeValue((Node)fileRequirednode);
                this.includeSubFolders[i] = XmlHandler.getNodeValue((Node)includeSubFoldersnode);
            }
            this.fileType = XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"type");
            this.fileCompression = XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"compression");
            if (this.fileCompression == null) {
                this.fileCompression = "None";
                if (YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"zipped"))) {
                    this.fileCompression = "Zip";
                }
            }
            if (XmlHandler.getTagValue((Node)transformNode, (String)CONST_FILTER) != null) {
                this.filter = new TextFileFilter[1];
                this.filter[0] = new TextFileFilter();
                this.filter[0].setFilterPosition(Const.toInt((String)XmlHandler.getTagValue((Node)transformNode, (String)CONST_FILTER_POSITION), (int)-1));
                this.filter[0].setFilterString(XmlHandler.getTagValue((Node)transformNode, (String)CONST_FILTER_STRING));
                this.filter[0].setFilterLastLine(YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)CONST_FILTER_IS_LAST_LINE)));
                this.filter[0].setFilterPositive(YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)CONST_FILTER_IS_POSITIVE)));
            } else {
                for (i = 0; i < nrfilters; ++i) {
                    fnode = XmlHandler.getSubNodeByNr((Node)filtersNode, (String)CONST_FILTER, (int)i);
                    this.filter[i] = new TextFileFilter();
                    this.filter[i].setFilterPosition(Const.toInt((String)XmlHandler.getTagValue((Node)fnode, (String)CONST_FILTER_POSITION), (int)-1));
                    String filterString = XmlHandler.getTagValue((Node)fnode, (String)CONST_FILTER_STRING);
                    if (filterString != null && filterString.startsWith(STRING_BASE64_PREFIX)) {
                        this.filter[i].setFilterString(new String(Base64.decodeBase64((byte[])filterString.substring(STRING_BASE64_PREFIX.length()).getBytes())));
                    } else {
                        this.filter[i].setFilterString(filterString);
                    }
                    this.filter[i].setFilterLastLine(YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)fnode, (String)CONST_FILTER_IS_LAST_LINE)));
                    this.filter[i].setFilterPositive(YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)fnode, (String)CONST_FILTER_IS_POSITIVE)));
                }
            }
            for (i = 0; i < nrFields; ++i) {
                fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)CONST_FIELD, (int)i);
                TextFileInputField field = new TextFileInputField();
                field.setName(XmlHandler.getTagValue((Node)fnode, (String)"name"));
                field.setType(ValueMetaFactory.getIdForValueMeta((String)XmlHandler.getTagValue((Node)fnode, (String)"type")));
                field.setFormat(XmlHandler.getTagValue((Node)fnode, (String)CONST_FORMAT));
                field.setCurrencySymbol(XmlHandler.getTagValue((Node)fnode, (String)"currency"));
                field.setDecimalSymbol(XmlHandler.getTagValue((Node)fnode, (String)"decimal"));
                field.setGroupSymbol(XmlHandler.getTagValue((Node)fnode, (String)"group"));
                field.setNullString(XmlHandler.getTagValue((Node)fnode, (String)"nullif"));
                field.setIfNullValue(XmlHandler.getTagValue((Node)fnode, (String)"ifnull"));
                field.setPosition(Const.toInt((String)XmlHandler.getTagValue((Node)fnode, (String)"position"), (int)-1));
                field.setLength(Const.toInt((String)XmlHandler.getTagValue((Node)fnode, (String)"length"), (int)-1));
                field.setPrecision(Const.toInt((String)XmlHandler.getTagValue((Node)fnode, (String)"precision"), (int)-1));
                field.setTrimType(ValueMetaBase.getTrimTypeByCode((String)XmlHandler.getTagValue((Node)fnode, (String)"trim_type")));
                field.setRepeated(YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)fnode, (String)"repeat")));
                this.inputFields[i] = field;
            }
            this.rowLimit = Const.toLong((String)XmlHandler.getTagValue((Node)transformNode, (String)"limit"), (long)0L);
            this.errorIgnored = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"error_ignored"));
            this.skipBadFiles = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"skip_bad_files"));
            this.fileErrorField = XmlHandler.getTagValue((Node)transformNode, (String)"file_error_field");
            this.fileErrorMessageField = XmlHandler.getTagValue((Node)transformNode, (String)"file_error_message_field");
            this.errorLineSkipped = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"error_line_skipped"));
            this.errorCountField = XmlHandler.getTagValue((Node)transformNode, (String)"error_count_field");
            this.errorFieldsField = XmlHandler.getTagValue((Node)transformNode, (String)"error_fields_field");
            this.errorTextField = XmlHandler.getTagValue((Node)transformNode, (String)"error_text_field");
            this.warningFilesDestinationDirectory = XmlHandler.getTagValue((Node)transformNode, (String)"bad_line_files_destination_directory");
            this.warningFilesExtension = XmlHandler.getTagValue((Node)transformNode, (String)"bad_line_files_extension");
            this.errorFilesDestinationDirectory = XmlHandler.getTagValue((Node)transformNode, (String)"error_line_files_destination_directory");
            this.errorFilesExtension = XmlHandler.getTagValue((Node)transformNode, (String)"error_line_files_extension");
            this.lineNumberFilesDestinationDirectory = XmlHandler.getTagValue((Node)transformNode, (String)"line_number_files_destination_directory");
            this.lineNumberFilesExtension = XmlHandler.getTagValue((Node)transformNode, (String)"line_number_files_extension");
            this.dateFormatLenient = !NO.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"date_format_lenient"));
            String dateLocale = XmlHandler.getTagValue((Node)transformNode, (String)"date_format_locale");
            this.dateFormatLocale = dateLocale != null ? EnvUtil.createLocale((String)dateLocale) : Locale.getDefault();
            this.shortFileFieldName = XmlHandler.getTagValue((Node)transformNode, (String)"shortFileFieldName");
            this.pathFieldName = XmlHandler.getTagValue((Node)transformNode, (String)"pathFieldName");
            this.hiddenFieldName = XmlHandler.getTagValue((Node)transformNode, (String)"hiddenFieldName");
            this.lastModificationTimeFieldName = XmlHandler.getTagValue((Node)transformNode, (String)"lastModificationTimeFieldName");
            this.uriNameFieldName = XmlHandler.getTagValue((Node)transformNode, (String)"uriNameFieldName");
            this.rootUriNameFieldName = XmlHandler.getTagValue((Node)transformNode, (String)"rootUriNameFieldName");
            this.extensionFieldName = XmlHandler.getTagValue((Node)transformNode, (String)"extensionFieldName");
            this.sizeFieldName = XmlHandler.getTagValue((Node)transformNode, (String)"sizeFieldName");
        }
        catch (Exception e) {
            throw new HopXmlException("Unable to load transform info from XML", (Throwable)e);
        }
    }

    public Object clone() {
        int i;
        TextFileInputMeta retval = (TextFileInputMeta)((Object)super.clone());
        int nrFiles = this.fileName.length;
        int nrFields = this.inputFields.length;
        int nrfilters = this.filter.length;
        retval.allocate(nrFiles, nrFields, nrfilters);
        System.arraycopy(this.fileName, 0, retval.fileName, 0, nrFiles);
        System.arraycopy(this.fileMask, 0, retval.fileMask, 0, nrFiles);
        System.arraycopy(this.excludeFileMask, 0, retval.excludeFileMask, 0, nrFiles);
        System.arraycopy(this.fileRequired, 0, retval.fileRequired, 0, nrFiles);
        System.arraycopy(this.includeSubFolders, 0, retval.includeSubFolders, 0, nrFiles);
        for (i = 0; i < nrFields; ++i) {
            retval.inputFields[i] = (TextFileInputField)this.inputFields[i].clone();
        }
        for (i = 0; i < nrfilters; ++i) {
            retval.filter[i] = (TextFileFilter)this.filter[i].clone();
        }
        retval.dateFormatLocale = (Locale)this.dateFormatLocale.clone();
        retval.fileCompression = this.fileCompression;
        return retval;
    }

    public void allocate(int nrfiles, int nrFields, int nrfilters) {
        this.allocateFiles(nrfiles);
        this.inputFields = new TextFileInputField[nrFields];
        this.filter = new TextFileFilter[nrfilters];
    }

    public void allocateFiles(int nrFiles) {
        this.fileName = new String[nrFiles];
        this.fileMask = new String[nrFiles];
        this.excludeFileMask = new String[nrFiles];
        this.fileRequired = new String[nrFiles];
        this.includeSubFolders = new String[nrFiles];
    }

    public void setDefault() {
        int i;
        this.shortFileFieldName = null;
        this.pathFieldName = null;
        this.hiddenFieldName = null;
        this.lastModificationTimeFieldName = null;
        this.uriNameFieldName = null;
        this.rootUriNameFieldName = null;
        this.extensionFieldName = null;
        this.sizeFieldName = null;
        this.isaddresult = true;
        this.separator = ";";
        this.enclosure = "\"";
        this.breakInEnclosureAllowed = false;
        this.header = true;
        this.nrHeaderLines = 1;
        this.footer = false;
        this.nrFooterLines = 1;
        this.lineWrapped = false;
        this.nrWraps = 1;
        this.layoutPaged = false;
        this.nrLinesPerPage = 80;
        this.nrLinesDocHeader = 0;
        this.fileCompression = "None";
        this.noEmptyLines = true;
        this.fileFormat = "DOS";
        this.fileType = "CSV";
        this.includeFilename = false;
        this.filenameField = "";
        this.includeRowNumber = false;
        this.rowNumberField = "";
        this.errorIgnored = false;
        this.skipBadFiles = false;
        this.errorLineSkipped = false;
        this.warningFilesDestinationDirectory = null;
        this.warningFilesExtension = "warning";
        this.errorFilesDestinationDirectory = null;
        this.errorFilesExtension = "error";
        this.lineNumberFilesDestinationDirectory = null;
        this.lineNumberFilesExtension = "line";
        this.dateFormatLenient = true;
        this.rowNumberByFile = false;
        int nrfiles = 0;
        int nrFields = 0;
        int nrfilters = 0;
        this.allocate(nrfiles, nrFields, nrfilters);
        for (i = 0; i < nrfiles; ++i) {
            this.fileName[i] = "filename" + (i + 1);
            this.fileMask[i] = "";
            this.excludeFileMask[i] = "";
            this.fileRequired[i] = NO;
            this.includeSubFolders[i] = NO;
        }
        for (i = 0; i < nrFields; ++i) {
            this.inputFields[i] = new TextFileInputField(CONST_FIELD + (i + 1), 1, -1);
        }
        this.dateFormatLocale = Locale.getDefault();
        this.rowLimit = 0L;
    }

    public void getFields(IRowMeta row, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (!this.isPassingThruFields()) {
            row.clear();
        } else if (info != null) {
            boolean found = false;
            for (int i = 0; i < info.length && !found; ++i) {
                if (info[i] == null) continue;
                row.mergeRowMeta(info[i]);
                found = true;
            }
        }
        for (int i = 0; i < this.inputFields.length; ++i) {
            TextFileInputField field = this.inputFields[i];
            int type = field.getType();
            if (type == 0) {
                type = 2;
            }
            try {
                IValueMeta v = ValueMetaFactory.createValueMeta((String)field.getName(), (int)type);
                v.setLength(field.getLength());
                v.setPrecision(field.getPrecision());
                v.setOrigin(name);
                v.setConversionMask(field.getFormat());
                v.setDecimalSymbol(field.getDecimalSymbol());
                v.setGroupingSymbol(field.getGroupSymbol());
                v.setCurrencySymbol(field.getCurrencySymbol());
                v.setDateFormatLenient(this.dateFormatLenient);
                v.setDateFormatLocale(this.dateFormatLocale);
                v.setTrimType(field.getTrimType());
                row.addValueMeta(v);
                continue;
            }
            catch (Exception e) {
                throw new HopTransformException((Throwable)e);
            }
        }
        if (this.errorIgnored) {
            if (!Utils.isEmpty((CharSequence)this.errorCountField)) {
                ValueMetaInteger v = new ValueMetaInteger(this.errorCountField);
                v.setLength(10, 0);
                v.setOrigin(name);
                row.addValueMeta((IValueMeta)v);
            }
            if (!Utils.isEmpty((CharSequence)this.errorFieldsField)) {
                ValueMetaString v = new ValueMetaString(this.errorFieldsField);
                v.setOrigin(name);
                row.addValueMeta((IValueMeta)v);
            }
            if (!Utils.isEmpty((CharSequence)this.errorTextField)) {
                ValueMetaString v = new ValueMetaString(this.errorTextField);
                v.setOrigin(name);
                row.addValueMeta((IValueMeta)v);
            }
        }
        if (this.includeFilename) {
            ValueMetaString v = new ValueMetaString(this.filenameField);
            v.setLength(100);
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
        if (this.includeRowNumber) {
            ValueMetaInteger v = new ValueMetaInteger(this.rowNumberField);
            v.setLength(10, 0);
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
        if (!Utils.isEmpty((CharSequence)this.getShortFileNameField())) {
            ValueMetaString v = new ValueMetaString(variables.resolve(this.getShortFileNameField()));
            v.setLength(100, -1);
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
        if (!Utils.isEmpty((CharSequence)this.getExtensionField())) {
            ValueMetaString v = new ValueMetaString(variables.resolve(this.getExtensionField()));
            v.setLength(100, -1);
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
        if (!Utils.isEmpty((CharSequence)this.getPathField())) {
            ValueMetaString v = new ValueMetaString(variables.resolve(this.getPathField()));
            v.setLength(100, -1);
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
        if (!Utils.isEmpty((CharSequence)this.getSizeField())) {
            ValueMetaInteger v = new ValueMetaInteger(variables.resolve(this.getSizeField()));
            v.setOrigin(name);
            v.setLength(9);
            row.addValueMeta((IValueMeta)v);
        }
        if (!Utils.isEmpty((CharSequence)this.isHiddenField())) {
            ValueMetaBoolean v = new ValueMetaBoolean(variables.resolve(this.isHiddenField()));
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
        if (!Utils.isEmpty((CharSequence)this.getLastModificationDateField())) {
            ValueMetaDate v = new ValueMetaDate(variables.resolve(this.getLastModificationDateField()));
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
        if (!Utils.isEmpty((CharSequence)this.getUriField())) {
            ValueMetaString v = new ValueMetaString(variables.resolve(this.getUriField()));
            v.setLength(100, -1);
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
        if (!Utils.isEmpty((CharSequence)this.getRootUriField())) {
            ValueMetaString v = new ValueMetaString(this.getRootUriField());
            v.setLength(100, -1);
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
    }

    public String getXml() {
        int i;
        StringBuilder retval = new StringBuilder(1500);
        retval.append("    ").append(XmlHandler.addTagValue((String)"accept_filenames", (boolean)this.acceptingFilenames));
        retval.append("    ").append(XmlHandler.addTagValue((String)"passing_through_fields", (boolean)this.passingThruFields));
        retval.append("    ").append(XmlHandler.addTagValue((String)"accept_field", (String)this.acceptingField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"accept_transform_name", (String)(this.acceptingTransform != null ? this.acceptingTransform.getName() : "")));
        retval.append("    ").append(XmlHandler.addTagValue((String)"separator", (String)this.separator));
        retval.append("    ").append(XmlHandler.addTagValue((String)"enclosure", (String)this.enclosure));
        retval.append("    ").append(XmlHandler.addTagValue((String)"enclosure_breaks", (boolean)this.breakInEnclosureAllowed));
        retval.append("    ").append(XmlHandler.addTagValue((String)"escapechar", (String)this.escapeCharacter));
        retval.append("    ").append(XmlHandler.addTagValue((String)"header", (boolean)this.header));
        retval.append("    ").append(XmlHandler.addTagValue((String)"nr_headerlines", (int)this.nrHeaderLines));
        retval.append("    ").append(XmlHandler.addTagValue((String)"footer", (boolean)this.footer));
        retval.append("    ").append(XmlHandler.addTagValue((String)"nr_footerlines", (int)this.nrFooterLines));
        retval.append("    ").append(XmlHandler.addTagValue((String)"line_wrapped", (boolean)this.lineWrapped));
        retval.append("    ").append(XmlHandler.addTagValue((String)"nr_wraps", (int)this.nrWraps));
        retval.append("    ").append(XmlHandler.addTagValue((String)"layout_paged", (boolean)this.layoutPaged));
        retval.append("    ").append(XmlHandler.addTagValue((String)"nr_lines_per_page", (int)this.nrLinesPerPage));
        retval.append("    ").append(XmlHandler.addTagValue((String)"nr_lines_doc_header", (int)this.nrLinesDocHeader));
        retval.append("    ").append(XmlHandler.addTagValue((String)"noempty", (boolean)this.noEmptyLines));
        retval.append("    ").append(XmlHandler.addTagValue((String)"include", (boolean)this.includeFilename));
        retval.append("    ").append(XmlHandler.addTagValue((String)"include_field", (String)this.filenameField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"rownum", (boolean)this.includeRowNumber));
        retval.append("    ").append(XmlHandler.addTagValue((String)"rownumByFile", (boolean)this.rowNumberByFile));
        retval.append("    ").append(XmlHandler.addTagValue((String)"rownum_field", (String)this.rowNumberField));
        retval.append("    ").append(XmlHandler.addTagValue((String)CONST_FORMAT, (String)this.fileFormat));
        retval.append("    ").append(XmlHandler.addTagValue((String)"encoding", (String)this.encoding));
        retval.append("    " + XmlHandler.addTagValue((String)"add_to_result_filenames", (boolean)this.isaddresult));
        retval.append("    <file>").append(Const.CR);
        for (i = 0; i < this.fileName.length; ++i) {
            this.saveSource(retval, this.fileName[i]);
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"filemask", (String)this.fileMask[i]));
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"exclude_filemask", (String)this.excludeFileMask[i]));
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"file_required", (String)this.fileRequired[i]));
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"include_subfolders", (String)this.includeSubFolders[i]));
        }
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"type", (String)this.fileType));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"compression", (String)(this.fileCompression == null ? "None" : this.fileCompression)));
        retval.append("    </file>").append(Const.CR);
        retval.append("    <filters>").append(Const.CR);
        for (i = 0; i < this.filter.length; ++i) {
            String filterString = this.filter[i].getFilterString();
            byte[] filterBytes = new byte[]{};
            String filterPrefix = "";
            if (filterString != null) {
                filterBytes = filterString.getBytes();
                filterPrefix = STRING_BASE64_PREFIX;
            }
            String filterEncoded = filterPrefix + new String(Base64.encodeBase64((byte[])filterBytes));
            retval.append("      <filter>").append(Const.CR);
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)CONST_FILTER_STRING, (String)filterEncoded, (boolean)false, (String[])new String[0]));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)CONST_FILTER_POSITION, (int)this.filter[i].getFilterPosition(), (boolean)false));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)CONST_FILTER_IS_LAST_LINE, (boolean)this.filter[i].isFilterLastLine(), (boolean)false));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)CONST_FILTER_IS_POSITIVE, (boolean)this.filter[i].isFilterPositive(), (boolean)false));
            retval.append("      </filter>").append(Const.CR);
        }
        retval.append("    </filters>").append(Const.CR);
        retval.append("    <fields>").append(Const.CR);
        for (i = 0; i < this.inputFields.length; ++i) {
            TextFileInputField field = this.inputFields[i];
            retval.append("      <field>").append(Const.CR);
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"name", (String)field.getName()));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"type", (String)field.getTypeDesc()));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)CONST_FORMAT, (String)field.getFormat()));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"currency", (String)field.getCurrencySymbol()));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"decimal", (String)field.getDecimalSymbol()));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"group", (String)field.getGroupSymbol()));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"nullif", (String)field.getNullString()));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"ifnull", (String)field.getIfNullValue()));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"position", (int)field.getPosition()));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"length", (int)field.getLength()));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"precision", (int)field.getPrecision()));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"trim_type", (String)field.getTrimTypeCode()));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"repeat", (boolean)field.isRepeated()));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        retval.append("    ").append(XmlHandler.addTagValue((String)"limit", (long)this.rowLimit));
        retval.append("    ").append(XmlHandler.addTagValue((String)"error_ignored", (boolean)this.errorIgnored));
        retval.append("    ").append(XmlHandler.addTagValue((String)"skip_bad_files", (boolean)this.skipBadFiles));
        retval.append("    ").append(XmlHandler.addTagValue((String)"file_error_field", (String)this.fileErrorField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"file_error_message_field", (String)this.fileErrorMessageField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"error_line_skipped", (boolean)this.errorLineSkipped));
        retval.append("    ").append(XmlHandler.addTagValue((String)"error_count_field", (String)this.errorCountField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"error_fields_field", (String)this.errorFieldsField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"error_text_field", (String)this.errorTextField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"bad_line_files_destination_directory", (String)this.warningFilesDestinationDirectory));
        retval.append("    ").append(XmlHandler.addTagValue((String)"bad_line_files_extension", (String)this.warningFilesExtension));
        retval.append("    ").append(XmlHandler.addTagValue((String)"error_line_files_destination_directory", (String)this.errorFilesDestinationDirectory));
        retval.append("    ").append(XmlHandler.addTagValue((String)"error_line_files_extension", (String)this.errorFilesExtension));
        retval.append("    ").append(XmlHandler.addTagValue((String)"line_number_files_destination_directory", (String)this.lineNumberFilesDestinationDirectory));
        retval.append("    ").append(XmlHandler.addTagValue((String)"line_number_files_extension", (String)this.lineNumberFilesExtension));
        retval.append("    ").append(XmlHandler.addTagValue((String)"date_format_lenient", (boolean)this.dateFormatLenient));
        retval.append("    ").append(XmlHandler.addTagValue((String)"date_format_locale", (String)(this.dateFormatLocale != null ? this.dateFormatLocale.toString() : Locale.getDefault().toString())));
        retval.append("    ").append(XmlHandler.addTagValue((String)"shortFileFieldName", (String)this.shortFileFieldName));
        retval.append("    ").append(XmlHandler.addTagValue((String)"pathFieldName", (String)this.pathFieldName));
        retval.append("    ").append(XmlHandler.addTagValue((String)"hiddenFieldName", (String)this.hiddenFieldName));
        retval.append("    ").append(XmlHandler.addTagValue((String)"lastModificationTimeFieldName", (String)this.lastModificationTimeFieldName));
        retval.append("    ").append(XmlHandler.addTagValue((String)"uriNameFieldName", (String)this.uriNameFieldName));
        retval.append("    ").append(XmlHandler.addTagValue((String)"rootUriNameFieldName", (String)this.rootUriNameFieldName));
        retval.append("    ").append(XmlHandler.addTagValue((String)"extensionFieldName", (String)this.extensionFieldName));
        retval.append("    ").append(XmlHandler.addTagValue((String)"sizeFieldName", (String)this.sizeFieldName));
        return retval.toString();
    }

    public String getLookupTransformName() {
        if (this.acceptingFilenames && this.acceptingTransform != null && !Utils.isEmpty((CharSequence)this.acceptingTransform.getName())) {
            return this.acceptingTransform.getName();
        }
        return null;
    }

    public void searchInfoAndTargetTransforms(List<TransformMeta> transforms) {
        this.acceptingTransform = TransformMeta.findTransform(transforms, (String)this.acceptingTransformName);
    }

    public String[] getInfoTransforms() {
        if (this.acceptingFilenames && this.acceptingTransform != null) {
            return new String[]{this.acceptingTransform.getName()};
        }
        return null;
    }

    public String[] getFilePaths(IVariables variables) {
        return FileInputList.createFilePathList((IVariables)variables, (String[])this.fileName, (String[])this.fileMask, (String[])this.excludeFileMask, (String[])this.fileRequired, (boolean[])this.includeSubFolderBoolean());
    }

    public FileInputList getTextFileList(IVariables variables) {
        return FileInputList.createFileList((IVariables)variables, (String[])this.fileName, (String[])this.fileMask, (String[])this.excludeFileMask, (String[])this.fileRequired, (boolean[])this.includeSubFolderBoolean());
    }

    private boolean[] includeSubFolderBoolean() {
        int len = this.fileName.length;
        boolean[] includeSubFolderBoolean = new boolean[len];
        for (int i = 0; i < len; ++i) {
            includeSubFolderBoolean[i] = YES.equalsIgnoreCase(this.includeSubFolders[i]);
        }
        return includeSubFolderBoolean;
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (input.length > 0) {
            if (!this.isAcceptingFilenames()) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TextFileInputMeta.CheckResult.NoInputError", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TextFileInputMeta.CheckResult.AcceptFilenamesOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TextFileInputMeta.CheckResult.NoInputOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        FileInputList textFileList = this.getTextFileList(variables);
        if (textFileList.nrOfFiles() == 0) {
            if (!this.isAcceptingFilenames()) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TextFileInputMeta.CheckResult.ExpectedFilesError", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TextFileInputMeta.CheckResult.ExpectedFilesOk", (String[])new String[]{"" + textFileList.nrOfFiles()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public String getEscapeCharacter() {
        return this.escapeCharacter;
    }

    public void setEscapeCharacter(String escapeCharacter) {
        this.escapeCharacter = escapeCharacter;
    }

    public String getErrorCountField() {
        return this.errorCountField;
    }

    public void setErrorCountField(String errorCountField) {
        this.errorCountField = errorCountField;
    }

    public String getErrorFieldsField() {
        return this.errorFieldsField;
    }

    public void setErrorFieldsField(String errorFieldsField) {
        this.errorFieldsField = errorFieldsField;
    }

    public boolean isErrorIgnored() {
        return this.errorIgnored;
    }

    public void setErrorIgnored(boolean errorIgnored) {
        this.errorIgnored = errorIgnored;
    }

    public String getErrorTextField() {
        return this.errorTextField;
    }

    public void setErrorTextField(String errorTextField) {
        this.errorTextField = errorTextField;
    }

    public boolean isLineWrapped() {
        return this.lineWrapped;
    }

    public void setLineWrapped(boolean lineWrapped) {
        this.lineWrapped = lineWrapped;
    }

    public int getNrFooterLines() {
        return this.nrFooterLines;
    }

    public void setNrFooterLines(int nrFooterLines) {
        this.nrFooterLines = nrFooterLines;
    }

    public String getRequiredFilesDesc(String tt) {
        if (tt == null) {
            return RequiredFilesDesc[0];
        }
        if (tt.equals(RequiredFilesCode[1])) {
            return RequiredFilesDesc[1];
        }
        return RequiredFilesDesc[0];
    }

    public int getNrHeaderLines() {
        return this.nrHeaderLines;
    }

    public void setNrHeaderLines(int nrHeaderLines) {
        this.nrHeaderLines = nrHeaderLines;
    }

    public int getNrWraps() {
        return this.nrWraps;
    }

    public void setNrWraps(int nrWraps) {
        this.nrWraps = nrWraps;
    }

    public boolean isLayoutPaged() {
        return this.layoutPaged;
    }

    public void setLayoutPaged(boolean layoutPaged) {
        this.layoutPaged = layoutPaged;
    }

    public int getNrLinesPerPage() {
        return this.nrLinesPerPage;
    }

    public void setNrLinesPerPage(int nrLinesPerPage) {
        this.nrLinesPerPage = nrLinesPerPage;
    }

    public int getNrLinesDocHeader() {
        return this.nrLinesDocHeader;
    }

    public void setNrLinesDocHeader(int nrLinesDocHeader) {
        this.nrLinesDocHeader = nrLinesDocHeader;
    }

    public String getWarningFilesDestinationDirectory() {
        return this.warningFilesDestinationDirectory;
    }

    public void setWarningFilesDestinationDirectory(String warningFilesDestinationDirectory) {
        this.warningFilesDestinationDirectory = warningFilesDestinationDirectory;
    }

    public String getWarningFilesExtension() {
        return this.warningFilesExtension;
    }

    public void setWarningFilesExtension(String warningFilesExtension) {
        this.warningFilesExtension = warningFilesExtension;
    }

    public String getLineNumberFilesDestinationDirectory() {
        return this.lineNumberFilesDestinationDirectory;
    }

    public void setLineNumberFilesDestinationDirectory(String lineNumberFilesDestinationDirectory) {
        this.lineNumberFilesDestinationDirectory = lineNumberFilesDestinationDirectory;
    }

    public String getLineNumberFilesExtension() {
        return this.lineNumberFilesExtension;
    }

    public void setLineNumberFilesExtension(String lineNumberFilesExtension) {
        this.lineNumberFilesExtension = lineNumberFilesExtension;
    }

    public String getErrorFilesDestinationDirectory() {
        return this.errorFilesDestinationDirectory;
    }

    public void setErrorFilesDestinationDirectory(String errorFilesDestinationDirectory) {
        this.errorFilesDestinationDirectory = errorFilesDestinationDirectory;
    }

    public String getErrorLineFilesExtension() {
        return this.errorFilesExtension;
    }

    public void setErrorLineFilesExtension(String errorLineFilesExtension) {
        this.errorFilesExtension = errorLineFilesExtension;
    }

    public boolean isDateFormatLenient() {
        return this.dateFormatLenient;
    }

    public void setDateFormatLenient(boolean dateFormatLenient) {
        this.dateFormatLenient = dateFormatLenient;
    }

    public void setAddResultFile(boolean isaddresult) {
        this.isaddresult = isaddresult;
    }

    public boolean isAddResultFile() {
        return this.isaddresult;
    }

    public boolean isErrorLineSkipped() {
        return this.errorLineSkipped;
    }

    public void setErrorLineSkipped(boolean errorLineSkipped) {
        this.errorLineSkipped = errorLineSkipped;
    }

    public Locale getDateFormatLocale() {
        return this.dateFormatLocale;
    }

    public void setDateFormatLocale(Locale dateFormatLocale) {
        this.dateFormatLocale = dateFormatLocale;
    }

    public boolean isAcceptingFilenames() {
        return this.acceptingFilenames;
    }

    public void setAcceptingFilenames(boolean getFileFromJob) {
        this.acceptingFilenames = getFileFromJob;
    }

    public boolean isPassingThruFields() {
        return this.passingThruFields;
    }

    public void setPassingThruFields(boolean passingThruFields) {
        this.passingThruFields = passingThruFields;
    }

    public String getAcceptingField() {
        return this.acceptingField;
    }

    public void setAcceptingField(String fileNameField) {
        this.acceptingField = fileNameField;
    }

    public String getAcceptingTransformName() {
        return this.acceptingTransformName;
    }

    public void setAcceptingTransformName(String acceptingTransform) {
        this.acceptingTransformName = acceptingTransform;
    }

    public TransformMeta getAcceptingTransform() {
        return this.acceptingTransform;
    }

    public void setAcceptingTransform(TransformMeta acceptingTransform) {
        this.acceptingTransform = acceptingTransform;
    }

    public int getFileFormatTypeNr() {
        if (this.getFileFormat().equalsIgnoreCase("DOS")) {
            return 0;
        }
        if (this.getFileFormat().equalsIgnoreCase("unix")) {
            return 1;
        }
        return 2;
    }

    public int getFileTypeNr() {
        if (this.getFileType().equalsIgnoreCase("CSV")) {
            return 0;
        }
        return 1;
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, TransformMeta transformMeta) {
        ArrayList<ResourceReference> references = new ArrayList<ResourceReference>(5);
        ResourceReference reference = new ResourceReference((IResourceHolder)transformMeta);
        references.add(reference);
        String[] textFiles = this.getFilePaths(variables);
        if (textFiles != null) {
            for (int i = 0; i < textFiles.length; ++i) {
                reference.getEntries().add(new ResourceEntry(textFiles[i], ResourceEntry.ResourceType.FILE));
            }
        }
        return references;
    }

    public String exportResources(IVariables variables, Map<String, ResourceDefinition> definitions, IResourceNaming iResourceNaming, IHopMetadataProvider metadataProvider) throws HopException {
        try {
            if (!this.acceptingFilenames) {
                for (int i = 0; i < this.fileName.length; ++i) {
                    FileObject fileObject = HopVfs.getFileObject((String)variables.resolve(this.fileName[i]), (IVariables)variables);
                    this.fileName[i] = iResourceNaming.nameResource(fileObject, variables, Utils.isEmpty((CharSequence)this.fileMask[i]));
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }

    public boolean supportsErrorHandling() {
        return this.isErrorIgnored() && this.isSkipBadFiles();
    }

    @VisibleForTesting
    public void setFileNameForTest(String[] fileName) {
        this.allocateFiles(fileName.length);
        this.setFileName(fileName);
    }

    protected String loadSource(Node filenode, Node filenamenode, int i, IHopMetadataProvider metadataProvider) {
        return XmlHandler.getNodeValue((Node)filenamenode);
    }

    protected void saveSource(StringBuilder retVal, String source) {
        retVal.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"name", (String)source));
    }
}

