/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.gettablenames;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBoolean;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.gettablenames.GetTableNames;
import org.apache.hop.pipeline.transforms.gettablenames.GetTableNamesData;

@InjectionSupported(localizationPrefix="GetTableNames.Injection.", groups={"FIELDS", "SETTINGS", "OUTPUT"})
@Transform(id="GetTableNames", image="gettablenames.svg", name="i18n::GetTableNames.Name", description="i18n::GetTableNames.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Input", keywords={"i18n::GetTableNamesMeta.keyword"}, documentationUrl="/pipeline/transforms/gettablenames.html")
public class GetTableNamesMeta
extends BaseTransformMeta<GetTableNames, GetTableNamesData> {
    private static final Class<?> PKG = GetTableNamesMeta.class;
    @HopMetadataProperty(key="connection", injectionKey="CONNECTIONNAME", injectionKeyDescription="GetTableNames.Injection.CONNECTION_NAME")
    private String connection;
    @HopMetadataProperty(key="schemaname", injectionKey="SCHEMANAME", injectionKeyDescription="GetTableNames.Injection.SCHEMA_NAME")
    private String schemaName;
    @HopMetadataProperty(key="tablenamefieldname", injectionKey="TABLENAMEFIELDNAME", injectionKeyDescription="GetTableNames.Injection.TABLE_NAME_FIELD_NAME")
    private String tableNameFieldName;
    @HopMetadataProperty(key="sqlcreationfieldname", injectionKey="SQLCREATIONFIELDNAME", injectionKeyDescription="GetTableNames.Injection.SQL_CREATION_FIELD_NAME")
    private String sqlCreationFieldName;
    @HopMetadataProperty(key="objecttypefieldname", injectionKey="OBJECTTYPEFIELDNAME", injectionKeyDescription="GetTableNames.Injection.OBJECT_TYPE_FIELD_NAME")
    private String objectTypeFieldName;
    @HopMetadataProperty(key="issystemobjectfieldname", injectionKey="ISSYSTEMOBJECTFIELDNAME", injectionKeyDescription="GetTableNames.Injection.IS_SYSTEM_OBJECT_FIELD_NAME")
    private String isSystemObjectFieldName;
    @HopMetadataProperty(key="includeCatalog", injectionKey="INCLUDECATALOG", injectionKeyDescription="GetTableNames.Injection.INCLUDE_CATALOG")
    private boolean includeCatalog;
    @HopMetadataProperty(key="includeSchema", injectionKey="INCLUDESCHEMA", injectionKeyDescription="GetTableNames.Injection.INCLUDE_SCHEMA")
    private boolean includeSchema;
    @HopMetadataProperty(key="includeTable", injectionKey="INCLUDETABLE", injectionKeyDescription="GetTableNames.Injection.INCLUDE_TABLE")
    private boolean includeTable;
    @HopMetadataProperty(key="includeView", injectionKey="INCLUDEVIEW", injectionKeyDescription="GetTableNames.Injection.INCLUDE_VIEW")
    private boolean includeView;
    @HopMetadataProperty(key="includeProcedure", injectionKey="INCLUDEPROCEDURE", injectionKeyDescription="GetTableNames.Injection.INCLUDE_PROCEDURE")
    private boolean includeProcedure;
    @HopMetadataProperty(key="includeSynonym", injectionKey="INCLUDESYNONYM", injectionKeyDescription="GetTableNames.Injection.INCLUDE_SYNONYM")
    private boolean includeSynonym;
    @HopMetadataProperty(key="addSchemaInOutput", injectionKey="ADDSCHEMAINOUTPUT", injectionKeyDescription="GetTableNames.Injection.ADD_SCHEMA_IN_OUTPUT")
    private boolean addSchemaInOutput;
    @HopMetadataProperty(key="dynamicSchema", injectionKey="DYNAMICSCHEMA", injectionKeyDescription="GetTableNames.Injection.DYNAMIC_SCHEMA")
    private boolean dynamicSchema;
    @HopMetadataProperty(key="schemaNameField", injectionKey="SCHEMANAMEFIELD", injectionKeyDescription="GetTableNames.Injection.SCHEMA_NAME_FIELD")
    private String schemaNameField;

    public GetTableNamesMeta() {
    }

    public GetTableNamesMeta(GetTableNamesMeta m) {
        this();
        this.connection = m.connection;
        this.schemaName = m.schemaName;
        this.tableNameFieldName = m.tableNameFieldName;
        this.sqlCreationFieldName = m.sqlCreationFieldName;
        this.objectTypeFieldName = m.objectTypeFieldName;
        this.isSystemObjectFieldName = m.isSystemObjectFieldName;
        this.includeCatalog = m.includeCatalog;
        this.includeSchema = m.includeSchema;
        this.includeTable = m.includeTable;
        this.includeView = m.includeView;
        this.includeProcedure = m.includeProcedure;
        this.includeSynonym = m.includeSynonym;
        this.addSchemaInOutput = m.addSchemaInOutput;
        this.dynamicSchema = m.dynamicSchema;
        this.schemaNameField = m.schemaNameField;
    }

    public GetTableNamesMeta clone() {
        return new GetTableNamesMeta(this);
    }

    public void setDefault() {
        this.connection = null;
        this.schemaName = null;
        this.includeCatalog = false;
        this.includeSchema = false;
        this.includeTable = true;
        this.includeProcedure = true;
        this.includeView = true;
        this.includeSynonym = true;
        this.addSchemaInOutput = false;
        this.tableNameFieldName = "tableName";
        this.sqlCreationFieldName = null;
        this.objectTypeFieldName = "type";
        this.isSystemObjectFieldName = "isSystem";
        this.dynamicSchema = false;
        this.schemaNameField = null;
    }

    public void getFields(IRowMeta r, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) {
        String realSqlCreation;
        String systemObject;
        String realObjectType;
        String realTableName = variables.resolve(this.tableNameFieldName);
        if (StringUtils.isNotEmpty((String)realTableName)) {
            ValueMetaString v = new ValueMetaString(realTableName);
            v.setLength(500);
            v.setPrecision(-1);
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
        if (StringUtils.isNotEmpty((String)(realObjectType = variables.resolve(this.objectTypeFieldName)))) {
            ValueMetaString v = new ValueMetaString(realObjectType);
            v.setLength(500);
            v.setPrecision(-1);
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
        if (StringUtils.isNotEmpty((String)(systemObject = variables.resolve(this.isSystemObjectFieldName)))) {
            ValueMetaBoolean v = new ValueMetaBoolean(systemObject);
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
        if (StringUtils.isNotEmpty((String)(realSqlCreation = variables.resolve(this.sqlCreationFieldName)))) {
            ValueMetaString v = new ValueMetaString(realSqlCreation);
            v.setLength(500);
            v.setPrecision(-1);
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        String errorMessage = "";
        DatabaseMeta databaseMeta = pipelineMeta.findDatabase(this.connection, variables);
        if (databaseMeta == null) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"GetTableNamesMeta.CheckResult.InvalidConnection", (String[])new String[]{variables.resolve(this.connection)}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (Utils.isEmpty((CharSequence)this.tableNameFieldName)) {
            errorMessage = BaseMessages.getString(PKG, (String)"GetTableNamesMeta.CheckResult.TableNameFieldNameMissing", (String[])new String[0]);
            cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            errorMessage = BaseMessages.getString(PKG, (String)"GetTableNamesMeta.CheckResult.TableNameFieldNameOK", (String[])new String[0]);
            cr = new CheckResult(1, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (!(this.isIncludeCatalog() || this.isIncludeSchema() || this.isIncludeTable() || this.isIncludeView() || this.isIncludeProcedure() || this.isIncludeSynonym())) {
            errorMessage = BaseMessages.getString(PKG, (String)"GetTableNamesMeta.CheckResult.IncludeAtLeastOneType", (String[])new String[0]);
            remarks.add((ICheckResult)new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta));
        }
        cr = input.length > 0 && !this.isDynamicSchema() ? new CheckResult(4, BaseMessages.getString(PKG, (String)"GetTableNamesMeta.CheckResult.NoInputReceived", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"GetTableNamesMeta.CheckResult.ReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public String getTableNameFieldName() {
        return this.tableNameFieldName;
    }

    public void setTableNameFieldName(String tablenamefieldname) {
        this.tableNameFieldName = tablenamefieldname;
    }

    public String getSqlCreationFieldName() {
        return this.sqlCreationFieldName;
    }

    public void setSqlCreationFieldName(String sqlcreationfieldname) {
        this.sqlCreationFieldName = sqlcreationfieldname;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaname) {
        this.schemaName = schemaname;
    }

    public void setObjectTypeFieldName(String objecttypefieldname) {
        this.objectTypeFieldName = objecttypefieldname;
    }

    public String getIsSystemObjectFieldName() {
        return this.isSystemObjectFieldName;
    }

    public void setIsSystemObjectFieldName(String isSystemObjectFieldName) {
        this.isSystemObjectFieldName = isSystemObjectFieldName;
    }

    public String getObjectTypeFieldName() {
        return this.objectTypeFieldName;
    }

    public String isSystemObjectFieldName() {
        return this.isSystemObjectFieldName;
    }

    public String getSchemaNameField() {
        return this.schemaNameField;
    }

    public void setSchemaNameField(String schemaNameField) {
        this.schemaNameField = schemaNameField;
    }

    public void setIncludeTable(boolean includetable) {
        this.includeTable = includetable;
    }

    public boolean isIncludeTable() {
        return this.includeTable;
    }

    public void setIncludeSchema(boolean includeSchema) {
        this.includeSchema = includeSchema;
    }

    public boolean isIncludeSchema() {
        return this.includeSchema;
    }

    public void setIncludeCatalog(boolean includeCatalog) {
        this.includeCatalog = includeCatalog;
    }

    public boolean isIncludeCatalog() {
        return this.includeCatalog;
    }

    public void setIncludeView(boolean includeView) {
        this.includeView = includeView;
    }

    public boolean isIncludeView() {
        return this.includeView;
    }

    public void setIncludeProcedure(boolean includeProcedure) {
        this.includeProcedure = includeProcedure;
    }

    public boolean isIncludeProcedure() {
        return this.includeProcedure;
    }

    public void setIncludeSynonym(boolean includeSynonym) {
        this.includeSynonym = includeSynonym;
    }

    public boolean isIncludeSynonym() {
        return this.includeSynonym;
    }

    public void setDynamicSchema(boolean dynamicSchema) {
        this.dynamicSchema = dynamicSchema;
    }

    public boolean isDynamicSchema() {
        return this.dynamicSchema;
    }

    public void setAddSchemaInOutput(boolean addSchemaInOutput) {
        this.addSchemaInOutput = addSchemaInOutput;
    }

    public boolean isAddSchemaInOutput() {
        return this.addSchemaInOutput;
    }
}

