/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.implementation.IdentityClient;
import com.azure.identity.implementation.IdentityClientBuilder;
import com.azure.identity.implementation.IdentityClientOptions;
import com.azure.identity.implementation.IdentitySyncClient;
import com.azure.identity.implementation.util.LoggingUtil;
import reactor.core.publisher.Mono;

public class OnBehalfOfCredential
implements TokenCredential {
    private static final ClientLogger LOGGER = new ClientLogger(OnBehalfOfCredential.class);
    private final IdentityClient identityClient;
    private final IdentitySyncClient identitySyncClient;

    OnBehalfOfCredential(String clientId, String tenantId, String clientSecret, String certificatePath, String certificatePassword, IdentityClientOptions identityClientOptions) {
        IdentityClientBuilder builder = new IdentityClientBuilder().tenantId(tenantId).clientId(clientId).clientSecret(clientSecret).certificatePath(certificatePath).certificatePassword(certificatePassword).identityClientOptions(identityClientOptions);
        this.identitySyncClient = builder.buildSyncClient();
        this.identityClient = builder.build();
    }

    public Mono<AccessToken> getToken(TokenRequestContext request) {
        return Mono.deferContextual(ctx -> this.identityClient.authenticateWithConfidentialClientCache(request).onErrorResume(t -> Mono.empty()).switchIfEmpty(Mono.defer(() -> this.identityClient.authenticateWithOBO(request))).doOnNext(token -> LoggingUtil.logTokenSuccess(LOGGER, request)).doOnError(error -> LoggingUtil.logTokenError(LOGGER, this.identityClient.getIdentityClientOptions(), request, error)));
    }

    public AccessToken getTokenSync(TokenRequestContext request) {
        try {
            AccessToken token = this.identitySyncClient.authenticateWithConfidentialClientCache(request);
            LoggingUtil.logTokenSuccess(LOGGER, request);
            return token;
        }
        catch (Exception token) {
            try {
                AccessToken token2 = this.identitySyncClient.authenticateWithOBO(request);
                LoggingUtil.logTokenSuccess(LOGGER, request);
                return token2;
            }
            catch (Exception e) {
                LoggingUtil.logTokenError(LOGGER, this.identityClient.getIdentityClientOptions(), request, e);
                throw e;
            }
        }
    }
}

