/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data;

import com.clickhouse.data.ClickHouseByteBuffer;
import com.clickhouse.data.ClickHouseCompression;
import com.clickhouse.data.ClickHouseCompressionAlgorithm;
import com.clickhouse.data.ClickHouseDataConfig;
import com.clickhouse.data.ClickHouseDataStreamFactory;
import com.clickhouse.data.ClickHouseDataUpdater;
import com.clickhouse.data.ClickHouseDeferredValue;
import com.clickhouse.data.ClickHouseFile;
import com.clickhouse.data.ClickHouseOutputStream;
import com.clickhouse.data.ClickHousePassThruStream;
import com.clickhouse.data.ClickHouseUtils;
import com.clickhouse.data.ClickHouseWriter;
import com.clickhouse.data.DelegatedInputStream;
import com.clickhouse.data.stream.BlockingInputStream;
import com.clickhouse.data.stream.DeferredInputStream;
import com.clickhouse.data.stream.EmptyInputStream;
import com.clickhouse.data.stream.IterableByteArrayInputStream;
import com.clickhouse.data.stream.IterableByteBufferInputStream;
import com.clickhouse.data.stream.IterableMultipleInputStream;
import com.clickhouse.data.stream.IterableObjectInputStream;
import com.clickhouse.data.stream.RestrictedInputStream;
import com.clickhouse.data.stream.WrappedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;

@Deprecated
public abstract class ClickHouseInputStream
extends InputStream
implements Iterable<ClickHouseByteBuffer> {
    protected static final String ERROR_INCOMPLETE_READ = "Reached end of input stream after reading %d of %d bytes";
    protected static final String ERROR_NULL_BYTES = "Non-null byte array is required";
    protected static final String ERROR_REUSE_BUFFER = "Please pass a different byte array instead of the same internal buffer for reading";
    protected static final String ERROR_STREAM_CLOSED = "Input stream has been closed";
    public static final String TYPE_NAME = "InputStream";
    protected final ClickHouseByteBuffer byteBuffer = ClickHouseByteBuffer.newInstance();
    protected final ClickHousePassThruStream stream;
    protected final Runnable postCloseAction;
    protected final Map<String, Object> userData;
    protected volatile boolean closed;
    protected OutputStream copyTo;

    public static ClickHouseInputStream wrap(ClickHousePassThruStream stream, InputStream input, int bufferSize, ClickHouseCompression compression, int compressionLevel, Runnable postCloseAction) {
        return ClickHouseCompressionAlgorithm.createInputStream(stream, input, bufferSize, compression, compressionLevel, postCloseAction);
    }

    public static ClickHouseInputStream wrap(InputStream input, int bufferSize, long length, Runnable postCloseAction) {
        RestrictedInputStream ris;
        if (input instanceof RestrictedInputStream && (ris = (RestrictedInputStream)input).getRemaining() == length) {
            return ris;
        }
        return new RestrictedInputStream(null, input, bufferSize, length, postCloseAction);
    }

    public static ClickHouseInputStream empty() {
        return EmptyInputStream.INSTANCE;
    }

    public static ClickHouseInputStream of(BlockingQueue<ByteBuffer> queue, int timeout) {
        return ClickHouseInputStream.of(queue, timeout, null);
    }

    public static ClickHouseInputStream of(BlockingQueue<ByteBuffer> queue, int timeout, Runnable postCloseAction) {
        return new BlockingInputStream(queue, timeout, postCloseAction);
    }

    public static ClickHouseInputStream of(ClickHouseDeferredValue<InputStream> deferredInput, int bufferSize, Runnable postCloseAction) {
        return new WrappedInputStream(null, new DeferredInputStream(deferredInput), bufferSize, postCloseAction);
    }

    public static ClickHouseInputStream of(ClickHousePassThruStream stream, int bufferSize, Runnable postCloseAction) {
        if (stream == null || !stream.hasInput()) {
            throw new IllegalArgumentException("Non-null pass-thru stream with input is required");
        }
        return stream.newInputStream(bufferSize, postCloseAction);
    }

    public static ClickHouseInputStream of(ClickHouseWriter writer) {
        return new DelegatedInputStream(null, writer);
    }

    public static ClickHouseInputStream of(ClickHouseDataConfig config, ClickHouseWriter writer) {
        return new DelegatedInputStream(config, writer);
    }

    public static ClickHouseInputStream of(InputStream input) {
        return ClickHouseInputStream.of(input, ClickHouseDataConfig.getDefaultReadBufferSize(), null, -1, null);
    }

    public static ClickHouseInputStream of(InputStream input, int bufferSize) {
        return ClickHouseInputStream.of(input, ClickHouseDataConfig.getBufferSize(bufferSize), null, -1, null);
    }

    public static ClickHouseInputStream of(InputStream input, int bufferSize, Runnable postCloseAction) {
        return ClickHouseInputStream.of(input, bufferSize, ClickHouseCompression.NONE, -1, postCloseAction);
    }

    public static ClickHouseInputStream of(InputStream input, ClickHouseCompression compression) {
        return ClickHouseInputStream.of(input, ClickHouseDataConfig.getDefaultReadBufferSize(), compression, -1, null);
    }

    public static ClickHouseInputStream of(InputStream input, int bufferSize, ClickHouseCompression compression, int compressionLevel, Runnable postCloseAction) {
        if (input == null) {
            return EmptyInputStream.INSTANCE;
        }
        if (input != EmptyInputStream.INSTANCE && input instanceof ClickHouseInputStream) {
            return (ClickHouseInputStream)input;
        }
        return ClickHouseInputStream.wrap(null, input, bufferSize, compression, compressionLevel, postCloseAction);
    }

    public static ClickHouseInputStream of(byte[] ... bytes) {
        if (bytes == null || bytes.length == 0) {
            return EmptyInputStream.INSTANCE;
        }
        return new IterableByteArrayInputStream(Arrays.asList(bytes), null);
    }

    public static ClickHouseInputStream of(ByteBuffer ... buffers) {
        if (buffers == null || buffers.length == 0) {
            return EmptyInputStream.INSTANCE;
        }
        return new IterableByteBufferInputStream(Arrays.asList(buffers), null);
    }

    public static ClickHouseInputStream of(File ... files) {
        if (files == null || files.length == 0) {
            return EmptyInputStream.INSTANCE;
        }
        return ClickHouseInputStream.of(Arrays.asList(files), File.class, null, ClickHouseDataConfig.getDefaultReadBufferSize(), null);
    }

    public static ClickHouseInputStream of(InputStream ... inputs) {
        if (inputs == null || inputs.length == 0) {
            return EmptyInputStream.INSTANCE;
        }
        if (inputs.length == 1) {
            return ClickHouseInputStream.of(inputs[0]);
        }
        return ClickHouseInputStream.of(Arrays.asList(inputs), InputStream.class, null, ClickHouseDataConfig.getDefaultReadBufferSize(), null);
    }

    public static ClickHouseInputStream of(String ... strings) {
        if (strings == null || strings.length == 0) {
            return EmptyInputStream.INSTANCE;
        }
        return ClickHouseInputStream.of(Arrays.asList(strings), String.class, null, ClickHouseDataConfig.getDefaultReadBufferSize(), null);
    }

    public static ClickHouseInputStream of(URL ... urls) {
        if (urls == null || urls.length == 0) {
            return EmptyInputStream.INSTANCE;
        }
        return ClickHouseInputStream.of(Arrays.asList(urls), URL.class, null, ClickHouseDataConfig.getDefaultReadBufferSize(), null);
    }

    public static <T> ClickHouseInputStream of(T[] source, Class<T> clazz, Function<T, byte[]> converter, Runnable postCloseAction) {
        if (source == null || source.length == 0) {
            return EmptyInputStream.INSTANCE;
        }
        return ClickHouseInputStream.of(Arrays.asList(source), clazz, converter, ClickHouseDataConfig.getDefaultReadBufferSize(), postCloseAction);
    }

    public static <T> ClickHouseInputStream of(Iterable<T> source, Class<T> clazz, Function<T, byte[]> converter, Runnable postCloseAction) {
        return ClickHouseInputStream.of(source, clazz, converter, ClickHouseDataConfig.getDefaultReadBufferSize(), postCloseAction);
    }

    public static <T> ClickHouseInputStream of(Iterable<T> source, Class<T> clazz, Function<T, byte[]> converter, int bufferSize, Runnable postCloseAction) {
        if (source == null) {
            return EmptyInputStream.INSTANCE;
        }
        if (converter != null) {
            return new IterableObjectInputStream<T>(source, converter, postCloseAction);
        }
        if (clazz == byte[].class) {
            return new IterableByteArrayInputStream(source, postCloseAction);
        }
        if (clazz == ByteBuffer.class) {
            return new IterableByteBufferInputStream(source, postCloseAction);
        }
        if (clazz == File.class) {
            return new IterableMultipleInputStream<File>(source, f -> {
                if (f == null) {
                    return null;
                }
                try {
                    return new FileInputStream((File)f);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }, bufferSize, postCloseAction);
        }
        if (clazz == String.class) {
            return new IterableObjectInputStream<String>(source, s -> s == null || s.isEmpty() ? ClickHouseByteBuffer.EMPTY_BYTES : s.getBytes(StandardCharsets.UTF_8), postCloseAction);
        }
        if (clazz == URL.class) {
            return new IterableMultipleInputStream<URL>(source, u -> {
                if (u == null) {
                    return null;
                }
                try {
                    return u.openStream();
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }, bufferSize, postCloseAction);
        }
        if (InputStream.class.isAssignableFrom(clazz)) {
            return new IterableMultipleInputStream<InputStream>(source, i -> i, bufferSize, postCloseAction);
        }
        throw new IllegalArgumentException("Missing converter for data type: " + clazz);
    }

    public static long pipe(InputStream input, OutputStream output, int bufferSize) throws IOException {
        if (input instanceof ClickHouseInputStream && output instanceof ClickHouseOutputStream) {
            return ((ClickHouseInputStream)input).pipe((ClickHouseOutputStream)output);
        }
        return ClickHouseInputStream.pipe(input, output, new byte[ClickHouseDataConfig.getBufferSize(bufferSize)]);
    }

    public static long pipe(InputStream input, OutputStream output, byte[] buffer) throws IOException {
        if (buffer == null && input instanceof ClickHouseInputStream && output instanceof ClickHouseOutputStream) {
            return ((ClickHouseInputStream)input).pipe((ClickHouseOutputStream)output);
        }
        if (input == null || output == null || buffer == null || buffer.length < 1) {
            throw new IllegalArgumentException("Non-null input, output, and write buffer are required");
        }
        int size = buffer.length;
        long count = 0L;
        int written = 0;
        try (InputStream in = input;){
            while ((written = in.read(buffer, 0, size)) >= 0) {
                output.write(buffer, 0, written);
                count += (long)written;
            }
        }
        return count;
    }

    public static File save(InputStream input) {
        return ClickHouseInputStream.save(null, input, null);
    }

    public static File save(InputStream input, File file) {
        return ClickHouseInputStream.save(null, input, file);
    }

    public static File save(ClickHouseDataConfig config, InputStream input) {
        return ClickHouseInputStream.save(config, input, null);
    }

    public static File save(ClickHouseDataConfig config, InputStream input, File file) {
        long timeout;
        int bufferSize;
        File tmp;
        if (file != null) {
            tmp = file;
        } else {
            try {
                tmp = ClickHouseUtils.createTempFile();
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to create temp file", e);
            }
        }
        if (config != null) {
            bufferSize = config.getWriteBufferSize();
            timeout = config.getWriteTimeout();
        } else {
            bufferSize = 8192;
            timeout = 30000L;
        }
        if (timeout <= 0L) {
            try {
                try (FileOutputStream out = new FileOutputStream(tmp);){
                    ClickHouseInputStream.pipe(input, (OutputStream)out, bufferSize);
                }
                return tmp;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        CompletableFuture<File> data = ClickHouseDataStreamFactory.getInstance().runBlockingTask(() -> {
            try {
                try (FileOutputStream out = new FileOutputStream(tmp);){
                    ClickHouseInputStream.pipe(input, (OutputStream)out, bufferSize);
                }
                return tmp;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        try {
            return data.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
        catch (TimeoutException e) {
            throw new IllegalStateException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof UncheckedIOException) {
                throw (UncheckedIOException)cause;
            }
            if (cause instanceof IOException) {
                throw new UncheckedIOException((IOException)cause);
            }
            throw new IllegalStateException(cause);
        }
    }

    @Deprecated
    public static File save(InputStream in, int bufferSize, int timeout) {
        return ClickHouseInputStream.save(null, in, bufferSize, timeout, true);
    }

    @Deprecated
    public static File save(File file, InputStream in, int bufferSize, int timeout, boolean deleteOnExit) {
        File tmp;
        if (file != null) {
            tmp = file;
            if (deleteOnExit) {
                tmp.deleteOnExit();
            }
        } else {
            try {
                tmp = ClickHouseUtils.createTempFile("chc", "data", true);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to create temp file", e);
            }
        }
        CompletableFuture<File> data = ClickHouseDataStreamFactory.getInstance().runBlockingTask(() -> {
            try {
                try (FileOutputStream out = new FileOutputStream(tmp);){
                    ClickHouseInputStream.pipe(in, (OutputStream)out, bufferSize);
                }
                return tmp;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        try {
            return data.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
        catch (TimeoutException e) {
            throw new IllegalStateException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof UncheckedIOException) {
                throw (UncheckedIOException)cause;
            }
            if (cause instanceof IOException) {
                throw new UncheckedIOException((IOException)cause);
            }
            throw new IllegalStateException(cause);
        }
    }

    protected ClickHouseInputStream(ClickHousePassThruStream stream, OutputStream copyTo, Runnable postCloseAction) {
        this.stream = stream != null ? stream : ClickHousePassThruStream.NULL;
        this.postCloseAction = postCloseAction;
        this.userData = new HashMap<String, Object>();
        this.closed = false;
        this.copyTo = copyTo;
    }

    protected void closeQuietly() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException(ERROR_STREAM_CLOSED);
        }
    }

    protected abstract ClickHouseByteBuffer getBuffer();

    protected boolean reusableBuffer() {
        return false;
    }

    protected abstract ClickHouseByteBuffer nextBuffer() throws IOException;

    public ClickHouseFile getUnderlyingFile() {
        return ClickHouseFile.of(this.stream);
    }

    public ClickHousePassThruStream getUnderlyingStream() {
        return this.stream;
    }

    public boolean hasUnderlyingStream() {
        return this.stream.hasInput();
    }

    public final Object getUserData(String key) {
        return this.userData.get(key);
    }

    public final <T> T getUserData(String key, T defaultValue) {
        return (T)this.userData.getOrDefault(key, defaultValue);
    }

    public final Object removeUserData(String key) {
        return this.userData.remove(key);
    }

    public final <T> T setUserData(String key, T value) {
        return (T)this.userData.put(key, value);
    }

    public abstract int peek() throws IOException;

    public long pipe(ClickHouseOutputStream output) throws IOException {
        long count = 0L;
        if (output == null || output.isClosed()) {
            return count;
        }
        this.ensureOpen();
        try (ClickHouseInputStream in = this;){
            for (ClickHouseByteBuffer buf : in) {
                count += (long)buf.length();
                output.writeBuffer(buf);
            }
        }
        return count;
    }

    public short readUnsignedByte() throws IOException {
        return (short)(0xFF & this.readByte());
    }

    public ClickHouseByteBuffer readBuffer(int length) throws IOException {
        if (length < 1) {
            return this.byteBuffer.reset();
        }
        return this.byteBuffer.update(this.readBytes(length));
    }

    public abstract ClickHouseByteBuffer readBufferUntil(byte[] var1) throws IOException;

    public boolean readBoolean() throws IOException {
        byte b = this.readByte();
        if (b == 0) {
            return false;
        }
        if (b == 1) {
            return true;
        }
        throw new IOException("Failed to read boolean value, expect 0 (false) or 1 (true) but we got: " + b);
    }

    public abstract byte readByte() throws IOException;

    public byte[] readBytes(int length) throws IOException {
        int read;
        if (length < 1) {
            return ClickHouseByteBuffer.EMPTY_BYTES;
        }
        this.ensureOpen();
        byte[] bytes = new byte[length];
        for (int offset = 0; offset < length; offset += read) {
            read = this.read(bytes, offset, length - offset);
            if (read != -1) continue;
            this.closeQuietly();
            throw offset == 0 ? new EOFException() : new StreamCorruptedException(ClickHouseUtils.format(ERROR_INCOMPLETE_READ, offset, length));
        }
        return bytes;
    }

    public abstract ClickHouseByteBuffer readCustom(ClickHouseDataUpdater var1) throws IOException;

    public String readString(Charset charset) throws IOException {
        return this.readString(this.readVarInt(), charset);
    }

    public String readString(int byteLength, Charset charset) throws IOException {
        if (byteLength < 1) {
            return "";
        }
        return this.readBuffer(byteLength).asString(charset);
    }

    public String readAsciiString() throws IOException {
        return this.readString(this.readVarInt(), StandardCharsets.US_ASCII);
    }

    public String readAsciiString(int byteLength) throws IOException {
        return this.readString(byteLength, StandardCharsets.US_ASCII);
    }

    public String readUnicodeString() throws IOException {
        return this.readString(this.readVarInt(), StandardCharsets.UTF_8);
    }

    public String readUnicodeString(int byteLength) throws IOException {
        return this.readString(byteLength, StandardCharsets.UTF_8);
    }

    public int readVarInt() throws IOException {
        int shift;
        byte b = this.readByte();
        if (b >= 0) {
            return b;
        }
        int result = b & 0x7F;
        for (shift = 7; shift <= 28; shift += 7) {
            b = this.readByte();
            if (b >= 0) {
                result |= b << shift;
                break;
            }
            result |= (b & 0x7F) << shift;
        }
        if (b < 0) {
            for (shift = 35; shift <= 63 && this.peek() >= 0 && this.readByte() < 0; shift += 7) {
            }
        }
        return result;
    }

    public long readVarLong() throws IOException {
        long b = this.readByte();
        if (b >= 0L) {
            return b;
        }
        long result = b & 0x7FL;
        for (int shift = 7; shift <= 63; shift += 7) {
            b = this.readByte();
            if (b >= 0L) {
                result |= b << shift;
                break;
            }
            result |= (b & 0x7FL) << shift;
        }
        return result;
    }

    public final void setCopyToTarget(OutputStream out) throws IOException {
        ClickHouseByteBuffer buf;
        if (this.copyTo != null) {
            this.copyTo.flush();
        } else if (out != null && !(buf = this.getBuffer()).isEmpty()) {
            out.write(buf.array(), buf.position(), buf.length());
        }
        this.copyTo = out;
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.userData.clear();
            this.byteBuffer.reset();
            ClickHouseDataStreamFactory.handleCustomAction(this.postCloseAction);
        }
    }

    @Override
    public Iterator<ClickHouseByteBuffer> iterator() {
        return new ByteBufferIterator(this);
    }

    static class ByteBufferIterator
    implements Iterator<ClickHouseByteBuffer> {
        private final ClickHouseInputStream input;

        private ByteBufferIterator(ClickHouseInputStream input) {
            this.input = input;
        }

        @Override
        public boolean hasNext() {
            try {
                return this.input.available() > 0;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public ClickHouseByteBuffer next() {
            try {
                ClickHouseByteBuffer buffer = this.input.nextBuffer();
                if (buffer.isEmpty() && this.input.available() < 1) {
                    throw new NoSuchElementException("No more byte buffer for read as we reached end of the stream");
                }
                return buffer;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

