/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.output;

import java.util.List;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.ActionTransformType;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.neo4j.core.value.ValueMetaGraph;
import org.apache.hop.neo4j.transforms.output.Neo4JOutput;
import org.apache.hop.neo4j.transforms.output.Neo4JOutputData;
import org.apache.hop.neo4j.transforms.output.fields.LabelField;
import org.apache.hop.neo4j.transforms.output.fields.NodeFromField;
import org.apache.hop.neo4j.transforms.output.fields.NodeToField;
import org.apache.hop.neo4j.transforms.output.fields.PropertyField;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;

@Transform(id="Neo4JOutput", image="neo4j_output.svg", name="i18n::Neo4JOutput.Transform.Name", description="i18n::Neo4JOutput.Transform.Description", categoryDescription="i18n::Neo4JOutput.Transform.Category", keywords={"i18n::Neo4JOutputMeta.keyword"}, documentationUrl="/pipeline/transforms/neo4j-output.html", actionTransformTypes={ActionTransformType.OUTPUT, ActionTransformType.GRAPH})
public class Neo4JOutputMeta
extends BaseTransformMeta<Neo4JOutput, Neo4JOutputData> {
    @HopMetadataProperty(key="connection", injectionKey="CONNECTION")
    private String connection;
    @HopMetadataProperty(key="batch_size", injectionKey="BATCH_SIZE")
    private String batchSize;
    @HopMetadataProperty(key="create_indexes", injectionKey="CREATE_INDEXES")
    private boolean creatingIndexes;
    @HopMetadataProperty(key="use_create", injectionKey="USE_CREATE")
    private boolean usingCreate;
    @HopMetadataProperty(key="only_create_relationships", injectionKey="ONLY_CREATE_RELATIONSHIPS")
    private boolean onlyCreatingRelationships;
    @HopMetadataProperty(key="relprop", injectionKey="", groupKey="relprops", injectionGroupKey="REL_PROPS")
    private List<PropertyField> relProps;
    @HopMetadataProperty(key="returning_graph", injectionKey="RETURNING_GRAPH")
    private boolean returningGraph;
    @HopMetadataProperty(key="return_graph_field", injectionKey="RETURNING_GRAPH_FIELD")
    private String returnGraphField;
    @HopMetadataProperty(key="from", injectionKey="")
    private NodeFromField nodeFromField;
    @HopMetadataProperty(key="to", injectionKey="")
    private NodeToField nodeToField;
    @HopMetadataProperty(key="relationship", injectionKey="RELATIONSHIP")
    private String relationship;
    @HopMetadataProperty(key="relationship_value", injectionKey="RELATIONSHIP_VALUE")
    private String relationshipValue;

    public void setDefault() {
        this.connection = "";
        this.batchSize = "1000";
        this.creatingIndexes = true;
        this.usingCreate = false;
        this.onlyCreatingRelationships = false;
        this.returnGraphField = "graph";
        this.nodeFromField = new NodeFromField();
        this.nodeToField = new NodeToField();
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables space, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (prev == null || prev.isEmpty()) {
            cr = new CheckResult(3, "Not receiving any fields from previous transform!", (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, "Transform is connected to previous one, receiving " + prev.size() + " fields", (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, "Transform is receiving info from other transform.", (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, "No input received from other transform!", (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextStep, IVariables space, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (this.returningGraph) {
            ValueMetaGraph valueMetaGraph = new ValueMetaGraph(Const.NVL((String)this.returnGraphField, (String)"graph"));
            valueMetaGraph.setOrigin(name);
            inputRowMeta.addValueMeta((IValueMeta)valueMetaGraph);
        }
    }

    public Object clone() {
        return super.clone();
    }

    public boolean dynamicFromLabels() {
        return this.dynamicLabels(this.nodeFromField.getLabels());
    }

    public boolean dynamicToLabels() {
        return this.dynamicLabels(this.nodeToField.getLabels());
    }

    protected boolean dynamicLabels(List<LabelField> fieldList) {
        for (LabelField labelField : fieldList) {
            if (!StringUtils.isNotEmpty((String)labelField.getLabel())) continue;
            return true;
        }
        return false;
    }

    public boolean isCreatingRelationships() {
        return StringUtils.isNotEmpty((String)this.relationshipValue) || StringUtils.isNotEmpty((String)this.relationship);
    }

    @Generated
    public String getConnection() {
        return this.connection;
    }

    @Generated
    public String getBatchSize() {
        return this.batchSize;
    }

    @Generated
    public boolean isCreatingIndexes() {
        return this.creatingIndexes;
    }

    @Generated
    public boolean isUsingCreate() {
        return this.usingCreate;
    }

    @Generated
    public boolean isOnlyCreatingRelationships() {
        return this.onlyCreatingRelationships;
    }

    @Generated
    public List<PropertyField> getRelProps() {
        return this.relProps;
    }

    @Generated
    public boolean isReturningGraph() {
        return this.returningGraph;
    }

    @Generated
    public String getReturnGraphField() {
        return this.returnGraphField;
    }

    @Generated
    public NodeFromField getNodeFromField() {
        return this.nodeFromField;
    }

    @Generated
    public NodeToField getNodeToField() {
        return this.nodeToField;
    }

    @Generated
    public String getRelationship() {
        return this.relationship;
    }

    @Generated
    public String getRelationshipValue() {
        return this.relationshipValue;
    }

    @Generated
    public void setConnection(String connection) {
        this.connection = connection;
    }

    @Generated
    public void setBatchSize(String batchSize) {
        this.batchSize = batchSize;
    }

    @Generated
    public void setCreatingIndexes(boolean creatingIndexes) {
        this.creatingIndexes = creatingIndexes;
    }

    @Generated
    public void setUsingCreate(boolean usingCreate) {
        this.usingCreate = usingCreate;
    }

    @Generated
    public void setOnlyCreatingRelationships(boolean onlyCreatingRelationships) {
        this.onlyCreatingRelationships = onlyCreatingRelationships;
    }

    @Generated
    public void setRelProps(List<PropertyField> relProps) {
        this.relProps = relProps;
    }

    @Generated
    public void setReturningGraph(boolean returningGraph) {
        this.returningGraph = returningGraph;
    }

    @Generated
    public void setReturnGraphField(String returnGraphField) {
        this.returnGraphField = returnGraphField;
    }

    @Generated
    public void setNodeFromField(NodeFromField nodeFromField) {
        this.nodeFromField = nodeFromField;
    }

    @Generated
    public void setNodeToField(NodeToField nodeToField) {
        this.nodeToField = nodeToField;
    }

    @Generated
    public void setRelationship(String relationship) {
        this.relationship = relationship;
    }

    @Generated
    public void setRelationshipValue(String relationshipValue) {
        this.relationshipValue = relationshipValue;
    }
}

