/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Database;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionValue;
import org.hsqldb.FunctionSQL;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDDL;
import org.hsqldb.RangeGroup;
import org.hsqldb.Routine;
import org.hsqldb.Scanner;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.StatementCommand;
import org.hsqldb.StatementSession;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.List;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.map.ValuePool;
import org.hsqldb.result.Result;
import org.hsqldb.rights.User;
import org.hsqldb.types.Charset;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class ParserCommand
extends ParserDDL {
    ParserCommand(Session session, Scanner scanner) {
        super(session, scanner);
    }

    Statement compileStatement(int n) {
        Statement statement = this.compilePart(n);
        if (this.token.tokenType == 1014) {
            if (statement.getSchemaName() == null) {
                statement.setSchemaHsqlName(this.session.getCurrentSchemaHsqlName());
            }
            return statement;
        }
        throw this.unexpectedToken();
    }

    HsqlArrayList<Statement> compileStatements(String string, Result result) {
        HsqlArrayList<Statement> hsqlArrayList = new HsqlArrayList<Statement>();
        Statement statement = null;
        this.reset(this.session, string);
        while (this.token.tokenType != 1014) {
            try {
                this.lastError = null;
                statement = this.compilePart(result.getExecuteProperties());
            }
            catch (HsqlException hsqlException) {
                if (this.lastError != null && this.lastError.getLevel() > hsqlException.getLevel()) {
                    throw this.lastError;
                }
                throw hsqlException;
            }
            if (!statement.isExplain && statement.getParametersMetaData().getColumnCount() > 0) {
                throw Error.error(5575);
            }
            statement.setCompileTimestamp(this.database.txManager.getSystemChangeNumber());
            hsqlArrayList.add(statement);
        }
        if (hsqlArrayList.size() > 1 && this.database.sqlRestrictExec) {
            throw Error.error(1252);
        }
        int n = result.getStatementType();
        if (n != 0) {
            int n2 = statement.getGroup();
            if (n2 == 2003) {
                if (n == 1) {
                    throw Error.error(1253);
                }
            } else if (n == 2 && this.database.sqlRestrictExec) {
                throw Error.error(1254);
            }
        }
        return hsqlArrayList;
    }

    private Statement compilePart(int n) {
        Statement statement;
        this.compileContext.reset();
        this.setPartPosition(this.getPosition());
        if (this.token.tokenType == 1015) {
            this.read();
        }
        switch (this.token.tokenType) {
            case 310: 
            case 344: 
            case 390: 
            case 926: {
                statement = this.compileCursorSpecification(RangeGroup.emptyArray, n, false);
                break;
            }
            case 376: {
                RangeGroup[] rangeGroupArray = this.session.sessionContext.sessionVariableRangeGroups;
                this.compileContext.setOuterRanges(rangeGroupArray);
                statement = this.compileShortCursorSpecification(n);
                break;
            }
            case 160: {
                statement = this.compileInsertStatement(RangeGroup.emptyArray);
                break;
            }
            case 371: {
                statement = this.compileUpdateStatement(RangeGroup.emptyArray);
                break;
            }
            case 212: {
                statement = this.compileMergeStatement(RangeGroup.emptyArray);
                break;
            }
            case 96: {
                statement = this.compileDeleteStatement(RangeGroup.emptyArray);
                break;
            }
            case 363: {
                statement = this.compileTruncateStatement();
                break;
            }
            case 781: {
                statement = this.compileInsertStatement(RangeGroup.emptyArray);
                break;
            }
            case 34: {
                statement = this.compileCallStatement(this.session.sessionContext.sessionVariableRangeGroups, false);
                break;
            }
            case 313: {
                statement = this.compileSet();
                break;
            }
            case 141: {
                statement = this.compileGetStatement(this.session.sessionContext.sessionVariableRangeGroups);
                break;
            }
            case 330: {
                statement = this.compileStartTransaction();
                break;
            }
            case 54: {
                statement = this.compileCommit();
                break;
            }
            case 296: {
                statement = this.compileRollback();
                break;
            }
            case 304: {
                statement = this.compileSavepoint();
                break;
            }
            case 288: {
                statement = this.compileReleaseSavepoint();
                break;
            }
            case 69: {
                statement = this.compileCreate();
                break;
            }
            case 6: {
                statement = this.compileAlter();
                break;
            }
            case 105: {
                statement = this.compileDrop();
                break;
            }
            case 143: 
            case 294: {
                statement = this.compileGrantOrRevoke();
                break;
            }
            case 633: {
                statement = this.compileComment();
                break;
            }
            case 721: {
                statement = this.compileLock();
                break;
            }
            case 58: {
                statement = this.compileConnect();
                break;
            }
            case 101: {
                statement = this.compileDisconnect();
                break;
            }
            case 788: {
                statement = this.compileScript(false);
                break;
            }
            case 796: {
                statement = this.compileShutdown();
                break;
            }
            case 610: {
                statement = this.compileBackup();
                break;
            }
            case 628: {
                statement = this.compileCheckpoint();
                break;
            }
            case 680: {
                statement = this.compileExplain();
                break;
            }
            case 93: {
                statement = this.compileDeclare();
                break;
            }
            case 759: {
                statement = this.compilePerform();
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        switch (statement.type) {
            case 14: 
            case 66: 
            case 1093: 
            case 1151: {
                break;
            }
            default: {
                statement.setSQL(this.getLastPart());
            }
        }
        if (this.token.tokenType == 932) {
            this.read();
        } else if (this.token.tokenType == 1014) {
            // empty if block
        }
        return statement;
    }

    private Statement compileDeclare() {
        Statement statement = this.compileDeclareLocalTableOrNull();
        if (statement != null) {
            return statement;
        }
        ColumnSchema[] columnSchemaArray = this.readLocalVariableDeclarationOrNull();
        if (columnSchemaArray != null) {
            Object[] objectArray = new Object[]{columnSchemaArray};
            statement = new StatementSession(1127, objectArray);
            return statement;
        }
        statement = this.compileDeclareCursorOrNull(RangeGroup.emptyArray, false);
        if (statement == null) {
            throw this.lastError == null ? this.unexpectedToken() : this.lastError;
        }
        return statement;
    }

    private Statement compileScript(boolean bl) {
        Object object;
        String string = null;
        int n = 0;
        int n2 = 0;
        Boolean bl2 = Boolean.FALSE;
        HsqlNameManager.HsqlName hsqlName = null;
        TimestampData timestampData = null;
        this.readThis(788);
        if (bl) {
            this.readThis(133);
            this.checkIsAny(646, 344, 0, 0);
            if (this.readIfThis(646)) {
                switch (this.token.tokenType) {
                    case 526: {
                        this.read();
                        n2 = 526;
                        break;
                    }
                    case 383: {
                        this.read();
                        this.readThis(451);
                        if (this.readIfThis(137)) {
                            this.readThis(350);
                            object = this.readQuotedString();
                            timestampData = (TimestampData)Type.SQL_TIMESTAMP.convertToType(this.session, object, Type.SQL_VARCHAR_DEFAULT);
                        } else {
                            timestampData = DateTimeType.epochTimestamp;
                        }
                        n2 = 383;
                        break;
                    }
                    case 451: {
                        this.read();
                        n2 = 451;
                        break;
                    }
                    default: {
                        n2 = 4;
                    }
                }
                if (this.readIfThis(390)) {
                    this.readThis(53);
                    this.readThis(531);
                    bl2 = Boolean.TRUE;
                }
                this.readThis(353);
                n = 646;
            } else if (this.readIfThis(344)) {
                object = this.readTableName();
                if (((Table)object).isView() || ((Table)object).isTemp()) {
                    throw Error.error(5501);
                }
                hsqlName = ((Table)object).getName();
                this.readThis(451);
                if (this.readIfThis(390)) {
                    this.readThis(53);
                    this.readThis(531);
                    bl2 = Boolean.TRUE;
                }
                this.readThis(353);
                n = 344;
                n2 = 451;
            } else {
                throw this.unexpectedToken();
            }
        }
        if (this.token.tokenType == 1011) {
            if (n == 0) {
                n = 646;
                n2 = 4;
            }
            string = this.readQuotedString();
        } else if (n == 0) {
            n = 646;
            n2 = 526;
        } else {
            throw this.unexpectedTokenRequire("PATH");
        }
        object = this.database.schemaManager.getCatalogAndBaseTableNames();
        Object[] objectArray = new Object[]{string, n, n2, bl2, hsqlName, timestampData};
        return new StatementCommand(1004, objectArray, null, (HsqlNameManager.HsqlName[])object);
    }

    private Statement compileConnect() {
        String string = null;
        this.read();
        this.readThis(373);
        this.checkIsSimpleName();
        String string2 = this.token.tokenString;
        this.read();
        if (!this.session.isProcessingLog()) {
            this.readThis(758);
            string = this.readPassword();
        }
        Expression[] expressionArray = new Expression[]{new ExpressionValue(string2, Type.SQL_VARCHAR), new ExpressionValue(string, Type.SQL_VARCHAR)};
        StatementSession statementSession = new StatementSession(this.session, this.compileContext, 81, expressionArray);
        return statementSession;
    }

    private StatementCommand compileSetDefault() {
        this.read();
        switch (this.token.tokenType) {
            case 156: {
                this.read();
                this.readThis(502);
                HsqlNameManager.HsqlName hsqlName = this.database.schemaManager.getSchemaHsqlName(this.token.tokenString);
                this.read();
                Object[] objectArray = new Object[]{hsqlName};
                return new StatementCommand(1034, objectArray);
            }
            case 291: {
                this.read();
                this.readThis(731);
                this.readThis(299);
                Integer n = this.readIntegerObject();
                Object[] objectArray = new Object[]{n};
                return new StatementCommand(1046, objectArray);
            }
            case 344: {
                int n;
                this.read();
                this.readThis(544);
                switch (this.token.tokenType) {
                    case 731: {
                        n = 4;
                        break;
                    }
                    case 626: {
                        n = 5;
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                this.read();
                Object[] objectArray = new Object[]{ValuePool.getInt(n)};
                return new StatementCommand(1035, objectArray);
            }
            case 506: {
                int n;
                this.read();
                this.readThis(516);
                switch (this.token.tokenType) {
                    case 583: {
                        this.read();
                        this.readThis(437);
                        n = 2;
                        break;
                    }
                    case 512: {
                        this.read();
                        n = 8;
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                Object[] objectArray = new Object[]{ValuePool.getInt(n)};
                return new StatementCommand(1053, objectArray);
            }
        }
        throw this.unexpectedToken();
    }

    private StatementCommand compileSetProperty() {
        Object object;
        this.read();
        this.checkIsSimpleName();
        this.checkIsDelimitedIdentifier();
        String string = this.token.tokenString;
        this.read();
        if (this.token.tokenType == 362) {
            object = Boolean.TRUE;
        } else if (this.token.tokenType == 127) {
            object = Boolean.FALSE;
        } else {
            this.checkIsValue();
            object = this.token.tokenValue;
        }
        this.read();
        Object[] objectArray = new Object[]{string, object};
        return new StatementCommand(1039, objectArray);
    }

    private Statement compileSet() {
        this.read();
        switch (this.token.tokenType) {
            case 418: {
                this.read();
                Expression expression = this.XreadValueSpecificationOrNull();
                if (expression == null) {
                    HsqlNameManager.HsqlName hsqlName = this.readSchemaName();
                    Object[] objectArray = new Object[]{hsqlName};
                    return new StatementSession(72, objectArray);
                }
                if (!expression.getDataType().isCharacterType()) {
                    throw Error.error(2200);
                }
                if (!(expression.getType() == 1 || expression.getType() == 28 && ((FunctionSQL)expression).isValueFunction())) {
                    throw Error.error(2200);
                }
                Expression[] expressionArray = new Expression[]{expression};
                return new StatementSession(this.session, this.compileContext, 72, expressionArray);
            }
            case 502: {
                this.read();
                Expression expression = this.XreadValueSpecificationOrNull();
                if (expression == null) {
                    HsqlNameManager.HsqlName hsqlName = this.readSchemaName();
                    Object[] objectArray = new Object[]{hsqlName};
                    return new StatementSession(80, objectArray);
                }
                if (expression.isUnresolvedParam()) {
                    expression.setDataType(this.session, Type.SQL_VARCHAR_DEFAULT);
                }
                if (!expression.getDataType().isCharacterType()) {
                    throw Error.error(2200);
                }
                switch (expression.getType()) {
                    case 1: 
                    case 7: 
                    case 8: {
                        break;
                    }
                    case 28: {
                        if (((FunctionSQL)expression).isValueFunction()) break;
                        throw Error.error(2200);
                    }
                    default: {
                        throw Error.error(2200);
                    }
                }
                Expression[] expressionArray = new Expression[]{expression};
                return new StatementSession(this.session, this.compileContext, 80, expressionArray);
            }
            case 226: {
                Object[] objectArray;
                this.read();
                this.readThis(429);
                HsqlArrayList<Object[]> hsqlArrayList = null;
                if (this.readIfThis(133)) {
                    hsqlArrayList = new HsqlArrayList<Object[]>();
                    while (true) {
                        objectArray = this.readSchemaObjectName(14);
                        hsqlArrayList.add(objectArray);
                        if (this.token.tokenType != 913) break;
                        this.read();
                    }
                }
                objectArray = new Object[]{null, Boolean.FALSE, hsqlArrayList};
                return new StatementSession(83, objectArray);
            }
            case 429: {
                Object[] objectArray;
                this.read();
                Expression expression = this.XreadValueSpecificationOrNull();
                if (expression == null || !expression.getDataType().isCharacterType()) {
                    throw Error.error(4650);
                }
                HsqlArrayList<Object[]> hsqlArrayList = null;
                if (this.readIfThis(133)) {
                    hsqlArrayList = new HsqlArrayList<Object[]>();
                    while (true) {
                        objectArray = this.readSchemaObjectName(14);
                        hsqlArrayList.add(objectArray);
                        if (this.token.tokenType != 913) break;
                        this.read();
                    }
                }
                objectArray = new Object[]{expression, Boolean.TRUE, hsqlArrayList};
                return new StatementSession(83, objectArray);
            }
            case 349: {
                this.read();
                return this.compileSetTimeZone();
            }
            case 594: {
                this.read();
                return this.compileSetRole();
            }
            case 514: {
                this.read();
                return this.compileSessionSettings();
            }
            case 535: {
                this.readAny(583, 506, 0, 0);
                Object[] objectArray = this.processTransactionCharacteristics();
                if (objectArray[0] == null && objectArray[1] == null) {
                    throw this.unexpectedToken();
                }
                return new StatementSession(85, objectArray);
            }
            case 609: {
                return this.compileSetAutoCommit();
            }
            case 769: {
                this.read();
                Boolean bl = this.processTrueOrFalseObject();
                Object[] objectArray = new Object[]{bl};
                return new StatementSession(82, objectArray);
            }
            case 696: {
                this.read();
                Boolean bl = this.processTrueOrFalseObject();
                Object[] objectArray = new Object[]{bl};
                return new StatementSession(1048, objectArray);
            }
            case 727: {
                this.read();
                Integer n = this.readIntegerObject();
                Object[] objectArray = new Object[]{n};
                return new StatementSession(1116, objectArray);
            }
            case 94: {
                int n;
                this.read();
                this.readThis(344);
                this.readThis(544);
                switch (this.token.tokenType) {
                    case 731: {
                        n = 4;
                        break;
                    }
                    case 626: {
                        n = 5;
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                this.read();
                Object[] objectArray = new Object[]{ValuePool.getInt(n)};
                return new StatementCommand(1035, objectArray);
            }
            case 344: {
                return this.compileSetTable();
            }
            case 851: {
                this.read();
                int n = 0;
                if (this.token.tokenType == 362) {
                    n = this.database.getProperties().getDefaultWriteDelay();
                    this.read();
                } else if (this.token.tokenType == 127) {
                    n = 0;
                    this.read();
                } else {
                    n = this.readInteger();
                    if (n < 0) {
                        n = 0;
                    }
                    if (this.token.tokenType == 733) {
                        this.read();
                    } else {
                        n *= 1000;
                    }
                }
                Object[] objectArray = new Object[]{n};
                return new StatementCommand(1033, objectArray, null, null);
            }
            case 758: {
                Boolean bl = Boolean.FALSE;
                this.read();
                if (this.readIfThis(674)) {
                    bl = Boolean.TRUE;
                }
                String string = this.readPassword();
                Object[] objectArray = new Object[]{null, string, bl};
                StatementCommand statementCommand = new StatementCommand(1093, objectArray);
                String string2 = User.getSetCurrentPasswordDigestSQL(this.database.granteeManager, string, bl);
                statementCommand.setSQL(string2);
                return statementCommand;
            }
            case 156: {
                this.read();
                this.readThis(502);
                HsqlNameManager.HsqlName hsqlName = this.token.tokenType == 94 ? null : this.database.schemaManager.getSchemaHsqlName(this.token.tokenString);
                this.read();
                Object[] objectArray = new Object[]{null, hsqlName};
                return new StatementCommand(1092, objectArray);
            }
            case 684: {
                return this.compileSetFilesProperty();
            }
            case 646: {
                return this.compileSetDatabaseProperty();
            }
            case 763: {
                return this.compileSetProperty();
            }
        }
        return this.compileSetStatement(this.session.sessionContext.sessionVariableRangeGroups, this.session.sessionContext.sessionVariablesRange);
    }

    StatementSession compileSetAutoCommit() {
        this.read();
        boolean bl = false;
        int n = -1;
        switch (this.token.tokenType) {
            case 127: 
            case 362: {
                bl = this.processTrueOrFalse();
                break;
            }
            case 18: {
                this.read();
                n = this.readInteger();
                if (n < 0) {
                    throw Error.error(3403);
                }
                this.readThis(299);
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        Object[] objectArray = new Object[]{bl, n};
        return new StatementSession(1114, objectArray);
    }

    StatementCommand compileSetTable() {
        this.read();
        Table table = this.readTableName();
        Object[] objectArray = new Object[]{table.getName(), null, null};
        switch (this.token.tokenType) {
            default: {
                throw this.unexpectedToken();
            }
            case 519: {
                this.read();
                return this.compileTableSource(table);
            }
            case 583: {
                this.read();
                boolean bl = false;
                if (this.token.tokenType == 561) {
                    this.read();
                } else {
                    this.readThis(243);
                    bl = true;
                }
                objectArray[1] = bl;
                return new StatementCommand(1155, objectArray, null, new HsqlNameManager.HsqlName[]{table.getName()});
            }
            case 769: {
                this.read();
                Boolean bl = this.processTrueOrFalseObject();
                objectArray[1] = bl;
                return new StatementCommand(1155, objectArray, null, new HsqlNameManager.HsqlName[]{table.getName()});
            }
            case 697: {
                this.read();
                this.checkIsValue();
                String string = this.token.tokenString;
                this.read();
                objectArray[1] = string;
                objectArray[2] = 5;
                return new StatementCommand(1154, objectArray, null, new HsqlNameManager.HsqlName[]{table.getName()});
            }
            case 544: {
                int n;
                this.read();
                switch (this.token.tokenType) {
                    case 731: {
                        n = 4;
                        break;
                    }
                    case 626: {
                        n = 5;
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                switch (table.getTableType()) {
                    case 4: 
                    case 5: 
                    case 7: {
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                this.read();
                objectArray[1] = n;
                return new StatementCommand(1158, objectArray, null, new HsqlNameManager.HsqlName[]{table.getName()});
            }
            case 632: {
                this.read();
                this.readThis(241);
                OrderedHashSet<String> orderedHashSet = new OrderedHashSet<String>();
                this.readThis(926);
                this.readSimpleColumnNames(orderedHashSet, table, false);
                this.readThis(911);
                int[] nArray = table.getColumnIndexes(orderedHashSet);
                objectArray[1] = nArray;
                return new StatementCommand(1159, objectArray, null, new HsqlNameManager.HsqlName[]{table.getName()});
            }
            case 225: {
                this.read();
                this.readThis(521);
                objectArray = new Object[]{table.getName()};
                HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
                return new StatementCommand(1160, objectArray, null, hsqlNameArray);
            }
            case 521: 
        }
        this.read();
        Integer n = this.readIntegerObject();
        objectArray = new Object[]{table.getName(), n};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementCommand(1161, objectArray, null, hsqlNameArray);
    }

    StatementCommand compileSetDatabaseProperty() {
        this.read();
        this.checkDatabaseUpdateAuthorisation();
        switch (this.token.tokenType) {
            case 608: {
                this.read();
                this.readThis(139);
                Routine routine = this.readCreateDatabaseAuthenticationFunction();
                Object[] objectArray = new Object[]{routine};
                return new StatementCommand(1036, objectArray, null, null);
            }
            case 429: {
                Boolean bl = null;
                this.read();
                this.checkIsSimpleName();
                String string = this.token.tokenString;
                this.read();
                if (this.readIfThis(226)) {
                    this.readThis(556);
                    bl = Boolean.FALSE;
                } else if (this.readIfThis(556)) {
                    this.readThis(521);
                    bl = Boolean.TRUE;
                }
                if (bl == null) {
                    bl = Boolean.TRUE;
                }
                Object[] objectArray = new Object[]{string, bl};
                return new StatementCommand(1047, objectArray, null, null);
            }
            case 94: {
                return this.compileSetDefault();
            }
            case 679: {
                this.read();
                this.readThis(199);
                boolean bl = this.readIfThis(324);
                this.readThis(516);
                Integer n = this.readIntegerObject();
                Object[] objectArray = new Object[]{n, bl, Boolean.TRUE};
                return new StatementCommand(1016, objectArray, null, null);
            }
            case 125: {
                this.read();
                this.readThis(679);
                this.readThis(199);
                this.readThis(516);
                Integer n = this.readIntegerObject();
                Object[] objectArray = new Object[]{n, Boolean.FALSE, Boolean.FALSE};
                return new StatementCommand(1016, objectArray, null, null);
            }
            case 687: {
                this.read();
                Integer n = this.readIntegerObject();
                Object[] objectArray = new Object[]{n};
                return new StatementCommand(1037, objectArray, null, null);
            }
            case 758: {
                this.read();
                switch (this.token.tokenType) {
                    case 46: {
                        this.read();
                        this.readThis(139);
                        Routine routine = this.readCreatePasswordCheckFunction();
                        Object[] objectArray = new Object[]{routine};
                        return new StatementCommand(1040, objectArray, null, null);
                    }
                    case 674: {
                        this.read();
                        String string = this.readQuotedString();
                        Object[] objectArray = new Object[]{string};
                        return new StatementCommand(1057, objectArray, null, null);
                    }
                }
                throw this.unexpectedToken();
            }
            case 770: {
                this.read();
                this.readThis(701);
                boolean bl = this.processTrueOrFalse();
                Object[] objectArray = new Object[]{bl};
                return new StatementCommand(1049, objectArray, null, null);
            }
            case 324: {
                this.read();
                int n = 1050;
                Boolean bl = Boolean.TRUE;
                Integer n2 = 0;
                String string = null;
                switch (this.token.tokenType) {
                    case 22: {
                        this.read();
                        this.readThis(501);
                        n2 = this.readIntegerObject();
                        string = "sql.avg_scale";
                        break;
                    }
                    case 44: {
                        this.read();
                        this.readThis(714);
                        bl = this.processTrueOrFalseObject();
                        string = "sql.char_literal";
                        break;
                    }
                    case 636: {
                        this.read();
                        this.readThis(542);
                        bl = this.processTrueOrFalseObject();
                        string = "sql.concat_nulls";
                        break;
                    }
                    case 61: {
                        this.read();
                        this.readThis(363);
                        bl = this.processTrueOrFalseObject();
                        string = "sql.convert_trunc";
                        break;
                    }
                    case 104: {
                        this.read();
                        this.readThis(742);
                        bl = this.processTrueOrFalseObject();
                        string = "sql.double_nan";
                        break;
                    }
                    case 696: {
                        this.read();
                        bl = this.processTrueOrFalseObject();
                        string = "sql.ignore_case";
                        break;
                    }
                    case 715: {
                        this.read();
                        this.readThis(544);
                        string = "sql.live_object";
                        bl = this.processTrueOrFalseObject();
                        break;
                    }
                    case 726: {
                        this.read();
                        this.readThis(167);
                        this.readThis(718);
                        bl = this.processTrueOrFalseObject();
                        string = "sql.longvar_is_lob";
                        break;
                    }
                    case 202: {
                        this.read();
                        this.readThis(38);
                        this.readThis(694);
                        bl = this.processTrueOrFalseObject();
                        string = "sql.lowercase_ident";
                        break;
                    }
                    case 209: {
                        this.read();
                        this.readThis(275);
                        n2 = this.readIntegerObject();
                        string = "sql.max_recursive";
                        break;
                    }
                    case 531: {
                        this.read();
                        string = "sql.enforce_names";
                        bl = this.processTrueOrFalseObject();
                        break;
                    }
                    case 542: {
                        this.read();
                        if (this.readIfThis(479)) {
                            string = "sql.nulls_first";
                        } else {
                            this.readThis(246);
                            string = "sql.nulls_order";
                        }
                        bl = this.processTrueOrFalseObject();
                        break;
                    }
                    case 779: {
                        this.read();
                        this.readThis(531);
                        string = "sql.regular_names";
                        bl = this.processTrueOrFalseObject();
                        break;
                    }
                    case 277: {
                        this.read();
                        bl = this.processTrueOrFalseObject();
                        string = "sql.enforce_refs";
                        break;
                    }
                    case 588: {
                        this.read();
                        this.readThis(120);
                        string = "sql.restrict_exec";
                        bl = this.processTrueOrFalseObject();
                        break;
                    }
                    case 518: {
                        this.read();
                        bl = this.processTrueOrFalseObject();
                        string = "sql.enforce_size";
                        break;
                    }
                    case 806: {
                        this.read();
                        if (this.token.tokenString.equals("DB2")) {
                            this.read();
                            string = "sql.syntax_db2";
                        } else if (this.token.tokenString.equals("MSS")) {
                            this.read();
                            string = "sql.syntax_mss";
                        } else if (this.token.tokenString.equals("MYS")) {
                            this.read();
                            string = "sql.syntax_mys";
                        } else if (this.token.tokenString.equals("ORA")) {
                            this.read();
                            string = "sql.syntax_ora";
                        } else if (this.token.tokenString.equals("PGS")) {
                            this.read();
                            string = "sql.syntax_pgs";
                        } else {
                            throw this.unexpectedToken();
                        }
                        bl = this.processTrueOrFalseObject();
                        break;
                    }
                    case 807: {
                        this.read();
                        this.readThis(697);
                        this.readThis(531);
                        bl = this.processTrueOrFalseObject();
                        string = "sql.sys_index_names";
                        break;
                    }
                    case 812: {
                        this.read();
                        if (this.readIfThis(96)) {
                            string = "sql.enforce_tdc_delete";
                        } else {
                            this.readThis(371);
                            string = "sql.enforce_tdc_update";
                        }
                        bl = this.processTrueOrFalseObject();
                        break;
                    }
                    case 355: {
                        this.read();
                        this.readThis(836);
                        this.readThis(837);
                        bl = this.processTrueOrFalseObject();
                        string = "jdbc.translate_tti_types";
                        break;
                    }
                    case 363: {
                        this.read();
                        this.readThis(354);
                        bl = this.processTrueOrFalseObject();
                        string = "sql.truncate_trailing";
                        break;
                    }
                    case 837: {
                        this.read();
                        bl = this.processTrueOrFalseObject();
                        string = "sql.enforce_types";
                        break;
                    }
                    case 367: {
                        this.read();
                        this.readThis(542);
                        bl = this.processTrueOrFalseObject();
                        string = "sql.unique_nulls";
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                Object[] objectArray = new Object[]{string, bl, n2};
                return new StatementCommand(n, objectArray, null, null);
            }
            case 814: {
                this.read();
                this.readThis(344);
                this.readThis(454);
                String string = this.readQuotedString();
                Object[] objectArray = new Object[]{string};
                return new StatementCommand(1051, objectArray, null, null);
            }
            case 535: {
                this.read();
                if (this.readIfThis(296)) {
                    this.readThis(241);
                    if (this.readIfThis(702)) {
                        Boolean bl = this.processTrueOrFalseObject();
                        StatementCommand statementCommand = new StatementCommand(1055, new Object[]{bl}, null, null);
                        return statementCommand;
                    }
                    this.readThis(638);
                    Boolean bl = this.processTrueOrFalseObject();
                    StatementCommand statementCommand = new StatementCommand(1054, new Object[]{bl}, null, null);
                    return statementCommand;
                }
                this.readThis(639);
                int n = 0;
                switch (this.token.tokenType) {
                    case 740: {
                        this.read();
                        n = 2;
                        break;
                    }
                    case 741: {
                        this.read();
                        n = 1;
                        break;
                    }
                    case 722: {
                        this.read();
                        n = 0;
                        break;
                    }
                }
                HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames();
                Object[] objectArray = new Object[]{ValuePool.getInt(n)};
                StatementCommand statementCommand = new StatementCommand(1052, objectArray, null, hsqlNameArray);
                return statementCommand;
            }
            case 367: {
                this.read();
                this.readThis(530);
                if (!this.isUndelimitedSimpleName()) {
                    throw this.unexpectedToken();
                }
                String string = this.token.tokenString;
                this.read();
                if (string.length() != 16) {
                    throw Error.error(5555);
                }
                if (!Charset.isInSet(string, Charset.unquotedIdentifier) || !Charset.startsWith(string, Charset.uppercaseLetters)) {
                    throw Error.error(5501);
                }
                Object[] objectArray = new Object[]{string};
                return new StatementCommand(1056, objectArray, null, null);
            }
        }
        throw this.unexpectedToken();
    }

    StatementCommand compileSetFilesProperty() {
        this.read();
        int n = 0;
        Boolean bl = null;
        Object object = null;
        Boolean bl2 = null;
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogNameArray();
        this.checkDatabaseUpdateAuthorisation();
        switch (this.token.tokenType) {
            case 46: {
                this.read();
                long l = this.readBigint();
                long l2 = -1L;
                n = 1014;
                hsqlNameArray = this.database.schemaManager.getCatalogNameArray();
                if (this.readIfThis(913)) {
                    l2 = this.readBigint();
                }
                Object[] objectArray = new Object[]{l, l2};
                return new StatementCommand(n, objectArray, null, hsqlNameArray);
            }
            case 625: {
                this.read();
                if (this.readIfThis(518)) {
                    object = this.readIntegerObject();
                    n = 1013;
                } else {
                    this.readThis(299);
                    object = this.readIntegerObject();
                    n = 1012;
                }
                if (!this.readIfThis(226)) break;
                this.readThis(46);
                bl2 = Boolean.TRUE;
                break;
            }
            case 501: {
                this.read();
                object = this.readIntegerObject();
                n = 1025;
                hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames();
                break;
            }
            case 521: {
                this.read();
                if (this.token.tokenType == 362) {
                    bl = Boolean.TRUE;
                    this.read();
                } else if (this.token.tokenType == 127) {
                    bl = Boolean.FALSE;
                    this.read();
                } else {
                    object = this.readIntegerObject();
                }
                n = 1031;
                hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames();
                break;
            }
            case 718: {
                this.read();
                if (this.readIfThis(501)) {
                    object = this.readIntegerObject();
                    n = 1017;
                } else {
                    this.readThis(635);
                    n = 1018;
                    bl = this.processTrueOrFalseObject();
                }
                hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames();
                break;
            }
            case 670: {
                this.read();
                n = 1015;
                object = this.readIntegerObject();
                break;
            }
            case 749: {
                this.read();
                if (this.readIfThis(518)) {
                    object = this.readIntegerObject();
                } else {
                    bl = this.processTrueOrFalseObject();
                }
                n = 1022;
                break;
            }
            case 610: {
                this.read();
                n = 1011;
                this.readThis(499);
                bl = this.processTrueOrFalseObject();
                break;
            }
            case 199: {
                this.read();
                if (this.readIfThis(518)) {
                    n = 1021;
                    object = this.readIntegerObject();
                    break;
                }
                n = 1020;
                bl = this.processTrueOrFalseObject();
                break;
            }
            case 813: {
                this.read();
                this.readThis(568);
                n = 1032;
                object = this.readQuotedString();
                break;
            }
            case 561: {
                this.read();
                this.readThis(672);
                n = 1033;
                int n2 = 0;
                if (this.token.tokenType == 362) {
                    n2 = this.database.getProperties().getDefaultWriteDelay();
                    this.read();
                } else if (this.token.tokenType == 127) {
                    n2 = 0;
                    this.read();
                } else {
                    n2 = this.readInteger();
                    if (n2 < 0) {
                        n2 = 0;
                    }
                    if (this.token.tokenType == 733) {
                        this.read();
                    } else {
                        n2 *= 1000;
                    }
                }
                object = n2;
                break;
            }
            case 788: {
                this.read();
                this.readThis(482);
                if (this.token.tokenType == 814) {
                    this.read();
                    object = 0;
                } else {
                    this.readThis(635);
                    object = 3;
                }
                n = 1026;
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        Object[] objectArray = new Object[]{bl == null ? object : bl, bl2};
        return new StatementCommand(n, objectArray, null, hsqlNameArray);
    }

    Object[] processTransactionCharacteristics() {
        int n = 0;
        boolean bl = false;
        Object[] objectArray = new Object[2];
        block10: while (true) {
            switch (this.token.tokenType) {
                case 583: {
                    if (objectArray[0] != null) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    if (this.token.tokenType == 243) {
                        this.read();
                        bl = true;
                    } else {
                        this.readThis(561);
                        bl = false;
                    }
                    objectArray[0] = bl;
                    continue block10;
                }
                case 506: {
                    if (objectArray[1] != null) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(516);
                    this.checkIsAny(512, 583, 585, 0);
                    switch (this.token.tokenType) {
                        case 512: {
                            this.read();
                            n = 8;
                            break;
                        }
                        case 583: {
                            this.readAny(437, 546, 0, 0);
                            if (this.token.tokenType == 437) {
                                this.read();
                                n = 2;
                                break;
                            }
                            if (this.token.tokenType == 546) {
                                this.read();
                                n = 1;
                                break;
                            }
                            throw this.unexpectedToken();
                        }
                        case 585: {
                            this.read();
                            this.readThis(583);
                            n = 4;
                            break;
                        }
                        default: {
                            throw this.unexpectedToken();
                        }
                    }
                    objectArray[1] = n;
                    continue block10;
                }
                case 913: {
                    if (objectArray[0] == null && objectArray[1] == null) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    continue block10;
                }
            }
            break;
        }
        return objectArray;
    }

    private Statement compileCommit() {
        boolean bl = false;
        this.read();
        this.readIfThis(560);
        if (this.token.tokenType == 7) {
            this.read();
            if (this.token.tokenType == 226) {
                this.read();
            } else {
                bl = true;
            }
            this.readThis(420);
        }
        String string = bl ? StatementSession.commitAndChainStatement.sql : StatementSession.commitNoChainStatement.sql;
        StatementSession statementSession = new StatementSession(14, new Object[]{bl});
        statementSession.setSQL(string);
        return statementSession;
    }

    private Statement compileStartTransaction() {
        this.read();
        this.readThis(535);
        Object[] objectArray = this.processTransactionCharacteristics();
        StatementSession statementSession = new StatementSession(86, objectArray);
        return statementSession;
    }

    private Statement compileLock() {
        this.read();
        if (this.readIfThis(418)) {
            return this.compileLockCatalog();
        }
        this.readThis(344);
        return this.compileLockTable();
    }

    private Statement compileLockCatalog() {
        boolean bl = this.processTrueOrFalse();
        int n = bl ? 1111 : 1112;
        HsqlNameManager.HsqlName[] hsqlNameArray = bl ? this.database.schemaManager.getCatalogAndBaseTableNames() : null;
        StatementSession statementSession = new StatementSession(n, null, hsqlNameArray);
        return statementSession;
    }

    private Statement compileLockTable() {
        HsqlNameManager.HsqlName[] hsqlNameArray;
        OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet = new OrderedHashSet<HsqlNameManager.HsqlName>();
        OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet2 = new OrderedHashSet<HsqlNameManager.HsqlName>();
        while (true) {
            hsqlNameArray = this.readTableName(true);
            switch (this.token.tokenType) {
                case 583: {
                    this.read();
                    orderedHashSet.add(hsqlNameArray.getName());
                    break;
                }
                case 561: {
                    this.read();
                    orderedHashSet2.add(hsqlNameArray.getName());
                    break;
                }
                default: {
                    throw this.unexpectedToken();
                }
            }
            if (this.token.tokenType != 913) break;
            this.read();
        }
        hsqlNameArray = new HsqlNameManager.HsqlName[orderedHashSet2.size()];
        orderedHashSet2.toArray(hsqlNameArray);
        orderedHashSet.removeAll(hsqlNameArray);
        HsqlNameManager.HsqlName[] hsqlNameArray2 = new HsqlNameManager.HsqlName[orderedHashSet.size()];
        orderedHashSet.toArray(hsqlNameArray2);
        StatementSession statementSession = new StatementSession(1113, hsqlNameArray2, hsqlNameArray);
        return statementSession;
    }

    private Statement compileRollback() {
        boolean bl = false;
        String string = null;
        this.read();
        if (this.token.tokenType == 560) {
            this.read();
        }
        if (this.token.tokenType == 353) {
            this.read();
            this.readThis(304);
            this.checkIsSimpleName();
            string = this.token.tokenString;
            this.read();
            Object[] objectArray = new Object[]{string};
            StatementSession statementSession = new StatementSession(1118, objectArray);
            return statementSession;
        }
        if (this.token.tokenType == 7) {
            this.read();
            if (this.token.tokenType == 226) {
                this.read();
            } else {
                bl = true;
            }
            this.readThis(420);
        }
        String string2 = bl ? StatementSession.rollbackAndChainStatement.sql : StatementSession.rollbackNoChainStatement.sql;
        StatementSession statementSession = new StatementSession(66, new Object[]{bl});
        statementSession.setSQL(string2);
        return statementSession;
    }

    private Statement compileSavepoint() {
        this.read();
        this.checkIsSimpleName();
        String string = this.token.tokenString;
        this.read();
        Object[] objectArray = new Object[]{string};
        return new StatementSession(67, objectArray);
    }

    private Statement compileReleaseSavepoint() {
        this.read();
        this.readThis(304);
        String string = this.token.tokenString;
        this.read();
        Object[] objectArray = new Object[]{string};
        return new StatementSession(61, objectArray);
    }

    private Statement compileSessionSettings() {
        this.checkIsAny(425, 21, 291, 682);
        switch (this.token.tokenType) {
            case 425: {
                this.read();
                this.readThis(14);
                this.readThis(535);
                this.checkIsAny(583, 506, 0, 0);
                Object[] objectArray = this.processTransactionCharacteristics();
                return new StatementSession(82, objectArray);
            }
            case 21: {
                this.read();
                Expression expression = this.XreadValueSpecificationOrNull();
                if (expression == null) {
                    throw Error.error(5584);
                }
                expression.resolveTypes(this.session, null);
                if (expression.isUnresolvedParam()) {
                    expression.dataType = Type.SQL_VARCHAR;
                }
                if (expression.dataType == null || !expression.dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
                Expression[] expressionArray = new Expression[]{expression, null};
                return new StatementSession(this.session, this.compileContext, 81, expressionArray);
            }
            case 291: {
                this.read();
                this.readThis(731);
                this.readThis(299);
                Integer n = this.readIntegerObject();
                Object[] objectArray = new Object[]{n};
                return new StatementSession(1117, objectArray);
            }
            case 682: {
                this.read();
                String string = this.parseSQLFeatureValue();
                Boolean bl = this.processTrueOrFalseObject();
                Object[] objectArray = new Object[]{string, bl};
                return new StatementSession(1115, objectArray);
            }
        }
        throw this.unexpectedToken();
    }

    private Statement compileSetRole() {
        Expression expression;
        if (this.token.tokenType == 227) {
            this.read();
            expression = null;
        } else {
            expression = this.XreadValueSpecificationOrNull();
            if (expression == null) {
                throw Error.error(4100);
            }
        }
        return new StatementSession(this.session, this.compileContext, 79, new Expression[]{expression});
    }

    private Statement compileSetTimeZone() {
        Expression expression;
        this.readThis(563);
        switch (this.token.tokenType) {
            case 196: {
                this.read();
                expression = new ExpressionValue(null, Type.SQL_INTERVAL_HOUR_TO_MINUTE);
                break;
            }
            case 165: {
                expression = this.XreadIntervalValueExpression();
                List<Expression> list = expression.resolveColumnReferences(this.session, RangeGroup.emptyGroup, RangeGroup.emptyArray, null);
                ExpressionColumn.checkColumnsResolved(list);
                expression.resolveTypes(this.session, null);
                if (expression.dataType == null) {
                    throw Error.error(5563);
                }
                if (expression.dataType.typeCode == 111) break;
                throw Error.error(5563);
            }
            default: {
                expression = this.XreadValueExpression();
            }
        }
        return new StatementSession(this.session, this.compileContext, 76, new Expression[]{expression});
    }

    private Statement compileShutdown() {
        this.session.checkAdmin();
        int n = 2;
        this.read();
        switch (this.token.tokenType) {
            case 496: {
                n = 1;
                this.read();
                break;
            }
            case 634: {
                n = 3;
                this.read();
                break;
            }
            case 788: {
                n = 4;
                this.read();
                break;
            }
        }
        if (this.token.tokenType == 932) {
            this.read();
        }
        if (this.token.tokenType != 1014) {
            throw this.unexpectedToken();
        }
        Object[] objectArray = new Object[]{n};
        StatementCommand statementCommand = new StatementCommand(1003, objectArray, null, null);
        return statementCommand;
    }

    private Statement compileBackup() {
        Boolean bl = null;
        Boolean bl2 = null;
        Boolean bl3 = null;
        Boolean bl4 = null;
        this.read();
        this.readThis(646);
        this.readThis(353);
        String string = this.readQuotedString();
        string = string.trim();
        if (string.isEmpty()) {
            throw this.unexpectedToken(string);
        }
        block7: while (true) {
            switch (this.token.tokenType) {
                case 622: {
                    if (bl != null) {
                        throw this.unexpectedToken();
                    }
                    bl = Boolean.TRUE;
                    this.read();
                    continue block7;
                }
                case 788: {
                    if (bl2 != null) {
                        throw this.unexpectedToken();
                    }
                    bl2 = Boolean.TRUE;
                    this.read();
                    continue block7;
                }
                case 635: {
                    if (bl3 != null) {
                        throw this.unexpectedToken();
                    }
                    bl3 = Boolean.TRUE;
                    this.read();
                    continue block7;
                }
                case 229: {
                    this.read();
                    if (this.token.tokenType == 635) {
                        if (bl3 != null) {
                            throw this.unexpectedToken();
                        }
                        bl3 = Boolean.FALSE;
                        this.read();
                        continue block7;
                    }
                    if (this.token.tokenType == 622) {
                        if (bl != null) {
                            throw this.unexpectedToken();
                        }
                        bl = Boolean.FALSE;
                        this.read();
                        continue block7;
                    }
                    throw this.unexpectedToken();
                }
                case 14: {
                    if (bl4 != null) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(684);
                    bl4 = Boolean.TRUE;
                    continue block7;
                }
            }
            break;
        }
        if (bl2 == null) {
            bl2 = Boolean.FALSE;
        }
        if (bl == null) {
            bl = Boolean.TRUE;
        }
        if (bl3 == null) {
            bl3 = Boolean.TRUE;
        }
        if (bl4 == null) {
            bl4 = Boolean.FALSE;
        }
        if (bl2.booleanValue() && !bl.booleanValue()) {
            throw this.unexpectedToken("NOT");
        }
        HsqlNameManager.HsqlName[] hsqlNameArray = bl != false ? this.database.schemaManager.getCatalogAndBaseTableNames() : HsqlNameManager.HsqlName.emptyArray;
        Object[] objectArray = new Object[]{string, bl, bl2, bl3, bl4};
        StatementCommand statementCommand = new StatementCommand(1001, objectArray, null, hsqlNameArray);
        return statementCommand;
    }

    private Statement compilePerform() {
        this.readAny(46, 681, 153, 0);
        switch (this.token.tokenType) {
            case 46: {
                return this.compileCheck();
            }
            case 153: {
                this.readAny(788, 451, 0, 0);
                if (this.token.tokenType == 788) {
                    return this.compileImportScript();
                }
                return this.compileImportData();
            }
            case 681: {
                this.readAny(788, 451, 0, 0);
                if (this.token.tokenType == 788) {
                    return this.compileScript(true);
                }
                return this.compileExportData();
            }
        }
        throw this.unexpectedToken();
    }

    private Statement compileCheck() {
        this.readAny(4, 344, 0, 0);
        boolean bl = false;
        HsqlNameManager.HsqlName hsqlName = null;
        Integer n = 3;
        Integer n2 = -1;
        switch (this.token.tokenType) {
            case 4: {
                this.read();
                bl = true;
            }
            case 344: {
                this.readThis(344);
                if (bl) {
                    this.readThis(697);
                    break;
                }
                hsqlName = this.readTableName().getName();
                this.readThis(697);
            }
        }
        if (this.readIfThis(7)) {
            this.readThis("FIX");
            n = 8;
        }
        Object[] objectArray = new Object[]{hsqlName, n, n2};
        HsqlNameManager.HsqlName[] hsqlNameArray = bl ? this.database.schemaManager.getCatalogAndBaseTableNames() : this.database.schemaManager.getCatalogAndBaseTableNames(hsqlName);
        return new StatementCommand(1006, objectArray, null, hsqlNameArray);
    }

    private Statement compileExportData() {
        this.readThis(451);
        this.readThis(137);
        this.readThis(344);
        HsqlNameManager.HsqlName hsqlName = this.readTableName().getName();
        this.readThis(353);
        String string = this.readQuotedString();
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames();
        Object[] objectArray = new Object[]{hsqlName, string};
        return new StatementCommand(910, objectArray, null, hsqlNameArray);
    }

    private Statement compileImportScript() {
        int n = 2;
        Boolean bl = Boolean.FALSE;
        this.readThis(788);
        this.checkIsAny(383, 451, 0, 0);
        if (this.token.tokenType == 383) {
            this.readThis(383);
            bl = Boolean.TRUE;
        }
        this.readThis(451);
        this.readThis(137);
        String string = this.readQuotedString();
        if (!bl.booleanValue()) {
            n = this.readLoadMode();
        }
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames();
        Object[] objectArray = new Object[]{string, n, bl};
        return new StatementCommand(1005, objectArray, null, hsqlNameArray);
    }

    private Statement compileImportData() {
        this.readThis(451);
        this.readThis(166);
        this.readThis(344);
        HsqlNameManager.HsqlName hsqlName = this.readTableName().getName();
        this.readThis(137);
        String string = this.readQuotedString();
        int n = this.readLoadMode();
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames();
        Object[] objectArray = new Object[]{hsqlName, string, n};
        return new StatementCommand(909, objectArray, null, hsqlNameArray);
    }

    private int readLoadMode() {
        int n = -1;
        this.checkIsAny(448, 802, 46, 0);
        switch (this.token.tokenType) {
            case 448: {
                n = 2;
                this.read();
                break;
            }
            case 802: {
                n = 1;
                this.read();
                break;
            }
            case 46: {
                n = 4;
                this.read();
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        this.readThis(241);
        this.readThis(472);
        return n;
    }

    private Statement compileCheckpoint() {
        boolean bl = false;
        this.read();
        if (this.token.tokenType == 670) {
            bl = true;
            this.read();
        } else if (this.token.tokenType == 932) {
            this.read();
        }
        if (this.token.tokenType != 1014) {
            throw this.unexpectedToken();
        }
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames();
        Object[] objectArray = new Object[]{bl};
        StatementCommand statementCommand = new StatementCommand(1002, objectArray, null, hsqlNameArray);
        return statementCommand;
    }

    public static Statement getAutoCheckpointStatement(Database database) {
        HsqlNameManager.HsqlName[] hsqlNameArray = database.schemaManager.getCatalogAndBaseTableNames();
        Object[] objectArray = new Object[]{Boolean.FALSE};
        StatementCommand statementCommand = new StatementCommand(1002, objectArray, null, hsqlNameArray);
        statementCommand.setCompileTimestamp(database.txManager.getSystemChangeNumber());
        statementCommand.setSQL("CHECKPOINT");
        return statementCommand;
    }

    private Statement compileDisconnect() {
        this.read();
        String string = "DISCONNECT";
        StatementSession statementSession = new StatementSession(22, null);
        return statementSession;
    }

    private Statement compileExplain() {
        int n = this.getPosition();
        this.readAny(572, 277, 0, 0);
        Statement statement = this.token.tokenType == 572 ? this.compileExplainPlan() : this.compileExplainReferences();
        statement.setSQL(this.getLastPart(n));
        return statement;
    }

    private Statement compileExplainPlan() {
        this.readThis(572);
        this.readThis(133);
        Statement statement = this.compilePart(0);
        statement.setDescribe();
        return new StatementCommand(1151, new Object[]{statement});
    }

    private Statement compileExplainReferences() {
        int n;
        boolean bl = false;
        this.readAny(353, 137, 0, 0);
        if (!this.readIfThis(353)) {
            this.readThis(137);
            bl = true;
        }
        switch (this.token.tokenType) {
            case 344: 
            case 559: {
                this.read();
                n = 3;
                break;
            }
            case 322: {
                this.read();
                this.readThis(595);
                n = 24;
                break;
            }
            case 466: 
            case 544: {
                this.read();
                n = 13;
                break;
            }
            case 511: {
                this.read();
                n = 7;
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        SchemaObject schemaObject = this.readSchemaObjectName(n);
        HsqlNameManager.HsqlName hsqlName = schemaObject.getName();
        if (schemaObject instanceof Routine) {
            hsqlName = ((Routine)schemaObject).getSpecificName();
        }
        return new StatementCommand(1150, new Object[]{hsqlName, bl});
    }

    private StatementCommand compileTableSource(Table table) {
        String string;
        boolean bl = false;
        boolean bl2 = false;
        Object[] objectArray = new Object[5];
        objectArray[0] = table.getName();
        if (!table.isText()) {
            throw Error.error(321);
        }
        if (this.token.tokenType == 241) {
            this.read();
            String string2 = this.getLastPart();
            objectArray[1] = Boolean.TRUE;
            return new StatementCommand(1156, objectArray, null, new HsqlNameManager.HsqlName[]{table.getName()});
        }
        if (this.token.tokenType == 757) {
            this.read();
            String string3 = this.getLastPart();
            objectArray[1] = Boolean.FALSE;
            return new StatementCommand(1156, objectArray, null, new HsqlNameManager.HsqlName[]{table.getName()});
        }
        if (this.token.tokenType == 691) {
            this.read();
            bl = true;
        }
        if (this.token.tokenType == 1013) {
            string = this.token.tokenString;
            this.read();
        } else {
            string = this.readQuotedString();
        }
        if (!bl && this.token.tokenType == 462) {
            bl2 = true;
            this.read();
        }
        String string4 = this.getLastPart();
        objectArray[2] = string;
        objectArray[3] = bl2;
        objectArray[4] = bl;
        int n = bl ? 1157 : 1156;
        return new StatementCommand(n, objectArray, null, new HsqlNameManager.HsqlName[]{table.getName()});
    }
}

