/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.vfs.minio;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileNameParser;
import org.apache.commons.vfs2.provider.FileNameParser;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.VfsComponentContext;
import org.apache.hop.vfs.minio.MinioFileName;

public class MinioFileNameParser
extends AbstractFileNameParser {
    private static final MinioFileNameParser INSTANCE = new MinioFileNameParser();

    public static FileNameParser getInstance() {
        return INSTANCE;
    }

    public FileName parseUri(VfsComponentContext context, FileName base, String uri) throws FileSystemException {
        StringBuilder name = new StringBuilder();
        String scheme = UriParser.extractScheme((String)uri, (StringBuilder)name);
        UriParser.canonicalizePath((StringBuilder)name, (int)0, (int)name.length(), (FileNameParser)this);
        UriParser.fixSeparators((StringBuilder)name);
        FileType fileType = UriParser.normalisePath((StringBuilder)name);
        String fullPath = name.toString();
        String bucketName = UriParser.extractFirstElement((StringBuilder)name);
        return new MinioFileName(scheme, bucketName, fullPath, fileType);
    }
}

