/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras;

import java.util.ArrayList;
import org.apache.directory.api.ldap.codec.StockCodecFactoryUtil;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.extras.ExtrasCodecFactoryUtil;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ExtrasBundleActivator
implements BundleActivator {
    private ServiceTracker<LdapApiService, LdapApiService> serviceTracker;

    public void start(BundleContext context) throws Exception {
        LdapApiServiceTracker ldapApiServiceTracker = new LdapApiServiceTracker(context);
        this.serviceTracker = new ServiceTracker(context, LdapApiService.class, (ServiceTrackerCustomizer)ldapApiServiceTracker);
        this.serviceTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        this.serviceTracker.close();
    }

    class LdapApiServiceTracker
    implements ServiceTrackerCustomizer<LdapApiService, LdapApiService> {
        private BundleContext context;

        LdapApiServiceTracker(BundleContext context) {
            this.context = context;
        }

        public LdapApiService addingService(ServiceReference<LdapApiService> reference) {
            LdapApiService ldapApiService = (LdapApiService)this.context.getService(reference);
            StockCodecFactoryUtil.loadStockControls((LdapApiService)ldapApiService);
            ExtrasCodecFactoryUtil.loadExtrasControls(ldapApiService);
            ExtrasCodecFactoryUtil.loadExtrasExtendedOperations(ldapApiService);
            ExtrasCodecFactoryUtil.loadExtrasIntermediateResponses(ldapApiService);
            return ldapApiService;
        }

        public void modifiedService(ServiceReference<LdapApiService> reference, LdapApiService ldapApiService) {
        }

        public void removedService(ServiceReference<LdapApiService> reference, LdapApiService ldapApiService) {
            for (String oid : new ArrayList(ldapApiService.getRequestControlFactories().keySet())) {
                ldapApiService.unregisterRequestControl(oid);
            }
            for (String oid : new ArrayList(ldapApiService.getResponseControlFactories().keySet())) {
                ldapApiService.unregisterResponseControl(oid);
            }
            for (String oid : new ArrayList(ldapApiService.getExtendedRequestFactories().keySet())) {
                ldapApiService.unregisterExtendedRequest(oid);
            }
            for (String oid : new ArrayList(ldapApiService.getExtendedResponseFactories().keySet())) {
                ldapApiService.unregisterExtendedResponse(oid);
            }
            for (String oid : new ArrayList(ldapApiService.getIntermediateResponseFactories().keySet())) {
                ldapApiService.unregisterIntermediateResponse(oid);
            }
        }
    }
}

