/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.request;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.cursor.CursorClosedException;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapOperationException;
import org.apache.directory.api.ldap.model.exception.LdapURLEncodingException;
import org.apache.directory.api.ldap.model.exception.OperationAbandonedException;
import org.apache.directory.api.ldap.model.filter.EqualityNode;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.filter.OrNode;
import org.apache.directory.api.ldap.model.filter.PresenceNode;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.LdapResult;
import org.apache.directory.api.ldap.model.message.MessageTypeEnum;
import org.apache.directory.api.ldap.model.message.Referral;
import org.apache.directory.api.ldap.model.message.ReferralImpl;
import org.apache.directory.api.ldap.model.message.Response;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.ResultResponseRequest;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.directory.api.ldap.model.message.SearchResultDone;
import org.apache.directory.api.ldap.model.message.SearchResultEntryImpl;
import org.apache.directory.api.ldap.model.message.SearchResultReferenceImpl;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.message.controls.PagedResults;
import org.apache.directory.api.ldap.model.message.controls.PagedResultsImpl;
import org.apache.directory.api.ldap.model.message.controls.PersistentSearch;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.url.LdapUrl;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.ReferralManager;
import org.apache.directory.server.core.api.entry.ClonedServerEntry;
import org.apache.directory.server.core.api.event.EventType;
import org.apache.directory.server.core.api.event.NotificationCriteria;
import org.apache.directory.server.core.api.partition.PartitionNexus;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.LdapRequestHandler;
import org.apache.directory.server.ldap.handlers.PersistentSearchListener;
import org.apache.directory.server.ldap.handlers.SearchAbandonListener;
import org.apache.directory.server.ldap.handlers.SearchTimeLimitingMonitor;
import org.apache.directory.server.ldap.handlers.controls.PagedSearchContext;
import org.apache.directory.server.ldap.replication.provider.ReplicationRequestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchRequestHandler
extends LdapRequestHandler<SearchRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(SearchRequestHandler.class);
    private static final Logger SEARCH_TIME_LOG = LoggerFactory.getLogger("org.apache.directory.server.ldap.handlers.request.SEARCH_TIME_LOG");
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    protected ReplicationRequestHandler replicationReqHandler;

    private EqualityNode<String> newIsReferralEqualityNode(LdapSession session) throws Exception {
        AttributeType objectClassAT = session.getCoreSession().getDirectoryService().getAtProvider().getObjectClass();
        return new EqualityNode<String>(objectClassAT, new Value(objectClassAT, "referral"));
    }

    private void handlePersistentSearch(LdapSession session, SearchRequest req, PersistentSearch psearch) throws Exception {
        SearchResultDone done;
        if (!psearch.isChangesOnly() && (done = this.doSimpleSearch(session, req)).getLdapResult().getResultCode() != ResultCodeEnum.SUCCESS) {
            session.getIoSession().write(done);
            return;
        }
        if (req.isAbandoned()) {
            return;
        }
        PersistentSearchListener persistentSearchListener = new PersistentSearchListener(session, req);
        NotificationCriteria criteria = new NotificationCriteria(session.getCoreSession().getDirectoryService().getSchemaManager());
        criteria.setAliasDerefMode(req.getDerefAliases());
        criteria.setBase(req.getBase());
        criteria.setFilter(req.getFilter());
        criteria.setScope(req.getScope());
        criteria.setEventMask(EventType.getEventTypes(psearch.getChangeTypes()));
        this.getLdapServer().getDirectoryService().getEventService().addListener(persistentSearchListener, criteria);
        req.addAbandonListener(new SearchAbandonListener(this.ldapServer, persistentSearchListener));
    }

    @Override
    public final void handle(LdapSession session, SearchRequest req) throws Exception {
        if (IS_DEBUG) {
            LOG.debug("Handling single reply request: {}", (Object)req);
        }
        if (req.getControls().containsKey("1.3.6.1.4.1.4203.1.9.1.1")) {
            this.handleReplication(session, req);
        } else if (req.getControls().containsKey("2.16.840.1.113730.3.4.2")) {
            LOG.debug("ManageDsaITControl detected.");
            this.handleIgnoringReferrals(session, req);
        } else {
            LOG.debug("ManageDsaITControl NOT detected.");
            if (req.getType() == MessageTypeEnum.SEARCH_REQUEST) {
                this.handleWithReferrals(session, req);
            } else {
                throw new IllegalStateException(I18n.err(I18n.ERR_685, req));
            }
        }
    }

    private void handleReplication(LdapSession session, SearchRequest searchRequest) throws LdapException {
        SearchResultDone done = (SearchResultDone)searchRequest.getResultResponse();
        if (this.replicationReqHandler != null) {
            this.replicationReqHandler.handleSyncRequest(session, searchRequest);
        } else {
            LOG.warn("This server does not allow replication");
            LdapResult result = done.getLdapResult();
            result.setDiagnosticMessage("Replication is not allowed on this server");
            result.setResultCode(ResultCodeEnum.OTHER);
            session.getIoSession().write(done);
        }
    }

    private void handleLookup(LdapSession session, SearchRequest req) throws Exception {
        Map<String, Control> controlMap = req.getControls();
        Control[] controls = null;
        if (controlMap != null) {
            Collection<Control> controlValues = controlMap.values();
            controls = new Control[controlValues.size()];
            int pos = 0;
            for (Control control : controlMap.values()) {
                controls[pos++] = control;
            }
        }
        Entry entry = session.getCoreSession().lookup(req.getBase(), controls, req.getAttributes().toArray(new String[0]));
        session.getIoSession().write(this.generateResponse(session, req, entry));
        session.getIoSession().write(req.getResultResponse());
    }

    private void setTimeLimitsOnCursor(SearchRequest req, LdapSession session, Cursor<Entry> cursor) {
        if (session.getCoreSession().isAnAdministrator() && req.getTimeLimit() == 0) {
            return;
        }
        if (this.ldapServer.getMaxTimeLimit() == 0 && req.getTimeLimit() == 0) {
            return;
        }
        if (req.getTimeLimit() == 0) {
            cursor.setClosureMonitor(new SearchTimeLimitingMonitor(this.ldapServer.getMaxTimeLimit(), TimeUnit.SECONDS));
            return;
        }
        if (this.ldapServer.getMaxTimeLimit() >= req.getTimeLimit()) {
            cursor.setClosureMonitor(new SearchTimeLimitingMonitor(req.getTimeLimit(), TimeUnit.SECONDS));
            return;
        }
        cursor.setClosureMonitor(new SearchTimeLimitingMonitor(this.ldapServer.getMaxTimeLimit(), TimeUnit.SECONDS));
    }

    private long getServerSizeLimit(LdapSession session, SearchRequest request) {
        if (session.getCoreSession().isAnAdministrator()) {
            if (request.getSizeLimit() == 0L) {
                return Long.MAX_VALUE;
            }
            return request.getSizeLimit();
        }
        if (this.ldapServer.getMaxSizeLimit() == 0L) {
            return Long.MAX_VALUE;
        }
        return this.ldapServer.getMaxSizeLimit();
    }

    private void writeResults(LdapSession session, SearchRequest req, LdapResult ldapResult, Cursor<Entry> cursor, long sizeLimit) throws Exception {
        long count;
        for (count = 0L; count < sizeLimit && cursor.next(); ++count) {
            if (session.getIoSession().isClosing()) {
                if (!IS_DEBUG) break;
                LOG.debug("Request terminated for message {}, the client has closed the session", (Object)req.getMessageId());
                break;
            }
            if (req.isAbandoned()) {
                cursor.close(new OperationAbandonedException());
                if (!IS_DEBUG) break;
                LOG.debug("Request terminated by an AbandonRequest for message {}", (Object)req.getMessageId());
                break;
            }
            Entry entry = cursor.get();
            session.getIoSession().write(this.generateResponse(session, req, entry));
            if (!IS_DEBUG) continue;
            LOG.debug("Sending {}", (Object)entry.getDn());
        }
        if (ldapResult.getResultCode() == null) {
            ldapResult.setResultCode(ResultCodeEnum.SUCCESS);
        }
        if (count >= sizeLimit && cursor.next()) {
            cursor.previous();
            ldapResult.setResultCode(ResultCodeEnum.SIZE_LIMIT_EXCEEDED);
        }
    }

    private void readPagedResults(LdapSession session, SearchRequest req, LdapResult ldapResult, Cursor<Entry> cursor, long sizeLimit, int pagedLimit, PagedSearchContext pagedContext, PagedResults pagedResultsControl) throws Exception {
        int pageCount;
        req.addAbandonListener(new SearchAbandonListener(this.ldapServer, cursor));
        this.setTimeLimitsOnCursor(req, session, cursor);
        if (IS_DEBUG) {
            LOG.debug("using <{},{}> for size limit", (Object)sizeLimit, (Object)pagedLimit);
        }
        int cookieValue = 0;
        int count = pagedContext.getCurrentPosition();
        for (pageCount = 0; (long)count < sizeLimit && pageCount < pagedLimit && cursor.next() && !session.getIoSession().isClosing(); ++pageCount) {
            Entry entry = cursor.get();
            session.getIoSession().write(this.generateResponse(session, req, entry));
            ++count;
        }
        ldapResult.setResultCode(ResultCodeEnum.SUCCESS);
        boolean hasMoreEntry = cursor.next();
        if (hasMoreEntry) {
            cursor.previous();
        }
        if (!hasMoreEntry) {
            cookieValue = pagedContext.getCookieValue();
            PagedSearchContext psCookie = session.removePagedSearchContext(cookieValue);
            if (psCookie != null && (cursor = psCookie.getCursor()) != null) {
                cursor.close();
            }
            pagedResultsControl = new PagedResultsImpl();
            pagedResultsControl.setCritical(true);
            pagedResultsControl.setSize(0);
            req.getResultResponse().addControl(pagedResultsControl);
        } else if ((long)count < sizeLimit) {
            ldapResult.setResultCode(ResultCodeEnum.SUCCESS);
            req.getResultResponse().addControl(pagedResultsControl);
            pagedContext.incrementCurrentPosition(pageCount);
        } else {
            ldapResult.setResultCode(ResultCodeEnum.SIZE_LIMIT_EXCEEDED);
            cursor.close();
            session.removePagedSearchContext(cookieValue);
        }
    }

    private SearchResultDone abandonPagedSearch(LdapSession session, SearchRequest req) throws Exception {
        PagedResults pagedSearchControl = (PagedResults)req.getControls().get("1.2.840.113556.1.4.319");
        byte[] cookie = pagedSearchControl.getCookie();
        if (!Strings.isEmpty(cookie)) {
            int cookieValue = pagedSearchControl.getCookieValue();
            PagedSearchContext psCookie = session.removePagedSearchContext(cookieValue);
            pagedSearchControl.setCookie(psCookie.getCookie());
            pagedSearchControl.setSize(0);
            pagedSearchControl.setCritical(true);
            Cursor<Entry> cursor = psCookie.getCursor();
            if (cursor != null) {
                cursor.close();
            }
        } else {
            pagedSearchControl.setSize(0);
            pagedSearchControl.setCritical(true);
        }
        LdapResult ldapResult = req.getResultResponse().getLdapResult();
        ldapResult.setResultCode(ResultCodeEnum.SUCCESS);
        req.getResultResponse().addControl(pagedSearchControl);
        return (SearchResultDone)req.getResultResponse();
    }

    private PagedSearchContext removeContext(LdapSession session, PagedSearchContext cookieInstance) {
        if (cookieInstance == null) {
            return null;
        }
        int cookieValue = cookieInstance.getCookieValue();
        return session.removePagedSearchContext(cookieValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SearchResultDone doPagedSearch(LdapSession session, SearchRequest req, PagedResults control) throws Exception {
        block20: {
            PagedResults pagedSearchControl = control;
            PagedResultsImpl pagedResultsControl = null;
            long serverLimit = this.getServerSizeLimit(session, req);
            long requestLimit = req.getSizeLimit() == 0L ? Long.MAX_VALUE : req.getSizeLimit();
            long sizeLimit = Math.min(serverLimit, requestLimit);
            int pagedLimit = pagedSearchControl.getSize();
            Cursor<Entry> cursor = null;
            PagedSearchContext pagedContext = null;
            if ((long)pagedLimit == 0L) {
                return this.abandonPagedSearch(session, req);
            }
            byte[] cookie = pagedSearchControl.getCookie();
            LdapResult ldapResult = req.getResultResponse().getLdapResult();
            if (Strings.isEmpty(cookie)) {
                cursor = session.getCoreSession().search(req);
                cursor.beforeFirst();
                if ((long)pagedLimit > sizeLimit) {
                    try {
                        this.writeResults(session, req, ldapResult, cursor, sizeLimit);
                    }
                    finally {
                        try {
                            cursor.close();
                        }
                        catch (Exception e) {
                            LOG.error(I18n.err(I18n.ERR_168, new Object[0]), e);
                        }
                    }
                    this.removeContext(session, pagedContext);
                    return (SearchResultDone)req.getResultResponse();
                }
                pagedContext = new PagedSearchContext(req);
                session.addPagedSearchContext(pagedContext);
                cookie = pagedContext.getCookie();
                pagedResultsControl = new PagedResultsImpl();
                pagedResultsControl.setCookie(cookie);
                pagedResultsControl.setSize(0);
                pagedResultsControl.setCritical(true);
                pagedContext.setCursor(cursor);
            } else {
                int cookieValue = pagedSearchControl.getCookieValue();
                pagedContext = session.getPagedSearchContext(cookieValue);
                if (pagedContext == null) {
                    ldapResult.setDiagnosticMessage("Invalid cookie for this PagedSearch request.");
                    ldapResult.setResultCode(ResultCodeEnum.UNWILLING_TO_PERFORM);
                    return (SearchResultDone)req.getResultResponse();
                }
                if (pagedContext.hasSameRequest(req, session)) {
                    cursor = pagedContext.getCursor();
                    cookie = pagedContext.getCookie();
                    pagedResultsControl = new PagedResultsImpl();
                    pagedResultsControl.setCookie(cookie);
                    pagedResultsControl.setSize(0);
                    pagedResultsControl.setCritical(true);
                } else {
                    cursor = pagedContext.getCursor();
                    if (cursor != null) {
                        cursor.close();
                    }
                    pagedContext = new PagedSearchContext(req);
                    session.addPagedSearchContext(pagedContext);
                    cookie = pagedContext.getCookie();
                    pagedResultsControl = new PagedResultsImpl();
                    pagedResultsControl.setCookie(cookie);
                    pagedResultsControl.setSize(0);
                    pagedResultsControl.setCritical(true);
                }
            }
            try {
                this.readPagedResults(session, req, ldapResult, cursor, sizeLimit, pagedLimit, pagedContext, pagedResultsControl);
            }
            catch (Exception e) {
                if (cursor == null) break block20;
                try {
                    cursor.close();
                }
                catch (Exception ne) {
                    LOG.error(I18n.err(I18n.ERR_168, new Object[0]), ne);
                }
            }
        }
        return (SearchResultDone)req.getResultResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SearchResultDone doSimpleSearch(LdapSession session, SearchRequest req) throws Exception {
        LdapResult ldapResult = req.getResultResponse().getLdapResult();
        Control control = req.getControls().get("1.2.840.113556.1.4.319");
        if (control != null) {
            return this.doPagedSearch(session, req, (PagedResults)control);
        }
        Cursor<Entry> cursor = session.getCoreSession().search(req);
        session.registerSearchRequest(req, cursor);
        cursor.beforeFirst();
        try {
            long serverLimit = this.getServerSizeLimit(session, req);
            long requestLimit = req.getSizeLimit() == 0L ? Long.MAX_VALUE : req.getSizeLimit();
            req.addAbandonListener(new SearchAbandonListener(this.ldapServer, cursor));
            this.setTimeLimitsOnCursor(req, session, cursor);
            if (IS_DEBUG) {
                LOG.debug("using <{},{}> for size limit", (Object)requestLimit, (Object)serverLimit);
            }
            long sizeLimit = Math.min(requestLimit, serverLimit);
            this.writeResults(session, req, ldapResult, cursor, sizeLimit);
        }
        finally {
            if (!cursor.isClosed()) {
                try {
                    cursor.close();
                }
                catch (Exception e) {
                    LOG.error(I18n.err(I18n.ERR_168, new Object[0]), e);
                }
            }
        }
        return (SearchResultDone)req.getResultResponse();
    }

    private Response generateResponse(LdapSession session, SearchRequest req, Entry entry) throws Exception {
        Attribute ref = entry.get("ref");
        boolean hasManageDsaItControl = req.getControls().containsKey("2.16.840.1.113730.3.4.2");
        if (ref != null && !hasManageDsaItControl) {
            SearchResultReferenceImpl respRef = new SearchResultReferenceImpl(req.getMessageId());
            respRef.setReferral(new ReferralImpl());
            for (Value val : ref) {
                String url = val.getString();
                if (!url.startsWith("ldap")) {
                    respRef.getReferral().addLdapUrl(url);
                }
                LdapUrl ldapUrl = null;
                try {
                    ldapUrl = new LdapUrl(url);
                    ldapUrl.setForceScopeRendering(true);
                    switch (req.getScope()) {
                        case SUBTREE: {
                            ldapUrl.setScope(SearchScope.SUBTREE.getScope());
                            break;
                        }
                        case ONELEVEL: {
                            ldapUrl.setScope(SearchScope.OBJECT.getScope());
                            break;
                        }
                        default: {
                            ldapUrl.setScope(SearchScope.OBJECT.getScope());
                            break;
                        }
                    }
                }
                catch (LdapURLEncodingException e) {
                    LOG.error(I18n.err(I18n.ERR_165, url, entry));
                    ldapUrl = new LdapUrl();
                }
                respRef.getReferral().addLdapUrl(ldapUrl.toString());
            }
            return respRef;
        }
        SearchResultEntryImpl respEntry = new SearchResultEntryImpl(req.getMessageId());
        respEntry.setEntry(entry);
        respEntry.setObjectName(entry.getDn());
        if (session.getCoreSession().getDirectoryService().isPasswordHidden()) {
            respEntry.getEntry().removeAttributes("userPassword");
        }
        return respEntry;
    }

    private void modifyFilter(LdapSession session, SearchRequest req) throws Exception {
        String attribute;
        AttributeType objectClassAT;
        AttributeType attributeType;
        PresenceNode presenceNode;
        if (req.hasControl("2.16.840.1.113730.3.4.2")) {
            return;
        }
        if (req.getFilter() instanceof PresenceNode && ((presenceNode = (PresenceNode)req.getFilter()).isSchemaAware() ? (attributeType = presenceNode.getAttributeType()).equals(objectClassAT = session.getCoreSession().getDirectoryService().getAtProvider().getObjectClass()) : (attribute = presenceNode.getAttribute()).equalsIgnoreCase("objectClass") || attribute.equalsIgnoreCase("2.5.4.0"))) {
            return;
        }
        if (this.isSubSchemaSubEntrySearch(session, req)) {
            return;
        }
        req.setFilter(new OrNode(req.getFilter(), this.newIsReferralEqualityNode(session)));
    }

    private boolean handleLookupAndRootDse(LdapSession session, SearchRequest req) throws Exception {
        boolean isBaseScope = req.getScope() == SearchScope.OBJECT;
        boolean isObjectClassFilter = false;
        if (req.getFilter() instanceof PresenceNode) {
            ExprNode filter = req.getFilter();
            if (filter.isSchemaAware()) {
                AttributeType attributeType = ((PresenceNode)req.getFilter()).getAttributeType();
                isObjectClassFilter = attributeType.equals(session.getCoreSession().getDirectoryService().getAtProvider().getObjectClass());
            } else {
                String attribute = ((PresenceNode)req.getFilter()).getAttribute();
                isObjectClassFilter = attribute.equalsIgnoreCase("objectClass") || attribute.equals("2.5.4.0");
            }
        }
        boolean isBaseIsRoot = req.getBase().isEmpty();
        if (isBaseScope && isObjectClassFilter) {
            if (isBaseIsRoot) {
                this.handleLookup(session, req);
                return true;
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleIgnoringReferrals(LdapSession session, SearchRequest req) {
        if (IS_DEBUG) {
            LOG.debug("Message received:  {}", (Object)req);
        }
        boolean isPersistentSearch = false;
        boolean persistentSearchException = false;
        session.registerOutstandingRequest(req);
        try {
            if (this.handleLookupAndRootDse(session, req)) {
                return;
            }
            this.modifyFilter(session, req);
            PersistentSearch psearch = (PersistentSearch)req.getControls().get("2.16.840.1.113730.3.4.3");
            if (psearch != null) {
                isPersistentSearch = true;
                this.handlePersistentSearch(session, req, psearch);
                return;
            }
            boolean isLogSearchTime = SEARCH_TIME_LOG.isDebugEnabled();
            long t0 = 0L;
            String filter = null;
            if (isLogSearchTime) {
                t0 = System.nanoTime();
                filter = req.getFilter().toString();
            }
            SearchResultDone done = this.doSimpleSearch(session, req);
            session.getIoSession().write(done);
            if (isLogSearchTime) {
                long t1 = System.nanoTime();
                SEARCH_TIME_LOG.debug("Search with filter {} took {}ms. Filter with assigned counts is {}", filter, (t1 - t0) / 1000000L, req.getFilter());
            }
        }
        catch (Exception e) {
            if (e instanceof OperationAbandonedException) {
                return;
            }
            if (isPersistentSearch) {
                persistentSearchException = true;
            }
            this.handleException(session, req, e);
        }
        finally {
            if (!isPersistentSearch || persistentSearchException) {
                session.unregisterOutstandingRequest(req);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleWithReferrals(LdapSession session, SearchRequest req) throws LdapException {
        LdapResult result = req.getResultResponse().getLdapResult();
        Entry entry = null;
        boolean isReferral = false;
        boolean isparentReferral = false;
        DirectoryService directoryService = session.getCoreSession().getDirectoryService();
        ReferralManager referralManager = directoryService.getReferralManager();
        Dn reqTargetDn = req.getBase();
        if (!reqTargetDn.isSchemaAware()) {
            reqTargetDn = new Dn(directoryService.getSchemaManager(), reqTargetDn);
            req.setBase(reqTargetDn);
        }
        referralManager.lockRead();
        try {
            isReferral = referralManager.isReferral(reqTargetDn);
            if (!isReferral) {
                isparentReferral = referralManager.hasParentReferral(reqTargetDn);
            }
        }
        finally {
            referralManager.unlock();
        }
        if (!isReferral && !isparentReferral) {
            if (IS_DEBUG) {
                LOG.debug("Entry {} is NOT a referral.", (Object)reqTargetDn);
            }
            this.handleIgnoringReferrals(session, req);
        } else {
            try {
                entry = session.getCoreSession().lookup(reqTargetDn, new String[0]);
                if (IS_DEBUG) {
                    LOG.debug("Entry for {} was found: ", (Object)reqTargetDn, (Object)entry);
                }
            }
            catch (LdapException e) {
                LOG.debug("Entry for {} not found.", (Object)reqTargetDn);
            }
            catch (Exception e) {
                this.handleException(session, req, e);
                return;
            }
            if (entry != null) {
                try {
                    if (IS_DEBUG) {
                        LOG.debug("Entry is a referral: {}", (Object)entry);
                    }
                    this.handleReferralEntryForSearch(session, req, entry);
                }
                catch (Exception e) {
                    this.handleException(session, req, e);
                }
            } else {
                Entry referralAncestor = null;
                try {
                    referralAncestor = SearchRequestHandler.getFarthestReferralAncestor(session, reqTargetDn);
                }
                catch (Exception e) {
                    this.handleException(session, req, e);
                    return;
                }
                if (referralAncestor == null) {
                    result.setDiagnosticMessage("Entry not found.");
                    result.setResultCode(ResultCodeEnum.NO_SUCH_OBJECT);
                    session.getIoSession().write(req.getResultResponse());
                    return;
                }
                try {
                    Referral referral = this.getReferralOnAncestorForSearch(session, req, referralAncestor);
                    result.setResultCode(ResultCodeEnum.REFERRAL);
                    result.setReferral(referral);
                    session.getIoSession().write(req.getResultResponse());
                }
                catch (Exception e) {
                    this.handleException(session, req, e);
                }
            }
        }
    }

    private void handleReferralEntryForSearch(LdapSession session, SearchRequest req, Entry entry) throws Exception {
        LdapResult result = req.getResultResponse().getLdapResult();
        ReferralImpl referral = new ReferralImpl();
        result.setReferral(referral);
        result.setResultCode(ResultCodeEnum.REFERRAL);
        result.setDiagnosticMessage("Encountered referral attempting to handle request.");
        result.setMatchedDn(req.getBase());
        Attribute refAttr = ((ClonedServerEntry)entry).getOriginalEntry().get("ref");
        for (Value refval : refAttr) {
            String refstr = refval.getString();
            if (!refstr.startsWith("ldap")) {
                referral.addLdapUrl(refstr);
                continue;
            }
            LdapUrl ldapUrl = null;
            try {
                ldapUrl = new LdapUrl(refstr);
            }
            catch (LdapURLEncodingException e) {
                LOG.error(I18n.err(I18n.ERR_165, refstr, entry));
                continue;
            }
            ldapUrl.setForceScopeRendering(true);
            ldapUrl.setAttributes(req.getAttributes());
            ldapUrl.setScope(req.getScope().getScope());
            referral.addLdapUrl(ldapUrl.toString());
        }
        session.getIoSession().write(req.getResultResponse());
    }

    private boolean isSubSchemaSubEntrySearch(LdapSession session, SearchRequest req) throws Exception {
        Dn base = req.getBase();
        DirectoryService ds = session.getCoreSession().getDirectoryService();
        PartitionNexus nexus = ds.getPartitionNexus();
        Value subschemaSubentry = nexus.getRootDseValue(ds.getAtProvider().getSubschemaSubentry());
        Dn subschemaSubentryDn = ds.getDnFactory().create(subschemaSubentry.getString());
        return subschemaSubentryDn.equals(base);
    }

    public Referral getReferralOnAncestorForSearch(LdapSession session, SearchRequest req, Entry referralAncestor) throws LdapException {
        if (IS_DEBUG) {
            LOG.debug("Inside getReferralOnAncestor()");
        }
        Attribute refAttr = ((ClonedServerEntry)referralAncestor).getOriginalEntry().get("ref");
        ReferralImpl referral = new ReferralImpl();
        for (Value value : refAttr) {
            String ref = value.getString();
            if (IS_DEBUG) {
                LOG.debug("Calculating LdapURL for referrence value {}", (Object)ref);
            }
            if (!ref.startsWith("ldap")) {
                referral.addLdapUrl(ref);
                continue;
            }
            LdapUrl ldapUrl = null;
            try {
                ldapUrl = new LdapUrl(ref);
            }
            catch (LdapURLEncodingException e) {
                LOG.error(I18n.err(I18n.ERR_165, ref, referralAncestor));
                ldapUrl = new LdapUrl();
            }
            Dn urlDn = new Dn(session.getCoreSession().getDirectoryService().getSchemaManager(), ldapUrl.getDn().getName());
            if (urlDn.equals(req.getBase())) {
                ldapUrl.setForceScopeRendering(true);
                ldapUrl.setAttributes(req.getAttributes());
                ldapUrl.setScope(req.getScope().getScope());
                referral.addLdapUrl(ldapUrl.toString());
                continue;
            }
            Dn suffix = req.getBase().getDescendantOf(referralAncestor.getDn());
            Dn refDn = urlDn.add(suffix);
            ldapUrl.setDn(refDn);
            ldapUrl.setForceScopeRendering(true);
            ldapUrl.setAttributes(req.getAttributes());
            ldapUrl.setScope(req.getScope().getScope());
            referral.addLdapUrl(ldapUrl.toString());
        }
        return referral;
    }

    public Referral getReferralOnAncestor(LdapSession session, Dn reqTargetDn, SearchRequest req, Entry referralAncestor) throws LdapException {
        if (IS_DEBUG) {
            LOG.debug("Inside getReferralOnAncestor()");
        }
        Attribute refAttr = ((ClonedServerEntry)referralAncestor).getOriginalEntry().get("ref");
        ReferralImpl referral = new ReferralImpl();
        for (Value value : refAttr) {
            String ref = value.getString();
            if (IS_DEBUG) {
                LOG.debug("Calculating LdapURL for referrence value {}", (Object)ref);
            }
            if (!ref.startsWith("ldap")) {
                referral.addLdapUrl(ref);
                continue;
            }
            LdapUrl ldapUrl = null;
            try {
                ldapUrl = new LdapUrl(ref);
            }
            catch (LdapURLEncodingException e) {
                LOG.error(I18n.err(I18n.ERR_165, ref, referralAncestor));
                ldapUrl = new LdapUrl();
            }
            Dn urlDn = new Dn(session.getCoreSession().getDirectoryService().getSchemaManager(), ldapUrl.getDn().getName());
            if (urlDn.equals(referralAncestor.getDn())) {
                StringBuilder buf = new StringBuilder();
                buf.append(ldapUrl.getScheme());
                buf.append(ldapUrl.getHost());
                if (ldapUrl.getPort() > 0) {
                    buf.append(":");
                    buf.append(ldapUrl.getPort());
                }
                referral.addLdapUrl(buf.toString());
                continue;
            }
            Dn suffix = req.getBase().getDescendantOf(referralAncestor.getDn());
            urlDn = urlDn.add(suffix);
            StringBuilder buf = new StringBuilder();
            buf.append(ldapUrl.getScheme());
            buf.append(ldapUrl.getHost());
            if (ldapUrl.getPort() > 0) {
                buf.append(":");
                buf.append(ldapUrl.getPort());
            }
            buf.append("/");
            buf.append(LdapUrl.urlEncode(urlDn.getName(), false));
            referral.addLdapUrl(buf.toString());
        }
        return referral;
    }

    public void handleException(LdapSession session, ResultResponseRequest req, Exception e) {
        SearchResultDone done = (SearchResultDone)req.getResultResponse();
        LdapResult result = done.getLdapResult();
        Exception cause = null;
        if (e instanceof CursorClosedException) {
            cause = (Exception)((CursorClosedException)e).getCause();
            if (cause == null) {
                cause = e;
            }
        } else {
            cause = e;
        }
        ResultCodeEnum code = cause instanceof LdapOperationException ? ((LdapOperationException)cause).getResultCode() : ResultCodeEnum.getBestEstimate(cause, req.getType());
        result.setResultCode(code);
        String msg = code.toString() + ": failed for " + req + ": " + cause.getLocalizedMessage();
        if (IS_DEBUG) {
            LOG.debug(msg, cause);
            msg = msg + ":\n" + ExceptionUtils.getStackTrace(cause);
        }
        result.setDiagnosticMessage(msg);
        if (cause instanceof LdapOperationException) {
            boolean setMatchedDn;
            LdapOperationException ne = (LdapOperationException)cause;
            boolean bl = setMatchedDn = code == ResultCodeEnum.NO_SUCH_OBJECT || code == ResultCodeEnum.ALIAS_PROBLEM || code == ResultCodeEnum.INVALID_DN_SYNTAX || code == ResultCodeEnum.ALIAS_DEREFERENCING_PROBLEM;
            if (ne.getResolvedDn() != null && setMatchedDn) {
                result.setMatchedDn(ne.getResolvedDn());
            }
        }
        session.getIoSession().write(done);
    }

    public static final Entry getFarthestReferralAncestor(LdapSession session, Dn target) {
        Entry farthestReferralAncestor = null;
        Dn dn = target;
        dn = dn.getParent();
        while (!dn.isEmpty()) {
            if (IS_DEBUG) {
                LOG.debug("Walking ancestors of {} to find referrals.", (Object)dn);
            }
            try {
                Entry entry = session.getCoreSession().lookup(dn, new String[0]);
                boolean isReferral = ((ClonedServerEntry)entry).getOriginalEntry().contains("objectClass", "referral");
                if (isReferral) {
                    farthestReferralAncestor = entry;
                }
                dn = dn.getParent();
            }
            catch (LdapException e) {
                if (IS_DEBUG) {
                    LOG.debug("Entry for {} not found.", (Object)dn);
                }
                dn = dn.getParent();
            }
        }
        return farthestReferralAncestor;
    }

    public void setReplicationReqHandler(ReplicationRequestHandler replicationReqHandler) {
        this.replicationReqHandler = replicationReqHandler;
    }
}

