/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authn.ppolicy;

import java.util.HashMap;
import java.util.Map;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.server.core.api.authn.ppolicy.PasswordPolicyConfiguration;

public class PpolicyConfigContainer {
    private Map<Dn, PasswordPolicyConfiguration> ppolicyConfigMap = new HashMap<Dn, PasswordPolicyConfiguration>();
    private Dn defaultPolicyDn;

    public void addPolicy(Dn configDn, PasswordPolicyConfiguration policyConfig) {
        if (configDn == null) {
            throw new IllegalArgumentException("password policy config's Dn cannot be null");
        }
        this.ppolicyConfigMap.put(configDn, policyConfig);
    }

    public boolean hasCustomConfigs() {
        return !this.ppolicyConfigMap.isEmpty();
    }

    public PasswordPolicyConfiguration getPolicyConfig(Dn configDn) {
        return this.ppolicyConfigMap.get(configDn);
    }

    public PasswordPolicyConfiguration getDefaultPolicy() {
        return this.getPolicyConfig(this.defaultPolicyDn);
    }

    public void setDefaultPolicyDn(Dn defaultPolicyDn) {
        this.defaultPolicyDn = defaultPolicyDn;
    }

    public PasswordPolicyConfiguration removePolicyConfig(Dn ppolicyConfigDn) {
        return this.ppolicyConfigMap.remove(ppolicyConfigDn);
    }
}

