/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.security.api.authorization;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import java.util.Set;
import javax.enterprise.util.Nonbinding;
import org.apache.deltaspike.core.api.config.view.DefaultErrorView;
import org.apache.deltaspike.core.api.config.view.ViewConfig;
import org.apache.deltaspike.core.api.config.view.metadata.CallbackDescriptor;
import org.apache.deltaspike.core.api.config.view.metadata.DefaultCallback;
import org.apache.deltaspike.core.api.config.view.metadata.ExecutableCallbackDescriptor;
import org.apache.deltaspike.core.api.config.view.metadata.ViewMetaData;
import org.apache.deltaspike.core.spi.config.view.ConfigPreProcessor;
import org.apache.deltaspike.core.spi.config.view.ViewConfigNode;
import org.apache.deltaspike.security.api.authorization.AccessDecisionVoter;
import org.apache.deltaspike.security.api.authorization.AccessDecisionVoterContext;
import org.apache.deltaspike.security.api.authorization.SecurityBindingType;
import org.apache.deltaspike.security.api.authorization.SecurityViolation;

@Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.ANNOTATION_TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@Documented
@SecurityBindingType
@ViewMetaData(preProcessor=AnnotationPreProcessor.class)
public @interface Secured {
    @Nonbinding
    public Class<? extends AccessDecisionVoter>[] value();

    @Nonbinding
    public Class<? extends ViewConfig> errorView() default DefaultErrorView.class;

    public static class Descriptor
    extends ExecutableCallbackDescriptor<Set<SecurityViolation>> {
        public Descriptor(Class<? extends AccessDecisionVoter>[] accessDecisionVoterBeanClasses) {
            super((Class[])accessDecisionVoterBeanClasses, DefaultCallback.class);
        }

        public List<Set<SecurityViolation>> execute(AccessDecisionVoterContext accessDecisionVoterContext) {
            return super.execute(new Object[]{accessDecisionVoterContext});
        }
    }

    public static class AnnotationPreProcessor
    implements ConfigPreProcessor<Secured> {
        public Secured beforeAddToConfig(Secured metaData, ViewConfigNode viewConfigNode) {
            viewConfigNode.registerCallbackDescriptors(Secured.class, (CallbackDescriptor)new Descriptor(metaData.value()));
            return metaData;
        }
    }
}

