/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.handler;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.interceptor.InvocationContext;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceException;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.util.ExceptionUtils;
import org.apache.deltaspike.core.util.ProxyUtils;
import org.apache.deltaspike.core.util.interceptor.AbstractInvocationContext;
import org.apache.deltaspike.core.util.metadata.AnnotationInstanceProvider;
import org.apache.deltaspike.data.api.QueryInvocationException;
import org.apache.deltaspike.data.api.Repository;
import org.apache.deltaspike.data.impl.builder.QueryBuilder;
import org.apache.deltaspike.data.impl.builder.QueryBuilderFactory;
import org.apache.deltaspike.data.impl.handler.CdiQueryContextHolder;
import org.apache.deltaspike.data.impl.handler.CdiQueryInvocationContext;
import org.apache.deltaspike.data.impl.handler.QueryRunner;
import org.apache.deltaspike.data.impl.meta.RepositoryMetadata;
import org.apache.deltaspike.data.impl.meta.RepositoryMetadataHandler;
import org.apache.deltaspike.data.impl.meta.RepositoryMethodMetadata;
import org.apache.deltaspike.jpa.api.transaction.Transactional;
import org.apache.deltaspike.jpa.impl.entitymanager.EntityManagerMetadata;
import org.apache.deltaspike.jpa.impl.entitymanager.EntityManagerRef;
import org.apache.deltaspike.jpa.impl.entitymanager.EntityManagerRefLookup;
import org.apache.deltaspike.jpa.spi.entitymanager.ActiveEntityManagerHolder;
import org.apache.deltaspike.jpa.spi.transaction.TransactionStrategy;

@Repository
@ApplicationScoped
public class QueryHandler
implements Serializable,
InvocationHandler {
    private static final Logger log = Logger.getLogger(QueryHandler.class.getName());
    @Inject
    private QueryBuilderFactory queryBuilderFactory;
    @Inject
    private RepositoryMetadataHandler metadataHandler;
    @Inject
    private CdiQueryContextHolder context;
    @Inject
    private EntityManagerRefLookup entityManagerRefLookup;
    @Inject
    private QueryRunner runner;
    @Inject
    private BeanManager beanManager;
    @Inject
    private TransactionStrategy transactionStrategy;
    @Inject
    private ActiveEntityManagerHolder activeEntityManagerHolder;

    @Override
    public Object invoke(final Object proxy, Method method, final Object[] args) throws Throwable {
        List candidates = ProxyUtils.getProxyAndBaseTypes(proxy.getClass());
        final RepositoryMetadata repositoryMetadata = this.metadataHandler.lookupMetadata(candidates);
        final RepositoryMethodMetadata repositoryMethodMetadata = this.metadataHandler.lookupMethodMetadata(repositoryMetadata, method);
        if (repositoryMethodMetadata.getTransactional() != null) {
            if (repositoryMethodMetadata.getTransactional().qualifier().length > 1) {
                throw new IllegalStateException(proxy.getClass().getName() + " uses @" + Transactional.class.getName() + " with multiple qualifiers. That isn't supported with @" + Repository.class.getName());
            }
            Class qualifier = repositoryMethodMetadata.getTransactional().qualifier()[0];
            if (!Any.class.equals((Object)qualifier)) {
                EntityManager entityManager = (EntityManager)BeanProvider.getContextualReference(EntityManager.class, (boolean)false, (Annotation[])new Annotation[]{AnnotationInstanceProvider.of((Class)qualifier)});
                this.activeEntityManagerHolder.set(entityManager);
            }
            return this.transactionStrategy.execute((InvocationContext)new AbstractInvocationContext<Object>(proxy, method, args, null){

                public Object proceed() throws Exception {
                    try {
                        return QueryHandler.this.process(proxy, this.method, args, repositoryMetadata, repositoryMethodMetadata);
                    }
                    catch (Throwable t) {
                        throw ExceptionUtils.throwAsRuntimeException((Throwable)t);
                    }
                }
            });
        }
        return this.process(proxy, method, args, repositoryMetadata, repositoryMethodMetadata);
    }

    protected Object process(Object proxy, Method method, Object[] args, RepositoryMetadata repositoryMetadata, RepositoryMethodMetadata repositoryMethodMetadata) throws Throwable {
        CdiQueryInvocationContext queryContext = null;
        EntityManagerRef entityManagerRef = null;
        try {
            Object result;
            entityManagerRef = this.entityManagerRefLookup.lookupReference((EntityManagerMetadata)repositoryMetadata);
            EntityManager entityManager = entityManagerRef.getEntityManager();
            if (entityManager == null) {
                throw new IllegalStateException("Unable to look up EntityManager");
            }
            queryContext = this.createContext(proxy, method, args, entityManager, repositoryMetadata, repositoryMethodMetadata);
            QueryBuilder builder = this.queryBuilderFactory.build(repositoryMethodMetadata, queryContext);
            Object object = result = this.runner.executeQuery(builder, queryContext);
            return object;
        }
        catch (PersistenceException e) {
            throw e;
        }
        catch (Exception e) {
            log.log(Level.FINEST, "Query execution error", e);
            if (queryContext != null) {
                throw new QueryInvocationException((Throwable)e, queryContext);
            }
            throw new QueryInvocationException((Throwable)e, proxy.getClass(), method);
        }
        finally {
            if (entityManagerRef != null) {
                entityManagerRef.release();
            }
            this.context.dispose();
        }
    }

    private CdiQueryInvocationContext createContext(Object proxy, Method method, Object[] args, EntityManager entityManager, RepositoryMetadata repositoryMetadata, RepositoryMethodMetadata repositoryMethodMetadata) {
        CdiQueryInvocationContext queryContext = new CdiQueryInvocationContext(proxy, method, args, repositoryMetadata, repositoryMethodMetadata, entityManager);
        this.context.set(queryContext);
        queryContext.init();
        return queryContext;
    }
}

