/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.cxf.plugin.state;

import java.io.IOException;
import java.net.URL;
import org.apache.cxf.fediz.core.RequestState;
import org.apache.cxf.fediz.cxf.plugin.state.ResponseState;
import org.apache.cxf.fediz.cxf.plugin.state.SPStateManager;
import org.apache.wss4j.common.util.Loader;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.config.Configuration;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.xml.XmlConfiguration;

public class EHCacheSPStateManager
implements SPStateManager {
    public static final String REQUEST_CACHE_KEY = "cxf.fediz.samlp.request.state.cache";
    public static final String RESPONSE_CACHE_KEY = "cxf.fediz.samlp.response.state.cache";
    private Cache<String, RequestState> requestCache;
    private Cache<String, ResponseState> responseCache;
    private CacheManager cacheManager;

    public EHCacheSPStateManager(String configFile) {
        this(EHCacheSPStateManager.getConfigFileURL(configFile));
    }

    public EHCacheSPStateManager(URL configFileURL) {
        XmlConfiguration xmlConfig = new XmlConfiguration(configFileURL);
        this.cacheManager = CacheManagerBuilder.newCacheManager((Configuration)xmlConfig);
        this.cacheManager.init();
        this.initCache();
    }

    public EHCacheSPStateManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
        this.initCache();
    }

    private static URL getConfigFileURL(String configFile) {
        try {
            URL url = Loader.getResource((String)configFile);
            if (url == null) {
                url = new URL(configFile);
            }
            return url;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void initCache() {
        this.requestCache = this.cacheManager.getCache(REQUEST_CACHE_KEY, String.class, RequestState.class);
        this.responseCache = this.cacheManager.getCache(RESPONSE_CACHE_KEY, String.class, ResponseState.class);
    }

    @Override
    public void setRequestState(String relayState, RequestState state) {
        if (relayState != null && !relayState.isEmpty()) {
            this.requestCache.put((Object)relayState, (Object)state);
        }
    }

    @Override
    public RequestState removeRequestState(String relayState) {
        RequestState state = (RequestState)this.requestCache.get((Object)relayState);
        if (state != null) {
            this.requestCache.remove((Object)relayState);
        }
        return state;
    }

    @Override
    public ResponseState getResponseState(String securityContextKey) {
        return (ResponseState)this.responseCache.get((Object)securityContextKey);
    }

    @Override
    public void setResponseState(String securityContextKey, ResponseState state) {
        if (securityContextKey != null && !securityContextKey.isEmpty()) {
            this.responseCache.put((Object)securityContextKey, (Object)state);
        }
    }

    @Override
    public ResponseState removeResponseState(String securityContextKey) {
        ResponseState state = (ResponseState)this.responseCache.get((Object)securityContextKey);
        if (state != null) {
            this.responseCache.remove((Object)securityContextKey);
        }
        return state;
    }

    @Override
    public void close() throws IOException {
        if (this.cacheManager != null) {
            this.cacheManager.close();
            this.cacheManager = null;
            this.requestCache = null;
            this.responseCache = null;
        }
    }
}

