/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.core.config;

import org.apache.cxf.fediz.core.config.Protocol;
import org.apache.cxf.fediz.core.config.SignatureDigestAlgorithm;
import org.apache.cxf.fediz.core.config.jaxb.ProtocolType;
import org.apache.cxf.fediz.core.config.jaxb.SamlProtocolType;
import org.apache.cxf.fediz.core.saml.SAMLTokenValidator;
import org.apache.cxf.fediz.core.samlsso.DefaultSAMLPRequestBuilder;
import org.apache.cxf.fediz.core.samlsso.SAMLPRequestBuilder;
import org.apache.wss4j.common.util.Loader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAMLProtocol
extends Protocol {
    private static final Logger LOG = LoggerFactory.getLogger(SAMLProtocol.class);
    private SAMLPRequestBuilder samlpRequestBuilder;

    public SAMLProtocol(ProtocolType protocolType) {
        super(protocolType);
        SAMLTokenValidator validator = new SAMLTokenValidator();
        this.getTokenValidators().add(this.getTokenValidators().size(), validator);
    }

    protected SamlProtocolType getSAMLProtocol() {
        return (SamlProtocolType)super.getProtocolType();
    }

    protected void setSAMLProtocol(SamlProtocolType samlProtocol) {
        super.setProtocolType(samlProtocol);
    }

    public boolean isSignRequest() {
        if (this.getSAMLProtocol().getSignRequest() != null) {
            return this.getSAMLProtocol().getSignRequest().isValue();
        }
        return false;
    }

    public SignatureDigestAlgorithm getSignRequestAlgorithm() {
        if (this.getSAMLProtocol().getSignRequest() != null && this.getSAMLProtocol().getSignRequest().getAlgorithm() != null) {
            return SignatureDigestAlgorithm.fromValue(this.getSAMLProtocol().getSignRequest().getAlgorithm().value());
        }
        return SignatureDigestAlgorithm.RSA_SHA1;
    }

    public void setSignRequest(boolean signRequest) {
        this.getSAMLProtocol().getSignRequest().setValue(signRequest);
    }

    public SAMLPRequestBuilder getSAMLPRequestBuilder() {
        if (this.samlpRequestBuilder != null) {
            return this.samlpRequestBuilder;
        }
        String samlpRequestBuilderStr = this.getSAMLProtocol().getAuthnRequestBuilder();
        if (samlpRequestBuilderStr != null && !"".equals(samlpRequestBuilderStr)) {
            try {
                Class samlpRequestBuilderClass = Loader.loadClass((String)samlpRequestBuilderStr);
                this.samlpRequestBuilder = (SAMLPRequestBuilder)samlpRequestBuilderClass.newInstance();
            }
            catch (ClassNotFoundException ex) {
                LOG.debug(ex.getMessage(), (Throwable)ex);
            }
            catch (InstantiationException ex) {
                LOG.debug(ex.getMessage(), (Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                LOG.debug(ex.getMessage(), (Throwable)ex);
            }
        }
        if (this.samlpRequestBuilder == null) {
            this.samlpRequestBuilder = new DefaultSAMLPRequestBuilder();
        }
        return this.samlpRequestBuilder;
    }

    public void setSAMLPRequestBuilder(SAMLPRequestBuilder requestBuilder) {
        this.samlpRequestBuilder = requestBuilder;
    }

    public boolean isDisableDeflateEncoding() {
        return this.getSAMLProtocol().isDisableDeflateEncoding();
    }

    public void setDisableDeflateEncoding(boolean disableDeflateEncoding) {
        this.getSAMLProtocol().setDisableDeflateEncoding(disableDeflateEncoding);
    }

    public boolean isDoNotEnforceKnownIssuer() {
        return this.getSAMLProtocol().isDoNotEnforceKnownIssuer();
    }

    public boolean isDoNotEnforceEncryptedAssertionsSigned() {
        return this.getSAMLProtocol().isDoNotEnforceEncryptedAssertionsSigned();
    }

    public void setDoNotEnforceKnownIssuer(boolean doNotEnforceKnownIssuer) {
        this.getSAMLProtocol().setDoNotEnforceKnownIssuer(doNotEnforceKnownIssuer);
    }

    public String getIssuerLogoutURL() {
        return this.getSAMLProtocol().getIssuerLogoutURL();
    }

    public boolean isDisableClientAddressCheck() {
        return this.getSAMLProtocol().isDisableClientAddressCheck();
    }
}

