/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.expiry;

import java.util.concurrent.TimeUnit;

@Deprecated
public final class Duration {
    public static final Duration INFINITE = new Duration(0L, null, true);
    public static final Duration ZERO = new Duration(0L, TimeUnit.NANOSECONDS, false);
    private final TimeUnit timeUnit;
    private final long length;

    public static Duration of(long length, TimeUnit timeUnit) {
        return new Duration(length, timeUnit);
    }

    public Duration(long length, TimeUnit timeUnit) {
        this(length, timeUnit, false);
    }

    private Duration(long length, TimeUnit timeUnit, boolean forever) {
        if (!forever) {
            if (length < 0L) {
                throw new IllegalArgumentException("length must be greater than or equal to zero: " + length);
            }
            if (timeUnit == null) {
                throw new NullPointerException("TimeUnit must not be null");
            }
        }
        this.length = length;
        this.timeUnit = timeUnit;
    }

    public long getLength() {
        this.checkInfinite();
        return this.length;
    }

    public TimeUnit getTimeUnit() {
        this.checkInfinite();
        return this.timeUnit;
    }

    private void checkInfinite() {
        if (this.isInfinite()) {
            throw new IllegalStateException("The calling code should be checking explicitly for Duration#INFINITE or isInfinite()");
        }
    }

    public boolean isInfinite() {
        return this.timeUnit == null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.length ^ this.length >>> 32);
        result = this.length != 0L ? 31 * result + (this.timeUnit == null ? 0 : this.timeUnit.hashCode()) : 31 * result + (this.timeUnit == null ? 0 : 1);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Duration other = (Duration)obj;
        if (this.length != other.length) {
            return false;
        }
        if (this.timeUnit == null || other.timeUnit == null) {
            return this.timeUnit == other.timeUnit;
        }
        if (this.timeUnit != other.timeUnit) {
            return this.length == 0L;
        }
        return true;
    }

    public String toString() {
        if (this.isInfinite()) {
            return "Duration[INFINITE]";
        }
        if (this.length == 0L) {
            return "Duration[ZERO]";
        }
        return "Duration[length=" + this.length + ", timeUnit=" + this.timeUnit.name() + "]";
    }
}

