/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.stat.descriptive.moment;

import org.apache.commons.math4.legacy.exception.NullArgumentException;
import org.apache.commons.math4.legacy.stat.descriptive.moment.SecondMoment;

class ThirdMoment
extends SecondMoment {
    protected double m3;
    protected double nDevSq;

    ThirdMoment() {
        this.m3 = Double.NaN;
        this.nDevSq = Double.NaN;
    }

    ThirdMoment(ThirdMoment original) throws NullArgumentException {
        ThirdMoment.copy(original, this);
    }

    @Override
    public void increment(double d) {
        if (this.n < 1L) {
            this.m1 = 0.0;
            this.m2 = 0.0;
            this.m3 = 0.0;
        }
        double prevM2 = this.m2;
        super.increment(d);
        this.nDevSq = this.nDev * this.nDev;
        double n0 = this.n;
        this.m3 = this.m3 - 3.0 * this.nDev * prevM2 + (n0 - 1.0) * (n0 - 2.0) * this.nDevSq * this.dev;
    }

    @Override
    public double getResult() {
        return this.m3;
    }

    @Override
    public void clear() {
        super.clear();
        this.m3 = Double.NaN;
        this.nDevSq = Double.NaN;
    }

    @Override
    public ThirdMoment copy() {
        ThirdMoment result = new ThirdMoment();
        ThirdMoment.copy(this, result);
        return result;
    }

    public static void copy(ThirdMoment source, ThirdMoment dest) throws NullArgumentException {
        NullArgumentException.check((Object)source);
        NullArgumentException.check((Object)dest);
        SecondMoment.copy(source, dest);
        dest.m3 = source.m3;
        dest.nDevSq = source.nDevSq;
    }
}

