/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.EOFException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOExceptionList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class IOExceptionListTest {
    IOExceptionListTest() {
    }

    @Test
    void testCause() {
        EOFException cause = new EOFException();
        List<EOFException> list = Collections.singletonList(cause);
        IOExceptionList sqlExceptionList = new IOExceptionList(list);
        Assertions.assertEquals((Object)cause, (Object)sqlExceptionList.getCause());
        Assertions.assertEquals((Object)cause, (Object)sqlExceptionList.getCause(0));
        Assertions.assertEquals(list, (Object)sqlExceptionList.getCauseList());
        Assertions.assertEquals(list, (Object)sqlExceptionList.getCauseList(EOFException.class));
        Assertions.assertEquals((Object)cause, (Object)sqlExceptionList.getCause(0, EOFException.class));
        List causeList = sqlExceptionList.getCauseList();
        Assertions.assertEquals(list, (Object)causeList);
    }

    @Test
    void testCheckEmpty() throws IOExceptionList {
        IOExceptionList.checkEmpty(null, (Object)"");
        IOExceptionList.checkEmpty(null, null);
        IOExceptionList.checkEmpty(Collections.emptyList(), (Object)"");
        IOExceptionList.checkEmpty(Collections.emptyList(), null);
        Assertions.assertThrows(IOExceptionList.class, () -> IOExceptionList.checkEmpty(Collections.singletonList(new Exception()), (Object)""));
        Assertions.assertThrows(IOExceptionList.class, () -> IOExceptionList.checkEmpty(Collections.singletonList(new Exception()), null));
    }

    @Test
    void testEmptyList() {
        new IOExceptionList(Collections.emptyList());
        new IOExceptionList("foo", Collections.emptyList());
    }

    @Test
    void testIterable() {
        EOFException cause = new EOFException();
        List<EOFException> list = Collections.singletonList(cause);
        IOExceptionList sqlExceptionList = new IOExceptionList("Hello", list);
        Assertions.assertEquals(list, (Object)sqlExceptionList.getCauseList());
        List causeList = sqlExceptionList.getCauseList();
        Assertions.assertEquals(list, (Object)causeList);
        ArrayList list2 = new ArrayList();
        sqlExceptionList.forEach(list2::add);
        Assertions.assertEquals(list2, (Object)causeList);
    }

    @Test
    void testMessageCause() {
        EOFException cause = new EOFException();
        List<EOFException> list = Collections.singletonList(cause);
        IOExceptionList sqlExceptionList = new IOExceptionList("Hello", list);
        Assertions.assertEquals((Object)"Hello", (Object)sqlExceptionList.getMessage());
        Assertions.assertEquals((Object)cause, (Object)sqlExceptionList.getCause());
        Assertions.assertEquals((Object)cause, (Object)sqlExceptionList.getCause(0));
        Assertions.assertEquals(list, (Object)sqlExceptionList.getCauseList());
        Assertions.assertEquals(list, (Object)sqlExceptionList.getCauseList(EOFException.class));
        Assertions.assertEquals((Object)cause, (Object)sqlExceptionList.getCause(0, EOFException.class));
        List causeList = sqlExceptionList.getCauseList();
        Assertions.assertEquals(list, (Object)causeList);
    }

    @Test
    void testNullCause() {
        IOExceptionList sqlExceptionList = new IOExceptionList(null);
        Assertions.assertNull((Object)sqlExceptionList.getCause());
        Assertions.assertTrue((boolean)sqlExceptionList.getCauseList().isEmpty());
    }

    @Test
    void testNullMessageArg() {
        Assertions.assertNotNull((Object)new IOExceptionList(null, Collections.emptyList()).getMessage());
        Assertions.assertNotNull((Object)new IOExceptionList(null, null).getMessage());
        Assertions.assertEquals((Object)"A", (Object)new IOExceptionList("A", Collections.emptyList()).getMessage());
        Assertions.assertEquals((Object)"A", (Object)new IOExceptionList("A", null).getMessage());
    }

    @Test
    void testPrintStackTrace() {
        EOFException cause = new EOFException();
        List<EOFException> list = Collections.singletonList(cause);
        IOExceptionList sqlExceptionList = new IOExceptionList(list);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        sqlExceptionList.printStackTrace(pw);
        String st = sw.toString();
        Assertions.assertTrue((boolean)st.startsWith("org.apache.commons.io.IOExceptionList: 1 exception(s): [java.io.EOFException]"));
        Assertions.assertTrue((boolean)st.contains("Caused by: java.io.EOFException"));
    }
}

