/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload2.core;

import java.nio.charset.Charset;
import java.nio.file.Path;
import org.apache.commons.fileupload2.core.DiskFileItem;
import org.apache.commons.fileupload2.core.FileItemFactory;
import org.apache.commons.io.FileCleaningTracker;
import org.apache.commons.io.build.AbstractStreamBuilder;
import org.apache.commons.io.file.PathUtils;

public final class DiskFileItemFactory
implements FileItemFactory<DiskFileItem> {
    public static final int DEFAULT_THRESHOLD = 10240;
    private final Path repository;
    private final int threshold;
    private final FileCleaningTracker fileCleaningTracker;
    private final Charset charsetDefault;

    public static Builder builder() {
        return new Builder();
    }

    private DiskFileItemFactory(Builder builder) {
        this.threshold = builder.threshold;
        this.repository = builder.getPath();
        this.charsetDefault = builder.getCharset();
        this.fileCleaningTracker = builder.fileCleaningTracker;
    }

    public DiskFileItem.Builder fileItemBuilder() {
        return (DiskFileItem.Builder)((DiskFileItem.Builder)((Object)((DiskFileItem.Builder)DiskFileItem.builder().setThreshold(this.threshold).setCharset(this.charsetDefault)).setFileCleaningTracker(this.fileCleaningTracker))).setPath(this.repository);
    }

    public Charset getCharsetDefault() {
        return this.charsetDefault;
    }

    public FileCleaningTracker getFileCleaningTracker() {
        return this.fileCleaningTracker;
    }

    public Path getRepository() {
        return this.repository;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public static class Builder
    extends AbstractStreamBuilder<DiskFileItemFactory, Builder> {
        private FileCleaningTracker fileCleaningTracker;
        private int threshold;

        public Builder() {
            this.setBufferSize(10240);
            this.setPath(PathUtils.getTempDirectory());
            this.setCharset(DiskFileItem.DEFAULT_CHARSET);
            this.setCharsetDefault(DiskFileItem.DEFAULT_CHARSET);
        }

        public DiskFileItemFactory get() {
            return new DiskFileItemFactory(this);
        }

        public int getBufferSize() {
            return this.getThreshold();
        }

        public int getThreshold() {
            return this.threshold;
        }

        public Builder setBufferSize(int bufferSize) {
            return this.setThreshold(bufferSize);
        }

        public Builder setFileCleaningTracker(FileCleaningTracker fileCleaningTracker) {
            this.fileCleaningTracker = fileCleaningTracker;
            return this;
        }

        public Builder setThreshold(int threshold) {
            this.threshold = threshold;
            return this;
        }
    }
}

