
Apache CloudStack CHANGES
=========================

Full release notes for each release are located in the project's documentation [website](https://docs.cloudstack.apache.org/en/latest/releasenotes/index.html)

Version 4.5.0
-------------

This major release has the following bug fixes:

Generated using Jira filter=12329803

Bug ID | Description
--- | ---
[CLOUDSTACK-8283](https://issues.apache.org/jira/browse/CLOUDSTACK-8283) | primary storage limit check not working...
[CLOUDSTACK-8244](https://issues.apache.org/jira/browse/CLOUDSTACK-8244) | LibvirtServerDiscoverer.java has hard coded agent class...
[CLOUDSTACK-8166](https://issues.apache.org/jira/browse/CLOUDSTACK-8166) | Usage data boundary condition and NPE...
[CLOUDSTACK-8140](https://issues.apache.org/jira/browse/CLOUDSTACK-8140) | secstorage.service.offering in GS set to service offering ID Webui fails to star...
[CLOUDSTACK-8101](https://issues.apache.org/jira/browse/CLOUDSTACK-8101) | volume sync not working as expected - MS restart during upload volume leaves vol...
[CLOUDSTACK-8093](https://issues.apache.org/jira/browse/CLOUDSTACK-8093) | Not able to list shared templates by passing id....
[CLOUDSTACK-8077](https://issues.apache.org/jira/browse/CLOUDSTACK-8077) | Not able to deploy VM using a shared template....
[CLOUDSTACK-8061](https://issues.apache.org/jira/browse/CLOUDSTACK-8061) | Extracting volume when it is in migrating state causes both the operations to fa...
[CLOUDSTACK-7994](https://issues.apache.org/jira/browse/CLOUDSTACK-7994) | Network rules are not configured in VR after out-of-band movement due to host cr...
[CLOUDSTACK-7986](https://issues.apache.org/jira/browse/CLOUDSTACK-7986) | [F5 LB] Failed to execute IPAssocCommand due to com.cloud.utils.exception.Execut...
[CLOUDSTACK-7981](https://issues.apache.org/jira/browse/CLOUDSTACK-7981) | listVirtualMachine is too slow in case of duplicate resource tags due to joining...
[CLOUDSTACK-7974](https://issues.apache.org/jira/browse/CLOUDSTACK-7974) | deleted VM entries still exists in /etc/hosts and /etc/dhcphosts.txt files on vi...
[CLOUDSTACK-7954](https://issues.apache.org/jira/browse/CLOUDSTACK-7954) | ListTags API is ignoring the resourceID and displaying all the tags of all resou...
[CLOUDSTACK-7952](https://issues.apache.org/jira/browse/CLOUDSTACK-7952) | listSslCerts returns private key...
[CLOUDSTACK-7951](https://issues.apache.org/jira/browse/CLOUDSTACK-7951) | cloudstack-agent jsvc gets too large virtual memory space....
[CLOUDSTACK-7917](https://issues.apache.org/jira/browse/CLOUDSTACK-7917) | Load Balancer Rule is not validated when updating LB...
[CLOUDSTACK-7887](https://issues.apache.org/jira/browse/CLOUDSTACK-7887) | fail to push snapshot to secondary storage if using multipart using swift...
[CLOUDSTACK-7886](https://issues.apache.org/jira/browse/CLOUDSTACK-7886) | cs:rabbitMQ:cloudstackoperations like deployvm,deleteNW  are failing if CS fail ...
[CLOUDSTACK-7884](https://issues.apache.org/jira/browse/CLOUDSTACK-7884) | Cloudstack MS is not responding (happening randomly) after some restart...
[CLOUDSTACK-7877](https://issues.apache.org/jira/browse/CLOUDSTACK-7877) | The NET.IPRELEASE events are not added to usage_event on IP range deletion from ...
[CLOUDSTACK-7872](https://issues.apache.org/jira/browse/CLOUDSTACK-7872) | One network incorrectly being shutdown ...
[CLOUDSTACK-7871](https://issues.apache.org/jira/browse/CLOUDSTACK-7871) | Fix update VirtualMachine/Template API to allow nic/disk controller details for ...
[CLOUDSTACK-7869](https://issues.apache.org/jira/browse/CLOUDSTACK-7869) | Add simulator support for findHostsForMigration API...
[CLOUDSTACK-7855](https://issues.apache.org/jira/browse/CLOUDSTACK-7855) | Sec storage/network MTU should be on nic3 and not nic1...
[CLOUDSTACK-7854](https://issues.apache.org/jira/browse/CLOUDSTACK-7854) | Delete redundant CentOS 5.3 buit-in template in case of XenServer since CentOS 5...
[CLOUDSTACK-7843](https://issues.apache.org/jira/browse/CLOUDSTACK-7843) | sync Job Failures always reported as success on Event Bus ...
[CLOUDSTACK-7842](https://issues.apache.org/jira/browse/CLOUDSTACK-7842) | wrong size column is getting updated with snapshot physical size in snapshot_sto...
[CLOUDSTACK-7837](https://issues.apache.org/jira/browse/CLOUDSTACK-7837) | [UI] CIDR field not completely visible in multi-edit view...
[CLOUDSTACK-7833](https://issues.apache.org/jira/browse/CLOUDSTACK-7833) | VM Async work jobs log "Was unable to find lock for the key vm_instance" errors ...
[CLOUDSTACK-7832](https://issues.apache.org/jira/browse/CLOUDSTACK-7832) | MySQL deadlock occurred in resetting job_executing_msid of the completed vm work...
[CLOUDSTACK-7830](https://issues.apache.org/jira/browse/CLOUDSTACK-7830) |  Usage Job fails with "Data too long for column 'user_name'"...
[CLOUDSTACK-7829](https://issues.apache.org/jira/browse/CLOUDSTACK-7829) |  Usage Job fails with "Data too long for column 'user_name'"...
[CLOUDSTACK-7822](https://issues.apache.org/jira/browse/CLOUDSTACK-7822) | test SSL cert expired...
[CLOUDSTACK-7798](https://issues.apache.org/jira/browse/CLOUDSTACK-7798) | listing 2 guest networks is taking close to 4 seconds (Slow compare to previous ...
[CLOUDSTACK-7797](https://issues.apache.org/jira/browse/CLOUDSTACK-7797) | listSupportedNetworkServices API takes more than 1 second to complete, slow comp...
[CLOUDSTACK-7766](https://issues.apache.org/jira/browse/CLOUDSTACK-7766) | Field Validations Missing for Ingress and Egress Rules...
[CLOUDSTACK-7765](https://issues.apache.org/jira/browse/CLOUDSTACK-7765) | Field Validations Missing for VPC IP Address Fields...
[CLOUDSTACK-7764](https://issues.apache.org/jira/browse/CLOUDSTACK-7764) | No IP Address Validations when Adding Networks...
[CLOUDSTACK-7749](https://issues.apache.org/jira/browse/CLOUDSTACK-7749) | AsyncJob GC thread cannot purge queue items that have been blocking for too long...
[CLOUDSTACK-7730](https://issues.apache.org/jira/browse/CLOUDSTACK-7730) | Failed to create two icmp firewall rules...
[CLOUDSTACK-7728](https://issues.apache.org/jira/browse/CLOUDSTACK-7728) | Network with egress policy allow, VR reboot missed default rule...
[CLOUDSTACK-7722](https://issues.apache.org/jira/browse/CLOUDSTACK-7722) | add.label: Add button for tags show the label not "Add" text...
[CLOUDSTACK-7720](https://issues.apache.org/jira/browse/CLOUDSTACK-7720) | No IP Address Validation for Acquire new secondary IP...
[CLOUDSTACK-7718](https://issues.apache.org/jira/browse/CLOUDSTACK-7718) | No Field Validations on Zone Form...
[CLOUDSTACK-7703](https://issues.apache.org/jira/browse/CLOUDSTACK-7703) | Cloudstack server endless loop when trying to create a volume while storage pool...
[CLOUDSTACK-7700](https://issues.apache.org/jira/browse/CLOUDSTACK-7700) | Volume Snapshot Async Job returns Success for a failed operation...
[CLOUDSTACK-7694](https://issues.apache.org/jira/browse/CLOUDSTACK-7694) | VMWare: Unable to create template from snapshots larger than 10G....
[CLOUDSTACK-7688](https://issues.apache.org/jira/browse/CLOUDSTACK-7688) | Do not allow various operations which breaks VM Snapshots...
[CLOUDSTACK-7679](https://issues.apache.org/jira/browse/CLOUDSTACK-7679) | bump up the RabbitMQ AMQP java client version from 2.8.7 to 3.3.5...
[CLOUDSTACK-7628](https://issues.apache.org/jira/browse/CLOUDSTACK-7628) | VM Worker job should be expunged one hour after completion instead of currently ...
[CLOUDSTACK-7624](https://issues.apache.org/jira/browse/CLOUDSTACK-7624) | Long hostnames cause CloudStack to die with an encryption error during startup...
[CLOUDSTACK-7595](https://issues.apache.org/jira/browse/CLOUDSTACK-7595) | Config parameters "job.expire.minutes" and "job.cancel.threshold.minutes" incorr...
[CLOUDSTACK-7589](https://issues.apache.org/jira/browse/CLOUDSTACK-7589) | VM not Starting and always stuck in Stopped state after management server restar...
[CLOUDSTACK-7581](https://issues.apache.org/jira/browse/CLOUDSTACK-7581) | Empty 'ID' parameters allowed in API calls...
[CLOUDSTACK-7570](https://issues.apache.org/jira/browse/CLOUDSTACK-7570) | min and max iops are being processed null while creating a vm using third party ...
[CLOUDSTACK-7566](https://issues.apache.org/jira/browse/CLOUDSTACK-7566) | Many jobs getting stuck in pending state and cloud is unusable...
[CLOUDSTACK-7563](https://issues.apache.org/jira/browse/CLOUDSTACK-7563) | ClassCastException in VirtualMachineManagerImpl in handling various Agent comman...
[CLOUDSTACK-7562](https://issues.apache.org/jira/browse/CLOUDSTACK-7562) | Details page for disk offerings only show details for write performance...
[CLOUDSTACK-7553](https://issues.apache.org/jira/browse/CLOUDSTACK-7553) | Channel Closed error after SSVM and CPVM agents reconnect back to clustered mana...
[CLOUDSTACK-7542](https://issues.apache.org/jira/browse/CLOUDSTACK-7542) | CreateNetworkCmd and CreateNetworkCmdByAdmin both have their own "vlan" paramete...
[CLOUDSTACK-7540](https://issues.apache.org/jira/browse/CLOUDSTACK-7540) | S2SVpnConnections:CheckRouterTask is fails with NullPointer exception...
[CLOUDSTACK-7538](https://issues.apache.org/jira/browse/CLOUDSTACK-7538) | Can not remove the vm nic due to there is another vm with same internal ip havin...
[CLOUDSTACK-7536](https://issues.apache.org/jira/browse/CLOUDSTACK-7536) | user vm can get a gateway ip in case of shared network....
[CLOUDSTACK-7528](https://issues.apache.org/jira/browse/CLOUDSTACK-7528) | When AlertManager fails to sendAlert it does not log the actual issue/error...
[CLOUDSTACK-7517](https://issues.apache.org/jira/browse/CLOUDSTACK-7517) | FTP modules are not loaded in VR...
[CLOUDSTACK-7482](https://issues.apache.org/jira/browse/CLOUDSTACK-7482) | Ajax calls in mgmt UI causing log pollution...
[CLOUDSTACK-7468](https://issues.apache.org/jira/browse/CLOUDSTACK-7468) | NetScaler SSL Termination does not handle Projects as expected...
[CLOUDSTACK-7463](https://issues.apache.org/jira/browse/CLOUDSTACK-7463) | UI: Domain Admin UI shows 'Add LDAP Users' button (should not be shown)...
[CLOUDSTACK-7417](https://issues.apache.org/jira/browse/CLOUDSTACK-7417) | Admin cannot archive or delete events for a deleted account...
[CLOUDSTACK-7412](https://issues.apache.org/jira/browse/CLOUDSTACK-7412) | Can't create proper template from VM on S3 secondary storage environment...
[CLOUDSTACK-7373](https://issues.apache.org/jira/browse/CLOUDSTACK-7373) | Incorrect Japanese keyboard mapping with CentOS CLI guestOS on VMware host...
[CLOUDSTACK-7360](https://issues.apache.org/jira/browse/CLOUDSTACK-7360) | [vmware] Add host to existing cluster fails if the cluster is using Nexus 1000v ...
[CLOUDSTACK-7344](https://issues.apache.org/jira/browse/CLOUDSTACK-7344) | VOLUME.DELETE usage event missing for VM's in ERROR state...
[CLOUDSTACK-7312](https://issues.apache.org/jira/browse/CLOUDSTACK-7312) | ISO/volume format name checking is crude and doesn't work with advanced URLs...
[CLOUDSTACK-7305](https://issues.apache.org/jira/browse/CLOUDSTACK-7305) | Hypervisor type parameter is mandatory when deploying VM using ISO...
[CLOUDSTACK-7302](https://issues.apache.org/jira/browse/CLOUDSTACK-7302) | UI: Remove Hover Interaction from breadcrumbs at top page...
[CLOUDSTACK-7293](https://issues.apache.org/jira/browse/CLOUDSTACK-7293) | UI: Validation message on login page is not user friendly...
[CLOUDSTACK-7261](https://issues.apache.org/jira/browse/CLOUDSTACK-7261) | CLONE UI - listSystemVMs API and listRouters API fail to return hypervisor prope...
[CLOUDSTACK-7260](https://issues.apache.org/jira/browse/CLOUDSTACK-7260) | Management server not responding after some time for Vmware due to Oom (cannot c...
[CLOUDSTACK-7259](https://issues.apache.org/jira/browse/CLOUDSTACK-7259) | KVM mappings for CentOS 6.x and RHEL 6.x...
[CLOUDSTACK-7250](https://issues.apache.org/jira/browse/CLOUDSTACK-7250) | [vCenter 5.5] SourceNAT,StaticNAT and Portfowrding is not working with Vmware DV...
[CLOUDSTACK-7245](https://issues.apache.org/jira/browse/CLOUDSTACK-7245) | listIsos call does not return isdynamicallyscalable in the response attributes a...
[CLOUDSTACK-7239](https://issues.apache.org/jira/browse/CLOUDSTACK-7239) | Wrong message thrown on Primary Storage addition failure in some cases...
[CLOUDSTACK-7219](https://issues.apache.org/jira/browse/CLOUDSTACK-7219) | Cannot display Cluster Settings after 4.4 Upgrade...
[CLOUDSTACK-7214](https://issues.apache.org/jira/browse/CLOUDSTACK-7214) | [LDAP] connection timeout is hardcoded to 500ms...
[CLOUDSTACK-7200](https://issues.apache.org/jira/browse/CLOUDSTACK-7200) | [LDAP] importUsersCmd for a group fails incase any member of a group is not an u...
[CLOUDSTACK-7191](https://issues.apache.org/jira/browse/CLOUDSTACK-7191) | On restartNetwork destroy the VR immediatley, instead of cleanup the rules then ...
[CLOUDSTACK-7182](https://issues.apache.org/jira/browse/CLOUDSTACK-7182) | NPE while trying to deploy VMs in parallel in isolated network...
[CLOUDSTACK-7175](https://issues.apache.org/jira/browse/CLOUDSTACK-7175) | Domain Id is exposed in error message when cross domain access is attempted when...
[CLOUDSTACK-7162](https://issues.apache.org/jira/browse/CLOUDSTACK-7162) | queryAsyncJobResult api does not return jobinstanceid...
[CLOUDSTACK-7153](https://issues.apache.org/jira/browse/CLOUDSTACK-7153) | addNicToVirtualMachine not BaseAsyncCreate but creates an entity...
[CLOUDSTACK-7144](https://issues.apache.org/jira/browse/CLOUDSTACK-7144) | No GSLB provider is available during assigning load balancing rule...
[CLOUDSTACK-7119](https://issues.apache.org/jira/browse/CLOUDSTACK-7119) | [VMware] Reset VM fails if there is a VM snapshot...
[CLOUDSTACK-7118](https://issues.apache.org/jira/browse/CLOUDSTACK-7118) | Unable to expunge vms in error state...
[CLOUDSTACK-7102](https://issues.apache.org/jira/browse/CLOUDSTACK-7102) | Volume migration fails with 'VM i-2-3-VM does not exist in VMware datacenter' ex...
[CLOUDSTACK-7078](https://issues.apache.org/jira/browse/CLOUDSTACK-7078) | CLONE - [VMWARE]System VM's are failed to start with Nexus enabled Zone ...
[CLOUDSTACK-7077](https://issues.apache.org/jira/browse/CLOUDSTACK-7077) | Quickly attaching multiple data disks to a VM fails...
[CLOUDSTACK-7072](https://issues.apache.org/jira/browse/CLOUDSTACK-7072) | [VMware] Volume attachment intermittently fails with 'A specified parameter was ...
[CLOUDSTACK-7071](https://issues.apache.org/jira/browse/CLOUDSTACK-7071) | Upgrade to 4.2 fails in case a VMware setup has multiple zones managing the same...
[CLOUDSTACK-7069](https://issues.apache.org/jira/browse/CLOUDSTACK-7069) | [VMware] VM property 'numCoresPerSocket' is supported since vSphere API 5.0...
[CLOUDSTACK-7068](https://issues.apache.org/jira/browse/CLOUDSTACK-7068) | addIpToNic not BaseAsyncCreate but creates an entity...
[CLOUDSTACK-7062](https://issues.apache.org/jira/browse/CLOUDSTACK-7062) | Creating storage pool failing with xenserver with NullPointerException...
[CLOUDSTACK-7030](https://issues.apache.org/jira/browse/CLOUDSTACK-7030) | VMWare Worker VMs left behind...
[CLOUDSTACK-7023](https://issues.apache.org/jira/browse/CLOUDSTACK-7023) | [Automation] DeleteTagsCmd failed due to "Unable to find tags by parameters spec...
[CLOUDSTACK-7012](https://issues.apache.org/jira/browse/CLOUDSTACK-7012) | [Atomation] Vcenter Hang during 4.4 automation runs...
[CLOUDSTACK-7011](https://issues.apache.org/jira/browse/CLOUDSTACK-7011) |  No logs being generated because Logs are created as root instead of cloud user...
[CLOUDSTACK-7004](https://issues.apache.org/jira/browse/CLOUDSTACK-7004) | [Automation] [KVM] Deploying a VM with rootdisksize less than the size of templa...
[CLOUDSTACK-6996](https://issues.apache.org/jira/browse/CLOUDSTACK-6996) | Adding cluster to legacy zone failed...
[CLOUDSTACK-6990](https://issues.apache.org/jira/browse/CLOUDSTACK-6990) | VM console displays blank page.AgentControlChannelException in cloud.log...
[CLOUDSTACK-6976](https://issues.apache.org/jira/browse/CLOUDSTACK-6976) | Support for "SecStorageFirewallCfgCommand" for simulator....
[CLOUDSTACK-6945](https://issues.apache.org/jira/browse/CLOUDSTACK-6945) | Null pointer exception when starting a VM that had its template deleted...
[CLOUDSTACK-6941](https://issues.apache.org/jira/browse/CLOUDSTACK-6941) | Can't choose storage for the volume, when attaching uploaded data volume to VM...
[CLOUDSTACK-6940](https://issues.apache.org/jira/browse/CLOUDSTACK-6940) | Templates cannot be downloaded from URLs without matching file extensions...
[CLOUDSTACK-6934](https://issues.apache.org/jira/browse/CLOUDSTACK-6934) | NPE at VolumeOrchestrator.java:868 during vm expunge when vm has volumes in Allo...
[CLOUDSTACK-6929](https://issues.apache.org/jira/browse/CLOUDSTACK-6929) | HAPlanner gets added into the list of regular planners...
[CLOUDSTACK-6919](https://issues.apache.org/jira/browse/CLOUDSTACK-6919) | CancelMaintenanceMode: when restart vms, don't attempt to restart user vm not ha...
[CLOUDSTACK-6918](https://issues.apache.org/jira/browse/CLOUDSTACK-6918) | CancelStorageMaintenance: Not all vms get restarted as a part of canceling maint...
[CLOUDSTACK-6915](https://issues.apache.org/jira/browse/CLOUDSTACK-6915) | Deleting dynamically added OS results in NPE for existing instances using that o...
[CLOUDSTACK-6910](https://issues.apache.org/jira/browse/CLOUDSTACK-6910) | Phase 1: tagging of test cases...
[CLOUDSTACK-6907](https://issues.apache.org/jira/browse/CLOUDSTACK-6907) | listVolumes: diskOfferingId is returned for the volume instead of service offeri...
[CLOUDSTACK-6905](https://issues.apache.org/jira/browse/CLOUDSTACK-6905) | NPE XenServerGuru.java:95 when remove the nic from the vm in Stopped state...
[CLOUDSTACK-6898](https://issues.apache.org/jira/browse/CLOUDSTACK-6898) | [Hyper-V] Open the console of a VM from CS, reboot the VM ( from CS or from insi...
[CLOUDSTACK-6892](https://issues.apache.org/jira/browse/CLOUDSTACK-6892) | Database HA Config prevents mgmt server from starting...
[CLOUDSTACK-6886](https://issues.apache.org/jira/browse/CLOUDSTACK-6886) | Cannot add SDX Netscaler device...
[CLOUDSTACK-6869](https://issues.apache.org/jira/browse/CLOUDSTACK-6869) | Public key content is overridden by template's meta data when you create a insta...
[CLOUDSTACK-6840](https://issues.apache.org/jira/browse/CLOUDSTACK-6840) | [OVS][UI] Ovs provider should not be displayed in NetworkServiceProviders if the...
[CLOUDSTACK-6821](https://issues.apache.org/jira/browse/CLOUDSTACK-6821) | Disk allocated for primary storage  remain unchanged after volume deletion ...
[CLOUDSTACK-6815](https://issues.apache.org/jira/browse/CLOUDSTACK-6815) | CallContext contains incorrect UUID for Account...
[CLOUDSTACK-6787](https://issues.apache.org/jira/browse/CLOUDSTACK-6787) | Event Bus - Publishing uuids missing in some cases...
[CLOUDSTACK-6740](https://issues.apache.org/jira/browse/CLOUDSTACK-6740) | Direct agent command throttling improvements...
[CLOUDSTACK-6718](https://issues.apache.org/jira/browse/CLOUDSTACK-6718) | [OVS][UI] Isolated network offering (non-vpc) creation page shows ovs as the ser...
[CLOUDSTACK-6691](https://issues.apache.org/jira/browse/CLOUDSTACK-6691) | NPE while assigning a VM nic primary/secondaryip to internal lb rule....
[CLOUDSTACK-6690](https://issues.apache.org/jira/browse/CLOUDSTACK-6690) | [UI] ListView while assigning VM to internal LB rule in VPC  is not valid....
[CLOUDSTACK-6666](https://issues.apache.org/jira/browse/CLOUDSTACK-6666) | UI search for vm's in port forward rules field does not work...
[CLOUDSTACK-6652](https://issues.apache.org/jira/browse/CLOUDSTACK-6652) | CLONE - [Automation] Vmware-  System's StartCommand failed with "NumberFormatExc...
[CLOUDSTACK-6631](https://issues.apache.org/jira/browse/CLOUDSTACK-6631) | unable to attach new Volume to VM...
[CLOUDSTACK-6605](https://issues.apache.org/jira/browse/CLOUDSTACK-6605) | CLONE - [Automation] jasypt decryption error is thrown after restarting console ...
[CLOUDSTACK-6594](https://issues.apache.org/jira/browse/CLOUDSTACK-6594) | Observed many DB Exception while starting MS "Can't DROP 'last_sent'; check that...
[CLOUDSTACK-6579](https://issues.apache.org/jira/browse/CLOUDSTACK-6579) | used_bytes column of storage_pool table is no longer used and should be removed...
[CLOUDSTACK-6576](https://issues.apache.org/jira/browse/CLOUDSTACK-6576) | No Error Handling while deploying GPU unsupported instances on a GPU enabled hos...
[CLOUDSTACK-6570](https://issues.apache.org/jira/browse/CLOUDSTACK-6570) | API breakage of the UpdateUser API call...
[CLOUDSTACK-6516](https://issues.apache.org/jira/browse/CLOUDSTACK-6516) | Default value of secstorage.encrypt.copy overridden...
[CLOUDSTACK-6496](https://issues.apache.org/jira/browse/CLOUDSTACK-6496) | addHost fails for XenServer with vSwitch networking...
[CLOUDSTACK-6495](https://issues.apache.org/jira/browse/CLOUDSTACK-6495) | JSVC package dependancy failures during installation  of Cloudstack Agent on RHE...
[CLOUDSTACK-6473](https://issues.apache.org/jira/browse/CLOUDSTACK-6473) | Debian 7 Virtual Router ip_conntrack_max not set at boot...
[CLOUDSTACK-6467](https://issues.apache.org/jira/browse/CLOUDSTACK-6467) | User VM state listener publishes to event bus incompletely...
[CLOUDSTACK-6465](https://issues.apache.org/jira/browse/CLOUDSTACK-6465) | vmware.reserve.mem is missing from cluster level settings ...
[CLOUDSTACK-6459](https://issues.apache.org/jira/browse/CLOUDSTACK-6459) | Unable to enable maintenance mode on a Primary storage that crashed...
[CLOUDSTACK-6445](https://issues.apache.org/jira/browse/CLOUDSTACK-6445) | Simulator enhancements...
[CLOUDSTACK-6434](https://issues.apache.org/jira/browse/CLOUDSTACK-6434) | Enable redundant virtual router to configure interval for VRRP broadcast...
[CLOUDSTACK-6433](https://issues.apache.org/jira/browse/CLOUDSTACK-6433) | Make sure redundant router would create a pair of routers when implementation...
[CLOUDSTACK-6432](https://issues.apache.org/jira/browse/CLOUDSTACK-6432) | Prevent VR from response to DNS request from outside of network...
[CLOUDSTACK-6376](https://issues.apache.org/jira/browse/CLOUDSTACK-6376) | listnetworkacls api when called with a networkid of a network which was created ...
[CLOUDSTACK-6374](https://issues.apache.org/jira/browse/CLOUDSTACK-6374) | LB rules added while router reqiuires upgrade should be removed from lb vm map...
[CLOUDSTACK-6371](https://issues.apache.org/jira/browse/CLOUDSTACK-6371) | KVM - secondary_storage count for account does not get incremted when snapshots ...
[CLOUDSTACK-6358](https://issues.apache.org/jira/browse/CLOUDSTACK-6358) | Remove hardcoded guest OS mappings...
[CLOUDSTACK-6337](https://issues.apache.org/jira/browse/CLOUDSTACK-6337) | Can't Migrate instance which use custom HA compute offering to another host...
[CLOUDSTACK-6309](https://issues.apache.org/jira/browse/CLOUDSTACK-6309) | [Automation] Router deployment failed due to "aggregated command s execution fai...
[CLOUDSTACK-6286](https://issues.apache.org/jira/browse/CLOUDSTACK-6286) | [Automation] VM deployment is failing in simulator...
[CLOUDSTACK-6271](https://issues.apache.org/jira/browse/CLOUDSTACK-6271) | Integrate Deploy DB Into windows msi installer...
[CLOUDSTACK-6228](https://issues.apache.org/jira/browse/CLOUDSTACK-6228) | Some action confirm dialogs show incorrect icon...
[CLOUDSTACK-6212](https://issues.apache.org/jira/browse/CLOUDSTACK-6212) | 'vm_instance' table has no AUTO_INCREMENT on 'id' field...
[CLOUDSTACK-6177](https://issues.apache.org/jira/browse/CLOUDSTACK-6177) | CS does XS master switch, which may cause weird XS behavior...
[CLOUDSTACK-6168](https://issues.apache.org/jira/browse/CLOUDSTACK-6168) | vm.instancename.flag inefficient...
[CLOUDSTACK-6099](https://issues.apache.org/jira/browse/CLOUDSTACK-6099) | live migration is failing for vm deployed using dynaic compute offerings with NP...
[CLOUDSTACK-6075](https://issues.apache.org/jira/browse/CLOUDSTACK-6075) | Increase the ram size for router service offering ...
[CLOUDSTACK-6036](https://issues.apache.org/jira/browse/CLOUDSTACK-6036) |  CloudStack stops the machine for no reason...
[CLOUDSTACK-5992](https://issues.apache.org/jira/browse/CLOUDSTACK-5992) | [Upgrade] default values of configuration parameters in configuration table are ...
[CLOUDSTACK-5984](https://issues.apache.org/jira/browse/CLOUDSTACK-5984) | addvmwaredc API call is not documented ...
[CLOUDSTACK-5952](https://issues.apache.org/jira/browse/CLOUDSTACK-5952) | [UI] VM ip address information is not shown after configuring static NAT...
[CLOUDSTACK-5946](https://issues.apache.org/jira/browse/CLOUDSTACK-5946) | SSL: Fail to find the generated keystore. Loading fail-safe one to continue....
[CLOUDSTACK-5910](https://issues.apache.org/jira/browse/CLOUDSTACK-5910) | mark the LDAP user as imported from LDAP...
[CLOUDSTACK-5879](https://issues.apache.org/jira/browse/CLOUDSTACK-5879) | Document on how to use RabbitMq event bus with spring modularisation done in 4.3...
[CLOUDSTACK-5853](https://issues.apache.org/jira/browse/CLOUDSTACK-5853) | cannot deploy vm with differing service storage tag and data disk storage tag...
[CLOUDSTACK-5836](https://issues.apache.org/jira/browse/CLOUDSTACK-5836) | When tried to reverting back to (disk attached)quiesced vm snapshot, got error a...
[CLOUDSTACK-5834](https://issues.apache.org/jira/browse/CLOUDSTACK-5834) | [upgrade]Error while collecting disk stats from : You gave an invalid object ref...
[CLOUDSTACK-5824](https://issues.apache.org/jira/browse/CLOUDSTACK-5824) | Delete snapshot UI always success...
[CLOUDSTACK-5809](https://issues.apache.org/jira/browse/CLOUDSTACK-5809) | Not able to deploy Vm becasue of crossing pool.storage.allocate d.capacity.disab...
[CLOUDSTACK-5800](https://issues.apache.org/jira/browse/CLOUDSTACK-5800) | While creating a VM from template (which is created based on existing newly crea...
[CLOUDSTACK-5700](https://issues.apache.org/jira/browse/CLOUDSTACK-5700) | [Vmsync] - kvm- "paused" state of Vm is not synced to CS....
[CLOUDSTACK-5673](https://issues.apache.org/jira/browse/CLOUDSTACK-5673) | [Hyper-V] Default IP address never configured on eth0 with default CentOS templa...
[CLOUDSTACK-5664](https://issues.apache.org/jira/browse/CLOUDSTACK-5664) | XEN patch/hotfix certification - after XS 6.0.2 XS602E030 patch installation VMs...
[CLOUDSTACK-5641](https://issues.apache.org/jira/browse/CLOUDSTACK-5641) | Local disk usage on host don't show up in the admin's webui...
[CLOUDSTACK-5578](https://issues.apache.org/jira/browse/CLOUDSTACK-5578) | KVM - Network down - When the host looses network connectivity , reboot stuck wh...
[CLOUDSTACK-5576](https://issues.apache.org/jira/browse/CLOUDSTACK-5576) | RemoteVPNonVPC :  Label needs to be changed to "Enable Remote Access VPN"...
[CLOUDSTACK-5482](https://issues.apache.org/jira/browse/CLOUDSTACK-5482) | Vmware - When nfs was down for about 1 hour , when snapshots were in progress , ...
[CLOUDSTACK-5469](https://issues.apache.org/jira/browse/CLOUDSTACK-5469) | Snapshot creation fails with following exception - "Failed to backup snapshot: q...
[CLOUDSTACK-5446](https://issues.apache.org/jira/browse/CLOUDSTACK-5446) | KVM-Secondary Store down-Even after secondary store is brought back up after bei...
[CLOUDSTACK-5395](https://issues.apache.org/jira/browse/CLOUDSTACK-5395) | When backup snapshot fails becasue of backup.snapshot.wait time exceeding , the ...
[CLOUDSTACK-5359](https://issues.apache.org/jira/browse/CLOUDSTACK-5359) | Failed to add second VMWARE cluster on a standard vSwitch enabled zone when vCen...
[CLOUDSTACK-5324](https://issues.apache.org/jira/browse/CLOUDSTACK-5324) | error message not proper when start VM  fails because router requires upgrade...
[CLOUDSTACK-5309](https://issues.apache.org/jira/browse/CLOUDSTACK-5309) | version number and requires upgrade fields are not displayed for routers when na...
[CLOUDSTACK-5241](https://issues.apache.org/jira/browse/CLOUDSTACK-5241) | ROT13 usage...
[CLOUDSTACK-4770](https://issues.apache.org/jira/browse/CLOUDSTACK-4770) | Management server fails to start with "Unable to get the management server node"...
[CLOUDSTACK-4665](https://issues.apache.org/jira/browse/CLOUDSTACK-4665) | ceph:delete volume fails with ArrayIndexOutOfBoundsException...
[CLOUDSTACK-4587](https://issues.apache.org/jira/browse/CLOUDSTACK-4587) | VM is failing to deploy on a Legacy zone after adding zone wide primary storage ...
[CLOUDSTACK-4451](https://issues.apache.org/jira/browse/CLOUDSTACK-4451) | associateIPaddress requires zone id but apidoc says it's optional...
[CLOUDSTACK-4364](https://issues.apache.org/jira/browse/CLOUDSTACK-4364) | Restore VM - needs to log usage event for volume...
[CLOUDSTACK-4351](https://issues.apache.org/jira/browse/CLOUDSTACK-4351) | [DOC] 4.3.2. Host/Hypervisor System Requirements has misleading  or premature no...
[CLOUDSTACK-4322](https://issues.apache.org/jira/browse/CLOUDSTACK-4322) | Delete domain with force option is not returning failed as response incase of ac...
[CLOUDSTACK-4292](https://issues.apache.org/jira/browse/CLOUDSTACK-4292) | ceph:destroyedvm failed with ArrayIndexexception while expunging...
[CLOUDSTACK-4200](https://issues.apache.org/jira/browse/CLOUDSTACK-4200) | listSystemVMs API and listRouters API fail to return hypervisor property ...
[CLOUDSTACK-3995](https://issues.apache.org/jira/browse/CLOUDSTACK-3995) | No error notification is generated when Primary storage (Zonelevel) is added wit...
[CLOUDSTACK-3815](https://issues.apache.org/jira/browse/CLOUDSTACK-3815) | "SNAPSHOT.CREATE" event's states are not registered on the events table ...
[CLOUDSTACK-3608](https://issues.apache.org/jira/browse/CLOUDSTACK-3608) | "guest_os_hypervisor" table has repeated mappings of hypervisor and guest OS...
[CLOUDSTACK-3607](https://issues.apache.org/jira/browse/CLOUDSTACK-3607) | "guest_os_hypervisor" table has values that are not registered in "guest_os" tab...
[CLOUDSTACK-2625](https://issues.apache.org/jira/browse/CLOUDSTACK-2625) | Duplicate usage records when listing large number of records...
[CLOUDSTACK-1990](https://issues.apache.org/jira/browse/CLOUDSTACK-1990) | Docs: Update "Choosing a Hypervisor" feature matrix with new info...
[CLOUDSTACK-315](https://issues.apache.org/jira/browse/CLOUDSTACK-315)   | Infrastructure view does not show capacity values...

Version 4.4.2
-------------

This maintenance release has the following bug fixes:

Bug ID | Description
--- | ---
[CLOUDSTACK-7952](https://issues.apache.org/jira/browse/CLOUDSTACK-7952) | listSslCerts returns private key...
[CLOUDSTACK-7906](https://issues.apache.org/jira/browse/CLOUDSTACK-7906) | certificate tests fail in CertServiceTest.java...
[CLOUDSTACK-7887](https://issues.apache.org/jira/browse/CLOUDSTACK-7887) | fail to push snapshot to secondary storage if using multipart using swift...
[CLOUDSTACK-7883](https://issues.apache.org/jira/browse/CLOUDSTACK-7883) | Allow infrastructure to handle delete of volume from DB...
[CLOUDSTACK-7871](https://issues.apache.org/jira/browse/CLOUDSTACK-7871) | Fix update VirtualMachine/Template API to allow nic/disk controller details for ...
[CLOUDSTACK-7855](https://issues.apache.org/jira/browse/CLOUDSTACK-7855) | Sec storage/network MTU should be on nic3 and not nic1...
[CLOUDSTACK-7826](https://issues.apache.org/jira/browse/CLOUDSTACK-7826) | UI - dialog widget - dependent dropdown field (dependsOn property specified) - f...
[CLOUDSTACK-7822](https://issues.apache.org/jira/browse/CLOUDSTACK-7822) | test SSL cert expired...
[CLOUDSTACK-7752](https://issues.apache.org/jira/browse/CLOUDSTACK-7752) | Management Server goes in infinite loop while creating a vm with tagged local da...
[CLOUDSTACK-7722](https://issues.apache.org/jira/browse/CLOUDSTACK-7722) | add.label: Add button for tags show the label not "Add" text...
[CLOUDSTACK-7246](https://issues.apache.org/jira/browse/CLOUDSTACK-7246) | VM deployment failed due to wrong in  script name createipalias.sh...

Version 4.4.1
-------------

This maintenance release has the following bug fixes:

Bug ID | Description
--- | ---
[CLOUDSTACK-7624](https://issues.apache.org/jira/browse/CLOUDSTACK-7624) | Long hostnames cause CloudStack to die with an encryption error during startup...
[CLOUDSTACK-7574](https://issues.apache.org/jira/browse/CLOUDSTACK-7574) | Fail to create Windows 2012r2 VM with OS type: Windows Server 2012 R2 (64-bit)...
[CLOUDSTACK-7538](https://issues.apache.org/jira/browse/CLOUDSTACK-7538) | Can not remove the vm nic due to there is another vm with same internal ip havin...
[CLOUDSTACK-7528](https://issues.apache.org/jira/browse/CLOUDSTACK-7528) | When AlertManager fails to sendAlert it does not log the actual issue/error...
[CLOUDSTACK-7468](https://issues.apache.org/jira/browse/CLOUDSTACK-7468) | NetScaler SSL Termination does not handle Projects as expected...
[CLOUDSTACK-7357](https://issues.apache.org/jira/browse/CLOUDSTACK-7357) | CLONE - Failed to stop VPC router with NPE...
[CLOUDSTACK-7356](https://issues.apache.org/jira/browse/CLOUDSTACK-7356) | CLONE - NPE XenServerGuru.java:95 when remove the nic from the vm in Stopped sta...
[CLOUDSTACK-7340](https://issues.apache.org/jira/browse/CLOUDSTACK-7340) | Instances unable to reach internet using SG provider and KVM...
[CLOUDSTACK-7309](https://issues.apache.org/jira/browse/CLOUDSTACK-7309) | NPE when project was already deleted...
[CLOUDSTACK-7257](https://issues.apache.org/jira/browse/CLOUDSTACK-7257) | CLONE - system VM  not coming up in LXC zone for rhel 6.x ...
[CLOUDSTACK-7225](https://issues.apache.org/jira/browse/CLOUDSTACK-7225) | SystemVM paused in a new 4.4.0 installation...
[CLOUDSTACK-7219](https://issues.apache.org/jira/browse/CLOUDSTACK-7219) | Cannot display Cluster Settings after 4.4 Upgrade...
[CLOUDSTACK-7193](https://issues.apache.org/jira/browse/CLOUDSTACK-7193) | Rebooting a VM doesn't update iptables rules...
[CLOUDSTACK-7140](https://issues.apache.org/jira/browse/CLOUDSTACK-7140) | Upgrade 4.2.1 -> 4.4.0rc2...
[CLOUDSTACK-7006](https://issues.apache.org/jira/browse/CLOUDSTACK-7006) | Template ID is missing in ROOT volume usages...
[CLOUDSTACK-6892](https://issues.apache.org/jira/browse/CLOUDSTACK-6892) | Database HA Config prevents mgmt server from starting...
[CLOUDSTACK-6886](https://issues.apache.org/jira/browse/CLOUDSTACK-6886) | Cannot add SDX Netscaler device...
[CLOUDSTACK-6358](https://issues.apache.org/jira/browse/CLOUDSTACK-6358) | Remove hardcoded guest OS mappings...
[CLOUDSTACK-6323](https://issues.apache.org/jira/browse/CLOUDSTACK-6323) | GetUser API always returns admin info...
[CLOUDSTACK-6099](https://issues.apache.org/jira/browse/CLOUDSTACK-6099) | live migration is failing for vm deployed using dynaic compute offerings with NP...
[CLOUDSTACK-6039](https://issues.apache.org/jira/browse/CLOUDSTACK-6039) | systemvm template for VMWare with jre7...
[CLOUDSTACK-4770](https://issues.apache.org/jira/browse/CLOUDSTACK-4770) | Management server fails to start with "Unable to get the management server node"...
[CLOUDSTACK-3822](https://issues.apache.org/jira/browse/CLOUDSTACK-3822) | Document all types of resource limits...
[CLOUDSTACK-1632](https://issues.apache.org/jira/browse/CLOUDSTACK-1632) | Mistakes in authorizeSecurityGroup* API docs...
[CLOUDSTACK-401](https://issues.apache.org/jira/browse/CLOUDSTACK-401)   | Storage options missing from table...

Version 4.4.0
-------------

This major release has the following bug fixes:

Bug ID | Description
--- | ---
[CLOUDSTACK-6997](https://issues.apache.org/jira/browse/CLOUDSTACK-6997) | conntrack set to a very low value on router...
[CLOUDSTACK-6996](https://issues.apache.org/jira/browse/CLOUDSTACK-6996) | Adding cluster to legacy zone failed...
[CLOUDSTACK-6989](https://issues.apache.org/jira/browse/CLOUDSTACK-6989) | Redunant virtual router(RvR): When time synced by ntpd, RvR may result in FAULT ...
[CLOUDSTACK-6941](https://issues.apache.org/jira/browse/CLOUDSTACK-6941) | Can't choose storage for the volume, when attaching uploaded data volume to VM...
[CLOUDSTACK-6925](https://issues.apache.org/jira/browse/CLOUDSTACK-6925) | [OVS] get rid custom logic to create bridges on hosts in the XenServer pool...
[CLOUDSTACK-6908](https://issues.apache.org/jira/browse/CLOUDSTACK-6908) | ipv6 enabled by default...
[CLOUDSTACK-6899](https://issues.apache.org/jira/browse/CLOUDSTACK-6899) | listNics doesn't have vm id in response but does take vm id as a param...
[CLOUDSTACK-6869](https://issues.apache.org/jira/browse/CLOUDSTACK-6869) | Public key content is overridden by template's meta data when you create a insta...
[CLOUDSTACK-6859](https://issues.apache.org/jira/browse/CLOUDSTACK-6859) | Management Server PermGen run out of memory after some time due to class leak....
[CLOUDSTACK-6850](https://issues.apache.org/jira/browse/CLOUDSTACK-6850) | Cpu cores, cpu speed and memory are not returned by listUsageRecords...
[CLOUDSTACK-6816](https://issues.apache.org/jira/browse/CLOUDSTACK-6816) | cloudstack-setup-management make /root directory's permission 0777  improperly...
[CLOUDSTACK-6756](https://issues.apache.org/jira/browse/CLOUDSTACK-6756) | usage id is not being returned for an ip in deleted ip range...
[CLOUDSTACK-6743](https://issues.apache.org/jira/browse/CLOUDSTACK-6743) | Race condition situation in MessageDetector may cause a outer tight loop to spin...
[CLOUDSTACK-6714](https://issues.apache.org/jira/browse/CLOUDSTACK-6714) | Service monitoring conf is has issue with script in vmware...
[CLOUDSTACK-6665](https://issues.apache.org/jira/browse/CLOUDSTACK-6665) | DHCP does not release ip addresses properly on VPC routers (edithosts.sh)...
[CLOUDSTACK-6646](https://issues.apache.org/jira/browse/CLOUDSTACK-6646) | Conntrackd is started on non-redundant virtual router...
[CLOUDSTACK-6578](https://issues.apache.org/jira/browse/CLOUDSTACK-6578) | DeleteRemoteAccessVpnCmd failed block enable Remote VPN access again on the IP a...
[CLOUDSTACK-6577](https://issues.apache.org/jira/browse/CLOUDSTACK-6577) | Disable service monitoring in RVR...
[CLOUDSTACK-6509](https://issues.apache.org/jira/browse/CLOUDSTACK-6509) | Cannot import multiple LDAP/AD users into a cloudstack account...
[CLOUDSTACK-6478](https://issues.apache.org/jira/browse/CLOUDSTACK-6478) | Failed to download Template when having 3 SSVM's in one zone on Vmware...
[CLOUDSTACK-6472](https://issues.apache.org/jira/browse/CLOUDSTACK-6472) | listUsageRecords generates NPEs for expunging instances...
[CLOUDSTACK-6471](https://issues.apache.org/jira/browse/CLOUDSTACK-6471) | Add logs to better diagnose failures and errors in LDAP AD integration...
[CLOUDSTACK-6396](https://issues.apache.org/jira/browse/CLOUDSTACK-6396) | KVM RBD Volumes shown as OVM, prevents snapshots...
[CLOUDSTACK-6376](https://issues.apache.org/jira/browse/CLOUDSTACK-6376) | listnetworkacls api when called with a networkid of a network which was created ...
[CLOUDSTACK-6374](https://issues.apache.org/jira/browse/CLOUDSTACK-6374) | LB rules added while router reqiuires upgrade should be removed from lb vm map...
[CLOUDSTACK-6371](https://issues.apache.org/jira/browse/CLOUDSTACK-6371) | KVM - secondary_storage count for account does not get incremted when snapshots ...
[CLOUDSTACK-6358](https://issues.apache.org/jira/browse/CLOUDSTACK-6358) | Remove hardcoded guest OS mappings...
[CLOUDSTACK-6356](https://issues.apache.org/jira/browse/CLOUDSTACK-6356) | OVS: tunnel networks does not work across the XenServer clusers...
[CLOUDSTACK-6328](https://issues.apache.org/jira/browse/CLOUDSTACK-6328) | Prevent console proxy support scripts from spawning multiple java processes...
[CLOUDSTACK-6322](https://issues.apache.org/jira/browse/CLOUDSTACK-6322) | Contrail: Params validation is missing while launching a service instance thru c...
[CLOUDSTACK-6319](https://issues.apache.org/jira/browse/CLOUDSTACK-6319) | Cannot create OVS network offering for VPC...
[CLOUDSTACK-6317](https://issues.apache.org/jira/browse/CLOUDSTACK-6317) | [VMware] Tagged VLAN support broken for Management/Control/Storage traffic...
[CLOUDSTACK-6299](https://issues.apache.org/jira/browse/CLOUDSTACK-6299) | GetVMPassword decypher instructions are wrong...
[CLOUDSTACK-6289](https://issues.apache.org/jira/browse/CLOUDSTACK-6289) | [Hyper-V] Storage migration failing in case of hyper-v if there are multiple dis...
[CLOUDSTACK-6288](https://issues.apache.org/jira/browse/CLOUDSTACK-6288) | [Hyper-v] Change default ImageFormat to vhdx for hyper-v and allow registration ...
[CLOUDSTACK-6285](https://issues.apache.org/jira/browse/CLOUDSTACK-6285) | Some passwords in the VR would be cleared out by accident due to falsely match i...
[CLOUDSTACK-6277](https://issues.apache.org/jira/browse/CLOUDSTACK-6277) | Fail to add instance, the Network and Review steps display as blank pages....
[CLOUDSTACK-6269](https://issues.apache.org/jira/browse/CLOUDSTACK-6269) | [Simulator]: Exception "Unable to send command. Upgrade in progress. Please cont...
[CLOUDSTACK-6245](https://issues.apache.org/jira/browse/CLOUDSTACK-6245) | Security group rules on hypervisor host are lagging behind rules in DB...
[CLOUDSTACK-6241](https://issues.apache.org/jira/browse/CLOUDSTACK-6241) | Dnsmasq programming error when deploy IPv6 and IPv4 in one VM with IPv4 as defau...
[CLOUDSTACK-6236](https://issues.apache.org/jira/browse/CLOUDSTACK-6236) | Negative ref_cnt of template(snapshot/volume)_store_ref results in out-of-range ...
[CLOUDSTACK-6232](https://issues.apache.org/jira/browse/CLOUDSTACK-6232) | isolated network can no longer reserve ip range...
[CLOUDSTACK-6231](https://issues.apache.org/jira/browse/CLOUDSTACK-6231) | Cloudstack createNetworkACL cuts cidrlist at 256 characters...
[CLOUDSTACK-6227](https://issues.apache.org/jira/browse/CLOUDSTACK-6227) | Add copy-paste support for detail view fields...
[CLOUDSTACK-6224](https://issues.apache.org/jira/browse/CLOUDSTACK-6224) | VM Snapshot inconsistent size...
[CLOUDSTACK-6223](https://issues.apache.org/jira/browse/CLOUDSTACK-6223) | removeNicFromVirtualMachine fails if another instance in another domain has a ni...
[CLOUDSTACK-6211](https://issues.apache.org/jira/browse/CLOUDSTACK-6211) | Xenserver - HA - SSVM fails to start due to running out of management Ip ranges ...
[CLOUDSTACK-6210](https://issues.apache.org/jira/browse/CLOUDSTACK-6210) | LDAP:listLdapUsers api throws exception when we click on "Add LDAP Account" ...
[CLOUDSTACK-6196](https://issues.apache.org/jira/browse/CLOUDSTACK-6196) | Fixed invalid field name (label.dynamically.scalable) on instance details....
[CLOUDSTACK-6192](https://issues.apache.org/jira/browse/CLOUDSTACK-6192) | KVM: StartCommand and PrepareForMigrationCommand don't fail if storage adaptor f...
[CLOUDSTACK-6187](https://issues.apache.org/jira/browse/CLOUDSTACK-6187) | Migrate router from UI is showing error...
[CLOUDSTACK-6183](https://issues.apache.org/jira/browse/CLOUDSTACK-6183) | Unplug the nic when all the ips of public subnet is released...
[CLOUDSTACK-6172](https://issues.apache.org/jira/browse/CLOUDSTACK-6172) | Volume is not retaining same uuid when migrating from one storage to another....
[CLOUDSTACK-6159](https://issues.apache.org/jira/browse/CLOUDSTACK-6159) | [Hyper-v]Attached data volumes are getting created with disk name in primary sto...
[CLOUDSTACK-6151](https://issues.apache.org/jira/browse/CLOUDSTACK-6151) | Local data disk with tag goes to the wrong local storage pool...
[CLOUDSTACK-6124](https://issues.apache.org/jira/browse/CLOUDSTACK-6124) | During MS maintenance unfinished work items are not cleaned up resulting in them...
[CLOUDSTACK-6103](https://issues.apache.org/jira/browse/CLOUDSTACK-6103) | vms with isos attached don't migrate...
[CLOUDSTACK-6062](https://issues.apache.org/jira/browse/CLOUDSTACK-6062) | nic device ids for routers don't always correspond...
[CLOUDSTACK-6053](https://issues.apache.org/jira/browse/CLOUDSTACK-6053) | While adding smb as primary or secondary the password should be uri encoded...
[CLOUDSTACK-6032](https://issues.apache.org/jira/browse/CLOUDSTACK-6032) | [VmScaleup]service offering id is not getting changed in usage_vm_instance table...
[CLOUDSTACK-6024](https://issues.apache.org/jira/browse/CLOUDSTACK-6024) | template copy to primary storage uses a random source secstorage from any zone...
[CLOUDSTACK-6011](https://issues.apache.org/jira/browse/CLOUDSTACK-6011) | NPE when detach is called on a deleted volume...
[CLOUDSTACK-6000](https://issues.apache.org/jira/browse/CLOUDSTACK-6000) | Volume lifecycle, stuck in expunging...
[CLOUDSTACK-5998](https://issues.apache.org/jira/browse/CLOUDSTACK-5998) | [AWSAPI] describe addresses call returns a fault with "domain cannot be null!!"...
[CLOUDSTACK-5995](https://issues.apache.org/jira/browse/CLOUDSTACK-5995) | change service offering is not honouring host tags ...
[CLOUDSTACK-5993](https://issues.apache.org/jira/browse/CLOUDSTACK-5993) | Cloud agent fails to start on 32-bit system vms (cpvm and ssvm) created with 4GB...
[CLOUDSTACK-5989](https://issues.apache.org/jira/browse/CLOUDSTACK-5989) | Trying to start a vm while 'vm snapshot' is in progress results in inconsistency...
[CLOUDSTACK-5976](https://issues.apache.org/jira/browse/CLOUDSTACK-5976) | [upgrade]Typo in "ssh_keypairs" table's foreign key constraints on the Upgraded ...
[CLOUDSTACK-5965](https://issues.apache.org/jira/browse/CLOUDSTACK-5965) | VM displayname is not returned by API...
[CLOUDSTACK-5962](https://issues.apache.org/jira/browse/CLOUDSTACK-5962) | Value of Global parameter "custom.diskoffering.size.min" is not reflected in UI ...
[CLOUDSTACK-5961](https://issues.apache.org/jira/browse/CLOUDSTACK-5961) | CLONE - API: synchronization on the object is broken...
[CLOUDSTACK-5960](https://issues.apache.org/jira/browse/CLOUDSTACK-5960) | Domain admin or user cannot register a template using S3/Swift object store...
[CLOUDSTACK-5936](https://issues.apache.org/jira/browse/CLOUDSTACK-5936) | Hyper-V agent should log to windows event viewer...
[CLOUDSTACK-5935](https://issues.apache.org/jira/browse/CLOUDSTACK-5935) | Problem with VMware snapshot when datastore has a space in its name...
[CLOUDSTACK-5934](https://issues.apache.org/jira/browse/CLOUDSTACK-5934) | Problem with VMware snapshot when datastore has a space in its name...
[CLOUDSTACK-5929](https://issues.apache.org/jira/browse/CLOUDSTACK-5929) | [VM Sync] - Vmware - Even when starting Vm fails, startVirtualMachine async job ...
[CLOUDSTACK-5928](https://issues.apache.org/jira/browse/CLOUDSTACK-5928) | [VM Sync] - Vmware - When a Vm is "suspended" from outside of CloudStack , this ...
[CLOUDSTACK-5915](https://issues.apache.org/jira/browse/CLOUDSTACK-5915) |  [AWSAPI] Instance launch is inconsistent if there are deleted service offerings...
[CLOUDSTACK-5891](https://issues.apache.org/jira/browse/CLOUDSTACK-5891) | [VMware] Template detail cpu.corespersocket's value is not honoured...
[CLOUDSTACK-5870](https://issues.apache.org/jira/browse/CLOUDSTACK-5870) | API support for retrieving UserData...
[CLOUDSTACK-5865](https://issues.apache.org/jira/browse/CLOUDSTACK-5865) | Unable to use login API if domainId parameter is id and not uuid...
[CLOUDSTACK-5845](https://issues.apache.org/jira/browse/CLOUDSTACK-5845) | [doc] Document Heterogeneous Secondary Storage Not Supported in Region...
[CLOUDSTACK-5839](https://issues.apache.org/jira/browse/CLOUDSTACK-5839) | listNetworkServiceProviders API doesn't return several parameters defined in the...
[CLOUDSTACK-5826](https://issues.apache.org/jira/browse/CLOUDSTACK-5826) | createPod: passing invalid gateway/netmask to the call causes infinite loop exec...
[CLOUDSTACK-5821](https://issues.apache.org/jira/browse/CLOUDSTACK-5821) | systemvmiso is locked by systevmvm in hyperv...
[CLOUDSTACK-5812](https://issues.apache.org/jira/browse/CLOUDSTACK-5812) | Secondary ip allocation in Basic zone - the pod is not respected...
[CLOUDSTACK-5810](https://issues.apache.org/jira/browse/CLOUDSTACK-5810) | addIpToNic: the owner of the secondary ip should be derived from vmInstance obje...
[CLOUDSTACK-5806](https://issues.apache.org/jira/browse/CLOUDSTACK-5806) | Storage types other than NFS/VMFS can't overprovision...
[CLOUDSTACK-5785](https://issues.apache.org/jira/browse/CLOUDSTACK-5785) | VM display name cell not updated upon detaching volume from VM...
[CLOUDSTACK-5770](https://issues.apache.org/jira/browse/CLOUDSTACK-5770) | [Automation] Unexpected Exception while executing DeployVMCmd: StreamCorruptedEx...
[CLOUDSTACK-5765](https://issues.apache.org/jira/browse/CLOUDSTACK-5765) | [Automation] scale vm failed with error "Unable to serialize"...
[CLOUDSTACK-5731](https://issues.apache.org/jira/browse/CLOUDSTACK-5731) | [Automation] VM deployment failed with ConcurrentOperationException in vmware...
[CLOUDSTACK-5729](https://issues.apache.org/jira/browse/CLOUDSTACK-5729) | [Automation]Deletion of a Account reported Success inspite of VM Expunge Failure...
[CLOUDSTACK-5728](https://issues.apache.org/jira/browse/CLOUDSTACK-5728) | [Automation] ReplaceNetworkACLListCmd command failing with NPE...
[CLOUDSTACK-5727](https://issues.apache.org/jira/browse/CLOUDSTACK-5727) | [Automation] Inspite of VM Deployment Failure, the job reports success...
[CLOUDSTACK-5712](https://issues.apache.org/jira/browse/CLOUDSTACK-5712) | [Automation] Failed to stop vm during vm destroy command, observed the error "Un...
[CLOUDSTACK-5696](https://issues.apache.org/jira/browse/CLOUDSTACK-5696) | [Vmsync]- Stopped state of VM is not synced to CS when VM is stopped outside of ...
[CLOUDSTACK-5688](https://issues.apache.org/jira/browse/CLOUDSTACK-5688) | NPE when the KVM host is rebooted  on the upgraded environment...
[CLOUDSTACK-5685](https://issues.apache.org/jira/browse/CLOUDSTACK-5685) | [Vmsync] - When VR is rebooted outside of cloudstack , there is no change in sta...
[CLOUDSTACK-5678](https://issues.apache.org/jira/browse/CLOUDSTACK-5678) | Cold Storage migration is failing...
[CLOUDSTACK-5660](https://issues.apache.org/jira/browse/CLOUDSTACK-5660) | Migrate vm live migration succeeds but throws error as ""Failed to migrate the s...
[CLOUDSTACK-5632](https://issues.apache.org/jira/browse/CLOUDSTACK-5632) | [Automation] XenServer - Template deletion fails with error "Please specify a te...
[CLOUDSTACK-5597](https://issues.apache.org/jira/browse/CLOUDSTACK-5597) | attachVolume shouldn't create the volume on the primary storage if the vm's root...
[CLOUDSTACK-5582](https://issues.apache.org/jira/browse/CLOUDSTACK-5582) | kvm - HA is not triggered when host is powered down since the host gets into "Di...
[CLOUDSTACK-5577](https://issues.apache.org/jira/browse/CLOUDSTACK-5577) | Remote Access VPN and S2S VPN should be treated as two separate services for Net...
[CLOUDSTACK-5575](https://issues.apache.org/jira/browse/CLOUDSTACK-5575) | Remote Access VPN and S2S VPN should be treated as two separate services on VPC...
[CLOUDSTACK-5563](https://issues.apache.org/jira/browse/CLOUDSTACK-5563) | path field is set to null in volumes table ...
[CLOUDSTACK-5505](https://issues.apache.org/jira/browse/CLOUDSTACK-5505) | [Automation] Private gateway not getting programmed in VPC router ...
[CLOUDSTACK-5501](https://issues.apache.org/jira/browse/CLOUDSTACK-5501) | Unable to create more than one vpnConnection per vpn customer gateway...
[CLOUDSTACK-5496](https://issues.apache.org/jira/browse/CLOUDSTACK-5496) | Account included in ActionEvents is Project Account ID...
[CLOUDSTACK-5463](https://issues.apache.org/jira/browse/CLOUDSTACK-5463) | Hyper-V does not report stopped VMs...
[CLOUDSTACK-5429](https://issues.apache.org/jira/browse/CLOUDSTACK-5429) | KVM - Primary store down/Network Failure - Hosts attempt to reboot becasue of pr...
[CLOUDSTACK-5419](https://issues.apache.org/jira/browse/CLOUDSTACK-5419) | missing parameters in configuration table and to remove unused parameters...
[CLOUDSTACK-5356](https://issues.apache.org/jira/browse/CLOUDSTACK-5356) | Xenserver - Failed to create snapshot when secondary store was made unavaibale f...
[CLOUDSTACK-5262](https://issues.apache.org/jira/browse/CLOUDSTACK-5262) | Few of  the snapshot creation from ROOT volume fails when there are concurrent s...
[CLOUDSTACK-5220](https://issues.apache.org/jira/browse/CLOUDSTACK-5220) | NullPointerException when invalid zone is passed into UsageEventUtils...
[CLOUDSTACK-5205](https://issues.apache.org/jira/browse/CLOUDSTACK-5205) | System vm startup scripts calculate jvm memory wrong...
[CLOUDSTACK-5150](https://issues.apache.org/jira/browse/CLOUDSTACK-5150) | Creating template from a VM in Simulator results in incorrect size...
[CLOUDSTACK-5062](https://issues.apache.org/jira/browse/CLOUDSTACK-5062) | Deleting Load Balancing Rule fails when generating usage events are enabled...
[CLOUDSTACK-5043](https://issues.apache.org/jira/browse/CLOUDSTACK-5043) | [DOC] Page number missing and words truncated in PDFs since 4.1.1...
[CLOUDSTACK-5012](https://issues.apache.org/jira/browse/CLOUDSTACK-5012) | Bad data inserted into physical network labels for Zone Create Wizard using VMWa...
[CLOUDSTACK-4744](https://issues.apache.org/jira/browse/CLOUDSTACK-4744) | updateVolume needs more changes in the context of "Ability to have better contro...
[CLOUDSTACK-4652](https://issues.apache.org/jira/browse/CLOUDSTACK-4652) | ceph:UI:Noticed 2 records for same volume after migrating instance from one prim...
[CLOUDSTACK-4639](https://issues.apache.org/jira/browse/CLOUDSTACK-4639) | status of VM is not synced properly when host is HA  during hypervisor failure...
[CLOUDSTACK-4578](https://issues.apache.org/jira/browse/CLOUDSTACK-4578) | [vmware]SSVM is not getting created if one host down from a cluster...
[CLOUDSTACK-4568](https://issues.apache.org/jira/browse/CLOUDSTACK-4568) | Need to add this to the release note of 4.2...
[CLOUDSTACK-4557](https://issues.apache.org/jira/browse/CLOUDSTACK-4557) | ceph:Performance:first time operstions taking more time...
[CLOUDSTACK-4549](https://issues.apache.org/jira/browse/CLOUDSTACK-4549) | ceph:deployvm from template created from snapshot is failing...
[CLOUDSTACK-4292](https://issues.apache.org/jira/browse/CLOUDSTACK-4292) | ceph:destroyedvm failed with ArrayIndexexception while expunging...
[CLOUDSTACK-4126](https://issues.apache.org/jira/browse/CLOUDSTACK-4126) | EN:  Typo error after click "Migrate instance to another host" button under inst...
[CLOUDSTACK-3994](https://issues.apache.org/jira/browse/CLOUDSTACK-3994) | Wrong error notification is generated when Primary storage (Cluster wide) is add...
[CLOUDSTACK-2932](https://issues.apache.org/jira/browse/CLOUDSTACK-2932) | Allow deleting of snapshots that have errored out....
[CLOUDSTACK-2714](https://issues.apache.org/jira/browse/CLOUDSTACK-2714) | Setting tab should not be visible for user accounts ...
[CLOUDSTACK-2697](https://issues.apache.org/jira/browse/CLOUDSTACK-2697) | cluster id in alert message is null {alertType:: 1 // dataCenterId:: 1 // podId:...
[CLOUDSTACK-2031](https://issues.apache.org/jira/browse/CLOUDSTACK-2031) | [mipn] support for number of ips per nic limit needs to be added for the multipl...

Version 4.3.1
-------------

This maintenance release has the following bug fixes:

Bug ID | Description
--- | ---
[CLOUDSTACK-6099](https://issues.apache.org/jira/browse/CLOUDSTACK-6099) | live migration is failing for vm deployed using dynamic compute offerings with NPE
[CLOUDSTACK-7528](https://issues.apache.org/jira/browse/CLOUDSTACK-7528) | More verbose logging when sending alert fails
[CLOUDSTACK-6624](https://issues.apache.org/jira/browse/CLOUDSTACK-6624) | set specifyIpRanges to true if specifyVlan is set to true
[CLOUDSTACK-7404](https://issues.apache.org/jira/browse/CLOUDSTACK-7404) | Failed to start an instance when originating template has been deleted
[CLOUDSTACK-6531](https://issues.apache.org/jira/browse/CLOUDSTACK-6531) | Stopping the router in case of command failures
[CLOUDSTACK-6115](https://issues.apache.org/jira/browse/CLOUDSTACK-6115) | TravisCI configuration
[CLOUDSTACK-7405](https://issues.apache.org/jira/browse/CLOUDSTACK-7405) | allowing VR meta-data to be accessed without trailing slash
[CLOUDSTACK-7260](https://issues.apache.org/jira/browse/CLOUDSTACK-7260) | Management server not responding after some time for Vmware due to Oom
[CLOUDSTACK-7038](https://issues.apache.org/jira/browse/CLOUDSTACK-7038) | Add mysql client dependency for mgmt server pkg for debian
[CLOUDSTACK-6892](https://issues.apache.org/jira/browse/CLOUDSTACK-6892) | Create separate package for the mysql HA component
[CLOUDSTACK-7038](https://issues.apache.org/jira/browse/CLOUDSTACK-7038) | Add mysql client dependency for mgmt server/rpms
[CLOUDSTACK-7193](https://issues.apache.org/jira/browse/CLOUDSTACK-7193) | handle domain ID being an int
[CLOUDSTACK-7309](https://issues.apache.org/jira/browse/CLOUDSTACK-7309) | using findProjectByProjectAccountIdIncludingRemoved
[CLOUDSTACK-6886](https://issues.apache.org/jira/browse/CLOUDSTACK-6886) | Fixed the issue created by the SSL feature with the SDX:
[CLOUDSTACK-6508](https://issues.apache.org/jira/browse/CLOUDSTACK-6508) | impossible to list projects from API with domainid set
[CLOUDSTACK-4725](https://issues.apache.org/jira/browse/CLOUDSTACK-4725) | if storage pool has different path, but the uuid is the same
[CLOUDSTACK-7087](https://issues.apache.org/jira/browse/CLOUDSTACK-7087) | Latest OS X VPN client not working Downgrading openswan version to 1:2.6.37-3
[CLOUDSTACK-6926](https://issues.apache.org/jira/browse/CLOUDSTACK-6926) | removed hard coded jdk dirs and setting java home using readlink and dirname
[CLOUDSTACK-6665](https://issues.apache.org/jira/browse/CLOUDSTACK-6665) | A fix for vpc routers not releasing dhcp leases.
[CLOUDSTACK-7006](https://issues.apache.org/jira/browse/CLOUDSTACK-7006) | Restore template ID in ROOT volume usages
[CLOUDSTACK-6747](https://issues.apache.org/jira/browse/CLOUDSTACK-6747) | test to allow all cidrs on other end of vpc
[CLOUDSTACK-6272](https://issues.apache.org/jira/browse/CLOUDSTACK-6272) | Fix recover/restore VM actions
[CLOUDSTACK-6927](https://issues.apache.org/jira/browse/CLOUDSTACK-6927) | store virsh list in list instead of querying libvirt
[CLOUDSTACK-6317](https://issues.apache.org/jira/browse/CLOUDSTACK-6317) | [VMware] Tagged VLAN support broken for Management/Control/Storage traffic
[CLOUDSTACK-5891](https://issues.apache.org/jira/browse/CLOUDSTACK-5891) | [VMware] If a template has been registered and "cpu.corespersocket=X" ,
[CLOUDSTACK-6478](https://issues.apache.org/jira/browse/CLOUDSTACK-6478) | Failed to download Template when having 3 SSVM's in one
[CLOUDSTACK-6464](https://issues.apache.org/jira/browse/CLOUDSTACK-6464) | if guest network type is vlan://untagged, and traffic label is used
[CLOUDSTACK-6816](https://issues.apache.org/jira/browse/CLOUDSTACK-6816) | bugfix: cloudstack-setup-management make /root directory's permission 0777
[CLOUDSTACK-6204](https://issues.apache.org/jira/browse/CLOUDSTACK-6204) | applying missed patch
[CLOUDSTACK-6472](https://issues.apache.org/jira/browse/CLOUDSTACK-6472) | (4.3 specific) listUsageRecords: Pull information from removed items as well
[CLOUDSTACK-5976](https://issues.apache.org/jira/browse/CLOUDSTACK-5976) | Typo in "ssh_keypairs" table's foreign key constraints on the Upgraded Setup
[CLOUDSTACK-6240](https://issues.apache.org/jira/browse/CLOUDSTACK-6240) | Fixed updating advanced SG rules for vm nic secondary ip
[CLOUDSTACK-6509](https://issues.apache.org/jira/browse/CLOUDSTACK-6509) | Cannot import multiple LDAP/AD users into a cloudstack account
[CLOUDSTACK-6485](https://issues.apache.org/jira/browse/CLOUDSTACK-6485) | private gateway network should not be associated with vpc
[CLOUDSTACK-6156](https://issues.apache.org/jira/browse/CLOUDSTACK-6156) | removing rampart maven dependencies from awsapi
[CLOUDSTACK-6433](https://issues.apache.org/jira/browse/CLOUDSTACK-6433) | Don't return success if only one of RvR successfully created
[CLOUDSTACK-6285](https://issues.apache.org/jira/browse/CLOUDSTACK-6285) | Fix savepassword.sh script for clear out old entries
[CLOUDSTACK-4665](https://issues.apache.org/jira/browse/CLOUDSTACK-4665) | Check if a snapshot is protected before trying to unprotect
[CLOUDSTACK-6375](https://issues.apache.org/jira/browse/CLOUDSTACK-6375) | suppress the prompt while installing libssl
[CLOUDSTACK-4665](https://issues.apache.org/jira/browse/CLOUDSTACK-4665) | Depend on rados-java 0.1.4
[CLOUDSTACK-6375](https://issues.apache.org/jira/browse/CLOUDSTACK-6375) | suppress the prompt while installing libssl
[CLOUDSTACK-6360](https://issues.apache.org/jira/browse/CLOUDSTACK-6360) | adding mysql-connector to class path  while starting cloudstack-usage
[CLOUDSTACK-6326](https://issues.apache.org/jira/browse/CLOUDSTACK-6326) | Fixed password visible in plain text in some of commands in Hyper-v Agent logs.
[CLOUDSTACK-6325](https://issues.apache.org/jira/browse/CLOUDSTACK-6325) | [hyper-v] fixed cleaning of bin and obj directories when building with mono.
[CLOUDSTACK-6285](https://issues.apache.org/jira/browse/CLOUDSTACK-6285) | Fix savepassword.sh script for clear out old entries
[CLOUDSTACK-6299](https://issues.apache.org/jira/browse/CLOUDSTACK-6299) | Fixed apidoc info with base64 encoded
[CLOUDSTACK-5743](https://issues.apache.org/jira/browse/CLOUDSTACK-5743) | The link generated for a volume/template gives permission error on hyper-v.

Version 4.3.0
-------------

This major release as the following bug fixes:

Bug ID | Description
--- | ---
[CLOUDSTACK-6103](https://issues.apache.org/jira/browse/CLOUDSTACK-6103) | vms with isos attached don't migrate...
[CLOUDSTACK-6089](https://issues.apache.org/jira/browse/CLOUDSTACK-6089) | resource tags show up in multiples...
[CLOUDSTACK-6046](https://issues.apache.org/jira/browse/CLOUDSTACK-6046) | CreateVolume from snapshot is failing with S3 as secondary storage and zone-wide...
[CLOUDSTACK-6040](https://issues.apache.org/jira/browse/CLOUDSTACK-6040) | Failed to configure PF on vm secondary ip for shared network...
[CLOUDSTACK-6007](https://issues.apache.org/jira/browse/CLOUDSTACK-6007) | [VMware] RestoreVM API fails with NPE...
[CLOUDSTACK-5986](https://issues.apache.org/jira/browse/CLOUDSTACK-5986) | dnsmasq racy condition result in dnsmasq failed to handout IP address...
[CLOUDSTACK-5971](https://issues.apache.org/jira/browse/CLOUDSTACK-5971) | Templates created from a snapshots can't be copied to other zones...
[CLOUDSTACK-5960](https://issues.apache.org/jira/browse/CLOUDSTACK-5960) | Domain admin or user cannot register a template using S3/Swift object store...
[CLOUDSTACK-5922](https://issues.apache.org/jira/browse/CLOUDSTACK-5922) | Incorrect handling RHEL guests ...
[CLOUDSTACK-5921](https://issues.apache.org/jira/browse/CLOUDSTACK-5921) | S3 security key is stored in DB unencrypted...
[CLOUDSTACK-5903](https://issues.apache.org/jira/browse/CLOUDSTACK-5903) | CLONE - OVA files exist for templates created from volumes...
[CLOUDSTACK-5895](https://issues.apache.org/jira/browse/CLOUDSTACK-5895) | CreateVolumeFromSnapshot can fail in a multiple pod environment with tagged stor...
[CLOUDSTACK-5886](https://issues.apache.org/jira/browse/CLOUDSTACK-5886) | 4.2.1 upgrade fails on acl migration...
[CLOUDSTACK-5877](https://issues.apache.org/jira/browse/CLOUDSTACK-5877) | listTemplates does not sort based on sort_key...
[CLOUDSTACK-5875](https://issues.apache.org/jira/browse/CLOUDSTACK-5875) | No templates in simulator run...
[CLOUDSTACK-5864](https://issues.apache.org/jira/browse/CLOUDSTACK-5864) | Simulator profile broken ...
[CLOUDSTACK-5813](https://issues.apache.org/jira/browse/CLOUDSTACK-5813) | With S3 as secondary storage, snapshot taken in one zone cannot be used to creat...
[CLOUDSTACK-5723](https://issues.apache.org/jira/browse/CLOUDSTACK-5723) | Malfunction agent may block future SSL connection to the server...
[CLOUDSTACK-5704](https://issues.apache.org/jira/browse/CLOUDSTACK-5704) | OVA files exist for templates created from volumes...
[CLOUDSTACK-5701](https://issues.apache.org/jira/browse/CLOUDSTACK-5701) | size column is not getting updated in snapshot_store_ref table....
[CLOUDSTACK-5666](https://issues.apache.org/jira/browse/CLOUDSTACK-5666) | Cant remove a nic when a vm is in the Stopped state ...
[CLOUDSTACK-5661](https://issues.apache.org/jira/browse/CLOUDSTACK-5661) | [VMware] DetachIsoCmd succeeds even though cdrom is locked by VM as cdrom is mou...
[CLOUDSTACK-5653](https://issues.apache.org/jira/browse/CLOUDSTACK-5653) | S3 object store as Secondary Storage, the template created from different zone i...
[CLOUDSTACK-5613](https://issues.apache.org/jira/browse/CLOUDSTACK-5613) | CloudStack 4.2.0 - Usage server is running but tables remain empty...
[CLOUDSTACK-5608](https://issues.apache.org/jira/browse/CLOUDSTACK-5608) | HyperV Builtin and System vm template entries missing in 4.3 upgrade setup...
[CLOUDSTACK-5534](https://issues.apache.org/jira/browse/CLOUDSTACK-5534) | MySQL exception raised when searching for users with keyword...
[CLOUDSTACK-5533](https://issues.apache.org/jira/browse/CLOUDSTACK-5533) | Virtual router in shared network does respond to DNS even when no DNS service is...
[CLOUDSTACK-5532](https://issues.apache.org/jira/browse/CLOUDSTACK-5532) | Long tag values are not readable within the UI...
[CLOUDSTACK-5519](https://issues.apache.org/jira/browse/CLOUDSTACK-5519) | [VMWARE] Cancel vCenter tasks if the task invoked by CloudStack failes with time...
[CLOUDSTACK-5517](https://issues.apache.org/jira/browse/CLOUDSTACK-5517) | NPE observed during "release portable IPs" as part of account cleanup...
[CLOUDSTACK-5514](https://issues.apache.org/jira/browse/CLOUDSTACK-5514) | Response of listAccounts API call includes removed users...
[CLOUDSTACK-5513](https://issues.apache.org/jira/browse/CLOUDSTACK-5513) | VM can't start after creating snapshot from it (CS4.2 + VMware 5.1)...
[CLOUDSTACK-5481](https://issues.apache.org/jira/browse/CLOUDSTACK-5481) | Regular User is unable to use "Add Isolated Network" Button on the UI...
[CLOUDSTACK-5466](https://issues.apache.org/jira/browse/CLOUDSTACK-5466) | removeIpFromNic not working properly...
[CLOUDSTACK-5453](https://issues.apache.org/jira/browse/CLOUDSTACK-5453) | Site-to-site VPN connection status monitoring is broken in KVM...
[CLOUDSTACK-5431](https://issues.apache.org/jira/browse/CLOUDSTACK-5431) | permit 'http' as service type for GSLB rule...
[CLOUDSTACK-5428](https://issues.apache.org/jira/browse/CLOUDSTACK-5428) | support NetScaler to be configured exclusively for GSLB service and not used for...
[CLOUDSTACK-5426](https://issues.apache.org/jira/browse/CLOUDSTACK-5426) | Cannot deploy instance having multiple volumes that use different storage tags f...
[CLOUDSTACK-5422](https://issues.apache.org/jira/browse/CLOUDSTACK-5422) | Changing  XenServer Tools Version 6.1 + doesnt work ...
[CLOUDSTACK-5417](https://issues.apache.org/jira/browse/CLOUDSTACK-5417) | On network restart for external devices egress rules configured with old CIDR...
[CLOUDSTACK-5416](https://issues.apache.org/jira/browse/CLOUDSTACK-5416) | [VMware] Not able to add seventh disk to VM in an upgraded setup...
[CLOUDSTACK-5404](https://issues.apache.org/jira/browse/CLOUDSTACK-5404) | Network usages (bytes sent/received) are saved in the wrong timezone...
[CLOUDSTACK-5401](https://issues.apache.org/jira/browse/CLOUDSTACK-5401) | VM migration during host maintenance fails if pool.storage.capacity.disablethres...
[CLOUDSTACK-5391](https://issues.apache.org/jira/browse/CLOUDSTACK-5391) | Change service offering of a stopped vm and then starting it should check host c...
[CLOUDSTACK-5355](https://issues.apache.org/jira/browse/CLOUDSTACK-5355) | addImageStore should not log password in clear text in the log...
[CLOUDSTACK-5354](https://issues.apache.org/jira/browse/CLOUDSTACK-5354) | CLONE - UI - normal users are not allowed to edit their own iso...
[CLOUDSTACK-5352](https://issues.apache.org/jira/browse/CLOUDSTACK-5352) | CPU cap calculated incorrectly for VMs on XenServer hosts...
[CLOUDSTACK-5332](https://issues.apache.org/jira/browse/CLOUDSTACK-5332) | Network offering don't use new system offering for router...
[CLOUDSTACK-5303](https://issues.apache.org/jira/browse/CLOUDSTACK-5303) | "snapshot" count and "secondary_storage" count  are not correct in resource_coun...
[CLOUDSTACK-5302](https://issues.apache.org/jira/browse/CLOUDSTACK-5302) | listHosts API response - value of cpuallocated is always 0%...
[CLOUDSTACK-5299](https://issues.apache.org/jira/browse/CLOUDSTACK-5299) | Can not get hypervisor type for volumes...
[CLOUDSTACK-5293](https://issues.apache.org/jira/browse/CLOUDSTACK-5293) |  Error while collecting vm disk stats from hosts if iso is attached to vm...
[CLOUDSTACK-5285](https://issues.apache.org/jira/browse/CLOUDSTACK-5285) | Correct the API command description for removeIpFromNic...
[CLOUDSTACK-5261](https://issues.apache.org/jira/browse/CLOUDSTACK-5261) | Ability to publish Alerts via CS Root API...
[CLOUDSTACK-5260](https://issues.apache.org/jira/browse/CLOUDSTACK-5260) | Vmware 5.1 Deploy Template Error : Read Timeout...
[CLOUDSTACK-5228](https://issues.apache.org/jira/browse/CLOUDSTACK-5228) | [API] [EIP/ELB enabled Zone] Need to display EIP address as "Public IP Address" ...
[CLOUDSTACK-5227](https://issues.apache.org/jira/browse/CLOUDSTACK-5227) | Cannot pass Japanese characters as parameter values to API...
[CLOUDSTACK-5218](https://issues.apache.org/jira/browse/CLOUDSTACK-5218) | CLONE - [Doc] Make VMware vCenter session timeout value configurable....
[CLOUDSTACK-5199](https://issues.apache.org/jira/browse/CLOUDSTACK-5199) | Cannot restart VM after taking a VM snapshot of an existing VM or reverting a VM...
[CLOUDSTACK-5141](https://issues.apache.org/jira/browse/CLOUDSTACK-5141) | [Automation] Router deployment failed due to failure in SavePasswordCommand, obs...
[CLOUDSTACK-5140](https://issues.apache.org/jira/browse/CLOUDSTACK-5140) | A stopped vm cant start after disable threshold has been reached on the storage ...
[CLOUDSTACK-5138](https://issues.apache.org/jira/browse/CLOUDSTACK-5138) | [Automation] NPE while create template from snapshot...
[CLOUDSTACK-5122](https://issues.apache.org/jira/browse/CLOUDSTACK-5122) | [VMware] System VMs are getting recreated with old template after upgrading to 4...
[CLOUDSTACK-5105](https://issues.apache.org/jira/browse/CLOUDSTACK-5105) |  Template/ISO download fails cause the object to disappear from UI...
[CLOUDSTACK-5098](https://issues.apache.org/jira/browse/CLOUDSTACK-5098) | [UI] Zone view is showing "Add VMware Datacenter" button even though zone is alr...
[CLOUDSTACK-5092](https://issues.apache.org/jira/browse/CLOUDSTACK-5092) | [Automation] [BVT] Failed to copy template and ISO between zones in xen ...
[CLOUDSTACK-5076](https://issues.apache.org/jira/browse/CLOUDSTACK-5076) | (Upgrade) reboot VM failed after bridge name change...
[CLOUDSTACK-5069](https://issues.apache.org/jira/browse/CLOUDSTACK-5069) | Make VMware vCenter session timeout value configurable....
[CLOUDSTACK-5066](https://issues.apache.org/jira/browse/CLOUDSTACK-5066) | Existed remote access VPN got dropped when adding new VPN users...
[CLOUDSTACK-5062](https://issues.apache.org/jira/browse/CLOUDSTACK-5062) | Deleting Load Balancing Rule fails when generating usage events are enabled...
[CLOUDSTACK-5054](https://issues.apache.org/jira/browse/CLOUDSTACK-5054) | vm migration involving storage migration on vmware fails with exception " The ob...
[CLOUDSTACK-5053](https://issues.apache.org/jira/browse/CLOUDSTACK-5053) | No Qemu-KVM module dependency error message is displayed (if not present)while i...
[CLOUDSTACK-5042](https://issues.apache.org/jira/browse/CLOUDSTACK-5042) | (Upgrade) Exception when stop VM after upgrade...
[CLOUDSTACK-5029](https://issues.apache.org/jira/browse/CLOUDSTACK-5029) | cloud-bugtool isn't in release package like release notes say...
[CLOUDSTACK-5025](https://issues.apache.org/jira/browse/CLOUDSTACK-5025) | display_volume field is set to false by default for VolumeVO object...
[CLOUDSTACK-5024](https://issues.apache.org/jira/browse/CLOUDSTACK-5024) | listVolumes: add support to list by storage pool (for admin only)...
[CLOUDSTACK-5017](https://issues.apache.org/jira/browse/CLOUDSTACK-5017) | If SSVM is unavailable DownloadCommands will be routed to mgmt server...
[CLOUDSTACK-5014](https://issues.apache.org/jira/browse/CLOUDSTACK-5014) | vmware:deployVM with data disk failed with exception...
[CLOUDSTACK-5012](https://issues.apache.org/jira/browse/CLOUDSTACK-5012) | Bad data inserted into physical network labels for Zone Create Wizard using VMWa...
[CLOUDSTACK-5008](https://issues.apache.org/jira/browse/CLOUDSTACK-5008) | [VMWARE]Failed to start the VM after performing Cold Migration of Volume to Seco...
[CLOUDSTACK-5002](https://issues.apache.org/jira/browse/CLOUDSTACK-5002) | unable to destroy vm ;VM destroy failed in Stop i-2-59-VM Command due to You gav...
[CLOUDSTACK-4998](https://issues.apache.org/jira/browse/CLOUDSTACK-4998) | assignVirtualMachine API has wrong response string, causing Cloudmonkey to crash...
[CLOUDSTACK-4997](https://issues.apache.org/jira/browse/CLOUDSTACK-4997) | OVS integration is broken...
[CLOUDSTACK-4973](https://issues.apache.org/jira/browse/CLOUDSTACK-4973) | CLONE - Specified keyboard language is not showing as default in consoleView pas...
[CLOUDSTACK-4943](https://issues.apache.org/jira/browse/CLOUDSTACK-4943) | Can't create cluster in CS 4.2...
[CLOUDSTACK-4941](https://issues.apache.org/jira/browse/CLOUDSTACK-4941) | CLONE - Allocation capacity of a cluster during HA...
[CLOUDSTACK-4935](https://issues.apache.org/jira/browse/CLOUDSTACK-4935) | Adding same network to VM multiple times resulting in failure, No new NIC is gen...
[CLOUDSTACK-4931](https://issues.apache.org/jira/browse/CLOUDSTACK-4931) | observed NPE with new system vm template...
[CLOUDSTACK-4913](https://issues.apache.org/jira/browse/CLOUDSTACK-4913) | Disable security group for bridge mode non-security group zone...
[CLOUDSTACK-4904](https://issues.apache.org/jira/browse/CLOUDSTACK-4904) | Unable to see a derieved template if the parent template is deleted...
[CLOUDSTACK-4886](https://issues.apache.org/jira/browse/CLOUDSTACK-4886) | cloud-setup-databases not escaping password in shell commands...
[CLOUDSTACK-4875](https://issues.apache.org/jira/browse/CLOUDSTACK-4875) | VMWARE: vCenter 5.5 - SYSTEM VM: Unable to create deployment for VM...
[CLOUDSTACK-4861](https://issues.apache.org/jira/browse/CLOUDSTACK-4861) | [VMware] If Guest traffic spans across multiple physical networks, selection of ...
[CLOUDSTACK-4860](https://issues.apache.org/jira/browse/CLOUDSTACK-4860) | [VMware] Vcenter 5.5  ESXi 5.5 hosts  SSVM CPVM fail to come up to running state...
[CLOUDSTACK-4856](https://issues.apache.org/jira/browse/CLOUDSTACK-4856) | Optimize on the # of control commands sent by MS to HV host...
[CLOUDSTACK-4855](https://issues.apache.org/jira/browse/CLOUDSTACK-4855) | Throttle based on the # of outstanding requests to the directly managed HV host ...
[CLOUDSTACK-4852](https://issues.apache.org/jira/browse/CLOUDSTACK-4852) | Since upgrade to 4.2 only users at the zone-attached domain level can manipulate...
[CLOUDSTACK-4850](https://issues.apache.org/jira/browse/CLOUDSTACK-4850) | [UCS] using template instead of cloning profile...
[CLOUDSTACK-4831](https://issues.apache.org/jira/browse/CLOUDSTACK-4831) | Ability for root admin or domain admin to create a network for another user unde...
[CLOUDSTACK-4830](https://issues.apache.org/jira/browse/CLOUDSTACK-4830) | Allow creation of users and accounts by domain admin in UI...
[CLOUDSTACK-4826](https://issues.apache.org/jira/browse/CLOUDSTACK-4826) | System VMs fail to start...
[CLOUDSTACK-4820](https://issues.apache.org/jira/browse/CLOUDSTACK-4820) | TestVPCNetworkGc.test_01_wait_network_gc netacls are not cleared...
[CLOUDSTACK-4810](https://issues.apache.org/jira/browse/CLOUDSTACK-4810) | Enable hypervisor snapshots for CloudStack-managed storage (for XenServer and VM...
[CLOUDSTACK-4768](https://issues.apache.org/jira/browse/CLOUDSTACK-4768) | [Automation] Race condition; delete the template and create VM at same time; dep...
[CLOUDSTACK-4750](https://issues.apache.org/jira/browse/CLOUDSTACK-4750) | bond.VLAN mapping in iptables FORWARD chain not created consistently...
[CLOUDSTACK-4741](https://issues.apache.org/jira/browse/CLOUDSTACK-4741) | URL of ImageStore not in proper format for XenServer...
[CLOUDSTACK-4740](https://issues.apache.org/jira/browse/CLOUDSTACK-4740) | Some vSphere VMs are shutdown when ACS is restarted...
[CLOUDSTACK-4734](https://issues.apache.org/jira/browse/CLOUDSTACK-4734) | Creating snapshot from ROOT volume fails with error message - "Failed to create ...
[CLOUDSTACK-4724](https://issues.apache.org/jira/browse/CLOUDSTACK-4724) | [Vmware] Deploy VM in designated cluster fail if there is only zone wide primary...
[CLOUDSTACK-4697](https://issues.apache.org/jira/browse/CLOUDSTACK-4697) | Not able to delete Primary storage when there are no hosts in the cluster....
[CLOUDSTACK-4676](https://issues.apache.org/jira/browse/CLOUDSTACK-4676) | [Baremetal]  baremetal hostename should not be fixed in  kickstart file ...
[CLOUDSTACK-4670](https://issues.apache.org/jira/browse/CLOUDSTACK-4670) | [Baremetal] Cloudplatform BareMetal installation guide for CP 4.2...
[CLOUDSTACK-4631](https://issues.apache.org/jira/browse/CLOUDSTACK-4631) | [Automation] Failed to create snapshot from volume due to storage pool missing e...
[CLOUDSTACK-4620](https://issues.apache.org/jira/browse/CLOUDSTACK-4620) | Vm failed to start on the host on which it was running due to not having enough ...
[CLOUDSTACK-4616](https://issues.apache.org/jira/browse/CLOUDSTACK-4616) | When system Vms fail to start when host is down ,  link local Ip addresses do no...
[CLOUDSTACK-4598](https://issues.apache.org/jira/browse/CLOUDSTACK-4598) | [Performance Testing] High delays during deployVM - both network delay and deplo...
[CLOUDSTACK-4597](https://issues.apache.org/jira/browse/CLOUDSTACK-4597) | Complete Exceptions are getting displayed in the UI where there is an operationa...
[CLOUDSTACK-4594](https://issues.apache.org/jira/browse/CLOUDSTACK-4594) | [VMWARE] [Upgrade] Failed to revert VM Snapshot which were created before Live S...
[CLOUDSTACK-4588](https://issues.apache.org/jira/browse/CLOUDSTACK-4588) | [Automation][Vmware] VM deployment failed while creating Volume with NPE...
[CLOUDSTACK-4577](https://issues.apache.org/jira/browse/CLOUDSTACK-4577) | VMWare:Volumes: Unexpected exception while executing org.apache.cloudstack.api.c...
[CLOUDSTACK-4543](https://issues.apache.org/jira/browse/CLOUDSTACK-4543) | [Automation] Failed to configure VPC router then reported as deployment failure...
[CLOUDSTACK-4542](https://issues.apache.org/jira/browse/CLOUDSTACK-4542) | [Automation] Failed to apply DHCP entry in VR and deployment failed ...
[CLOUDSTACK-4540](https://issues.apache.org/jira/browse/CLOUDSTACK-4540) | [Automation] Parallel deployment - Vmware - When deploying 30 parallel Vms , 16 ...
[CLOUDSTACK-4506](https://issues.apache.org/jira/browse/CLOUDSTACK-4506) | In a mixed hypervisor setup, destroying a VM whose host has been removed, throws...
[CLOUDSTACK-4504](https://issues.apache.org/jira/browse/CLOUDSTACK-4504) | VM creation Is failing using the Ubuntu ISO with Xen 6.1 and 6.2...
[CLOUDSTACK-4450](https://issues.apache.org/jira/browse/CLOUDSTACK-4450) | Possibility of /tmp/xapilog filling up the Root disk on Xenserver ...
[CLOUDSTACK-4445](https://issues.apache.org/jira/browse/CLOUDSTACK-4445) |  [UI]Edit Icon is used for Dedicate host / Add or Remove VMWARE Datacenter with ...
[CLOUDSTACK-4428](https://issues.apache.org/jira/browse/CLOUDSTACK-4428) | [UI] "kvm.snapshot.enabled" flag should be taken to account only when snapshot i...
[CLOUDSTACK-4402](https://issues.apache.org/jira/browse/CLOUDSTACK-4402) | [deleteStoragePool] There is no way to delete Primary storage if the last host w...
[CLOUDSTACK-4371](https://issues.apache.org/jira/browse/CLOUDSTACK-4371) | [Performance Testing] Basic zone with 20K Hosts, management server restart leave...
[CLOUDSTACK-4263](https://issues.apache.org/jira/browse/CLOUDSTACK-4263) | Unable to get git number in maven-jgit-buildnumber-plugin, while build cloudstac...
[CLOUDSTACK-4207](https://issues.apache.org/jira/browse/CLOUDSTACK-4207) | [upgrade] Exception observed after upgrade "jsonParseException: The JsonDeserial...
[CLOUDSTACK-4061](https://issues.apache.org/jira/browse/CLOUDSTACK-4061) | UI issue with Japanese localized ui...
[CLOUDSTACK-3806](https://issues.apache.org/jira/browse/CLOUDSTACK-3806) | OS Preference can not be set...
[CLOUDSTACK-3664](https://issues.apache.org/jira/browse/CLOUDSTACK-3664) | scaling up vms is not considering  parameter "cluster.(memory/cpu).allocated.cap...
[CLOUDSTACK-3627](https://issues.apache.org/jira/browse/CLOUDSTACK-3627) | Public IP interface(eth2) is not getting configured with Redundant VR (State = F...
[CLOUDSTACK-3577](https://issues.apache.org/jira/browse/CLOUDSTACK-3577) | NPE while downloading the template to secondary storage ...
[CLOUDSTACK-3561](https://issues.apache.org/jira/browse/CLOUDSTACK-3561) | When inputting the nfs server in secondary storage, if once it's required, it al...
[CLOUDSTACK-3364](https://issues.apache.org/jira/browse/CLOUDSTACK-3364) | normal users are not allowed to edit their own iso...
[CLOUDSTACK-3266](https://issues.apache.org/jira/browse/CLOUDSTACK-3266) | [UI] Failed to delete Anti affinitygroup for the first time ...
[CLOUDSTACK-3252](https://issues.apache.org/jira/browse/CLOUDSTACK-3252) | An instance deployed using explicit or implicit dedication doesn't generate a us...
[CLOUDSTACK-3247](https://issues.apache.org/jira/browse/CLOUDSTACK-3247) | Removing a Disconnected Host throws a NoTransitionException...
[CLOUDSTACK-3156](https://issues.apache.org/jira/browse/CLOUDSTACK-3156) | needs proper message for failing Add nic command when vmware tools is not instal...
[CLOUDSTACK-3067](https://issues.apache.org/jira/browse/CLOUDSTACK-3067) | UI for Dedicating POD/Cluster/Host is misleading Icons should be changed....
[CLOUDSTACK-3027](https://issues.apache.org/jira/browse/CLOUDSTACK-3027) | Object_Store_Refactor - Uploaded template S3 content-type is not appropriate....
[CLOUDSTACK-2895](https://issues.apache.org/jira/browse/CLOUDSTACK-2895) | Can't start a VM with 3 volumes attached [VMWare]...
[CLOUDSTACK-2766](https://issues.apache.org/jira/browse/CLOUDSTACK-2766) | [VPC] [UI] Firewall service should not be enabled for acquired public IPs in VPC...
[CLOUDSTACK-2687](https://issues.apache.org/jira/browse/CLOUDSTACK-2687) | NPE with deploy VM when there are no resources available ...
[CLOUDSTACK-2570](https://issues.apache.org/jira/browse/CLOUDSTACK-2570) | [UI]Resource Name is mentioned twice with view VNMC devices ...
[CLOUDSTACK-2562](https://issues.apache.org/jira/browse/CLOUDSTACK-2562) | [VMWARE] As per the code, currently CloudStack fails to program PF/NAT/LB rules ...
[CLOUDSTACK-2428](https://issues.apache.org/jira/browse/CLOUDSTACK-2428) | HA - When the master host is disconnected , the host status contines to remain i...
[CLOUDSTACK-2414](https://issues.apache.org/jira/browse/CLOUDSTACK-2414) | NPE while deleting Cisco VNMC provider...
[CLOUDSTACK-2396](https://issues.apache.org/jira/browse/CLOUDSTACK-2396) | PVLAN - Should not be allowed to create multiple networks with same Vlan  associ...
[CLOUDSTACK-2199](https://issues.apache.org/jira/browse/CLOUDSTACK-2199) | ID parameter of UpdateConfiguration API should be changed to a different name...
[CLOUDSTACK-2141](https://issues.apache.org/jira/browse/CLOUDSTACK-2141) | During HA process ,  dead lock is detected - Caused by: com.mysql.jdbc.exception...
[CLOUDSTACK-1970](https://issues.apache.org/jira/browse/CLOUDSTACK-1970) | Ubuntu - "cloudstack-setup-management" not available in "/usr/bin"...
[CLOUDSTACK-1889](https://issues.apache.org/jira/browse/CLOUDSTACK-1889) | [UI] Consumed Resource usage details are not available for all the resources...
[CLOUDSTACK-1868](https://issues.apache.org/jira/browse/CLOUDSTACK-1868) | GetVmStatsCommand throws NullPointerException with VMWare...
[CLOUDSTACK-1762](https://issues.apache.org/jira/browse/CLOUDSTACK-1762) | [MultipleIpsToNic] addIpToNic should not let network id or broadcast to be assig...
[CLOUDSTACK-1637](https://issues.apache.org/jira/browse/CLOUDSTACK-1637) | LDAP:UI related issues...

Version 4.2.1
-------------

Release notes contain the list of [bug fixes](http://cloudstack.apache.org/docs/en-US/Apache_CloudStack/4.2.1/html/Release_Notes/version-4.2.html#issues-fixed-4.2.1)

Version 4.2.0
-------------
Released on October 1 2013.
Release notes contain the list of [bug fixes](http://cloudstack.apache.org/docs/en-US/Apache_CloudStack/4.2.0/html/Release_Notes/index.html)

Version 4.1.0
-------------

This is the second major release of CloudStack from within the Apache Software Foundation, and the
first major release as a Top-Level Project (TLP).

Build Tool Changes:

 * The project now uses Maven 3 exclusively to build.

New Features:
* CLOUDSTACK-101: OVS support in KVM
* CLOUDSTACK-132: Mash up marvin into an interactive auto-completing API shell for CloudStack
* CLOUDSTACK-241: AWS Style Regions
* CLOUDSTACK-297: Reset SSH Key to access VM (similar to reset password)
* CLOUDSTACK-299: Egress firewall rules for guest network
* CLOUDSTACK-306: Support SRX & F5 inline mode
* CLOUDSTACK-618: API request throttling to avoid malicious attacks on MS per account through frequent API request.
* CLOUDSTACK-637: AutoScale
* CLOUDSTACK-644: Resize volumes feature
* CLOUDSTACK-706: Persistent Networks without running a VM
* CLOUDSTACK-726: Implement L3 Router functionality in Nicira Nvp Plugin
* CLOUDSTACK-780: Additional VMX Settings
* CLOUDSTACK-926: ApiDiscoverService: Implement a plugin mechanism that exposes the list of APIs through a discovery service on the management server

Bug Fixes:

* CLOUDSTACK-1600 Typo in dpkg-buildpackage command
* CLOUDSTACK-1574 updateResourceCount API is failed saying to specify valida resource type even after parsing the valid resource type
* CLOUDSTACK-1562 Replace the short-cut solution of supporting @DB with the formal one
* CLOUDSTACK-1541 NPE while deleting snapshot :Unexpected exception while executing org.apache.cloudstack.api.command.user.snapshot.DeleteSnapshotCmd
* CLOUDSTACK-1521 Redundant router: Services are not stopped when switch to BACKUP state
* CLOUDSTACK-1509 Failed to implement network elements and resources while provisioning for persistent network(createVlanIpRange to an account]
* CLOUDSTACK-1496 List API Performance: listAccounts failing with OOME for high values of pagesize (>1000 )
* CLOUDSTACK-1487 cloudstack-setup-agent fails to set private.network.device on KVM host add
* CLOUDSTACK-1485 Add Baremetal Provider back to 4.1 branch
* CLOUDSTACK-1484 "API Throttling : api.throttling.enabled, Global setting missing"
* CLOUDSTACK-1473 deleteDomain is failing with NPE
* CLOUDSTACK-1470 unhandled exception executing api command: deployVirtualMachine
* CLOUDSTACK-1469 kvm agent: agent service fails to start up
* CLOUDSTACK-1465 List Zones returns null under create instance when logged is as user
* CLOUDSTACK-1449 listAccounts and listProjectAccounts API lists all the users not account-specific users for each account returned
* CLOUDSTACK-1447 [UI]Persistent Status is not displayed for VPC Tiers
* CLOUDSTACK-1436 4.1 management server fails to start from RPM build artifacts
* CLOUDSTACK-1429 single account is unable to use same vnet across multiple physical networks
* CLOUDSTACK-1425 unhandled exception executing api command: migrateVirtualMachine & recoverVirtualMachine
* CLOUDSTACK-1420 Ensure trademarks are properly attributed in publican brand.
* CLOUDSTACK-1419 Apache-ify and apply trademark logos in the UI
* CLOUDSTACK-1418 "As regular user , we are not allowed to deploy VM on a shared network."
* CLOUDSTACK-1417 "When invalid values are passed to createNetwork() , error message does not indicate the parameter name that has invalid values."
* CLOUDSTACK-1414 Redundant router: BACKUP switch cancelled due to lock timeout after a glitch in network
* CLOUDSTACK-1403 Storage and console-proxy related error
* CLOUDSTACK-1402 listRouters API response doesn't return linklocal IP and public IP details
* CLOUDSTACK-1399 Unhandled exception executing api command: stopVirtualMachine
* CLOUDSTACK-1397 Static Nat configuration is failing with NPE
* CLOUDSTACK-1391 EventBus is not getting injected after javelin merge
* CLOUDSTACK-1383 Deploying basic zone on 4.1 fails in NPE
* CLOUDSTACK-1382 "vm deploy fails with Error ""cannot find DeployPlannerSelector for vm"""
* CLOUDSTACK-1375 deploydb failing with acs master
* CLOUDSTACK-1369 "Ipv6 - In dual Stack network , guest VM does not have the Ipv6 address of the router programmed in /etc/resolv.conf for DNS resolution."
* CLOUDSTACK-1367 NPE noticed in logs while AgentMonitor is monitoring the host ping interval
* CLOUDSTACK-1357 "Autoscale: Provisioned VMs from Netscaler not being added to lb vserver, provserver fails with provserver_err_asynctaskpoll"
* CLOUDSTACK-1350 Management server Stop and start causes previously downloaded ISOs and templates to redownload & reinstall
* CLOUDSTACK-1347 "Not able to delete network. Error - ""Unable to insert queue item into database, DB is full?"""
* CLOUDSTACK-1346 "Check to see if external devices are used in the network, is hardcoded for specific devices"
* CLOUDSTACK-1345 BigSwitch plugin introduces 'VNS' isolation in UI without backend implementation
* CLOUDSTACK-1344 Typo in use.external.dns setting description
* CLOUDSTACK-1343 Porting Baremetal related UI changes to ACS
* CLOUDSTACK-1341 URL for the KEYs file is wrong in the installation guide
* CLOUDSTACK-1339 ASF 4.1: Management server becomes unresponsive
* CLOUDSTACK-1338 Deploy VM failed using ISO
* CLOUDSTACK-1334 vmware.root.disk.controller doesn't work.
* CLOUDSTACK-1332 IPV6 - Router and guest Vms should be able to use an IPV6 address for external DNS entry.
* CLOUDSTACK-1331 Upgrade fails for a 2.2.14 Zone having multiple guest networks using network_tags and Public Vlan
* CLOUDSTACK-1330 ec2-run-instances - When -n option is used to deploy multiple Vms API returns error even though few of the Vms have been deployed successfully.
* CLOUDSTACK-1320 Routers naming convention is changed to hostname
* CLOUDSTACK-1319 createCustomerVpnGateway response gives TypeError: json.createvpncustomergatewayresponse is undefined
* CLOUDSTACK-1315 [F5-SRX-InlineMode] Network implement failed with Run time Exception during network upgrade from VR to SRX-F5
* CLOUDSTACK-1313 Working with Volumes Section Is Missing
* CLOUDSTACK-1312 "Fix rolling upgrades from 4.0 to 4.1 in 4.1 release, fix db schemas to be same as 4.0"
* CLOUDSTACK-1307 Noticed NPE when we put host in maintenance mode in clustered management setup
* CLOUDSTACK-1303 Ipv6 - java.lang.NullPointerException when executing listnetworks() and deployVirtualMachine() after extending the Ipv4 range of a dual stack network.
* CLOUDSTACK-1300 section in wrong order in installation guide
* CLOUDSTACK-1299 Errors in 4.5.5 section of installation guide
* CLOUDSTACK-1295 NPE in usage parsers due to missing @Component inject
* CLOUDSTACK-1289 [F5-SRX-InlineMode] Usage stats are not generated for Juniper SRX Firewall in inlinemode
* CLOUDSTACK-1288 [F5-SRX-InlineMode] classCastException during network restart with cleanup option true
* CLOUDSTACK-1277 ApiResponseHelper.createUserVmResponse failed to populate password field set from UserVm object
* CLOUDSTACK-1272 Autoscale: createAutoScaleVmProfile fails due to unable to retrieve Service Offering id
* CLOUDSTACK-1267 KVM's cloudstack-agent service doesn't log (log4j)
* CLOUDSTACK-1265 logrotate dnsmasq configuration is wrong
* CLOUDSTACK-1262 "Failed to Prepare Secondary Storage in VMware,"
* CLOUDSTACK-1251 Baremetal zone doesn't need primary/secondary storage in UI wizard
* CLOUDSTACK-1243 Failed to cleanup account :java.lang.NullPointerException
* CLOUDSTACK-1242 [F5-SRX-InlineMode] Failed to create LB rule with F5-SRX inlinemode deployement
* CLOUDSTACK-1241 Network apply rules logic is broken
* CLOUDSTACK-1237 "Register Template fails with ""Cannot find template adapter for XenServer"""
* CLOUDSTACK-1234 Unable to start KVM agent with 4.1 build
* CLOUDSTACK-1233 Veewee configuration files are inappropriately identified as ASLv2 licensed files
* CLOUDSTACK-1232 "Ipv6 - Guest Vms are not able to get Ipaddress when executing dhclient command when using ""/96"" network."
* CLOUDSTACK-1226 Error while running Cloudstack-setup-databases
* CLOUDSTACK-1223 Exception while starting jetty server: org.springframework.beans.factory.BeanCreationException Error creating bean with name 'apiServer':
* CLOUDSTACK-1222 API rate limit configs: removed double quote in upgrade script
* CLOUDSTACK-1220 Ipv6 - Better error message when deploy Vm fails to get a free Ip address.
* CLOUDSTACK-1219 Ipv6 - Provide better error messages when deploying a Vm with Ip an address that is outside the network's ip range / if the ip address already is assigned to another Vm.
* CLOUDSTACK-1216 UUID is null for admin and failed to register user key with 4.1
* CLOUDSTACK-1210 Make all pluggable services return list of api cmd classes
* CLOUDSTACK-1206 Failure in Copy of System templates
* CLOUDSTACK-1205 Ipv6 - Ubuntu 12.10 guest Vms looses default route (after it expiration time ~ 30 mts) when ipv6.autoconfig parameters are disabled except for net.ipv6.conf.lo.autoconf which is enabled.
* CLOUDSTACK-1204 Fail to create advance zone due to fail to add host
* CLOUDSTACK-1201 "Failed to create ssh key for user ""cloud"" /var/lib/cloud/management/.ssh/id_rsa and failed to start management server"
* CLOUDSTACK-1190 Make APIChecker interface throw a single sensible exception
* CLOUDSTACK-1181 mvn deploy db failing with NPE
* CLOUDSTACK-1176 Issue with snapshots(create/list)
* CLOUDSTACK-1174 Snapshots related SQL error
* CLOUDSTACK-1173 ConsoleProxyResource instantiation exception
* CLOUDSTACK-1168 Create firewall rule broken
* CLOUDSTACK-1163 Failed with NPE while creating firewall rule
* CLOUDSTACK-1161 Differences between 4.1 and master in ongoing-config-of-external-firewalls-lb.xml
* CLOUDSTACK-1154 Account/Users related API failed due to RegionService inject exception
* CLOUDSTACK-1153 "Ipv6 - Vm deployment fails with ""n must be positive"" error."
* CLOUDSTACK-1152 Missing tag in host-add.xml
* CLOUDSTACK-1141 "Ipv6 - After network restart (and reboot router) , we do not see the existing vms dnsentries not being programmed in the router."
* CLOUDSTACK-1138 "Providing invalid values for gateway, netmask etc in the zoneWizard blocks the VLAN container to load , throwing an error"
* CLOUDSTACK-1123 ListStoragePools API broken by refactor
* CLOUDSTACK-1113 "Ipv6 - Not able to deploy a new VM in this network because of ""Unable to allocate Unique Ipv6 address"""
* CLOUDSTACK-1112 "Errors in ""Prepare the System VM Template"""
* CLOUDSTACK-1111 Ipv6 - listRouters() does not return guestipaddress/
* CLOUDSTACK-1109 "Ipv6 - Unable to expunge User Vms that are ""Destroyed""."
* CLOUDSTACK-1108 Ipv6 - Not able to restart Networks.
* CLOUDSTACK-1107 Ipv6 - Unable to extend Ip range for a Ipv6 network using craeteVlanIpRange() command - Error code 530 returned.
* CLOUDSTACK-1105 "IpV6 - listVirtualMachines() does not return netmask ,gateway,ipaddress."
* CLOUDSTACK-1104 Ipv6 - listVlanIpRanges() returns error 530.
* CLOUDSTACK-1103 "IpV6 - listNetwork() command does not retrun gateway,netmask,cidr"
* CLOUDSTACK-1095 Ipv6 - dhclient command needs to be run manually on the Vms to get the Ipv6 address.
* CLOUDSTACK-1088 EnableStaticNat error will clear the data in database
* CLOUDSTACK-1087 Update the Developer Guide for ASFCS 4.1 Release
* CLOUDSTACK-1083 listUsageRecords api: removed project results in NPE
* CLOUDSTACK-1082 UI doesn't throw any error message when trying to delete ip range from a network that is in use
* CLOUDSTACK-1079 Deploying AWSAPI with mvn -pl :cloud-awsapi jetty:run fails
* CLOUDSTACK-1070 javelin: NPE on executing registerIso API
* CLOUDSTACK-1064 A type error occurs when trying to add account/register template....
* CLOUDSTACK-1063 "SG Enabled Advanced Zone - ""Add Guest Networks"" - When user tries to add a guest Network with scope as ""Account"" , he should NOT be presented with ""Offering for shared security group enabled"""
* CLOUDSTACK-1057 regression of changeServiceForVirtualMachine API - fails to find service offering by serviceOfferingId parameter
* CLOUDSTACK-1056 S3 secondary storage fails to upload systemvm template due to KVMHA directory
* CLOUDSTACK-1055 "The overlay still exists when the ""Recurring Snapshots"" dialog is canceled by pressing esc key."
* CLOUDSTACK-1051 API dispatcher unable to find objectVO corresponding to DeleteTemplatecmd
* CLOUDSTACK-1050 No Documentation on Adding a Load Balancer Rule
* CLOUDSTACK-1037 "Make cloudmonkey awesome-er: Online help docs and api discovery, better colored output, parameter value autocompletion"
* CLOUDSTACK-1029 Enter the token to specified project is malfunctioned
* CLOUDSTACK-1027 """Update SSL certificate"" button should properly reflect it's functionality"
* CLOUDSTACK-1024 Regression: Unable to add Xenserver host with latest build
* CLOUDSTACK-1021 the vlan is not creat to right nic. when i creat multi guest network.
* CLOUDSTACK-1016 Not able to deploy VM.
* CLOUDSTACK-1014 Merge ManagementServer and ManagementServerExt
* CLOUDSTACK-1013 running cloudstack overwrites default public/private ssh keys
* CLOUDSTACK-1011 KVM host getting disconnected in cluster environment
* CLOUDSTACK-1010 Host count and Secondary storage count always shows 1 in UI
* CLOUDSTACK-1002 Not able to start VM.
* CLOUDSTACK-995  Not able to add the KVM host.
* CLOUDSTACK-993  """admin"" user is not getting created when management server is started."
* CLOUDSTACK-987  Sections missing in Working With Snapshots
* CLOUDSTACK-985  Different MAC address for RvR caused issue in short term network outrage
* CLOUDSTACK-978  TypeError: instance.displayname is undefined while adding VM's to the LB rule.
* CLOUDSTACK-968  marvin: vlan should be an attribute of the physical_network and not the zone
* CLOUDSTACK-959  Missing sub-sections in document section System Service Offerings
* CLOUDSTACK-938  s2s VPN trouble
* CLOUDSTACK-928  [Simulator] Latency for Agent Commands - change unit of wait from seconds to milliseconds
* CLOUDSTACK-863  Non-printable characters (ASCII control character) such as %00 or %0025 are getting stored in raw/non encoded form in the database.
* CLOUDSTACK-819  Create Account/User API logging password in access logs
* CLOUDSTACK-799  [Load Test] Check router statistics falls behind in gathering stats by more than 2 times the set value
* CLOUDSTACK-798  Move usage related cmd classes from cloud-server to cloud-api
* CLOUDSTACK-736  Integration smoke tests: Fix check for vm name for the deployvm smoke test
* CLOUDSTACK-734  api_refactoring: CreateAccountCmd fails to send response due to NPE in service layer
* CLOUDSTACK-725  UI: Error when the Egress rules tab is selected for a network
* CLOUDSTACK-721  Bytes sent/received in user statistics is empty (CloudStack 4.0)
* CLOUDSTACK-720  Fail to load a png image when accessing the web console
* CLOUDSTACK-717  cloudmonkey fails to parse/print response
* CLOUDSTACK-693  Adding a VPC virtual router to a NiciraNVP enabled network fails
* CLOUDSTACK-691  A warning dialog box shows after reloading the welcome page
* CLOUDSTACK-689  RVR: Stop pending flag is not cleared when user start the disconnected router from another host
* CLOUDSTACK-683  Image Is Missing in the Accessing VM Section
* CLOUDSTACK-660  Network Traffic Labels are not functional in Marvin
* CLOUDSTACK-648  The normal users could change their own login password
* CLOUDSTACK-639  API Refactoring: Adapters for ACL
* CLOUDSTACK-617  Unable to edit a Sub domain
* CLOUDSTACK-614  "ListTemplates API is not returning ""Enable SSH Key"" attribute for any given template"
* CLOUDSTACK-606  Starting VM fails with 'ConcurrentOperationException' in a clustered MS scenario
* CLOUDSTACK-605  Host physical CPU is incorrectly calculated for Vmware hosts
* CLOUDSTACK-599  DhcpEntryCommand fails on Router VM on CS4.0 and vSphere5 with Advanced Network Zone
* CLOUDSTACK-596  DeployVM command takes a lot of time to return job id
* CLOUDSTACK-584  "typos in ""Apache_CloudStack-4.0.0-incubating-CloudStack_Nicira_NVP_Guide-en-US"""
* CLOUDSTACK-573  "NPE at ""com.cloud.network.NetworkManagerImpl.networkOfferingIsConfiguredForExternalNetworking(NetworkManagerImpl.java:4345)"" when create network from the network offering having NULL provider for the service"
* CLOUDSTACK-572  SG Enabled Advanced Zone - Not able to deploy a VM in an account specific shared network.
* CLOUDSTACK-560  Usage server doesn't work in 4.0.0 due to missing db changes
* CLOUDSTACK-556  Erratic window behavior in Quick View tooltip
* CLOUDSTACK-553  "SRX - When adding SRX device make ""Public Network"" - default to ""untrusted"" and ""Private Network"" - default to ""trusted"" as un-editable fields."
* CLOUDSTACK-552  ]Quick view details for a volume displays scroll bar in place of name of the volume when the name of the volume has more no of characters
* CLOUDSTACK-539  Cropped Text in UI under Quick View
* CLOUDSTACK-536  remove citrix cloudpatform from 4.0 build - CloudStack is ASF project
* CLOUDSTACK-527  List API performance optimization by using DB views and removing UUID conversion.
* CLOUDSTACK-522  Log requests in cloudmonkey's log file
* CLOUDSTACK-520  Dependency jar names mismatch with install-non-oss.sh
* CLOUDSTACK-518  API refactoring -- change @Parameter annotation and remove the @IdentityMapper annotation
* CLOUDSTACK-514  Marvin and Cloudmonkey don't work when an API target uses https or an alternate path
* CLOUDSTACK-510  Add button not visible when adding public IPs to physical network
* CLOUDSTACK-508  CLVM copies template to primary storage unnecessarily
* CLOUDSTACK-507  fix api docs for listSSHKeyPairs
* CLOUDSTACK-504  Duplicate guest password scripts in codebase
* CLOUDSTACK-501  Apidocs and marvin does not know how to handle Autoscaling docs
* CLOUDSTACK-500  Passwd-server iptables rules are dropped on domr on fresh start or on reboot
* CLOUDSTACK-499  cloudmonkey CLI can't accept complex parameters
* CLOUDSTACK-493  2.2.x-3.0 DB upgrade support for Advance SG enabled networks
* CLOUDSTACK-481  Installation Guide Doc Error
* CLOUDSTACK-467  Developer's Guide points to cloud.com for API reference
* CLOUDSTACK-465  French language file quotes are dropping javascript syntax errors
* CLOUDSTACK-464  "Regression in AWSAPI docs, entire sections removed"
* CLOUDSTACK-462  A few corrections to make to the 4.0.0 installation guide
* CLOUDSTACK-459  [Optional Public IP assignment for EIP with Basic Zone] Associate IP Checkbox in Create Network Offering Dialog is Displayed When Elastic LB is Selected
* CLOUDSTACK-456  License tag in SPEC isn't what RPM is expecting
* CLOUDSTACK-448  SSVM bootstrap failure on XenServer hosts with E3 CPU
* CLOUDSTACK-446  "Host going to alert state, if you are adding already added host"
* CLOUDSTACK-441  Running mgmt server using jetty fails to start api server
* CLOUDSTACK-435  Vmware network labels are ignored when creating a Zone using basic networking
* CLOUDSTACK-427  Change hardcoded step number references to dynamic links
* CLOUDSTACK-424  Updated userdata not propagating to the VR.
* CLOUDSTACK-417  Handle password server securely to run on port 8080 on VR
* CLOUDSTACK-416  XCP 1.6beta2 (61002c) - can't add a host
* CLOUDSTACK-404  Update docs on the usage of cloud-setup-databases
* CLOUDSTACK-398  Install Guide: Section 11.17.3 (Using VPN with Mac OSX): Not complete?
* CLOUDSTACK-397  Install Guide: Section 11.1 (Guest Traffic): Diagram is the wrong diagram
* CLOUDSTACK-390  Install Guide: Section 4.5.7 (Prepare the System VM Template): Links go to cloud.com
* CLOUDSTACK-378  mavenize marvin on master
* CLOUDSTACK-377  provide deployment config access to marvin's testcase
* CLOUDSTACK-373  "static NAT and Firewall is not working on external firewall device SRX, it needs to be implemented"
* CLOUDSTACK-369  ASF 4.0 - unable to support XenServer 6.1 host
* CLOUDSTACK-364  Docs point to download.cloud.com for AWS API script
* CLOUDSTACK-361  Wrong creation of guest networks on a KVM host in Multiple Physical Networks with guest traffic
* CLOUDSTACK-359  PropagateResourceEventCommand failes in cluster configuration
* CLOUDSTACK-357  "ISOs can be deleted while still attached to a running VM, and they subsequently cannot be detached from a running VM"
* CLOUDSTACK-355  "Fix ""count"" in a bunch of API commands"
* CLOUDSTACK-348  deleteNetwork does not clean up network resource count correctly
* CLOUDSTACK-347  listNetworks API: return vlan information only when the caller is ROOT admin
* CLOUDSTACK-346  Cannot add Vmware cluster with class loader conflict exception
* CLOUDSTACK-335  KVM VPC load balancer not working
* CLOUDSTACK-333  When Datacenter name in VCenter has spaces Primary Storage (VMFS) discovery will fail
* CLOUDSTACK-332  """count"" property in list* API response should be equal to how many entries in database, not how many objects in API response"
* CLOUDSTACK-318  Adding XenServer Host Fails - 6.0.2 fails with 4.0.0
* CLOUDSTACK-304  Add synchronization for createSnapshot command per host basis
* CLOUDSTACK-293  "We do awful, hacky things in our spec file for client"
* CLOUDSTACK-290  3.0.0 template also needed for 2.2.14 to 3.0.5 direct upgrade.
* CLOUDSTACK-284  listVirtualMachines does not return deleted machines when zone is specified
* CLOUDSTACK-279  deleteProject fails when executed by the regular user (works fine for root/domain admin)
* CLOUDSTACK-274  Two error codes mapped to same value in API
* CLOUDSTACK-271  updatePhysicalNetwork dies with an NPE when the vlan range is empty
* CLOUDSTACK-256  "vpn:As an admin user , not able to delete VPN user which is present in a regular user's network."
* CLOUDSTACK-250  Incorrect description of maintenance mode in admin guide
* CLOUDSTACK-249  Add host id to failed VM deploy alerts
* CLOUDSTACK-235  Network rate can be set in 2 places. Clarify docs on how this works.
* CLOUDSTACK-232  Zone infrastructure chart -- disable resource total display
* CLOUDSTACK-228  UI provides an option to reconnect a disconnected host - ServerApiException is thrown on an attempt
* CLOUDSTACK-227  ReconnectHostCmd: NullPointerException: Unable to get host Information for XenServer 6.0.2 host - on intentionally changing the traffic labels on the physical network
* CLOUDSTACK-226  UpdatePhysicalNetworkcommand failed due to java.sql.BatchUpdateException ; Tried to extend the existing Guest VLAN Range of one physical network into the Guest VLAN range of the other physical network
* CLOUDSTACK-225  API Docs: Request params repeated with different descriptions
* CLOUDSTACK-222  Admin UI prompts to restart Management server with cancel edit operation
* CLOUDSTACK-178  Expose name parameter of VM in list Vm view.
* CLOUDSTACK-130  Clarify docs on tags parameter in API reference
* CLOUDSTACK-119  Move Agent-Simulator in to the hypervisor plugin model
* CLOUDSTACK-118  "Status of host resorce stuck in ""ErrorInMaintenance"""
* CLOUDSTACK-95   IP address allocation not working when a user tries to allocate IP addresses in a Project.
* CLOUDSTACK-70   Improve Network Restart Behaviour for Basic Zone: Restarting Network Fails
* CLOUDSTACK-46   Remnants of mycloud remain

Security Fixes:

 * CVE-2012-4501: Apache CloudStack configuration vulnerability

Version 4.0.2
------------------------

This is a maintenance release for the Apache CloudStack 4.0.x series, with no new features.

Issues fixed in this release:

* CLOUDSTACK-354: Display of storage statistics is wrong.
* CLOUDSTACK-397: Install Guide: Section 11.1 (Guest Traffic): Diagram is the wrong diagram
* CLOUDSTACK-398: Install Guide: Section 11.17.3 (Using VPN with Mac OSX): Not complete?
* CLOUDSTACK-462: A few corrections to make to the 4.0.0 installation guide
* CLOUDSTACK-524: http proxy used by ssvm (secstorage.proxy) NOT working
* CLOUDSTACK-587: MEMORY_CONSTRAINT_VIOLATIONMemory limits must satisfy:
* CLOUDSTACK-803: HA gets triggered even when the host investigator is unable to determine the state of the host
* CLOUDSTACK-810: Make DirectAgent thread pool size configurable
* CLOUDSTACK-976: unable to start cloudstack (error: "java.lang.NoSuchMethodError: org.apache.commons.codec.binary.Base64.encodeBase64URLSafeString([B)Ljava/lang/String;")
* CLOUDSTACK-988: HV version must be updated in hypervisor_version column of host table
* CLOUDSTACK-990: Documentation issue with libvirtd.conf tcp_port configuration
* CLOUDSTACK-1088: EnableStaticNat error will clear the data in database
* CLOUDSTACK-1106: Missing documentation for cloud-setup-databases
* CLOUDSTACK-1110: Documentation missing "Management Server Load Balancing"
* CLOUDSTACK-1112: Errors in "Prepare the System VM Template"
* CLOUDSTACK-1137: Force reconnect of a disconnected state complains about the state of the host.
* CLOUDSTACK-1150: Documentation for libvirt on Ubuntu 12.04
* CLOUDSTACK-1151: vmware systemVm template upgrade is missing in 4.0 upgrade
* CLOUDSTACK-1211: Network operations are Blocked for the Read-only file system of Virtual Router
* CLOUDSTACK-1265: logrotate dnsmasq configuration is wrong
* CLOUDSTACK-1291: duplicate arguments in commands.xml prevents cloudapis.py to run to completion
* CLOUDSTACK-1298: typo in deb package setup
* CLOUDSTACK-1299: Errors in 4.5.5 section of installation guide
* CLOUDSTACK-1300: section in wrong order in installation guide
* CLOUDSTACK-1341: URL for the KEYs file is wrong in the installation guide
* CLOUDSTACK-1419: Apache-ify and apply trademark logos in the UI
* CLOUDSTACK-1420: Ensure trademarks are properly attributed in publican brand.
* CLOUDSTACK-1589: Ubuntu 4.0 packages depend on non-existent chkconfig
* CLOUDSTACK-1629: Need to move location or conflict with antlr
* CLOUDSTACK-1642: Add support CentOS 6.4
* CLOUDSTACK-1648: Unable to add KVM host
* CLOUDSTACK-1652: /etc/hosts error in virtual router when deploy instance with the name same to previous instances
* CLOUDSTACK-1666: KVM VPC NetworkUsage doesnot work
* CLOUDSTACK-1668: IP conflict in VPC tier
* CLOUDSTACK-1761: Available local storage disk capacity incorrectly reported in KVM to manager.
* CLOUDSTACK-1845: KVM - storage migration often fails
* CLOUDSTACK-1846: KVM - storage pools can silently fail to be unregistered, leading to failure to register later
* CLOUDSTACK-2003: Deleting domain while deleted account is cleaning up leaves VMs expunging forever due to 'Failed to update resource count'
* CLOUDSTACK-2090: Upgrade from version 4.0.1 to version 4.0.2 triggers the 4.0.0 to 4.0.1.
* CLOUDSTACK-2091: Error in API documentation for 4.0.x.

Version 4.0.1-incubating
------------------------

This is a bugfix release for Apache CloudStack 4.0.0-incubating, with no new features.

Security Fixes:

* CVE-2012-5616: Local Information Disclosure Vulnerability (See CLOUDSTACK-505)

Bugs fixed in this release:

* CLOUDSTACK-359: PropagateResourceEventCommand fails in cluster configuration
* CLOUDSTACK-374: When running cloud-setup-databases, it auto chooses the highest priority nic (lowest number ie: eth0)
* CLOUDSTACK-389: Install Guide: Section 4.5.5 (Prepare NFS Shares): Confusing statement about iSCSI
* CLOUDSTACK-395: Primary Storage and Secondary Storage sections missing sub-sections
* CLOUDSTACK-411: Add another step during kvm agent installation on Ubuntu machine
* CLOUDSTACK-415: restartNetwork call causes VM to be unreachable when Nicira based SDN is used.
* CLOUDSTACK-422: XSL files missing license header.
* CLOUDSTACK-426: SetVPCStaticNatRules unimplemented for KVM.
* CLOUDSTACK-448: SSVM bootstrap failure on XenServer hosts with E3 CPU.
* CLOUDSTACK-465: French language file quotes are dropping javascript syntax errors.
* CLOUDSTACK-473: API Doc for uploadCustomCertificate doesn't explain how to use the optional parameters well.
* CLOUDSTACK-480: Installation Documentation error: Section 4.5.5.2 needs to mention nfs-kernel-server.
* CLOUDSTACK-481: Installation Guide Doc Error
* CLOUDSTACK-498: Missing dependency in RPM of KVM Agent.
* CLOUDSTACK-502: VPC router needs to resolve its hostname.
* CLOUDSTACK-505: cloudstack logs the private key in plaintext.
* CLOUDSTACK-507: fix api docs for listSSHKeyPairs.
* CLOUDSTACK-515: NVP installation.
* CLOUDSTACK-536: remove citrix cloudpatform from 4.0 build - CloudStack is ASF project.
* CLOUDSTACK-560: Usage server doesn't work in 4.0.0 due to missing db changes.
* CLOUDSTACK-580: Packages are named with 4.0 with 4.0.1 build.
* CLOUDSTACK-591: Wrong vnet in iptables on KVM hypervisors after VM reboot.
* CLOUDSTACK-595: Recreate root volume scenarios doesn't work in VMware
* CLOUDSTACK-603: Upgrade from 4.0 to 4.0.1 is not enabled.
* CLOUDSTACK-605: Host physical CPU is incorrectly calculated for VMware host
* CLOUDSTACK-622: In the add primary storage dialog in the ui the RBD fields don't disappear when changing from RBD to another protocol.
* CLOUDSTACK-683: Image is missing in the Accessing VM Section
* CLOUDSTACK-685: CloudStack 4.0 Network Usage is ZERO
* CLOUDSTACK-938: s2s VPN trouble
* CLOUDSTACK-961: Installation docs don't detail dependencies for building RPMs
* CLOUDSTACK-995: Not able to add the KVM host

Version 4.0.0-incubating
------------------------

This is the first release of CloudStack from within the Apache Software Foundation.

Build Tool Changes:

 * The project now uses a combination of maven3 and ant for building
 * License header auditing is now implemented via the Apache RAT Maven plugin
 * Some integrations have been disabled in the default build, due to the license types of our dependencies (See README.md for details on how to build with the optional capabilities)

New Features:

 * Inter-VLAN Routing (VPC)
 * Site-to-Site VPN
 * Local Storage Support for Data Volumes
 * Virtual Resource Tagging
 * Secure Console Access on XenServer
 * Added the ability to create a VM without immediately starting it (via API)
 * Upload an Existing Volume to a Virtual Machine
 * Dedicated High-Availability Hosts
 * Support for Amazon Web Services API (formerly a separate package)
 * AWS API Extensions to include Tagging
 * Support for Nicira NVP (L2)
 * Ceph RBD Support for KVM
 * Support for Caringo as Secondary Storage
 * KVM Hypervisor support upgraded to work with Ubuntu 12.04 and RHEL 6.3

Security Fixes:

 * CVE-2012-4501: Apache CloudStack configuration vulnerability

Updating this file
------------------

To generate a list of resolved bugfixes for a specific release, use the script ``./tools/jira/jira-changes.py`` with a jira filter (authentication to Jira required).

Jira bugfix filter example for 4.5.0 release:

    project = CLOUDSTACK AND
    type = Bug AND
    affectedVersion in (4.2.0, 4.2.1, 4.3.0, 4.4.0, 4.4.1, 4.4.2, 4.3.1)
    AND fixVersion = 4.5.0
    AND resolution != "\"Unresolved\""
    ORDER BY created DESC, priority DESC, key ASC
