/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.db2;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.jdbc.ProcedureAction;
import org.apache.cayenne.access.jdbc.RowDescriptor;
import org.apache.cayenne.access.translator.procedure.ProcedureTranslator;
import org.apache.cayenne.query.ProcedureQuery;

class DB2ProcedureAction
extends ProcedureAction {
    DB2ProcedureAction(ProcedureQuery query, DataNode dataNode) {
        super(query, dataNode);
    }

    @Override
    public void performAction(Connection connection, OperationObserver observer) throws SQLException, Exception {
        this.processedResultSets = 0;
        ProcedureTranslator transl = this.createTranslator(connection);
        try (CallableStatement statement = (CallableStatement)transl.createStatement();){
            this.initStatement(statement);
            boolean hasResultSet = statement.execute();
            this.readProcedureOutParameters(statement, observer);
            while (true) {
                if (hasResultSet) {
                    try (ResultSet rs = statement.getResultSet();){
                        RowDescriptor descriptor = this.describeResultSet(rs, this.processedResultSets++);
                        this.readResultSet(rs, descriptor, this.query, observer);
                    }
                }
                int updateCount = statement.getUpdateCount();
                if (updateCount == -1) {
                    break;
                }
                this.dataNode.getJdbcEventLogger().logUpdateCount(updateCount);
                observer.nextCount(this.query, updateCount);
                hasResultSet = statement.getMoreResults();
            }
        }
    }
}

