/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.di.spi;

import java.util.LinkedList;
import java.util.List;
import org.apache.cayenne.di.DIRuntimeException;
import org.apache.cayenne.di.Key;

class InjectionStack {
    private ThreadLocal<LinkedList<Key<?>>> stack = new ThreadLocal();

    InjectionStack() {
    }

    void reset() {
        List localStack = this.stack.get();
        if (localStack != null) {
            localStack.clear();
        }
    }

    void push(Key<?> bindingKey) throws DIRuntimeException {
        LinkedList<Key<Object>> localStack = this.stack.get();
        if (localStack == null) {
            localStack = new LinkedList();
            this.stack.set(localStack);
        }
        if (localStack.contains(bindingKey)) {
            throw new DIRuntimeException("Circular dependency detected when binding a key \"%s\". Nested keys: %s. To resolve it, you should inject a Provider instead of an object.", bindingKey, localStack);
        }
        localStack.add(bindingKey);
    }

    void pop() {
        LinkedList<Key<?>> localStack = this.stack.get();
        if (localStack == null) {
            throw new IndexOutOfBoundsException("0");
        }
        localStack.removeLast();
    }

    public String toString() {
        List localStack = this.stack.get();
        if (localStack != null) {
            return String.valueOf(localStack);
        }
        return "[]";
    }
}

