/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.SQLTreeProcessor;
import org.apache.cayenne.access.translator.ParameterBinding;
import org.apache.cayenne.access.translator.ejbql.EJBQLTranslatorFactory;
import org.apache.cayenne.access.translator.select.SelectTranslator;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.PkGenerator;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.di.Provider;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.FluentSelect;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.query.SelectQuery;

public class AutoAdapter
implements DbAdapter {
    protected Provider<DbAdapter> adapterProvider;
    protected PkGenerator pkGenerator;
    protected JdbcEventLogger logger;
    volatile DbAdapter adapter;

    public AutoAdapter(Provider<DbAdapter> adapterProvider, JdbcEventLogger logger) {
        if (adapterProvider == null) {
            throw new CayenneRuntimeException("Null adapterProvider", new Object[0]);
        }
        this.adapterProvider = adapterProvider;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DbAdapter getAdapter() {
        if (this.adapter == null) {
            AutoAdapter autoAdapter = this;
            synchronized (autoAdapter) {
                if (this.adapter == null) {
                    this.adapter = this.loadAdapter();
                }
            }
        }
        return this.adapter;
    }

    protected DbAdapter loadAdapter() {
        return this.adapterProvider.get();
    }

    @Override
    @Deprecated
    public SelectTranslator getSelectTranslator(SelectQuery<?> query, EntityResolver entityResolver) {
        return this.getAdapter().getSelectTranslator(query, entityResolver);
    }

    @Override
    public SelectTranslator getSelectTranslator(FluentSelect<?> query, EntityResolver entityResolver) {
        return this.getAdapter().getSelectTranslator(query, entityResolver);
    }

    @Override
    public String getBatchTerminator() {
        return this.getAdapter().getBatchTerminator();
    }

    @Override
    public SQLTreeProcessor getSqlTreeProcessor() {
        return this.getAdapter().getSqlTreeProcessor();
    }

    @Override
    public SQLAction getAction(Query query, DataNode node) {
        return this.getAdapter().getAction(query, node);
    }

    @Override
    public boolean supportsUniqueConstraints() {
        return this.getAdapter().supportsUniqueConstraints();
    }

    @Override
    public boolean supportsCatalogsOnReverseEngineering() {
        return this.getAdapter().supportsCatalogsOnReverseEngineering();
    }

    @Override
    public boolean supportsGeneratedKeys() {
        return this.getAdapter().supportsGeneratedKeys();
    }

    @Override
    public boolean supportsGeneratedKeysForBatchInserts() {
        return this.getAdapter().supportsGeneratedKeysForBatchInserts();
    }

    @Override
    public boolean supportsBatchUpdates() {
        return this.getAdapter().supportsBatchUpdates();
    }

    @Override
    public boolean typeSupportsLength(int type) {
        return this.getAdapter().typeSupportsLength(type);
    }

    @Override
    public Collection<String> dropTableStatements(DbEntity table) {
        return this.getAdapter().dropTableStatements(table);
    }

    @Override
    public String createTable(DbEntity entity) {
        return this.getAdapter().createTable(entity);
    }

    @Override
    public String createUniqueConstraint(DbEntity source, Collection<DbAttribute> columns) {
        return this.getAdapter().createUniqueConstraint(source, columns);
    }

    @Override
    public String createFkConstraint(DbRelationship rel) {
        return this.getAdapter().createFkConstraint(rel);
    }

    @Override
    public String[] externalTypesForJdbcType(int type) {
        return this.getAdapter().externalTypesForJdbcType(type);
    }

    @Override
    public ExtendedTypeMap getExtendedTypes() {
        return this.getAdapter().getExtendedTypes();
    }

    @Override
    public PkGenerator getPkGenerator() {
        return this.pkGenerator != null ? this.pkGenerator : this.getAdapter().getPkGenerator();
    }

    @Override
    public void setPkGenerator(PkGenerator pkGenerator) {
        this.pkGenerator = pkGenerator;
    }

    @Override
    public DbAttribute buildAttribute(String name, String typeName, int type, int size, int precision, boolean allowNulls) {
        return this.getAdapter().buildAttribute(name, typeName, type, size, precision, allowNulls);
    }

    @Override
    public void bindParameter(PreparedStatement statement, ParameterBinding parameterBinding) throws SQLException, Exception {
        this.getAdapter().bindParameter(statement, parameterBinding);
    }

    @Override
    public String tableTypeForTable() {
        return this.getAdapter().tableTypeForTable();
    }

    @Override
    public String tableTypeForView() {
        return this.getAdapter().tableTypeForView();
    }

    @Override
    public void createTableAppendColumn(StringBuffer sqlBuffer, DbAttribute column) {
        this.getAdapter().createTableAppendColumn(sqlBuffer, column);
    }

    @Override
    public QuotingStrategy getQuotingStrategy() {
        return this.getAdapter().getQuotingStrategy();
    }

    @Override
    public DbAdapter unwrap() {
        return this.getAdapter();
    }

    @Override
    public EJBQLTranslatorFactory getEjbqlTranslatorFactory() {
        return this.getAdapter().getEjbqlTranslatorFactory();
    }

    @Override
    public List<String> getSystemCatalogs() {
        return this.getAdapter().getSystemCatalogs();
    }

    @Override
    public List<String> getSystemSchemas() {
        return this.getAdapter().getSystemSchemas();
    }
}

